/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.util.text.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbpedia.util.text.Appender;
import org.dbpedia.util.text.DefaultAppender;
import org.dbpedia.util.text.ParseExceptionHandler;
import org.dbpedia.util.text.ParseExceptionThrower;
import org.dbpedia.util.text.html.HtmlReferenceException;
import org.dbpedia.util.text.html.XmlCodes;

public class HtmlCoder {
    private final XmlCodes _encode;
    private final XmlCodes _keep;
    private ParseExceptionHandler _handler = ParseExceptionThrower.INSTANCE;
    private Appender _appender = DefaultAppender.INSTANCE;
    private String _in;
    private StringBuilder _out;
    private int _last = 0;
    private static final int MIN_NAME_LEN = 2;
    private static final int MAX_NAME_LEN = 8;
    private static final String CONTENT_TYPE = "text/html; charset=";
    private static final Pattern NAME_PATTERN = Pattern.compile("[A-Za-z]{2,8}|[A-Za-z]{2,6}\\d{0,2}");
    private static final Pattern VALUE_PATTERN = Pattern.compile("\"&amp;#(\\d{2,4});\"");
    private static final Comparator<String> PRETTY_ORDER = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int comp = String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
            return comp == 0 ? s1.compareTo(s2) : comp;
        }
    };
    private static final Map<String, Integer> ENTITIES = new HashMap<String, Integer>();

    public HtmlCoder(XmlCodes encode) {
        if (encode == null) {
            throw new NullPointerException("characters to encode");
        }
        this._encode = this._keep = encode;
    }

    public HtmlCoder(XmlCodes encodePlain, XmlCodes keepEncoded) {
        if (encodePlain == null) {
            throw new NullPointerException("characters to change from plain to encoded form");
        }
        if (keepEncoded == null) {
            throw new NullPointerException("characters to keep in encoded form");
        }
        this._encode = encodePlain;
        this._keep = keepEncoded;
    }

    public void setErrorHandler(ParseExceptionHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this._handler = handler;
    }

    public void setAppender(Appender appender) {
        if (appender == null) {
            throw new NullPointerException("appender");
        }
        this._appender = appender;
    }

    public String code(String string) {
        this.run(string, null);
        return this._out != null ? this._out.toString() : this._in;
    }

    public void code(String string, StringBuilder target) {
        this.run(string, target);
    }

    private void run(String in, StringBuilder out) {
        int skip;
        if (in == null) {
            throw new NullPointerException("string");
        }
        this._in = in;
        this._out = out;
        this._last = 0;
        for (int pos = 0; pos < this._in.length(); pos += skip) {
            skip = this._in.charAt(pos) == '&' ? this.decode(pos) : this.encode(pos);
        }
        if (this._out != null) {
            this._out.append(this._in, this._last, this._in.length());
        }
    }

    private int encode(int pos) {
        String encoded = this._encode.encode(this._in.charAt(pos));
        if (encoded != null) {
            this.append(pos, 1, encoded);
        }
        return 1;
    }

    private int decode(int pos) {
        String encoded;
        int decoded;
        boolean numeric;
        int sem = this._in.indexOf(59, pos);
        if (sem == -1) {
            return this.error(pos, "unclosed reference", null);
        }
        int len = sem - pos + 1;
        if (len - 2 == 0) {
            return this.error(pos, "empty reference", null);
        }
        if (len - 2 < 2) {
            return this.error(pos, "invalid reference (too short)", this._in.substring(pos + 1, sem));
        }
        if (len - 2 > 8) {
            return this.error(pos, "invalid reference (too long)", null);
        }
        boolean bl = numeric = this._in.charAt(pos + 1) == '#';
        if (numeric) {
            decoded = -1;
            try {
                char hex = this._in.charAt(pos + 2);
                decoded = hex == 'x' || hex == 'X' ? Integer.parseInt(this._in.substring(pos + 3, sem), 16) : Integer.parseInt(this._in.substring(pos + 2, sem), 10);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (decoded < 0 || decoded > 0x10FFFF) {
                return this.error(pos, "invalid numeric reference", this._in.substring(pos + 2, sem));
            }
        } else {
            String name2 = this._in.substring(pos + 1, sem);
            Integer obj = ENTITIES.get(name2);
            if (obj == null) {
                return this.error(pos, "reference to unknown entity", name2);
            }
            decoded = obj;
        }
        if ((encoded = this._keep.encode(decoded)) == null) {
            this.append(pos, len, decoded);
        } else if (numeric) {
            this.append(pos, len, encoded);
        }
        return len;
    }

    private int error(int pos, String description, String reference) {
        HtmlReferenceException error = new HtmlReferenceException(this._in, pos, description, reference);
        this._handler.error(error);
        String encoded = this._encode.encode(38);
        this.append(pos, 1, encoded != null ? encoded : "&");
        return 1;
    }

    private void append(int pos, int skip, int code) {
        if (this._out == null) {
            this._out = new StringBuilder();
        }
        this._out.append(this._in, this._last, pos);
        this._last = pos + skip;
        this._appender.append(this._out, code);
    }

    private void append(int pos, int skip, String str) {
        if (this._out == null) {
            this._out = new StringBuilder();
        }
        this._out.append(this._in, this._last, pos);
        this._last = pos + skip;
        this._appender.append(this._out, str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate() throws IOException {
        ArrayList<String> strange = new ArrayList<String>();
        TreeMap<String, Integer> entities = new TreeMap<String, Integer>(PRETTY_ORDER);
        URL url = new URL("http://www.w3.org/TR/html4/sgml/entities.html");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            String contentType = conn.getContentType();
            if (!contentType.startsWith(CONTENT_TYPE)) {
                throw new IOException("don't like content-type [" + contentType + "]");
            }
            Charset charset = Charset.forName(contentType.substring(CONTENT_TYPE.length()));
            try (InputStream in = conn.getInputStream();){
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("&lt;!ENTITY")) {
                        String[] parts = line.split("\\s+", -1);
                        if (parts.length < 4) {
                            throw HtmlCoder.error("expected at least [4] whitespace-separated parts, found [" + parts.length + "]", line);
                        }
                        if (!parts[0].equals("&lt;!ENTITY")) {
                            throw HtmlCoder.error("first part should be '&lt;!ENTITY', but is '" + parts[0] + "'", line);
                        }
                        Matcher matcher = NAME_PATTERN.matcher(parts[1]);
                        if (!matcher.matches()) {
                            throw HtmlCoder.error("second part should match regex '" + NAME_PATTERN + "', but is '" + parts[1] + "'", line);
                        }
                        String name2 = parts[1];
                        if (!parts[2].equals("CDATA")) {
                            throw HtmlCoder.error("third part should be 'CDATA', but is '" + parts[2] + "'", line);
                        }
                        matcher = VALUE_PATTERN.matcher(parts[3]);
                        if (!matcher.matches()) {
                            throw HtmlCoder.error("fourth part should match regex '" + VALUE_PATTERN + "', but is '" + parts[3] + "'", line);
                        }
                        Integer value = Integer.valueOf(matcher.group(1));
                        entities.put(name2, value);
                        continue;
                    }
                    if (!line.contains("ENTITY")) continue;
                    strange.add(line);
                }
            }
        }
        finally {
            conn.disconnect();
        }
        entities.put("apos", new Integer(39));
        System.out.println("/** Map from entity names (without leading {@code &} and trailing {@code ;}) to Unicode code points. */");
        System.out.println("private static final Map<String, Integer> ENTITIES = new HashMap<String, Integer>();");
        System.out.println("static");
        System.out.println("{");
        for (Map.Entry entry : entities.entrySet()) {
            System.out.println("ENTITIES.put(\"" + (String)entry.getKey() + "\", Integer.valueOf(" + entry.getValue() + "));");
        }
        System.out.println("}");
        System.out.println();
        System.out.println();
        System.err.println("lines in input document that contain 'ENTITY' but do not start with '&lt;!ENTITY'");
        for (String line : strange) {
            System.err.println(line);
        }
    }

    private static IllegalArgumentException error(String msg, String line) {
        return new IllegalArgumentException(msg + ". line: " + line);
    }

    static {
        ENTITIES.put("Aacute", 193);
        ENTITIES.put("aacute", 225);
        ENTITIES.put("Acirc", 194);
        ENTITIES.put("acirc", 226);
        ENTITIES.put("acute", 180);
        ENTITIES.put("AElig", 198);
        ENTITIES.put("aelig", 230);
        ENTITIES.put("Agrave", 192);
        ENTITIES.put("agrave", 224);
        ENTITIES.put("alefsym", 8501);
        ENTITIES.put("Alpha", 913);
        ENTITIES.put("alpha", 945);
        ENTITIES.put("amp", 38);
        ENTITIES.put("and", 8743);
        ENTITIES.put("ang", 8736);
        ENTITIES.put("apos", 39);
        ENTITIES.put("Aring", 197);
        ENTITIES.put("aring", 229);
        ENTITIES.put("asymp", 8776);
        ENTITIES.put("Atilde", 195);
        ENTITIES.put("atilde", 227);
        ENTITIES.put("Auml", 196);
        ENTITIES.put("auml", 228);
        ENTITIES.put("bdquo", 8222);
        ENTITIES.put("Beta", 914);
        ENTITIES.put("beta", 946);
        ENTITIES.put("brvbar", 166);
        ENTITIES.put("bull", 8226);
        ENTITIES.put("cap", 8745);
        ENTITIES.put("Ccedil", 199);
        ENTITIES.put("ccedil", 231);
        ENTITIES.put("cedil", 184);
        ENTITIES.put("cent", 162);
        ENTITIES.put("Chi", 935);
        ENTITIES.put("chi", 967);
        ENTITIES.put("circ", 710);
        ENTITIES.put("clubs", 9827);
        ENTITIES.put("cong", 8773);
        ENTITIES.put("copy", 169);
        ENTITIES.put("crarr", 8629);
        ENTITIES.put("cup", 8746);
        ENTITIES.put("curren", 164);
        ENTITIES.put("Dagger", 8225);
        ENTITIES.put("dagger", 8224);
        ENTITIES.put("dArr", 8659);
        ENTITIES.put("darr", 8595);
        ENTITIES.put("deg", 176);
        ENTITIES.put("Delta", 916);
        ENTITIES.put("delta", 948);
        ENTITIES.put("diams", 9830);
        ENTITIES.put("divide", 247);
        ENTITIES.put("Eacute", 201);
        ENTITIES.put("eacute", 233);
        ENTITIES.put("Ecirc", 202);
        ENTITIES.put("ecirc", 234);
        ENTITIES.put("Egrave", 200);
        ENTITIES.put("egrave", 232);
        ENTITIES.put("empty", 8709);
        ENTITIES.put("emsp", 8195);
        ENTITIES.put("ensp", 8194);
        ENTITIES.put("Epsilon", 917);
        ENTITIES.put("epsilon", 949);
        ENTITIES.put("equiv", 8801);
        ENTITIES.put("Eta", 919);
        ENTITIES.put("eta", 951);
        ENTITIES.put("ETH", 208);
        ENTITIES.put("eth", 240);
        ENTITIES.put("Euml", 203);
        ENTITIES.put("euml", 235);
        ENTITIES.put("euro", 8364);
        ENTITIES.put("exist", 8707);
        ENTITIES.put("fnof", 402);
        ENTITIES.put("forall", 8704);
        ENTITIES.put("frac12", 189);
        ENTITIES.put("frac14", 188);
        ENTITIES.put("frac34", 190);
        ENTITIES.put("frasl", 8260);
        ENTITIES.put("Gamma", 915);
        ENTITIES.put("gamma", 947);
        ENTITIES.put("ge", 8805);
        ENTITIES.put("gt", 62);
        ENTITIES.put("hArr", 8660);
        ENTITIES.put("harr", 8596);
        ENTITIES.put("hearts", 9829);
        ENTITIES.put("hellip", 8230);
        ENTITIES.put("Iacute", 205);
        ENTITIES.put("iacute", 237);
        ENTITIES.put("Icirc", 206);
        ENTITIES.put("icirc", 238);
        ENTITIES.put("iexcl", 161);
        ENTITIES.put("Igrave", 204);
        ENTITIES.put("igrave", 236);
        ENTITIES.put("image", 8465);
        ENTITIES.put("infin", 8734);
        ENTITIES.put("int", 8747);
        ENTITIES.put("Iota", 921);
        ENTITIES.put("iota", 953);
        ENTITIES.put("iquest", 191);
        ENTITIES.put("isin", 8712);
        ENTITIES.put("Iuml", 207);
        ENTITIES.put("iuml", 239);
        ENTITIES.put("Kappa", 922);
        ENTITIES.put("kappa", 954);
        ENTITIES.put("Lambda", 923);
        ENTITIES.put("lambda", 955);
        ENTITIES.put("lang", 9001);
        ENTITIES.put("laquo", 171);
        ENTITIES.put("lArr", 8656);
        ENTITIES.put("larr", 8592);
        ENTITIES.put("lceil", 8968);
        ENTITIES.put("ldquo", 8220);
        ENTITIES.put("le", 8804);
        ENTITIES.put("lfloor", 8970);
        ENTITIES.put("lowast", 8727);
        ENTITIES.put("loz", 9674);
        ENTITIES.put("lrm", 8206);
        ENTITIES.put("lsaquo", 8249);
        ENTITIES.put("lsquo", 8216);
        ENTITIES.put("lt", 60);
        ENTITIES.put("macr", 175);
        ENTITIES.put("mdash", 8212);
        ENTITIES.put("micro", 181);
        ENTITIES.put("middot", 183);
        ENTITIES.put("minus", 8722);
        ENTITIES.put("Mu", 924);
        ENTITIES.put("mu", 956);
        ENTITIES.put("nabla", 8711);
        ENTITIES.put("nbsp", 160);
        ENTITIES.put("ndash", 8211);
        ENTITIES.put("ne", 8800);
        ENTITIES.put("ni", 8715);
        ENTITIES.put("not", 172);
        ENTITIES.put("notin", 8713);
        ENTITIES.put("nsub", 8836);
        ENTITIES.put("Ntilde", 209);
        ENTITIES.put("ntilde", 241);
        ENTITIES.put("Nu", 925);
        ENTITIES.put("nu", 957);
        ENTITIES.put("Oacute", 211);
        ENTITIES.put("oacute", 243);
        ENTITIES.put("Ocirc", 212);
        ENTITIES.put("ocirc", 244);
        ENTITIES.put("OElig", 338);
        ENTITIES.put("oelig", 339);
        ENTITIES.put("Ograve", 210);
        ENTITIES.put("ograve", 242);
        ENTITIES.put("oline", 8254);
        ENTITIES.put("Omega", 937);
        ENTITIES.put("omega", 969);
        ENTITIES.put("Omicron", 927);
        ENTITIES.put("omicron", 959);
        ENTITIES.put("oplus", 8853);
        ENTITIES.put("or", 8744);
        ENTITIES.put("ordf", 170);
        ENTITIES.put("ordm", 186);
        ENTITIES.put("Oslash", 216);
        ENTITIES.put("oslash", 248);
        ENTITIES.put("Otilde", 213);
        ENTITIES.put("otilde", 245);
        ENTITIES.put("otimes", 8855);
        ENTITIES.put("Ouml", 214);
        ENTITIES.put("ouml", 246);
        ENTITIES.put("para", 182);
        ENTITIES.put("part", 8706);
        ENTITIES.put("permil", 8240);
        ENTITIES.put("perp", 8869);
        ENTITIES.put("Phi", 934);
        ENTITIES.put("phi", 966);
        ENTITIES.put("Pi", 928);
        ENTITIES.put("pi", 960);
        ENTITIES.put("piv", 982);
        ENTITIES.put("plusmn", 177);
        ENTITIES.put("pound", 163);
        ENTITIES.put("Prime", 8243);
        ENTITIES.put("prime", 8242);
        ENTITIES.put("prod", 8719);
        ENTITIES.put("prop", 8733);
        ENTITIES.put("Psi", 936);
        ENTITIES.put("psi", 968);
        ENTITIES.put("quot", 34);
        ENTITIES.put("radic", 8730);
        ENTITIES.put("rang", 9002);
        ENTITIES.put("raquo", 187);
        ENTITIES.put("rArr", 8658);
        ENTITIES.put("rarr", 8594);
        ENTITIES.put("rceil", 8969);
        ENTITIES.put("rdquo", 8221);
        ENTITIES.put("real", 8476);
        ENTITIES.put("reg", 174);
        ENTITIES.put("rfloor", 8971);
        ENTITIES.put("Rho", 929);
        ENTITIES.put("rho", 961);
        ENTITIES.put("rlm", 8207);
        ENTITIES.put("rsaquo", 8250);
        ENTITIES.put("rsquo", 8217);
        ENTITIES.put("sbquo", 8218);
        ENTITIES.put("Scaron", 352);
        ENTITIES.put("scaron", 353);
        ENTITIES.put("sdot", 8901);
        ENTITIES.put("sect", 167);
        ENTITIES.put("shy", 173);
        ENTITIES.put("Sigma", 931);
        ENTITIES.put("sigma", 963);
        ENTITIES.put("sigmaf", 962);
        ENTITIES.put("sim", 8764);
        ENTITIES.put("spades", 9824);
        ENTITIES.put("sub", 8834);
        ENTITIES.put("sube", 8838);
        ENTITIES.put("sum", 8721);
        ENTITIES.put("sup", 8835);
        ENTITIES.put("sup1", 185);
        ENTITIES.put("sup2", 178);
        ENTITIES.put("sup3", 179);
        ENTITIES.put("supe", 8839);
        ENTITIES.put("szlig", 223);
        ENTITIES.put("Tau", 932);
        ENTITIES.put("tau", 964);
        ENTITIES.put("there4", 8756);
        ENTITIES.put("Theta", 920);
        ENTITIES.put("theta", 952);
        ENTITIES.put("thetasym", 977);
        ENTITIES.put("thinsp", 8201);
        ENTITIES.put("THORN", 222);
        ENTITIES.put("thorn", 254);
        ENTITIES.put("tilde", 732);
        ENTITIES.put("times", 215);
        ENTITIES.put("trade", 8482);
        ENTITIES.put("Uacute", 218);
        ENTITIES.put("uacute", 250);
        ENTITIES.put("uArr", 8657);
        ENTITIES.put("uarr", 8593);
        ENTITIES.put("Ucirc", 219);
        ENTITIES.put("ucirc", 251);
        ENTITIES.put("Ugrave", 217);
        ENTITIES.put("ugrave", 249);
        ENTITIES.put("uml", 168);
        ENTITIES.put("upsih", 978);
        ENTITIES.put("Upsilon", 933);
        ENTITIES.put("upsilon", 965);
        ENTITIES.put("Uuml", 220);
        ENTITIES.put("uuml", 252);
        ENTITIES.put("weierp", 8472);
        ENTITIES.put("Xi", 926);
        ENTITIES.put("xi", 958);
        ENTITIES.put("Yacute", 221);
        ENTITIES.put("yacute", 253);
        ENTITIES.put("yen", 165);
        ENTITIES.put("Yuml", 376);
        ENTITIES.put("yuml", 255);
        ENTITIES.put("Zeta", 918);
        ENTITIES.put("zeta", 950);
        ENTITIES.put("zwj", 8205);
        ENTITIES.put("zwnj", 8204);
    }
}

