/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.util.text;

public class ParseException
extends RuntimeException {
    private final String _input;
    private final int _position;
    private final String _description;

    public ParseException(String input, int position, String description) {
        this(ParseException.buildMessage(input, position, description), input, position, description);
    }

    public ParseException(String message, String input, int position, String description) {
        super(message);
        this._input = input;
        this._position = ParseException.checkPosition(input, position);
        this._description = description;
    }

    private static String buildMessage(String input, int position, String description) {
        StringBuilder sb = new StringBuilder();
        ParseException.addDescription(description, sb);
        ParseException.addDetail(input, position, sb);
        return sb.toString();
    }

    protected static void addDescription(String description, StringBuilder target) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (description == null) {
            throw new NullPointerException("description");
        }
        target.append(description);
    }

    protected static void addDetail(String input, int position, StringBuilder target) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (ParseException.checkPosition(input, position) == -1) {
            return;
        }
        int length = input.length();
        target.append(" at position [").append(position).append("]: \"");
        if (position - 30 > 0) {
            target.append("...");
        }
        target.append(input.substring(Math.max(position - 30, 0), Math.min(position + 50, length)));
        if (position + 50 < length) {
            target.append("...");
        }
        target.append("\"");
    }

    protected static int checkPosition(String input, int position) {
        if (input == null || position == -1) {
            return -1;
        }
        int length = input.length();
        if (position < 0 || position >= length) {
            throw new IllegalArgumentException("invalid position [" + position + "] for string of length [" + length + "]");
        }
        return position;
    }

    public String getInput() {
        return this._input;
    }

    public int getPosition() {
        return this._position;
    }

    public String getDescription() {
        return this._description;
    }
}

