/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.dbpedia.util.text.uri.UriDecoder;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u0017\tQq+[6j\u0007\u0006dG.\u001a:\u000b\u0005\r!\u0011\u0001B;uS2T!!\u0002\u0004\u0002\u0015\u0015DHO]1di&|gN\u0003\u0002\b\u0011\u00059AM\u00199fI&\f'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\r)(\u000f\u001c\t\u0003+ii\u0011A\u0006\u0006\u0003/a\t1A\\3u\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\f\u0003\u0007U\u0013F\n\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003=1w\u000e\u001c7poJ+G-\u001b:fGR\u001c\bCA\u0007 \u0013\t\u0001cBA\u0004C_>dW-\u00198\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\r!ce\n\t\u0003K\u0001i\u0011A\u0001\u0005\u0006'\u0005\u0002\r\u0001\u0006\u0005\u0006;\u0005\u0002\rA\b\u0005\u0006S\u0001!\tAK\u0001\bKb,7-\u001e;f+\tYc\u0006\u0006\u0002-oA\u0011QF\f\u0007\u0001\t\u0015y\u0003F1\u00011\u0005\u0005\u0011\u0016CA\u00195!\ti!'\u0003\u00024\u001d\t9aj\u001c;iS:<\u0007CA\u00076\u0013\t1dBA\u0002B]fDQ\u0001\u000f\u0015A\u0002e\nq\u0001\u001d:pG\u0016\u001c8\u000f\u0005\u0003\u000euqb\u0013BA\u001e\u000f\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002>\u00016\taH\u0003\u0002@1\u0005\u0011\u0011n\\\u0005\u0003\u0003z\u00121\"\u00138qkR\u001cFO]3b[\")1\t\u0001C\u0005\t\u0006i1\r[3dWJ+7\u000f]8og\u0016$\"!\u0012%\u0011\u000551\u0015BA$\u000f\u0005\u0011)f.\u001b;\t\u000b%\u0013\u0005\u0019\u0001&\u0002\t\r|gN\u001c\t\u0003+-K!\u0001\u0014\f\u0003#!#H\u000f]+S\u0019\u000e{gN\\3di&|g\u000e")
public class WikiCaller {
    private final URL url;
    private final boolean followRedirects;

    public <R> R execute(Function1<InputStream, R> process) {
        HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
        try {
            Object object;
            this.checkResponse(conn);
            InputStream in = conn.getInputStream();
            try {
                object = process.apply((Object)in);
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return (R)object;
        }
        finally {
            conn.disconnect();
        }
    }

    private void checkResponse(HttpURLConnection conn) {
        conn.setInstanceFollowRedirects(this.followRedirects);
        int code = conn.getResponseCode();
        if (code != 200) {
            String location = conn.getHeaderField("Location");
            if (location != null) {
                location = UriDecoder.decode(location);
                URL url2 = new URL(location);
                if (!(this.followRedirects || code != 301 && code != 302)) {
                    String string = url2.getPath();
                    String string2 = this.url.getPath();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        String string3 = url2.getQuery();
                        String string4 = this.url.getQuery();
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            Seq parts = Predef$.MODULE$.refArrayOps((Object[])this.url.getHost().split("\\.", -1)).toSeq();
                            Seq parts2 = Predef$.MODULE$.refArrayOps((Object[])url2.getHost().split("\\.", -1)).toSeq();
                            if (BoxesRunTime.equals((Object)parts.tail(), (Object)parts2.tail())) {
                                throw new HttpRetryException((String)parts2.head(), code, location);
                            }
                        }
                    }
                }
            }
            throw new IOException(new StringBuilder().append((Object)"URL '").append((Object)this.url).append((Object)"' replied ").append((Object)BoxesRunTime.boxToInteger((int)code)).append((Object)" ").append((Object)conn.getResponseMessage()).append((Object)" - Location: '").append((Object)location).append((Object)"'").toString());
        }
    }

    public WikiCaller(URL url, boolean followRedirects) {
        this.url = url;
        this.followRedirects = followRedirects;
    }
}

