/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.Format;
import org.dbpedia.extraction.util.NumberUtils$;
import org.dbpedia.extraction.util.StringUtils$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class StringUtils$ {
    public static final StringUtils$ MODULE$;
    private final ThreadLocal<DateFormat> timestampFormat;
    private final String zeros;

    static {
        new StringUtils$();
    }

    private ThreadLocal<DateFormat> timestampFormat() {
        return this.timestampFormat;
    }

    public String formatCurrentTimestamp() {
        return this.formatTimestamp(System.currentTimeMillis());
    }

    public String formatTimestamp(long timestamp) {
        return timestamp < 0L ? "" : ((Format)this.timestampFormat().get()).format(BoxesRunTime.boxToLong((long)timestamp));
    }

    public long parseTimestamp(String str) {
        return str == null || str.isEmpty() ? -1L : this.timestampFormat().get().parse(str).getTime();
    }

    public String prettyMillis(long millis) {
        return new scala.collection.mutable.StringBuilder().append((Object)this.zeros(2, millis / 60000L)).append((Object)BoxesRunTime.boxToCharacter((char)':')).append((Object)this.zeros(2, millis % 60000L / 1000L)).append((Object)BoxesRunTime.boxToCharacter((char)'.')).append((Object)this.zeros(3, millis % 1000L)).append((Object)BoxesRunTime.boxToCharacter((char)'s')).toString();
    }

    private String zeros() {
        return this.zeros;
    }

    private String zeros(int z, long n) {
        int p = 10;
        for (int e = 1; e < z; ++e) {
            if (n < (long)p) {
                return new scala.collection.mutable.StringBuilder().append((Object)this.zeros().substring(0, z - e)).append((Object)BoxesRunTime.boxToLong((long)n)).toString();
            }
            p *= 10;
        }
        return ((Object)BoxesRunTime.boxToLong((long)n)).toString();
    }

    public StringBuilder escape(StringBuilder target, String str, char esc, String replace) {
        ObjectRef sb = new ObjectRef((Object)target);
        char[] chars = str.toCharArray();
        int last = 0;
        for (int pos = 0; pos < chars.length; ++pos) {
            Object object;
            char c = chars[pos];
            if (replace.indexOf(c) != -1) {
                if ((StringBuilder)sb.elem == null) {
                    sb.elem = new StringBuilder();
                }
                ((StringBuilder)sb.elem).append(chars, last, pos - last);
                last = pos + 1;
                if (c < '\u0080') {
                    ((StringBuilder)sb.elem).append(esc);
                    object = NumberUtils$.MODULE$.intToHex((StringBuilder)sb.elem, c, 2);
                    continue;
                }
                byte[] bytes = new String(new char[]{c}).getBytes("UTF-8");
                Predef$.MODULE$.byteArrayOps(bytes).foreach((Function1)new Serializable(esc, sb){
                    public static final long serialVersionUID = 0L;
                    private final char esc$1;
                    private final ObjectRef sb$1;

                    public final StringBuilder apply(byte b) {
                        ((StringBuilder)this.sb$1.elem).append(this.esc$1);
                        return NumberUtils$.MODULE$.intToHex((StringBuilder)this.sb$1.elem, b, 2);
                    }
                    {
                        this.esc$1 = esc$1;
                        this.sb$1 = sb$1;
                    }
                });
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        Object object = (StringBuilder)sb.elem == null ? BoxedUnit.UNIT : ((StringBuilder)sb.elem).append(chars, last, chars.length - last);
        return (StringBuilder)sb.elem;
    }

    public String[] replacements(char esc, String chars, int limit) {
        String[] stringArray;
        if (chars.isEmpty()) {
            stringArray = new String[]{};
        } else {
            char max = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(chars)).max((Ordering)Ordering.Char$.MODULE$));
            if (max >= limit) {
                throw new IllegalArgumentException(new scala.collection.mutable.StringBuilder().append((Object)"highest code point ").append((Object)BoxesRunTime.boxToInteger((int)max)).append((Object)" exceeds limit ").append((Object)BoxesRunTime.boxToInteger((int)limit)).toString());
            }
            String[] replace = new String[max + '\u0001'];
            for (int pos = 0; pos < chars.length(); ++pos) {
                StringBuilder stringBuilder;
                char c = chars.charAt(pos);
                StringBuilder sb = new StringBuilder();
                if (c < '\u0080') {
                    sb.append(esc);
                    stringBuilder = NumberUtils$.MODULE$.intToHex(sb, c, 2);
                } else {
                    byte[] bytes = new String(new char[]{c}).getBytes("UTF-8");
                    Predef$.MODULE$.byteArrayOps(bytes).foreach((Function1)new Serializable(esc, sb){
                        public static final long serialVersionUID = 0L;
                        private final char esc$2;
                        private final StringBuilder sb$2;

                        public final StringBuilder apply(byte b) {
                            this.sb$2.append(this.esc$2);
                            return NumberUtils$.MODULE$.intToHex(this.sb$2, b, 2);
                        }
                        {
                            this.esc$2 = esc$2;
                            this.sb$2 = sb$2;
                        }
                    });
                    stringBuilder = BoxedUnit.UNIT;
                }
                replace[c] = sb.toString();
            }
            stringArray = replace;
        }
        return stringArray;
    }

    public int replacements$default$3() {
        return 256;
    }

    public String escape(String input, String[] replace) {
        StringBuilder sb = this.escape(null, input, replace);
        return sb == null ? input : sb.toString();
    }

    public StringBuilder escape(StringBuilder target, String str, String[] replace) {
        StringBuilder sb = target;
        char[] chars = str.toCharArray();
        int last = 0;
        for (int pos = 0; pos < chars.length; ++pos) {
            Object object;
            char c = chars[pos];
            if (c < replace.length) {
                String rep = replace[c];
                if (rep == null) {
                    object = BoxedUnit.UNIT;
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(chars, last, pos - last);
                last = pos + 1;
                object = sb.append(rep);
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        Object object = sb == null ? BoxedUnit.UNIT : sb.append(chars, last, chars.length - last);
        return sb;
    }

    public StringBuilder replaceChars(StringBuilder target, String str, String replace, String by) {
        StringBuilder sb = target;
        char[] chars = str.toCharArray();
        int last = 0;
        for (int pos = 0; pos < chars.length; ++pos) {
            char ch = chars[pos];
            int index = replace.indexOf(ch);
            if (index == -1) continue;
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(chars, last, pos - last);
            Object object = index < by.length() ? sb.append(by.charAt(index)) : BoxedUnit.UNIT;
            last = pos + 1;
        }
        Object object = sb == null ? BoxedUnit.UNIT : sb.append(chars, last, chars.length - last);
        return sb;
    }

    public String md5sum(String input) {
        byte[] inputBytes = input.getBytes("UTF-8");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        md5.update(inputBytes);
        return (String)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.byteArrayOps(md5.digest()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(byte x$1) {
                return 0xFF & x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$2) {
                return new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x$2)}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foldLeft((Object)"", (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$3, String x$4) {
                return new scala.collection.mutable.StringBuilder().append((Object)x$3).append((Object)x$4).toString();
            }
        });
    }

    private StringUtils$() {
        MODULE$ = this;
        this.timestampFormat = new anon.1();
        this.zeros = "0000000000000000000000000";
    }
}

