/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.dbpedia.extraction.ontology.Ontology;
import org.dbpedia.extraction.ontology.io.OntologyOWLWriter;
import org.dbpedia.extraction.ontology.io.OntologyOWLWriter$;
import org.dbpedia.extraction.ontology.io.OntologyReader;
import org.dbpedia.extraction.sources.XMLSource$;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.WikiDownloader;
import org.dbpedia.extraction.wikiparser.Namespace;
import org.dbpedia.extraction.wikiparser.Namespace$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;

public final class OntologyDownloader$ {
    public static final OntologyDownloader$ MODULE$;
    private final String apiUrl;

    static {
        new OntologyDownloader$();
    }

    public String apiUrl() {
        return this.apiUrl;
    }

    public void main(String[] args) {
        Predef$.MODULE$.require(args != null && args.length == 2, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "expected two arguments: target file for wikitext XML dump, target file for OWL format.";
            }
        });
        File dumpFile = new File(args[0]);
        File owlFile = new File(args[1]);
        this.download(dumpFile);
        Ontology ontology = this.load(dumpFile);
        this.save(ontology, owlFile);
    }

    public void download(File dumpFile) {
        long nanos = System.nanoTime();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"downloading ontology from ").append((Object)this.apiUrl()).append((Object)" to ").append((Object)dumpFile).toString());
        new WikiDownloader(this.apiUrl()).download(dumpFile, (Seq<Namespace>)Predef$.MODULE$.wrapRefArray((Object[])new Namespace[]{Namespace$.MODULE$.OntologyClass(), Namespace$.MODULE$.OntologyProperty()}));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"downloaded ontology from ").append((Object)this.apiUrl()).append((Object)" to ").append((Object)dumpFile).append((Object)" in ").append((Object)BoxesRunTime.boxToFloat((float)((float)((double)(System.nanoTime() - nanos) / 1.0E9)))).append((Object)" seconds").toString());
    }

    public Ontology load(File dumpFile) {
        long nanos = System.nanoTime();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"loading ontology from ").append((Object)dumpFile).toString());
        Ontology ontology = new OntologyReader().read(XMLSource$.MODULE$.fromFile(dumpFile, Language$.MODULE$.Mappings(), XMLSource$.MODULE$.fromFile$default$3()));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"loaded ontology from ").append((Object)dumpFile).append((Object)" in ").append((Object)BoxesRunTime.boxToFloat((float)((float)((double)(System.nanoTime() - nanos) / 1.0E9)))).append((Object)" seconds").toString());
        return ontology;
    }

    /*
     * WARNING - void declaration
     */
    public void save(Ontology ontology, File owlFile) {
        long nanos = System.nanoTime();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"saving ontology to ").append((Object)owlFile).toString());
        Elem xml = new OntologyOWLWriter(OntologyOWLWriter$.MODULE$.$lessinit$greater$default$1()).write(ontology);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(owlFile), "UTF-8");
        try {
            writer.write(xml.toString());
        }
        catch (Throwable throwable) {
            void var6_5;
            var6_5.close();
            throw throwable;
        }
        writer.close();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"saved ontology to ").append((Object)owlFile).append((Object)" in ").append((Object)BoxesRunTime.boxToFloat((float)((float)((double)(System.nanoTime() - nanos) / 1.0E9)))).append((Object)" seconds").toString());
    }

    private OntologyDownloader$() {
        MODULE$ = this;
        this.apiUrl = Language$.MODULE$.Mappings().apiUri();
    }
}

