/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.RichString$;
import org.dbpedia.extraction.util.WikiInfo;
import org.dbpedia.extraction.util.WikiInfo$;
import org.dbpedia.extraction.wikiparser.Namespace$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class ConfigUtils$ {
    public static final ConfigUtils$ MODULE$;
    private final Regex LanguageRegex;
    private final Regex RangeRegex;

    static {
        new ConfigUtils$();
    }

    /*
     * WARNING - void declaration
     */
    public Properties loadConfig(String file, String charset) {
        void var3_3;
        Properties config = new Properties();
        FileInputStream in = new FileInputStream(file);
        try {
            config.load(new InputStreamReader((InputStream)in, charset));
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        in.close();
        return var3_3;
    }

    public <T> Seq<T> getValues(Properties config, String key, char sep, boolean required, Function1<String, T> map) {
        return (Seq)this.getStrings(config, key, sep, required).map((Function1)new Serializable(map){
            public static final long serialVersionUID = 0L;
            private final Function1 map$1;

            public final T apply(String x$1) {
                return (T)this.map$1.apply((Object)x$1);
            }
            {
                this.map$1 = map$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> getStrings(Properties config, String key, char sep, boolean required) {
        String string = this.getString(config, key, required);
        return string == null ? (Seq)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])RichString$.MODULE$.wrapString(string).trimSplit(sep));
    }

    public <T> T getValue(Properties config, String key, boolean required, Function1<String, T> map) {
        String string = this.getString(config, key, required);
        return (T)(string == null ? null : map.apply((Object)string));
    }

    public String getString(Properties config, String key, boolean required) {
        String string;
        String string2 = config.getProperty(key);
        if (string2 == null) {
            if (required) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"property '").append((Object)key).append((Object)"' not defined.").toString());
            }
            string = null;
        } else {
            string = string2;
        }
        return string;
    }

    public Language[] parseLanguages(File baseDir, Seq<String> args) {
        Seq keys = (Seq)args.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String arg) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])arg.split("[,\\s]")).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String key) {
                        return new StringOps(Predef$.MODULE$.augmentString(key)).nonEmpty();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String key) {
                        return key;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            }
        }, Seq$.MODULE$.canBuildFrom());
        ObjectRef languages = new ObjectRef((Object)((SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, Language$.MODULE$.wikiCodeOrdering())));
        HashSet ranges = new HashSet();
        keys.foreach((Function1)new Serializable(languages, ranges){
            public static final long serialVersionUID = 0L;
            private final ObjectRef languages$1;
            private final HashSet ranges$1;

            public final Object apply(String key) {
                String string;
                block5: {
                    BoxedUnit boxedUnit;
                    block3: {
                        block4: {
                            block2: {
                                String string2 = string = key;
                                if ("@mappings" != null ? !"@mappings".equals(string2) : string2 != null) break block2;
                                this.languages$1.elem = (SortedSet)((SortedSet)this.languages$1.elem).$plus$plus((GenTraversableOnce)Namespace$.MODULE$.mappings().keySet());
                                boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            Option option = ConfigUtils$.MODULE$.RangeRegex().unapplySeq((Object)string);
                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) break block4;
                            String from = (String)((LinearSeqOptimized)option.get()).apply(0);
                            String to = (String)((LinearSeqOptimized)option.get()).apply(1);
                            boxedUnit = this.ranges$1.$plus$eq(ConfigUtils$.MODULE$.toRange(from, to));
                            break block3;
                        }
                        Option option = ConfigUtils$.MODULE$.LanguageRegex().unapplySeq((Object)string);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block5;
                        String language = (String)((LinearSeqOptimized)option.get()).apply(0);
                        this.languages$1.elem = (SortedSet)((SortedSet)this.languages$1.elem).$plus((Object)Language$.MODULE$.apply(language));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid language / range '").append((Object)string).append((Object)"'").toString());
            }
            {
                this.languages$1 = languages$1;
                this.ranges$1 = ranges$1;
            }
        });
        if (ranges.nonEmpty()) {
            File listFile = new File(baseDir, WikiInfo$.MODULE$.FileName());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"parsing ").append((Object)listFile).toString());
            Seq<WikiInfo> wikis = WikiInfo$.MODULE$.fromFile(listFile, Codec$.MODULE$.UTF8());
            ranges.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                    Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(languages, wikis){
                public static final long serialVersionUID = 0L;
                public final ObjectRef languages$1;
                private final Seq wikis$1;

                public final void apply(Tuple2<Object, Object> x$2) {
                    Tuple2<Object, Object> tuple2 = x$2;
                    if (tuple2 != null) {
                        int from = tuple2._1$mcI$sp();
                        int to = tuple2._2$mcI$sp();
                        this.wikis$1.withFilter((Function1)new Serializable(this, from, to){
                            public static final long serialVersionUID = 0L;
                            private final int from$1;
                            private final int to$1;

                            public final boolean apply(WikiInfo wiki) {
                                return this.from$1 <= wiki.pages() && wiki.pages() <= this.to$1;
                            }
                            {
                                this.from$1 = from$1;
                                this.to$1 = to$1;
                            }
                        }).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.parseLanguages.3 $outer;

                            public final void apply(WikiInfo wiki) {
                                this.$outer.languages$1.elem = (SortedSet)((SortedSet)this.$outer.languages$1.elem).$plus((Object)wiki.language());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.languages$1 = languages$1;
                    this.wikis$1 = wikis$1;
                }
            });
        }
        return (Language[])((SortedSet)languages.elem).toArray(ClassTag$.MODULE$.apply(Language.class));
    }

    public Regex LanguageRegex() {
        return this.LanguageRegex;
    }

    public Regex RangeRegex() {
        return this.RangeRegex;
    }

    public Tuple2<Object, Object> toRange(String from, String to) {
        int hi;
        int lo = from.isEmpty() ? 0 : new StringOps(Predef$.MODULE$.augmentString(from)).toInt();
        int n = hi = to.isEmpty() ? Integer.MAX_VALUE : new StringOps(Predef$.MODULE$.augmentString(to)).toInt();
        if (lo > hi) {
            throw new NumberFormatException();
        }
        return new Tuple2.mcII.sp(lo, hi);
    }

    private ConfigUtils$() {
        MODULE$ = this;
        this.LanguageRegex = new StringOps(Predef$.MODULE$.augmentString("([a-z][a-z0-9-]+)")).r();
        this.RangeRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d*)-(\\d*)")).r();
    }
}

