/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.destinations.formatters;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.dbpedia.extraction.destinations.formatters.Formatter;
import org.dbpedia.extraction.destinations.formatters.UriPolicy$;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.RichString$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.xml.Utility$;

public final class UriPolicy$ {
    public static final UriPolicy$ MODULE$;
    private final int SUBJECT;
    private final int PREDICATE;
    private final int OBJECT;
    private final int DATATYPE;
    private final int CONTEXT;
    private final int POSITIONS;
    private final int ALL;
    private final Map<String, Tuple3<Object, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies;
    private final Map<String, Function1<Function1<URI, URI>[], Formatter>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters;
    private final int MAX_LENGTH;

    static {
        new UriPolicy$();
    }

    public int SUBJECT() {
        return this.SUBJECT;
    }

    public int PREDICATE() {
        return this.PREDICATE;
    }

    public int OBJECT() {
        return this.OBJECT;
    }

    public int DATATYPE() {
        return this.DATATYPE;
    }

    public int CONTEXT() {
        return this.CONTEXT;
    }

    public int POSITIONS() {
        return this.POSITIONS;
    }

    public int ALL() {
        return this.ALL;
    }

    public Map<String, Tuple3<Object, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies() {
        return this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies;
    }

    public Map<String, Function1<Function1<URI, URI>[], Formatter>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters() {
        return this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters;
    }

    public Map<String, Formatter> parseFormats(Properties config, String uriPolicyPrefix, String formatPrefix) {
        Map<String, Function1<URI, URI>[]> policies = this.parsePolicies(config, uriPolicyPrefix);
        return this.parseFormats(config, formatPrefix, policies);
    }

    public Map<String, Formatter> parseFormats(Properties config, String prefix, Map<String, Function1<URI, URI>[]> policies) {
        String dottedPrefix = new StringBuilder().append((Object)prefix).append((Object)".").toString();
        HashMap formats = new HashMap();
        JavaConversions$.MODULE$.asScalaSet(config.stringPropertyNames()).foreach((Function1)new Serializable(config, policies, dottedPrefix, formats){
            public static final long serialVersionUID = 0L;
            private final Properties config$2;
            public final Map policies$1;
            private final String dottedPrefix$1;
            private final HashMap formats$1;

            public final void apply(String key) {
                if (key.startsWith(this.dottedPrefix$1)) {
                    String suffix = key.substring(this.dottedPrefix$1.length());
                    Seq<String> settings = ConfigUtils$.MODULE$.getStrings(this.config$2, key, ';', true);
                    Predef$.MODULE$.require(settings.length() == 1 || settings.length() == 2, (Function0)new Serializable(this, key){
                        public static final long serialVersionUID = 0L;
                        private final String key$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"key '").append((Object)this.key$1).append((Object)"' must have one or two values separated by ';' - file format and optional uri policy name").toString();
                        }
                        {
                            this.key$1 = key$1;
                        }
                    });
                    Function1 formatter = (Function1)UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters().getOrElse(settings.apply(0), (Function0)new Serializable(this, key, settings){
                        public static final long serialVersionUID = 0L;
                        private final String key$1;
                        private final Seq settings$1;

                        public final Nothing$ apply() {
                            throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"first value for key '").append((Object)this.key$1).append((Object)"' is '").append(this.settings$1.apply(0)).append((Object)"' but must be one of ").append((Object)((TraversableOnce)UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters().keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("'", "','", "'")).toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
                        }
                        {
                            this.key$1 = key$1;
                            this.settings$1 = settings$1;
                        }
                    });
                    Function1[] policy = settings.length() == 1 ? null : (Function1[])this.policies$1.getOrElse(settings.apply(1), (Function0)new Serializable(this, key, settings){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.parseFormats.1 $outer;
                        private final String key$1;
                        private final Seq settings$1;

                        public final Nothing$ apply() {
                            throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"second value for key '").append((Object)this.key$1).append((Object)"' is '").append(this.settings$1.apply(1)).append((Object)"' but must be a configured uri-policy, i.e. one of ").append((Object)this.$outer.policies$1.keys().mkString("'", "','", "'")).toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.key$1 = key$1;
                            this.settings$1 = settings$1;
                        }
                    });
                    this.formats$1.update((Object)suffix, formatter.apply(policy));
                }
            }
            {
                this.config$2 = config$2;
                this.policies$1 = policies$1;
                this.dottedPrefix$1 = dottedPrefix$1;
                this.formats$1 = formats$1;
            }
        });
        return formats;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Function1<URI, URI>[]> parsePolicies(Properties config, String prefix) {
        void var3_3;
        HashMap policies = new HashMap();
        JavaConversions$.MODULE$.asScalaSet(config.stringPropertyNames()).foreach((Function1)new Serializable(config, prefix, policies){
            public static final long serialVersionUID = 0L;
            private final Properties config$1;
            private final String prefix$2;
            private final HashMap policies$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(String key) {
                if (!key.startsWith(this.prefix$2)) return;
                try {
                    this.policies$2.update((Object)key, UriPolicy$.MODULE$.parsePolicy(this.config$1.getProperty(key)));
                    return;
                }
                catch (Exception exception) {
                    throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"invalid URI policy: '").append((Object)key).append((Object)"=").append((Object)this.config$1.getProperty(key)).append((Object)"'").toString(), exception);
                }
            }
            {
                this.config$1 = config$1;
                this.prefix$2 = prefix$2;
                this.policies$2 = policies$2;
            }
        });
        return var3_3;
    }

    public Function1<URI, URI>[] parsePolicy(String list) {
        ArrayBuffer[] entries = (ArrayBuffer[])Array$.MODULE$.fill(this.POSITIONS(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> apply() {
                return new ArrayBuffer();
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class));
        Predef$.MODULE$.refArrayOps((Object[])RichString$.MODULE$.wrapString(list).trimSplit(';')).foreach((Function1)new Serializable(entries){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer[] entries$1;

            public final Object apply(String policy) {
                String[] stringArray = RichString$.MODULE$.wrapString(policy).trimSplit(':');
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    Some some;
                    Tuple3 tuple3;
                    String name2 = (String)((SeqLike)option.get()).apply(0);
                    String languages = (String)((SeqLike)option.get()).apply(1);
                    Option option2 = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies().get((Object)name2);
                    if (option2 instanceof Some && (tuple3 = (Tuple3)(some = (Some)option2).x()) != null) {
                        ArrayBuffer arrayBuffer;
                        ArrayBuffer arrayBuffer2;
                        int prio = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        int position = BoxesRunTime.unboxToInt((Object)tuple3._2());
                        Function1 factory = (Function1)tuple3._3();
                        Function1<URI, Object> predicate = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$parsePredicate(languages);
                        Tuple2 entry = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)prio)), factory.apply(predicate));
                        if (position == UriPolicy$.MODULE$.ALL()) {
                            Predef$.MODULE$.refArrayOps((Object[])this.entries$1).foreach((Function1)new Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final Tuple2 entry$1;

                                public final ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> apply(ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> x$9) {
                                    return x$9.$plus$eq((Object)this.entry$1);
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            });
                            arrayBuffer2 = BoxedUnit.UNIT;
                        } else {
                            arrayBuffer2 = this.entries$1[position].$plus$eq((Object)entry);
                        }
                        ArrayBuffer arrayBuffer3 = arrayBuffer = arrayBuffer2;
                        return arrayBuffer3;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option3 = option2;
                    if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                        throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"unknown policy name '").append((Object)name2).append((Object)"' in '").append((Object)policy).append((Object)"'").toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
                    }
                    throw new MatchError((Object)option2);
                }
                throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"invalid format in '").append((Object)policy).append((Object)"'").toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
            }
            {
                this.entries$1 = entries$1;
            }
        });
        ArrayBuffer[] ordered = (ArrayBuffer[])Predef$.MODULE$.refArrayOps((Object[])entries).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayBuffer<Function1<URI, URI>> apply(ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> x$10) {
                return (ArrayBuffer)((TraversableLike)x$10.sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Function1<URI, URI>> x$11) {
                        return x$11._1$mcI$sp();
                    }
                }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Function1<URI, URI> apply(Tuple2<Object, Function1<URI, URI>> x$12) {
                        return (Function1)x$12._2();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ArrayBuffer.class)));
        Predef$.MODULE$.refArrayOps((Object[])ordered).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(ArrayBuffer<Function1<URI, URI>> list) {
                return list.isEmpty() ? list.$plus$eq((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final URI apply(URI x) {
                        return (URI)Predef$.MODULE$.identity((Object)x);
                    }
                }) : BoxedUnit.UNIT;
            }
        });
        return (Function1[])Predef$.MODULE$.refArrayOps((Object[])ordered).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<URI, URI> apply(ArrayBuffer<Function1<URI, URI>> x$13) {
                return (Function1)x$13.reduceLeft((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Function1<URI, URI> apply(Function1<URI, URI> x$14, Function1<URI, URI> x$15) {
                        return x$14.andThen(x$15);
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
    }

    public Function1<URI, Object> org$dbpedia$extraction$destinations$formatters$UriPolicy$$parsePredicate(String languages) {
        Object object;
        Set codes2 = Predef$.MODULE$.refArrayOps((Object[])RichString$.MODULE$.wrapString(languages).trimSplit(',')).toSet();
        if (codes2.apply((Object)"*")) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(URI uri2) {
                    String host = uri2.getHost();
                    return host != null && (host.equals("dbpedia.org") || host.endsWith(".dbpedia.org"));
                }
            };
        } else {
            Set domains = (Set)codes2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$16) {
                    return Language$.MODULE$.apply(x$16).dbpediaDomain();
                }
            }, Set$.MODULE$.canBuildFrom());
            object = new Serializable(domains){
                public static final long serialVersionUID = 0L;
                private final Set domains$1;

                public final boolean apply(URI uri2) {
                    return this.domains$1.apply((Object)uri2.getHost());
                }
                {
                    this.domains$1 = domains$1;
                }
            };
        }
        return object;
    }

    public IllegalArgumentException org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(String message, Throwable cause) {
        return new IllegalArgumentException(message, cause);
    }

    public Throwable org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2() {
        return null;
    }

    public Function1<URI, URI> uri(Function1<URI, Object> activeFor) {
        return new Serializable(activeFor){
            public static final long serialVersionUID = 0L;
            private final Function1 activeFor$2;

            public final URI apply(URI iri) {
                return BoxesRunTime.unboxToBoolean((Object)this.activeFor$2.apply((Object)iri)) ? new URI(iri.toASCIIString()) : iri;
            }
            {
                this.activeFor$2 = activeFor$2;
            }
        };
    }

    public Function1<URI, URI> generic(Function1<URI, Object> activeFor) {
        return new Serializable(activeFor){
            public static final long serialVersionUID = 0L;
            private final Function1 activeFor$4;

            public final URI apply(URI iri) {
                URI uRI;
                if (BoxesRunTime.unboxToBoolean((Object)this.activeFor$4.apply((Object)iri))) {
                    String scheme = iri.getScheme();
                    String user = iri.getRawUserInfo();
                    String host = "dbpedia.org";
                    int port = iri.getPort();
                    String path = iri.getRawPath();
                    String query2 = iri.getRawQuery();
                    String frag = iri.getRawFragment();
                    uRI = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(scheme, user, host, port, path, query2, frag);
                } else {
                    uRI = iri;
                }
                return uRI;
            }
            {
                this.activeFor$4 = activeFor$4;
            }
        };
    }

    public int MAX_LENGTH() {
        return this.MAX_LENGTH;
    }

    public Function1<URI, URI> rejectLong(Function1<URI, Object> activeFor) {
        return new Serializable(activeFor){
            public static final long serialVersionUID = 0L;
            private final Function1 activeFor$1;

            public final URI apply(URI iri) {
                String str;
                if (BoxesRunTime.unboxToBoolean((Object)this.activeFor$1.apply((Object)iri)) && (str = iri.toString()).length() > UriPolicy$.MODULE$.MAX_LENGTH()) {
                    throw new URISyntaxException(str, new StringBuilder().append((Object)"length ").append((Object)BoxesRunTime.boxToInteger((int)str.length())).append((Object)" exceeds maximum ").append((Object)BoxesRunTime.boxToInteger((int)UriPolicy$.MODULE$.MAX_LENGTH())).toString());
                }
                return iri;
            }
            {
                this.activeFor$1 = activeFor$1;
            }
        };
    }

    public Function1<URI, URI> xmlSafe(Function1<URI, Object> activeFor) {
        return new Serializable(activeFor){
            public static final long serialVersionUID = 0L;
            private final Function1 activeFor$3;

            public final URI apply(URI iri) {
                URI uRI;
                if (BoxesRunTime.unboxToBoolean((Object)this.activeFor$3.apply((Object)iri))) {
                    String scheme = iri.getScheme();
                    String user = iri.getRawUserInfo();
                    String host = iri.getHost();
                    int port = iri.getPort();
                    String path = iri.getRawPath();
                    String query2 = iri.getRawQuery();
                    String frag = iri.getRawFragment();
                    if (frag == null) {
                        if (query2 == null) {
                            path = path != null && new StringOps(Predef$.MODULE$.augmentString(path)).nonEmpty() ? UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(path) : "/_";
                        } else {
                            query2 = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(query2);
                        }
                    } else {
                        frag = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(frag);
                    }
                    uRI = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(scheme, user, host, port, path, query2, frag);
                } else {
                    uRI = iri;
                }
                return uRI;
            }
            {
                this.activeFor$3 = activeFor$3;
            }
        };
    }

    public String org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(String tail) {
        int index = tail.length();
        while (index > 0) {
            if (--index >= 2 && tail.charAt(index - 2) == '%') {
                return new StringBuilder().append((Object)tail).append((Object)BoxesRunTime.boxToCharacter((char)'_')).toString();
            }
            char ch = tail.charAt(index);
            if (ch != ':' && Utility$.MODULE$.isNameChar(ch)) {
                if (!Utility$.MODULE$.isNameStart(ch)) continue;
                return tail;
            }
            return new StringBuilder().append((Object)tail).append((Object)BoxesRunTime.boxToCharacter((char)'_')).toString();
        }
        return new StringBuilder().append((Object)tail).append((Object)BoxesRunTime.boxToCharacter((char)'_')).toString();
    }

    public URI org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(String scheme, String user, String host, int port, String path, String query2, String frag) {
        Object object;
        StringBuilder sb = new StringBuilder();
        Object object2 = scheme == null ? BoxedUnit.UNIT : sb.append(scheme).append(':');
        if (host == null) {
            object = BoxedUnit.UNIT;
        } else {
            sb.append("//");
            Object object3 = user == null ? BoxedUnit.UNIT : sb.append(user).append('@');
            sb.append(host);
            object = port != -1 ? sb.append(':').append(port) : BoxedUnit.UNIT;
        }
        Object object4 = path == null ? BoxedUnit.UNIT : sb.append(path);
        Object object5 = query2 == null ? BoxedUnit.UNIT : sb.append('?').append(query2);
        Object object6 = frag == null ? BoxedUnit.UNIT : sb.append('#').append(frag);
        return new URI(sb.toString());
    }

    private UriPolicy$() {
        MODULE$ = this;
        this.SUBJECT = 0;
        this.PREDICATE = 1;
        this.OBJECT = 2;
        this.DATATYPE = 3;
        this.CONTEXT = 4;
        this.POSITIONS = 5;
        this.ALL = -1;
        Seq policies = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"reject-long", (Object)BoxesRunTime.boxToInteger((int)1), (Object)new anonfun.1()), new Tuple3((Object)"uri", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new anonfun.2()), new Tuple3((Object)"xml-safe", (Object)BoxesRunTime.boxToInteger((int)3), (Object)new anonfun.3()), new Tuple3((Object)"generic", (Object)BoxesRunTime.boxToInteger((int)4), (Object)new anonfun.4())}));
        Seq positions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)this.ALL())), new Tuple2((Object)"-subjects", (Object)BoxesRunTime.boxToInteger((int)this.SUBJECT())), new Tuple2((Object)"-predicates", (Object)BoxesRunTime.boxToInteger((int)this.PREDICATE())), new Tuple2((Object)"-objects", (Object)BoxesRunTime.boxToInteger((int)this.OBJECT())), new Tuple2((Object)"-datatypes", (Object)BoxesRunTime.boxToInteger((int)this.DATATYPE())), new Tuple2((Object)"-contexts", (Object)BoxesRunTime.boxToInteger((int)this.CONTEXT()))}));
        Seq product = (Seq)policies.withFilter((Function1)new anonfun.5()).flatMap((Function1)new anonfun.6(positions), Seq$.MODULE$.canBuildFrom());
        this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies = (Map)Predef$.MODULE$.locally((Object)product.toMap(Predef$.MODULE$.conforms()));
        this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"trix-triples"), (Object)new anonfun.7()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"trix-quads"), (Object)new anonfun.8()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"turtle-triples"), (Object)new anonfun.9()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"turtle-quads"), (Object)new anonfun.10()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"n-triples"), (Object)new anonfun.11()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"n-quads"), (Object)new anonfun.12())}));
        this.MAX_LENGTH = 500;
    }
}

