/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.util.text.xml;

public class XmlEncoder {
    private final String _str;
    private int _last = 0;
    private StringBuilder _sb;

    public static String encode(String string) {
        return XmlEncoder.encode(string, false);
    }

    public static void encode(String str, StringBuilder target) {
        XmlEncoder.encode(str, target, false);
    }

    public static String encodeAttr(String string) {
        return XmlEncoder.encode(string, true);
    }

    public static void encodeAttr(String string, StringBuilder target) {
        XmlEncoder.encode(string, target, true);
    }

    public static String encode(String string, boolean attr2) {
        XmlEncoder encoder = new XmlEncoder(string);
        encoder.encode(attr2);
        return encoder.result();
    }

    public static void encode(String string, StringBuilder target, boolean attr2) {
        new XmlEncoder(string, target).encode(attr2);
    }

    public XmlEncoder(String str) {
        if (str == null) {
            throw new NullPointerException("string");
        }
        this._str = str;
        this._sb = null;
    }

    public XmlEncoder(String string, StringBuilder target) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        if (target == null) {
            throw new NullPointerException("target");
        }
        this._str = string;
        this._sb = target;
    }

    public void encode(boolean attr2) {
        for (int pos = 0; pos < this._str.length(); ++pos) {
            char ch = this._str.charAt(pos);
            if (ch == '<') {
                this.append(pos, "&lt;");
                continue;
            }
            if (ch == '>') {
                this.append(pos, "&gt;");
                continue;
            }
            if (ch == '&') {
                this.append(pos, "&amp;");
                continue;
            }
            if (!attr2) continue;
            if (ch == '\'') {
                this.append(pos, "&apos;");
                continue;
            }
            if (ch != '\"') continue;
            this.append(pos, "&quot;");
        }
        if (this._sb != null) {
            this._sb.append(this._str, this._last, this._str.length());
        }
    }

    public String result() {
        return this._sb == null ? this._str : this._sb.toString();
    }

    private void append(int pos, String app) {
        if (this._sb == null) {
            this._sb = new StringBuilder();
        }
        this._sb.append(this._str, this._last, pos);
        this._sb.append(app);
        this._last = pos + 1;
    }
}

