/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.util.text.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLStreamUtils {
    public static boolean isStartElement(XMLStreamReader reader, String uri2, String name2) {
        return XMLStreamUtils.isElement(reader, 1, uri2, name2);
    }

    public static boolean isEndElement(XMLStreamReader reader, String uri2, String name2) {
        return XMLStreamUtils.isElement(reader, 2, uri2, name2);
    }

    private static boolean isElement(XMLStreamReader reader, int event, String uri2, String name2) {
        String found;
        if (reader.getEventType() != event) {
            return false;
        }
        if (uri2 != null && !(found = reader.getNamespaceURI()).equals(uri2)) {
            return false;
        }
        return name2 == null || (found = reader.getLocalName()).equals(name2);
    }

    public static void requireStartElement(XMLStreamReader reader, String uri2, String name2) throws XMLStreamException {
        XMLStreamUtils.requireElement(reader, 1, uri2, name2, "");
    }

    public static void requireEndElement(XMLStreamReader reader, String uri2, String name2) throws XMLStreamException {
        XMLStreamUtils.requireElement(reader, 2, uri2, name2, "/");
    }

    private static void requireElement(XMLStreamReader reader, int event, String uri2, String name2, String slash) throws XMLStreamException {
        String found;
        if (reader.getEventType() != event) {
            throw new XMLStreamException("expected <" + slash + name2 + ">", reader.getLocation());
        }
        if (uri2 != null && !(found = reader.getNamespaceURI()).equals(uri2)) {
            throw new XMLStreamException("expected <" + slash + name2 + "> with namespace [" + uri2 + "], found [" + found + "]", reader.getLocation());
        }
        if (name2 != null && !(found = reader.getLocalName()).equals(name2)) {
            throw new XMLStreamException("expected <" + slash + name2 + ">, found <" + slash + found + ">", reader.getLocation());
        }
    }

    public static void skipElement(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() != 1) {
            throw new XMLStreamException("expected start of element", reader.getLocation());
        }
        int depth = 0;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                ++depth;
                continue;
            }
            if (event != 2 || --depth != -1) continue;
            break;
        }
    }

    public static String requireAttr(XMLStreamReader reader, String elem, String attr2) throws XMLStreamException {
        String str = reader.getAttributeValue(null, attr2);
        if (str == null || str.length() == 0) {
            throw new XMLStreamException("expected non-empty attribute [" + attr2 + "] on element [" + elem + "]", reader.getLocation());
        }
        return str;
    }
}

