/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.util.text.uri;

import java.nio.charset.Charset;

public class UriDecoder {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String _str;
    private StringBuilder _sb = null;
    private int _last = 0;
    private int _start = -1;
    private byte[] _bytes = new byte[8];
    private int _count = 0;

    public static String decode(String string) {
        UriDecoder decoder = new UriDecoder(string);
        decoder.decode();
        return decoder.result();
    }

    public UriDecoder(String string) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        this._str = string;
    }

    public void decode() {
        for (int pos = 0; pos < this._str.length(); ++pos) {
            int b;
            char c = this._str.charAt(pos);
            if (c == '%' && (b = this.getByte(pos + 1)) >= 0) {
                this.addByte(b, pos);
                pos += 2;
                continue;
            }
            this.useBytes(pos);
        }
        this.useBytes(this._str.length());
        if (this._sb != null) {
            this._sb.append(this._str, this._last, this._str.length());
        }
    }

    private void addByte(int b, int pos) {
        if (this._count == this._bytes.length) {
            this._bytes = new byte[this._count << 1];
            System.arraycopy(this._bytes, 0, this._bytes, 0, this._count);
        }
        this._bytes[this._count] = (byte)b;
        if (this._start == -1) {
            this._start = pos;
        }
        ++this._count;
    }

    public String result() {
        return this._sb == null ? this._str : this._sb.toString();
    }

    private void useBytes(int pos) {
        if (this._count == 0) {
            return;
        }
        if (this._sb == null) {
            this._sb = new StringBuilder();
        }
        this._sb.append(this._str, this._last, this._start);
        this._sb.append(new String(this._bytes, 0, this._count, UTF_8));
        this._start = -1;
        this._count = 0;
        this._last = pos;
    }

    private int getByte(int pos) {
        if (pos + 2 > this._str.length()) {
            return -1;
        }
        try {
            return Integer.parseInt(this._str.substring(pos, pos + 2), 16);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

