/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.util.text.nt;

public class NtDecoder {
    private final String _str;
    private StringBuilder _sb = null;
    private int _last = 0;

    public static String decodeNt(String string) {
        NtDecoder decoder = new NtDecoder(string);
        decoder.decode();
        return decoder.result();
    }

    public static void decodeNt(String string, StringBuilder target) {
        new NtDecoder(string, target).decode();
    }

    public NtDecoder(String string) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        this._str = string;
    }

    public NtDecoder(String string, StringBuilder target) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        if (target == null) {
            throw new NullPointerException("target");
        }
        this._str = string;
        this._sb = target;
    }

    public void decode() {
        for (int pos = 0; pos < this._str.length(); ++pos) {
            char ch = this._str.charAt(pos);
            if (ch != '\\') continue;
            if (pos + 1 == this._str.length()) {
                throw this.error();
            }
            ch = this._str.charAt(pos + 1);
            if (ch == 't') {
                this.append(pos, '\t');
            } else if (ch == 'n') {
                this.append(pos, '\n');
            } else if (ch == 'r') {
                this.append(pos, '\r');
            } else if (ch == '\"') {
                this.append(pos, '\"');
            } else if (ch == '\\') {
                this.append(pos, '\\');
            } else if (ch == 'u') {
                this.appendCode(pos, 6);
            } else if (ch == 'U') {
                this.appendCode(pos, 10);
            } else {
                throw this.error();
            }
            pos = this._last - 1;
        }
        if (this._sb != null) {
            this._sb.append(this._str, this._last, this._str.length());
        }
    }

    public String result() {
        return this._sb == null ? this._str : this._sb.toString();
    }

    private void append(int pos, char app) {
        if (this._sb == null) {
            this._sb = new StringBuilder();
        }
        this._sb.append(this._str, this._last, pos);
        this._sb.append(app);
        this._last = pos + 2;
    }

    private void appendCode(int pos, int length) {
        int code;
        if (pos + length > this._str.length()) {
            throw this.error();
        }
        try {
            String hex = this._str.substring(pos + 2, pos + length);
            code = Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException e) {
            throw this.error(e);
        }
        if (this._sb == null) {
            this._sb = new StringBuilder();
        }
        this._sb.append(this._str, this._last, pos);
        try {
            this._sb.appendCodePoint(code);
        }
        catch (IllegalArgumentException e) {
            throw this.error(e);
        }
        this._last = pos + length;
    }

    private IllegalArgumentException error() {
        return this.error(null);
    }

    private IllegalArgumentException error(Throwable cause) {
        return new IllegalArgumentException("invalid N-Triples string [" + this._str + "]", cause);
    }
}

