/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.util.text.nt;

public class NtCharsDecoder {
    private static final String[] SPECIAL = new String[128];
    private final String _str;
    private StringBuilder _sb = null;
    private int _last = 0;

    public static String decodeNtChars(String string) {
        NtCharsDecoder decoder = new NtCharsDecoder(string);
        decoder.decode();
        return decoder.result();
    }

    public static void decodeNtChars(String string, StringBuilder target) {
        new NtCharsDecoder(string, target).decode();
    }

    public NtCharsDecoder(String string) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        this._str = string;
    }

    public NtCharsDecoder(String string, StringBuilder target) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        if (target == null) {
            throw new NullPointerException("target");
        }
        this._str = string;
        this._sb = target;
    }

    public void decode() {
        for (int pos = 0; pos < this._str.length(); ++pos) {
            String rep;
            char ch = this._str.charAt(pos);
            if (ch == '\\') {
                if (++pos == this._str.length()) {
                    throw this.error();
                }
                ch = this._str.charAt(pos);
                if (ch == 't' || ch == 'n' || ch == 'r' || ch == '\"' || ch == '\\') continue;
                if (ch == 'u') {
                    this.appendCode(pos - 1, 6);
                } else if (ch == 'U') {
                    this.appendCode(pos - 1, 10);
                } else {
                    throw this.error();
                }
                pos = this._last - 1;
                continue;
            }
            if (ch >= '\u0080' || (rep = SPECIAL[ch]) == null) continue;
            this.append(pos, rep);
        }
        if (this._sb != null) {
            this._sb.append(this._str, this._last, this._str.length());
        }
    }

    public String result() {
        return this._sb == null ? this._str : this._sb.toString();
    }

    private void append(int pos, String app) {
        if (this._sb == null) {
            this._sb = new StringBuilder();
        }
        this._sb.append(this._str.substring(this._last, pos));
        this._sb.append(app);
        this._last = pos + 1;
    }

    private void appendCode(int pos, int length) {
        String rep;
        int code;
        if (pos + length > this._str.length()) {
            throw this.error();
        }
        try {
            String hex = this._str.substring(pos + 2, pos + length);
            code = Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException e) {
            throw this.error(e);
        }
        if (this._sb == null) {
            this._sb = new StringBuilder();
        }
        this._sb.append(this._str.substring(this._last, pos));
        String string = rep = code < 128 ? SPECIAL[code] : null;
        if (rep != null) {
            this._sb.append(rep);
        } else {
            try {
                this._sb.appendCodePoint(code);
            }
            catch (IllegalArgumentException e) {
                throw this.error(e);
            }
        }
        this._last = pos + length;
    }

    private IllegalArgumentException error() {
        return this.error(null);
    }

    private IllegalArgumentException error(Throwable cause) {
        return new IllegalArgumentException("invalid N-Triples string [" + this._str + "]", cause);
    }

    static {
        NtCharsDecoder.SPECIAL[9] = "\\t";
        NtCharsDecoder.SPECIAL[10] = "\\n";
        NtCharsDecoder.SPECIAL[13] = "\\r";
        NtCharsDecoder.SPECIAL[34] = "\\\"";
        NtCharsDecoder.SPECIAL[92] = "\\\\";
    }
}

