/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.wikiparser;

import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.RichString$;
import org.dbpedia.extraction.util.WikiUtil$;
import org.dbpedia.extraction.wikiparser.Namespace;
import org.dbpedia.extraction.wikiparser.WikiParserException;
import org.dbpedia.extraction.wikiparser.WikiTitle$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001-\u0011\u0011bV5lSRKG\u000f\\3\u000b\u0005\r!\u0011AC<jW&\u0004\u0018M]:fe*\u0011QAB\u0001\u000bKb$(/Y2uS>t'BA\u0004\t\u0003\u001d!'\r]3eS\u0006T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011!\u0002CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t7\u0001\u0011)\u0019!C\u00019\u00059A-Z2pI\u0016$W#A\u000f\u0011\u0005y\tcBA\u000b \u0013\t\u0001c#\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\r\u0012aa\u0015;sS:<'B\u0001\u0011\u0017\u0011!)\u0003A!A!\u0002\u0013i\u0012\u0001\u00033fG>$W\r\u001a\u0011\t\u0011\u001d\u0002!Q1A\u0005\u0002!\n\u0011B\\1nKN\u0004\u0018mY3\u0016\u0003%\u0002\"AK\u0016\u000e\u0003\tI!\u0001\f\u0002\u0003\u00139\u000bW.Z:qC\u000e,\u0007\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u00159\fW.Z:qC\u000e,\u0007\u0005\u0003\u00051\u0001\t\u0015\r\u0011\"\u00012\u0003!a\u0017M\\4vC\u001e,W#\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U\"\u0011\u0001B;uS2L!a\u000e\u001b\u0003\u00111\u000bgnZ;bO\u0016D\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAM\u0001\nY\u0006tw-^1hK\u0002B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001P\u0001\u0014SNLe\u000e^3s\u0019\u0006tw-^1hK2Kgn[\u000b\u0002{A\u0011QCP\u0005\u0003\u007fY\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003>\u0003QI7/\u00138uKJd\u0015M\\4vC\u001e,G*\u001b8lA!A1\t\u0001BC\u0002\u0013\u0005A$\u0001\u0005ge\u0006<W.\u001a8u\u0011!)\u0005A!A!\u0002\u0013i\u0012!\u00034sC\u001elWM\u001c;!\u0011\u00159\u0005\u0001\"\u0001I\u0003\u0019a\u0014N\\5u}Q1\u0011JS&M\u001b:\u0003\"A\u000b\u0001\t\u000bm1\u0005\u0019A\u000f\t\u000b\u001d2\u0005\u0019A\u0015\t\u000bA2\u0005\u0019\u0001\u001a\t\u000fm2\u0005\u0013!a\u0001{!91I\u0012I\u0001\u0002\u0004i\u0002b\u0002)\u0001\u0005\u0004%\t\u0001H\u0001\bK:\u001cw\u000eZ3e\u0011\u0019\u0011\u0006\u0001)A\u0005;\u0005AQM\\2pI\u0016$\u0007\u0005C\u0004U\u0001\t\u0007I\u0011\u0001\u000f\u0002)\u0011,7m\u001c3fI^KG\u000f\u001b(b[\u0016\u001c\b/Y2f\u0011\u00191\u0006\u0001)A\u0005;\u0005)B-Z2pI\u0016$w+\u001b;i\u001d\u0006lWm\u001d9bG\u0016\u0004\u0003b\u0002-\u0001\u0005\u0004%\t\u0001H\u0001\u0015K:\u001cw\u000eZ3e/&$\bNT1nKN\u0004\u0018mY3\t\ri\u0003\u0001\u0015!\u0003\u001e\u0003U)gnY8eK\u0012<\u0016\u000e\u001e5OC6,7\u000f]1dK\u0002Bq\u0001\u0018\u0001C\u0002\u0013\u0005Q,A\u0004qC\u001e,\u0017J]5\u0016\u0003y\u0003\"!D0\n\u0005\tr\u0001BB1\u0001A\u0003%a,\u0001\u0005qC\u001e,\u0017J]5!\u0011\u0015\u0019\u0007\u0001\"\u0003e\u000359\u0018\u000e\u001e5OC6,7\u000f]1dKR\u0011Q$\u001a\u0005\u0006M\n\u0004\r!P\u0001\u0007K:\u001cw\u000eZ3\t\u000b!\u0004A\u0011I5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u0018\u0005\u0006W\u0002!\t\u0005\\\u0001\u0007KF,\u0018\r\\:\u0015\u0005uj\u0007\"\u00028k\u0001\u0004y\u0017!B8uQ\u0016\u0014\bCA\u000bq\u0013\t\thCA\u0002B]fDQa\u001d\u0001\u0005BQ\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002kB\u0011QC^\u0005\u0003oZ\u00111!\u00138u\u000f\u0015I(\u0001#\u0002{\u0003%9\u0016n[5USRdW\r\u0005\u0002+w\u001a)\u0011A\u0001E\u0003yN\u00191\u0010\u0004\u000b\t\u000b\u001d[H\u0011\u0001@\u0015\u0003iDq!!\u0001|\t\u0003\t\u0019!A\u0003qCJ\u001cX\rF\u0003J\u0003\u000b\tI\u0001\u0003\u0004\u0002\b}\u0004\r!H\u0001\u0006i&$H.\u001a\u0005\u0007\u0003\u0017y\b\u0019\u0001\u001a\u0002\u001dM|WO]2f\u0019\u0006tw-^1hK\"I\u0011qB>\u0012\u0002\u0013\u0005\u0011\u0011C\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019BK\u0002>\u0003+Y#!a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C1\u0012AC1o]>$\u0018\r^5p]&!\u0011QEA\u000e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003SY\u0018\u0013!C\u0001\u0003W\ta\"\u001b8ji\u0012\"WMZ1vYR$S'\u0006\u0002\u0002.)\u001aQ$!\u0006")
public class WikiTitle
implements ScalaObject {
    private final String decoded;
    private final Namespace namespace;
    private final Language language;
    private final boolean isInterLanguageLink;
    private final String fragment;
    private final String encoded;
    private final String decodedWithNamespace;
    private final String encodedWithNamespace;
    private final String pageIri;

    public static final String init$default$5() {
        return WikiTitle$.MODULE$.init$default$5();
    }

    public static final boolean init$default$4() {
        return WikiTitle$.MODULE$.init$default$4();
    }

    public static final WikiTitle parse(String string, Language language) {
        return WikiTitle$.MODULE$.parse(string, language);
    }

    public String decoded() {
        return this.decoded;
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public Language language() {
        return this.language;
    }

    public boolean isInterLanguageLink() {
        return this.isInterLanguageLink;
    }

    public String fragment() {
        return this.fragment;
    }

    public String encoded() {
        return this.encoded;
    }

    public String decodedWithNamespace() {
        return this.decodedWithNamespace;
    }

    public String encodedWithNamespace() {
        return this.encodedWithNamespace;
    }

    public String pageIri() {
        return this.pageIri;
    }

    private String withNamespace(boolean encode) {
        String ns = this.namespace().name(this.language());
        if (encode) {
            ns = RichString$.MODULE$.wrapString(WikiUtil$.MODULE$.wikiEncode(ns)).capitalize(this.language().locale());
        }
        return new StringBuilder().append((Object)(ns.isEmpty() ? ns : new StringBuilder().append((Object)ns).append((Object)BoxesRunTime.boxToCharacter((char)':')).toString())).append((Object)(encode ? this.encoded() : this.decoded())).toString();
    }

    public String toString() {
        String frag = this.fragment() == null ? "" : new StringBuilder().append((Object)";fragment='").append((Object)this.fragment()).append((Object)"'").toString();
        return new StringBuilder().append((Object)"title=").append((Object)this.decoded()).append((Object)";ns=").append((Object)this.namespace()).append((Object)"/").append((Object)this.namespace().name(this.language())).append((Object)";language:").append((Object)this.language()).append((Object)frag).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        WikiTitle wikiTitle;
        Object object = other;
        if (!(object instanceof WikiTitle)) return false;
        WikiTitle title = wikiTitle = (WikiTitle)object;
        Language language = this.language();
        Language language2 = title.language();
        if (language == null) {
            if (language2 != null) {
                return false;
            }
        } else if (!language.equals(language2)) return false;
        Namespace namespace = this.namespace();
        Namespace namespace2 = title.namespace();
        if (namespace == null) {
            if (namespace2 != null) {
                return false;
            }
        } else if (!namespace.equals(namespace2)) return false;
        String string = this.decoded();
        String string2 = title.decoded();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return this.language().hashCode() ^ this.decoded().hashCode() ^ this.namespace().hashCode();
    }

    public WikiTitle(String decoded, Namespace namespace, Language language, boolean isInterLanguageLink, String fragment) {
        this.decoded = decoded;
        this.namespace = namespace;
        this.language = language;
        this.isInterLanguageLink = isInterLanguageLink;
        this.fragment = fragment;
        if (decoded.isEmpty()) {
            throw new WikiParserException("page name must not be empty");
        }
        this.encoded = RichString$.MODULE$.wrapString(WikiUtil$.MODULE$.wikiEncode(decoded)).capitalize(language.locale());
        this.decodedWithNamespace = this.withNamespace(false);
        this.encodedWithNamespace = this.withNamespace(true);
        this.pageIri = new StringBuilder().append((Object)language.baseUri()).append((Object)"/wiki/").append((Object)this.encodedWithNamespace()).toString();
    }
}

