/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import org.dbpedia.extraction.util.RichString$;
import org.dbpedia.extraction.util.StringUtils$;
import org.dbpedia.util.text.uri.UriDecoder;
import scala.Predef$;
import scala.ScalaObject;
import scala.util.matching.Regex;

public final class WikiUtil$
implements ScalaObject {
    public static final WikiUtil$ MODULE$;
    private final String[] iriReplacements;
    private final Regex wikiEmphasisRegex1;
    private final Regex wikiEmphasisRegex2;
    private final Regex wikiEmphasisRegex3;

    static {
        new WikiUtil$();
    }

    public String cleanSpace(String string) {
        return RichString$.MODULE$.wrapString(string).replaceChars("_\u00a0\u200e\u200f\u2028\u202a\u202b\u202c\u3000", "  ").replaceAll(" +", " ").trim();
    }

    private String[] iriReplacements() {
        return this.iriReplacements;
    }

    public String wikiEncode(String name2) {
        String encoded = name2.replace(' ', '_');
        encoded = encoded.replaceAll("_+", "_");
        encoded = encoded.replaceAll("^_", "");
        encoded = encoded.replaceAll("_$", "");
        StringBuilder sb = StringUtils$.MODULE$.escape(null, encoded, this.iriReplacements());
        return sb == null ? encoded : sb.toString();
    }

    public String wikiDecode(String name2) {
        return this.cleanSpace(UriDecoder.decode(name2));
    }

    private Regex wikiEmphasisRegex1() {
        return this.wikiEmphasisRegex1;
    }

    private Regex wikiEmphasisRegex2() {
        return this.wikiEmphasisRegex2;
    }

    private Regex wikiEmphasisRegex3() {
        return this.wikiEmphasisRegex3;
    }

    /*
     * WARNING - void declaration
     */
    public String removeWikiEmphasis(String text) {
        void var2_2;
        String result = this.wikiEmphasisRegex1().replaceAllIn((CharSequence)text, "$1");
        result = this.wikiEmphasisRegex2().replaceAllIn((CharSequence)result, "$1");
        result = this.wikiEmphasisRegex3().replaceAllIn((CharSequence)result, "$1");
        return var2_2;
    }

    private WikiUtil$() {
        MODULE$ = this;
        this.iriReplacements = StringUtils$.MODULE$.replacements('%', "\"#%<>?[\\]^`{|}", StringUtils$.MODULE$.replacements$default$3());
        this.wikiEmphasisRegex1 = Predef$.MODULE$.augmentString("(?s)'''''(.*?)'''''").r();
        this.wikiEmphasisRegex2 = Predef$.MODULE$.augmentString("(?s)'''(.*?)'''").r();
        this.wikiEmphasisRegex3 = Predef$.MODULE$.augmentString("(?s)''(.*?)''").r();
    }
}

