/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.io.File;
import java.net.URL;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.WikiInfo;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WikiInfo$
implements ScalaObject {
    public static final WikiInfo$ MODULE$;
    private final URL URL;
    private final String FileName;

    static {
        new WikiInfo$();
    }

    public URL URL() {
        return this.URL;
    }

    public String FileName() {
        return this.FileName;
    }

    public Seq<WikiInfo> fromFile(File file, Codec codec) {
        BufferedSource source = Source$.MODULE$.fromFile(file, codec);
        Seq<WikiInfo> exceptionResult1 = null;
        try {
            exceptionResult1 = this.fromSource((Source)source);
            return exceptionResult1;
        }
        finally {
            source.close();
        }
    }

    public Seq<WikiInfo> fromURL(URL url, Codec codec) {
        BufferedSource source = Source$.MODULE$.fromURL(url, codec);
        Seq<WikiInfo> exceptionResult2 = null;
        try {
            exceptionResult2 = this.fromSource((Source)source);
            return exceptionResult2;
        }
        finally {
            source.close();
        }
    }

    public Seq<WikiInfo> fromSource(Source source) {
        return this.fromLines((Iterator<String>)source.getLines());
    }

    public Seq<WikiInfo> fromLines(Iterator<String> lines) {
        ArrayBuffer info$1 = new ArrayBuffer();
        if (lines.hasNext()) {
            lines.next();
            lines.foreach((Function1)new Serializable(info$1){
                public static final long serialVersionUID;
                private final ArrayBuffer info$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(String line) {
                    return Predef$.MODULE$.augmentString(line).nonEmpty() ? this.info$1.$plus$eq((Object)WikiInfo$.MODULE$.fromLine(line)) : BoxedUnit.UNIT;
                }
                {
                    this.info$1 = arrayBuffer;
                }
            });
            return info$1;
        }
        throw new Exception("empty file");
    }

    public WikiInfo fromLine(String line) {
        int pages;
        String[] fields = line.split(",", -1);
        if (fields.length != 15) {
            throw new Exception(new StringBuilder().append((Object)"expected [15] fields, found [").append((Object)BoxesRunTime.boxToInteger((int)fields.length)).append((Object)"] in line [").append((Object)line).append((Object)"]").toString());
        }
        int exceptionResult3 = 0;
        try {
            pages = exceptionResult3 = Predef$.MODULE$.augmentString(fields[5]).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception(new StringBuilder().append((Object)"expected page count in field with index [5], found line [").append((Object)line).append((Object)"]").toString());
        }
        String wikiCode = fields[2];
        if (ConfigUtils$.MODULE$.LanguageRegex().pattern().matcher(fields[2]).matches()) {
            return new WikiInfo(Language$.MODULE$.apply(wikiCode), pages);
        }
        throw new Exception(new StringBuilder().append((Object)"expected language code in field with index [2], found line [").append((Object)line).append((Object)"]").toString());
    }

    private WikiInfo$() {
        MODULE$ = this;
        this.URL = new URL("http://s23.org/wikistats/wikipedias_csv.php");
        this.FileName = "wikipedias.csv";
    }
}

