/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.dbpedia.util.text.uri.UriDecoder;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u0017\tQq+[6j\u0007\u0006dG.\u001a:\u000b\u0005\r!\u0011\u0001B;uS2T!!\u0002\u0004\u0002\u0015\u0015DHO]1di&|gN\u0003\u0002\b\u0011\u00059AM\u00199fI&\f'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011m\u0001!\u0011!Q\u0001\nq\t1!\u001e:m!\ti\u0002%D\u0001\u001f\u0015\ty\u0002#A\u0002oKRL!!\t\u0010\u0003\u0007U\u0013F\n\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003=1w\u000e\u001c7poJ+G-\u001b:fGR\u001c\bCA\u000b&\u0013\t1cCA\u0004C_>dW-\u00198\t\u000b!\u0002A\u0011A\u0015\u0002\rqJg.\u001b;?)\rQC&\f\t\u0003W\u0001i\u0011A\u0001\u0005\u00067\u001d\u0002\r\u0001\b\u0005\u0006G\u001d\u0002\r\u0001\n\u0005\u0006_\u0001!\t\u0001M\u0001\bKb,7-\u001e;f+\t\tD\u0007\u0006\u00023{A\u00111\u0007\u000e\u0007\u0001\t\u0015)dF1\u00017\u0005\u0005\u0011\u0016CA\u001c;!\t)\u0002(\u0003\u0002:-\t9aj\u001c;iS:<\u0007CA\u000b<\u0013\tadCA\u0002B]fDQA\u0010\u0018A\u0002}\nq\u0001\u001d:pG\u0016\u001c8\u000f\u0005\u0003\u0016\u0001\n\u0013\u0014BA!\u0017\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002D\r6\tAI\u0003\u0002F!\u0005\u0011\u0011n\\\u0005\u0003\u000f\u0012\u00131\"\u00138qkR\u001cFO]3b[\")\u0011\n\u0001C\u0005\u0015\u0006i1\r[3dWJ+7\u000f]8og\u0016$\"a\u0013(\u0011\u0005Ua\u0015BA'\u0017\u0005\u0011)f.\u001b;\t\u000b=C\u0005\u0019\u0001)\u0002\t\r|gN\u001c\t\u0003;EK!A\u0015\u0010\u0003#!#H\u000f]+S\u0019\u000e{gN\\3di&|g\u000e")
public class WikiCaller
implements ScalaObject {
    private final URL url;
    private final boolean followRedirects;

    public <R> R execute(Function1<InputStream, R> process) {
        HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
        Object exceptionResult2 = null;
        try {
            this.checkResponse(conn);
            InputStream in = conn.getInputStream();
            Object exceptionResult3 = null;
            try {
                exceptionResult3 = process.apply((Object)in);
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            exceptionResult2 = exceptionResult3;
            return (R)exceptionResult2;
        }
        finally {
            conn.disconnect();
        }
    }

    private void checkResponse(HttpURLConnection conn) {
        conn.setInstanceFollowRedirects(this.followRedirects);
        int code = conn.getResponseCode();
        if (code != 200) {
            String location = conn.getHeaderField("Location");
            if (location != null) {
                location = UriDecoder.decode(location);
                URL url2 = new URL(location);
                if (!(this.followRedirects || code != 301 && code != 302)) {
                    String string = url2.getPath();
                    String string2 = this.url.getPath();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        String string3 = url2.getQuery();
                        String string4 = this.url.getQuery();
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            Seq parts = Predef$.MODULE$.refArrayOps((Object[])this.url.getHost().split("\\.", -1)).toSeq();
                            Seq parts2 = Predef$.MODULE$.refArrayOps((Object[])url2.getHost().split("\\.", -1)).toSeq();
                            if (BoxesRunTime.equals((Object)parts.tail(), (Object)parts2.tail())) {
                                throw new HttpRetryException((String)parts2.head(), code, location);
                            }
                        }
                    }
                }
            }
            throw new IOException(new StringBuilder().append((Object)"URL '").append((Object)this.url).append((Object)"' replied ").append((Object)BoxesRunTime.boxToInteger((int)code)).append((Object)" ").append((Object)conn.getResponseMessage()).append((Object)" - Location: '").append((Object)location).append((Object)"'").toString());
        }
    }

    public WikiCaller(URL url, boolean followRedirects) {
        this.url = url;
        this.followRedirects = followRedirects;
    }
}

