/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.text.DateFormat;
import java.text.Format;
import org.dbpedia.extraction.util.NumberUtils$;
import org.dbpedia.extraction.util.StringUtils$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils$
implements ScalaObject {
    public static final StringUtils$ MODULE$;
    private final ThreadLocal<DateFormat> timestampFormat;
    private final String zeros;

    static {
        new StringUtils$();
    }

    private ThreadLocal<DateFormat> timestampFormat() {
        return this.timestampFormat;
    }

    public String formatCurrentTimestamp() {
        return this.formatTimestamp(System.currentTimeMillis());
    }

    public String formatTimestamp(long timestamp) {
        return timestamp < 0L ? "" : ((Format)this.timestampFormat().get()).format(BoxesRunTime.boxToLong((long)timestamp));
    }

    public long parseTimestamp(String str) {
        return str == null || str.isEmpty() ? -1L : this.timestampFormat().get().parse(str).getTime();
    }

    public String prettyMillis(long millis) {
        return new StringBuilder().append((Object)this.zeros(2, millis / 60000L)).append((Object)BoxesRunTime.boxToCharacter((char)':')).append((Object)this.zeros(2, millis % 60000L / 1000L)).append((Object)BoxesRunTime.boxToCharacter((char)'.')).append((Object)this.zeros(3, millis % 1000L)).append((Object)BoxesRunTime.boxToCharacter((char)'s')).toString();
    }

    private String zeros() {
        return this.zeros;
    }

    private String zeros(int z, long n) {
        int p = 10;
        for (int e = 1; e < z; ++e) {
            if (n < (long)p) {
                return new StringBuilder().append((Object)this.zeros().substring(0, z - e)).append((Object)BoxesRunTime.boxToLong((long)n)).toString();
            }
            p *= 10;
        }
        return ((Object)BoxesRunTime.boxToLong((long)n)).toString();
    }

    public java.lang.StringBuilder escape(java.lang.StringBuilder target, String str, char esc$1, String replace) {
        ObjectRef sb$1 = new ObjectRef((Object)target);
        char[] chars = str.toCharArray();
        int last = 0;
        for (int pos = 0; pos < chars.length; ++pos) {
            Object object;
            char c = chars[pos];
            if (replace.indexOf(c) != -1) {
                if ((java.lang.StringBuilder)sb$1.elem == null) {
                    sb$1.elem = new java.lang.StringBuilder();
                }
                ((java.lang.StringBuilder)sb$1.elem).append(chars, last, pos - last);
                last = pos + 1;
                if (c < '\u0080') {
                    ((java.lang.StringBuilder)sb$1.elem).append(esc$1);
                    object = NumberUtils$.MODULE$.intToHex((java.lang.StringBuilder)sb$1.elem, c, 2);
                    continue;
                }
                byte[] bytes = new String(Array$.MODULE$.apply(c, (Seq)Predef$.MODULE$.wrapCharArray(new char[0]))).getBytes("UTF-8");
                Predef$.MODULE$.byteArrayOps(bytes).foreach((Function1)new Serializable(esc$1, sb$1){
                    public static final long serialVersionUID;
                    private final char esc$1;
                    private final ObjectRef sb$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final java.lang.StringBuilder apply(byte b) {
                        ((java.lang.StringBuilder)this.sb$1.elem).append(this.esc$1);
                        return NumberUtils$.MODULE$.intToHex((java.lang.StringBuilder)this.sb$1.elem, b, 2);
                    }
                    {
                        this.esc$1 = c;
                        this.sb$1 = objectRef;
                    }
                });
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        Object object = (java.lang.StringBuilder)sb$1.elem == null ? BoxedUnit.UNIT : ((java.lang.StringBuilder)sb$1.elem).append(chars, last, chars.length - last);
        return (java.lang.StringBuilder)sb$1.elem;
    }

    public String[] replacements(char esc$2, String chars, int limit) {
        String[] stringArray;
        if (chars.isEmpty()) {
            stringArray = new String[]{};
        } else {
            char max = BoxesRunTime.unboxToChar((Object)Predef$.MODULE$.augmentString(chars).max((Ordering)Ordering.Char$.MODULE$));
            if (max >= limit) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"highest code point ").append((Object)BoxesRunTime.boxToInteger((int)max)).append((Object)" exceeds limit ").append((Object)BoxesRunTime.boxToInteger((int)limit)).toString());
            }
            String[] replace = new String[max + '\u0001'];
            for (int pos = 0; pos < chars.length(); ++pos) {
                java.lang.StringBuilder stringBuilder;
                char c = chars.charAt(pos);
                java.lang.StringBuilder sb$2 = new java.lang.StringBuilder();
                if (c < '\u0080') {
                    sb$2.append(esc$2);
                    stringBuilder = NumberUtils$.MODULE$.intToHex(sb$2, c, 2);
                } else {
                    byte[] bytes = new String(Array$.MODULE$.apply(c, (Seq)Predef$.MODULE$.wrapCharArray(new char[0]))).getBytes("UTF-8");
                    Predef$.MODULE$.byteArrayOps(bytes).foreach((Function1)new Serializable(esc$2, sb$2){
                        public static final long serialVersionUID;
                        private final char esc$2;
                        private final java.lang.StringBuilder sb$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final java.lang.StringBuilder apply(byte b) {
                            this.sb$2.append(this.esc$2);
                            return NumberUtils$.MODULE$.intToHex(this.sb$2, b, 2);
                        }
                        {
                            this.esc$2 = c;
                            this.sb$2 = stringBuilder;
                        }
                    });
                    stringBuilder = BoxedUnit.UNIT;
                }
                replace[c] = sb$2.toString();
            }
            stringArray = replace;
        }
        return stringArray;
    }

    public int replacements$default$3() {
        return 256;
    }

    public java.lang.StringBuilder escape(java.lang.StringBuilder target, String str, String[] replace) {
        java.lang.StringBuilder sb = target;
        char[] chars = str.toCharArray();
        int last = 0;
        for (int pos = 0; pos < chars.length; ++pos) {
            Object object;
            char c = chars[pos];
            if (c < replace.length) {
                String rep = replace[c];
                if (rep == null) {
                    object = BoxedUnit.UNIT;
                    continue;
                }
                if (sb == null) {
                    sb = new java.lang.StringBuilder();
                }
                sb.append(chars, last, pos - last);
                last = pos + 1;
                object = sb.append(rep);
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        Object object = sb == null ? BoxedUnit.UNIT : sb.append(chars, last, chars.length - last);
        return sb;
    }

    public java.lang.StringBuilder replaceChars(java.lang.StringBuilder target, String str, String replace, String by) {
        java.lang.StringBuilder sb = target;
        char[] chars = str.toCharArray();
        int last = 0;
        for (int pos = 0; pos < chars.length; ++pos) {
            char ch = chars[pos];
            int index = replace.indexOf(ch);
            if (index == -1) continue;
            if (sb == null) {
                sb = new java.lang.StringBuilder();
            }
            sb.append(chars, last, pos - last);
            Object object = index < by.length() ? sb.append(by.charAt(index)) : BoxedUnit.UNIT;
            last = pos + 1;
        }
        Object object = sb == null ? BoxedUnit.UNIT : sb.append(chars, last, chars.length - last);
        return sb;
    }

    private StringUtils$() {
        MODULE$ = this;
        this.timestampFormat = new anon.1();
        this.zeros = "0000000000000000000000000";
    }
}

