/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.io.File;
import java.io.FileNotFoundException;
import org.dbpedia.extraction.util.RichFile$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u0017\tia)\u001b7f!J|7-Z:t_JT!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b\u0019\t!\"\u001a=ue\u0006\u001cG/[8o\u0015\t9\u0001\"A\u0004eEB,G-[1\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"aC*dC2\fwJ\u00196fGRD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\bE\u0006\u001cX\rR5s!\ti\u0002%D\u0001\u001f\u0015\ty\u0002#\u0001\u0002j_&\u0011\u0011E\b\u0002\u0005\r&dW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003\u00191\u0017\u000e\u001c;feB!Q#J\u0014/\u0013\t1cCA\u0005Gk:\u001cG/[8ocA\u0011\u0001f\u000b\b\u0003+%J!A\u000b\f\u0002\rA\u0013X\rZ3g\u0013\taSF\u0001\u0004TiJLgn\u001a\u0006\u0003UY\u0001\"!F\u0018\n\u0005A2\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006e\u0001!\taM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007Q2t\u0007\u0005\u00026\u00015\t!\u0001C\u0003\u001cc\u0001\u0007A\u0004C\u0003$c\u0001\u0007A%\u0002\u0003:\u0001\u0001Q$!\u0003)s_\u000e,7o]8s!\u0015)2hJ\u0014>\u0013\tadCA\u0005Gk:\u001cG/[8oeA\u0011QCP\u0005\u0003\u007fY\u0011A!\u00168ji\")\u0011\t\u0001C\u0001\u0005\u0006a\u0001O]8dKN\u001ch)\u001b7fgR\u0011Qh\u0011\u0005\u0006\t\u0002\u0003\r!R\u0001\naJ|7-Z:t_J\u0004\"A\u0012\u001d\u000e\u0003\u0001AQ\u0001\u0013\u0001\u0005\n%\u000b\u0001\u0003\u001d:pG\u0016\u001c8OU3dkJ\u001c\u0018N^3\u0015\u0007uRE\nC\u0003L\u000f\u0002\u0007A$\u0001\u0003gS2,\u0007\"\u0002#H\u0001\u0004)\u0005\"\u0002(\u0001\t\u0013y\u0015\u0001\u0005:fC\u00124\u0015\u000e\\3D_:$XM\u001c;t)\t\u0001\u0006\f\u0006\u0002(#\"9!+\u0014I\u0001\u0002\b\u0019\u0016!B2pI\u0016\u001c\u0007C\u0001+W\u001b\u0005)&BA\u0010\u0017\u0013\t9VKA\u0003D_\u0012,7\rC\u0003L\u001b\u0002\u0007A\u0004C\u0004[\u0001E\u0005I\u0011B.\u00025I,\u0017\r\u001a$jY\u0016\u001cuN\u001c;f]R\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0015\u0005q3'FA*^W\u0005q\u0006CA0e\u001b\u0005\u0001'BA1c\u0003%)hn\u00195fG.,GM\u0003\u0002d-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0015\u0004'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\")1*\u0017a\u00019\u0001")
public class FileProcessor
implements ScalaObject {
    private final File baseDir;
    private final Function1<String, Object> filter;

    public void processFiles(Function2<String, String, BoxedUnit> processor) {
        this.org$dbpedia$extraction$util$FileProcessor$$processRecursive(this.baseDir, processor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void org$dbpedia$extraction$util$FileProcessor$$processRecursive(File file, Function2<String, String, BoxedUnit> processor$1) {
        if (file.isFile()) {
            String path = RichFile$.MODULE$.wrapFile(this.baseDir).relativize(file);
            if (!BoxesRunTime.unboxToBoolean((Object)this.filter.apply((Object)path))) return;
            String source = this.readFileContents(file, Codec$.MODULE$.fallbackSystemCodec());
            processor$1.apply((Object)path, (Object)source);
            return;
        } else {
            Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).foreach((Function1)new Serializable(this, processor$1){
                public static final long serialVersionUID;
                private final FileProcessor $outer;
                private final Function2 processor$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(File childFile) {
                    this.$outer.org$dbpedia$extraction$util$FileProcessor$$processRecursive(childFile, (Function2<String, String, BoxedUnit>)this.processor$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.processor$1 = function2;
                }
            });
        }
    }

    private String readFileContents(File file, Codec codec) {
        return Source$.MODULE$.fromFile(file, 65536, codec).mkString();
    }

    private Codec readFileContents$default$2(File file) {
        return Codec$.MODULE$.charset2codec(Codec$.MODULE$.UTF8());
    }

    public FileProcessor(File baseDir, Function1<String, Object> filter) {
        this.baseDir = baseDir;
        this.filter = filter;
        if (baseDir.exists()) {
            return;
        }
        throw new FileNotFoundException(new StringBuilder().append((Object)"'").append((Object)baseDir).append((Object)"' not found").toString());
    }
}

