/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.sources;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dbpedia.extraction.sources.WikiPage;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.wikiparser.Namespace;
import org.dbpedia.extraction.wikiparser.WikiTitle;
import org.dbpedia.util.Exceptions;
import org.dbpedia.util.text.xml.XMLStreamUtils;
import scala.Function1;
import scala.util.control.ControlThrowable;

public class WikipediaDumpParser {
    private static final Logger logger = Logger.getLogger(WikipediaDumpParser.class.getName());
    private static final String ROOT_ELEM = "mediawiki";
    private static final String SITEINFO_ELEM = "siteinfo";
    private static final String BASE_ELEM = "base";
    private static final String PAGE_ELEM = "page";
    private static final String TITLE_ELEM = "title";
    private static final String REDIRECT_ELEM = "redirect";
    private static final String ID_ELEM = "id";
    private static final String NS_ELEM = "ns";
    private static final String REVISION_ELEM = "revision";
    private static final String TEXT_ELEM = "text";
    private static final String TIMESTAMP_ELEM = "timestamp";
    private Reader _stream;
    private XMLStreamReader _reader;
    private final String _namespace = "http://www.mediawiki.org/xml/export-0.6/";
    private Language _language;
    private final Function1<WikiTitle, Boolean> _filter;
    private final Function1<WikiPage, ?> _processor;

    public WikipediaDumpParser(Reader stream, Language language, Function1<WikiTitle, Boolean> filter, Function1<WikiPage, ?> processor) {
        if (stream == null) {
            throw new NullPointerException("file");
        }
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        this._stream = stream;
        this._language = language;
        this._filter = filter;
        this._processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException, XMLStreamException, InterruptedException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        this._reader = factory.createXMLStreamReader(this._stream);
        try {
            this.readDump();
        }
        finally {
            this._stream.close();
            this._stream = null;
            this._reader.close();
            this._reader = null;
        }
    }

    private void readDump() throws XMLStreamException, InterruptedException {
        this.nextTag();
        this.requireStartElement(ROOT_ELEM);
        this.nextTag();
        if (this._language == null) {
            this._language = this.readSiteInfo();
        } else if (this.isStartElement(SITEINFO_ELEM)) {
            this.skipElement(SITEINFO_ELEM, true);
        }
        this.readPages();
        this.requireEndElement(ROOT_ELEM);
    }

    private Language readSiteInfo() throws XMLStreamException {
        this.requireStartElement(SITEINFO_ELEM);
        this.nextTag();
        this.skipElement("sitename", true);
        String uri2 = this.readString(BASE_ELEM, true);
        String wikiCode = uri2.substring(uri2.indexOf("://") + 3, uri2.indexOf(46));
        Language language = Language.apply(wikiCode);
        this.skipElement("generator", true);
        this.skipElement("case", true);
        this.skipElement("namespaces", true);
        this.requireEndElement(SITEINFO_ELEM);
        this.nextTag();
        return language;
    }

    private void readPages() throws XMLStreamException, InterruptedException {
        while (this.isStartElement(PAGE_ELEM)) {
            this.readPage();
            this.nextTag();
        }
    }

    private void readPage() throws XMLStreamException {
        int nsCode;
        this.requireStartElement(PAGE_ELEM);
        this.nextTag();
        String titleStr = this.readString(TITLE_ELEM, true);
        WikiTitle title = this.parseTitle(titleStr);
        if (title == null || !((Boolean)this._filter.apply((Object)title)).booleanValue()) {
            while (!this.isEndElement(PAGE_ELEM)) {
                this._reader.next();
            }
            return;
        }
        try {
            nsCode = Integer.parseInt(this.readString(NS_ELEM, true));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("cannot parse content of element [ns] as int", e);
        }
        if (title.namespace().code() != nsCode) {
            Namespace expected = (Namespace)Namespace.values().apply((Object)nsCode);
            logger.log(Level.WARNING, "Error parsing title: found namespace " + title.namespace() + ", expected " + expected + " in title " + titleStr);
        }
        String pageId = this.readString(ID_ELEM, false);
        WikiPage page = null;
        WikiTitle redirect = null;
        while (this.nextTag() == 1) {
            if (this.isStartElement(REDIRECT_ELEM)) {
                redirect = this.parseTitle(this._reader.getAttributeValue(null, TITLE_ELEM));
                this.nextTag();
                continue;
            }
            if (this.isStartElement(REVISION_ELEM)) {
                page = this.readRevision(title, redirect, pageId);
                continue;
            }
            this.skipElement(null, false);
        }
        if (page != null) {
            try {
                this._processor.apply(page);
            }
            catch (Exception e) {
                if (e instanceof ControlThrowable) {
                    throw Exceptions.unchecked(e);
                }
                if (e instanceof InterruptedException) {
                    throw Exceptions.unchecked(e);
                }
                logger.log(Level.WARNING, "Error processing page  " + title, e);
            }
        }
        this.requireEndElement(PAGE_ELEM);
    }

    private WikiPage readRevision(WikiTitle title, WikiTitle redirect, String pageId) throws XMLStreamException {
        String text = null;
        String timestamp = null;
        String revisionId = null;
        while (this.nextTag() == 1) {
            if (this.isStartElement(TEXT_ELEM)) {
                text = this.readString(TEXT_ELEM, false);
                continue;
            }
            if (this.isStartElement(TIMESTAMP_ELEM)) {
                timestamp = this.readString(TIMESTAMP_ELEM, false);
                continue;
            }
            if (this.isStartElement(ID_ELEM)) {
                revisionId = this.readString(ID_ELEM, false);
                continue;
            }
            this.skipElement(null, false);
        }
        this.requireEndElement(REVISION_ELEM);
        return new WikiPage(title, redirect, pageId, revisionId, timestamp, text);
    }

    private WikiTitle parseTitle(String titleString) {
        try {
            return WikiTitle.parse(titleString, this._language);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error parsing page title [" + titleString + "]", e);
            return null;
        }
    }

    private String readString(String name2, boolean nextTag) throws XMLStreamException {
        XMLStreamUtils.requireStartElement(this._reader, "http://www.mediawiki.org/xml/export-0.6/", name2);
        String text = this._reader.getElementText();
        if (nextTag) {
            this._reader.nextTag();
        }
        return text;
    }

    private void skipElement(String name2, boolean nextTag) throws XMLStreamException {
        XMLStreamUtils.requireStartElement(this._reader, "http://www.mediawiki.org/xml/export-0.6/", name2);
        XMLStreamUtils.skipElement(this._reader);
        if (nextTag) {
            this._reader.nextTag();
        }
    }

    private boolean isStartElement(String name2) throws XMLStreamException {
        return XMLStreamUtils.isStartElement(this._reader, "http://www.mediawiki.org/xml/export-0.6/", name2);
    }

    private boolean isEndElement(String name2) throws XMLStreamException {
        return XMLStreamUtils.isEndElement(this._reader, "http://www.mediawiki.org/xml/export-0.6/", name2);
    }

    private void requireStartElement(String name2) throws XMLStreamException {
        XMLStreamUtils.requireStartElement(this._reader, "http://www.mediawiki.org/xml/export-0.6/", name2);
    }

    private void requireEndElement(String name2) throws XMLStreamException {
        XMLStreamUtils.requireEndElement(this._reader, "http://www.mediawiki.org/xml/export-0.6/", name2);
    }

    private int nextTag() throws XMLStreamException {
        return this._reader.nextTag();
    }
}

