/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.destinations.formatters;

import java.net.URI;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Utility$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UriPolicy$
implements ScalaObject {
    public static final UriPolicy$ MODULE$;
    private final int SUBJECT;
    private final int PREDICATE;
    private final int OBJECT;
    private final int DATATYPE;
    private final int CONTEXT;
    private final int POSITIONS;
    private final int ALL;

    static {
        new UriPolicy$();
    }

    public int SUBJECT() {
        return this.SUBJECT;
    }

    public int PREDICATE() {
        return this.PREDICATE;
    }

    public int OBJECT() {
        return this.OBJECT;
    }

    public int DATATYPE() {
        return this.DATATYPE;
    }

    public int CONTEXT() {
        return this.CONTEXT;
    }

    public int POSITIONS() {
        return this.POSITIONS;
    }

    public int ALL() {
        return this.ALL;
    }

    public Function1<URI, URI> uri(Function1<URI, Object> activeFor$1) {
        return new Serializable(activeFor$1){
            public static final long serialVersionUID;
            private final Function1 activeFor$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final URI apply(URI iri) {
                return BoxesRunTime.unboxToBoolean((Object)this.activeFor$1.apply((Object)iri)) ? new URI(iri.toASCIIString()) : iri;
            }
            {
                this.activeFor$1 = function1;
            }
        };
    }

    public Function1<URI, URI> generic(Function1<URI, Object> activeFor$2) {
        return new Serializable(activeFor$2){
            public static final long serialVersionUID;
            private final Function1 activeFor$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final URI apply(URI iri) {
                URI uRI;
                if (BoxesRunTime.unboxToBoolean((Object)this.activeFor$2.apply((Object)iri))) {
                    String scheme = iri.getScheme();
                    String user = iri.getRawUserInfo();
                    String host = "dbpedia.org";
                    int port = iri.getPort();
                    String path = iri.getRawPath();
                    String query2 = iri.getRawQuery();
                    String frag = iri.getRawFragment();
                    uRI = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(scheme, user, host, port, path, query2, frag);
                } else {
                    uRI = iri;
                }
                return uRI;
            }
            {
                this.activeFor$2 = function1;
            }
        };
    }

    public Function1<URI, URI> xmlSafe(Function1<URI, Object> activeFor$3) {
        return new Serializable(activeFor$3){
            public static final long serialVersionUID;
            private final Function1 activeFor$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final URI apply(URI iri) {
                URI uRI;
                if (BoxesRunTime.unboxToBoolean((Object)this.activeFor$3.apply((Object)iri))) {
                    String scheme = iri.getScheme();
                    String user = iri.getRawUserInfo();
                    String host = iri.getHost();
                    int port = iri.getPort();
                    String path = iri.getRawPath();
                    String query2 = iri.getRawQuery();
                    String frag = iri.getRawFragment();
                    if (frag == null) {
                        if (query2 == null) {
                            path = path != null && Predef$.MODULE$.augmentString(path).nonEmpty() ? UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(path) : "/_";
                        } else {
                            query2 = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(query2);
                        }
                    } else {
                        frag = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(frag);
                    }
                    uRI = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(scheme, user, host, port, path, query2, frag);
                } else {
                    uRI = iri;
                }
                return uRI;
            }
            {
                this.activeFor$3 = function1;
            }
        };
    }

    public final String org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(String tail) {
        int index = tail.length();
        while (index > 0) {
            if (--index >= 2 && tail.charAt(index - 2) == '%') {
                return new StringBuilder().append((Object)tail).append((Object)BoxesRunTime.boxToCharacter((char)'_')).toString();
            }
            char ch = tail.charAt(index);
            if (ch != ':' && Utility$.MODULE$.isNameChar(ch)) {
                if (!Utility$.MODULE$.isNameStart(ch)) continue;
                return tail;
            }
            return new StringBuilder().append((Object)tail).append((Object)BoxesRunTime.boxToCharacter((char)'_')).toString();
        }
        return new StringBuilder().append((Object)tail).append((Object)BoxesRunTime.boxToCharacter((char)'_')).toString();
    }

    public final URI org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(String scheme, String user, String host, int port, String path, String query2, String frag) {
        Object object;
        StringBuilder sb = new StringBuilder();
        Object object2 = scheme == null ? BoxedUnit.UNIT : sb.append(scheme).append(':');
        if (host == null) {
            object = BoxedUnit.UNIT;
        } else {
            sb.append("//");
            Object object3 = user == null ? BoxedUnit.UNIT : sb.append(user).append('@');
            sb.append(host);
            object = port != -1 ? sb.append(':').append(port) : BoxedUnit.UNIT;
        }
        Object object4 = path == null ? BoxedUnit.UNIT : sb.append(path);
        Object object5 = query2 == null ? BoxedUnit.UNIT : sb.append('?').append(query2);
        Object object6 = frag == null ? BoxedUnit.UNIT : sb.append('#').append(frag);
        return new URI(sb.toString());
    }

    private UriPolicy$() {
        MODULE$ = this;
        this.SUBJECT = 0;
        this.PREDICATE = 1;
        this.OBJECT = 2;
        this.DATATYPE = 3;
        this.CONTEXT = 4;
        this.POSITIONS = 5;
        this.ALL = -1;
    }
}

