/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.destinations;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.dbpedia.extraction.destinations.Destination;
import org.dbpedia.extraction.destinations.Quad;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u0017\t\tR*\u0019:lKJ$Um\u001d;j]\u0006$\u0018n\u001c8\u000b\u0005\r!\u0011\u0001\u00043fgRLg.\u0019;j_:\u001c(BA\u0003\u0007\u0003))\u0007\u0010\u001e:bGRLwN\u001c\u0006\u0003\u000f!\tq\u0001\u001a2qK\u0012L\u0017MC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0002\u0006\r\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u0017\u0011+7\u000f^5oCRLwN\u001c\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003\u0015\u0003-!Wm\u001d;j]\u0006$\u0018n\u001c8\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\nAAZ5mKB\u00111EJ\u0007\u0002I)\u0011Q\u0005E\u0001\u0003S>L!a\n\u0013\u0003\t\u0019KG.\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005)1\u000f^1siB\u0011\u0011dK\u0005\u0003Yi\u0011qAQ8pY\u0016\fg\u000eC\u0003/\u0001\u0011\u0005q&\u0001\u0004=S:LGO\u0010\u000b\u0005aE\u00124\u0007\u0005\u0002\u0016\u0001!)q$\fa\u0001)!)\u0011%\fa\u0001E!)\u0011&\fa\u0001U!)Q\u0007\u0001C!m\u0005!q\u000e]3o)\u00059\u0004CA\r9\u0013\tI$D\u0001\u0003V]&$\b\"B\u001e\u0001\t\u0003b\u0014!B<sSR,GCA\u001c>\u0011\u0015q$\b1\u0001@\u0003\u00159'/\u00199i!\r\u0001\u0005j\u0013\b\u0003\u0003\u001as!AQ#\u000e\u0003\rS!\u0001\u0012\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012BA$\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0013&\u0003\u0007M+\u0017O\u0003\u0002H5A\u0011Q\u0003T\u0005\u0003\u001b\n\u0011A!U;bI\")q\n\u0001C!m\u0005)1\r\\8tK\")\u0011\u000b\u0001C\u0005m\u000511M]3bi\u0016DQa\u0015\u0001\u0005\nY\na\u0001Z3mKR,\u0007")
public class MarkerDestination
implements Destination,
ScalaObject {
    private final Destination destination;
    private final File file;
    private final boolean start;

    @Override
    public void open() {
        if (this.start) {
            this.create();
        } else {
            this.delete();
        }
        this.destination.open();
    }

    @Override
    public void write(Seq<Quad> graph) {
        this.destination.write(graph);
    }

    @Override
    public void close() {
        this.destination.close();
        if (this.start) {
            this.delete();
        } else {
            this.create();
        }
    }

    private void create() {
        if (this.file.exists()) {
            throw new IOException(new StringBuilder().append((Object)"file '").append((Object)this.file).append((Object)"' already exists").toString());
        }
        new FileOutputStream(this.file).close();
    }

    private void delete() {
        if (this.file.exists()) {
            if (this.file.delete()) {
                return;
            }
            throw new IOException(new StringBuilder().append((Object)"failed to delete file '").append((Object)this.file).append((Object)"'").toString());
        }
    }

    public MarkerDestination(Destination destination, File file, boolean start2) {
        this.destination = destination;
        this.file = file;
        this.start = start2;
    }
}

