/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.transformation.pattern;

import cz.vse.keg.patomat.transformation.pattern.NameDetectionPattern;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameDetectionPatternImpl
implements NameDetectionPattern {
    private float threshold;
    private NameDetectionPattern.MeasureType measureType;
    private String entity1;
    private String entity2;
    private NameDetectionPattern.NamePatternType namePatternType;

    @Override
    public NameDetectionPattern.MeasureType getMeasureType() {
        return this.measureType;
    }

    @Override
    public float getThreshold() {
        return this.threshold;
    }

    @Override
    public void setMeasureType(String type) {
        if (type.equals("equal")) {
            this.measureType = NameDetectionPattern.MeasureType.EQUAL;
        } else if (type.equals("unequal")) {
            this.measureType = NameDetectionPattern.MeasureType.UNEQUAL;
        } else if (type.equals("levenshtein")) {
            this.measureType = NameDetectionPattern.MeasureType.LEVENSHTEIN;
        } else if (type.equals("jaro")) {
            this.measureType = NameDetectionPattern.MeasureType.JARO;
        } else if (type.equals("hypernym")) {
            this.measureType = NameDetectionPattern.MeasureType.HYPERNYM;
        } else if (type.equals("not_hypernym")) {
            this.measureType = NameDetectionPattern.MeasureType.NOT_HYPERNYM;
        }
    }

    @Override
    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    @Override
    public String getEntity1() {
        return this.entity1;
    }

    @Override
    public String getEntity2() {
        return this.entity2;
    }

    @Override
    public void setEntity1(String e) {
        this.entity1 = e;
    }

    @Override
    public void setEntity2(String e) {
        this.entity2 = e;
    }

    public String toString() {
        return String.valueOf(this.entity1) + "," + this.entity2 + "," + this.getThreshold() + "," + (Object)((Object)this.measureType) + "," + (Object)((Object)this.namePatternType);
    }

    @Override
    public void setNamePatternType(String type) {
        if (type.equals("comparison")) {
            this.namePatternType = NameDetectionPattern.NamePatternType.COMPARISON;
        } else if (type.equals("exist")) {
            this.namePatternType = NameDetectionPattern.NamePatternType.EXIST;
        }
    }

    @Override
    public NameDetectionPattern.NamePatternType getNamePatternType() {
        return this.namePatternType;
    }

    @Override
    public ArrayList<String> getInvolvedPlaceholders() {
        ArrayList<String> results = new ArrayList<String>();
        results.addAll(this.getInvolvedPlaceholdersEntity1());
        results.addAll(this.getInvolvedPlaceholdersEntity2());
        return results;
    }

    @Override
    public ArrayList<String> getInvolvedPlaceholdersEntity1() {
        String s = this.entity1;
        Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        Matcher matcher = pat.matcher(s);
        ArrayList<String> placeholders = new ArrayList<String>();
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        return placeholders;
    }

    @Override
    public ArrayList<String> getInvolvedPlaceholdersEntity2() {
        if (this.entity2 == null) {
            return new ArrayList<String>();
        }
        String s = this.entity2;
        Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        Matcher matcher = pat.matcher(s);
        ArrayList<String> placeholders = new ArrayList<String>();
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        return placeholders;
    }

    public static void main(String[] args) {
        NameDetectionPatternImpl ndp = new NameDetectionPatternImpl();
        ndp.threshold = 1.0f;
        ndp.entity1 = "head_noun(?OP1_A)";
        ndp.entity2 = "head_noun(?OP1_P)";
        ndp.measureType = NameDetectionPattern.MeasureType.EQUAL;
        ndp.namePatternType = NameDetectionPattern.NamePatternType.COMPARISON;
        System.out.println(ndp);
        System.out.println(ndp.getInvolvedPlaceholders());
    }
}

