/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.transformation.pattern;

import cz.vse.keg.patomat.naming.NameEntityImpl;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern;
import cz.vse.keg.patomat.transformation.pattern.PatternTransformation;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InstructionGeneratorImpl
implements InstructionGenerator {
    private TransformationPattern tp;
    private String ontology;
    private boolean POStagger;
    private String dictionaryPath;
    private String modelsPath;
    private HashSet<String> entitiesInstructions;
    private HashSet<String> instantiatedEntitiesInstructions;
    private HashSet<String> axiomsRemovingInstructions;
    private HashSet<String> instantiatedAxiomsRemovingInstructions;
    private HashSet<String> axiomsInstructions;
    private HashSet<String> instantiatedAxiomsInstructions;
    private HashSet<String> axiomAddingInstructions;
    private HashSet<String> instantiatedAxiomAddingInstructions;
    private HashSet<String> annotationsInstructions;
    private HashSet<String> instantiatedAnnotationsInstructions;
    private HashMap<String, String> renameList = new HashMap();
    private boolean debuggingOutput = false;
    HashMap<String, String> namingInstructions;
    private HashMap<String, String> namingOP2;
    private HashMap<String, String> OP2toOP1;
    private NameEntityImpl ne;
    private int number_of_generated_names;

    public InstructionGeneratorImpl(TransformationPattern tp, boolean POStagger, String dictionaryPath, String modelsPath) {
        this.tp = tp;
        this.POStagger = POStagger;
        this.dictionaryPath = dictionaryPath;
        this.modelsPath = modelsPath;
        this.entitiesInstructions = new HashSet();
        this.instantiatedEntitiesInstructions = new HashSet();
        this.axiomsInstructions = new HashSet();
        this.axiomsRemovingInstructions = new HashSet();
        this.instantiatedAxiomsRemovingInstructions = new HashSet();
        this.instantiatedAxiomsInstructions = new HashSet();
        this.axiomAddingInstructions = new HashSet();
        this.instantiatedAxiomAddingInstructions = new HashSet();
        this.annotationsInstructions = new HashSet();
        this.instantiatedAnnotationsInstructions = new HashSet();
        this.namingOP2 = new HashMap();
        this.OP2toOP1 = new HashMap();
        this.namingInstructions = new HashMap();
        this.ne = new NameEntityImpl(this.POStagger, this.dictionaryPath, this.modelsPath);
        this.number_of_generated_names = 1;
    }

    @Override
    public HashMap<String, String> getOldBindings() {
        return null;
    }

    @Override
    public HashMap<String, String> getBindings() {
        return this.namingOP2;
    }

    @Override
    public ArrayList<String> getAxiomsForAdding() {
        ArrayList<String> axiomsForAdding = new ArrayList<String>();
        boolean forAdding = true;
        for (String s : this.tp.getOP2().getAxioms()) {
            if (this.debuggingOutput) {
                System.out.println("axiom in OP2:" + s);
            }
            Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            Matcher m = pat.matcher(s);
            while (m.find()) {
                if (this.tp.getPT().getLinks(PatternTransformation.Type.eqAnn).containsValue(m.group())) {
                    forAdding = false;
                    break;
                }
                if (this.tp.getPT().getLinks(PatternTransformation.Type.eq).containsValue(m.group()) || this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).containsValue(m.group())) {
                    forAdding = true;
                    break;
                }
                forAdding = true;
            }
            if (!forAdding) continue;
            if (this.debuggingOutput) {
                System.out.println(String.valueOf(s) + " will be added");
            }
            axiomsForAdding.add(s);
        }
        return axiomsForAdding;
    }

    @Override
    public ArrayList<String> getAnnotationAxiomsForAdding() {
        ArrayList<String> annotationAxiomsForAdding = new ArrayList<String>();
        boolean forAdding = true;
        for (String s : this.tp.getOP2().getAxioms()) {
            Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            Matcher m = pat.matcher(s);
            if (this.debuggingOutput) {
                System.out.println(String.valueOf(s) + " annotation?");
            }
            while (m.find()) {
                if (this.tp.getPT().getLinks(PatternTransformation.Type.eqAnn).containsValue(m.group())) {
                    if (this.debuggingOutput) {
                        System.out.println(String.valueOf(s) + " yes annotation");
                    }
                    forAdding = true;
                    break;
                }
                if (this.debuggingOutput) {
                    System.out.println(String.valueOf(s) + " no annotation");
                }
                forAdding = false;
            }
            if (!forAdding) continue;
            annotationAxiomsForAdding.add(s);
        }
        block2: for (String s : this.tp.getOP2().getSpecifiedEntities().keySet()) {
            if (!this.tp.getOP2().getSpecifiedEntities().get(s).equals((Object)OntologyPattern.EntityType.AnnotationProperty)) continue;
            if (this.debuggingOutput) {
                System.out.println(String.valueOf(s) + " annotation property to check");
            }
            for (String ss : this.tp.getOP2().getAxioms()) {
                if (this.debuggingOutput) {
                    System.out.println(String.valueOf(ss) + " annotation?");
                }
                if (!ss.matches(".*" + s + ".*")) continue;
                if (this.debuggingOutput) {
                    System.out.println(String.valueOf(s) + " ano anotace");
                }
                annotationAxiomsForAdding.add(ss);
                continue block2;
            }
        }
        return annotationAxiomsForAdding;
    }

    @Override
    public ArrayList<String> getAxiomsForRemoving() {
        ArrayList<String> axiomsForRemoving = new ArrayList<String>();
        ArrayList<String> annotationProperties = new ArrayList<String>();
        boolean axiomRemoving = false;
        for (String s : this.tp.getOP1().getSpecifiedEntities().keySet()) {
            if (!this.tp.getOP1().getSpecifiedEntities().get(s).equals((Object)OntologyPattern.EntityType.AnnotationProperty)) continue;
            annotationProperties.add(s);
        }
        for (String s : this.tp.getOP1().getAxioms()) {
            axiomRemoving = true;
            Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
            Matcher m = pat.matcher(s);
            for (String ss : annotationProperties) {
                if (!s.matches(".*" + ss + ".*")) continue;
                axiomRemoving = false;
                break;
            }
            if (!axiomRemoving) continue;
            axiomsForRemoving.add(s);
        }
        return axiomsForRemoving;
    }

    @Override
    public ArrayList<String> getEntitiesForAdding() {
        ArrayList<String> entitiesForAdding = new ArrayList<String>();
        for (String s : this.tp.getOP2().getPlaceholders().keySet()) {
            if (this.tp.getPT().getLinks(PatternTransformation.Type.eq).containsValue(s) || this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).containsValue(s)) continue;
            if (this.debuggingOutput) {
                System.out.println("add ADD(" + s + ",ENP(" + this.tp.getPT().getENP().get(s) + ")");
            }
            entitiesForAdding.add(s);
        }
        return entitiesForAdding;
    }

    public ArrayList<String> getSpecifiedEntitiesForAdding() {
        ArrayList<String> specifiedEntitiesForAdding = new ArrayList<String>();
        for (String s : this.tp.getOP2().getSpecifiedEntities().keySet()) {
            if (this.tp.getPT().getLinks(PatternTransformation.Type.eq).containsValue(s) || this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).containsValue(s)) continue;
            if (this.debuggingOutput) {
                System.out.println("add ADD(" + s + ",ENP(" + this.tp.getPT().getENP().get(s) + ")");
            }
            specifiedEntitiesForAdding.add(s);
        }
        return specifiedEntitiesForAdding;
    }

    public ArrayList<String> getAxiomsEntitiesForAdding() {
        ArrayList<String> axiomsEntitiesForAdding = new ArrayList<String>();
        for (String s : this.tp.getOP2().getPlaceholderAxioms().keySet()) {
            if (this.tp.getPT().getLinks(PatternTransformation.Type.eq).containsValue(s) || this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).containsValue(s)) continue;
            if (this.debuggingOutput) {
                System.out.println("add ADD(" + s + ",ENP(" + this.tp.getPT().getENP().get(s) + ")");
            }
            axiomsEntitiesForAdding.add(s);
        }
        return axiomsEntitiesForAdding;
    }

    @Override
    public ArrayList<String> getEntitiesForRemoving() {
        ArrayList<String> entitiesForRemoving = new ArrayList<String>();
        for (String s : this.tp.getOP1().getPlaceholders().keySet()) {
            if (this.tp.getPT().getLinks(PatternTransformation.Type.any).containsKey(s)) continue;
            if (this.debuggingOutput) {
                System.out.println("REMOVE(" + s + ")");
            }
            entitiesForRemoving.add(s);
        }
        return entitiesForRemoving;
    }

    @Override
    public ArrayList<String> getEntitiesForRetyping(ArrayList<String> specifiedOP2OptionalPlaceholders) {
        ArrayList<String> entitiesForRetyping = new ArrayList<String>();
        for (String s : this.tp.getOP2().getPlaceholders().keySet()) {
            if (!specifiedOP2OptionalPlaceholders.contains(s) || !this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).containsValue(s) && !this.tp.getPT().getLinks(PatternTransformation.Type.eqAnn).containsValue(s)) continue;
            if (this.debuggingOutput) {
                System.out.println("ADD(" + s + ",ENP(" + this.tp.getPT().getENP().get(s) + "))");
            }
            entitiesForRetyping.add(s);
        }
        return entitiesForRetyping;
    }

    @Override
    public HashMap<String, String> parseXMLpatternInstanceBinding(String bindingPlaceholders) {
        try {
            HashMap<String, String> binding = new HashMap<String, String>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new StringBufferInputStream(bindingPlaceholders));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "/pattern_instance/binding";
            NodeList nodesOP = null;
            nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodesOP.getLength()) {
                binding.put(((Element)nodesOP.item(i)).getAttribute("placeholder"), ((Element)nodesOP.item(i)).getTextContent());
                ++i;
            }
            nodesOP = (NodeList)xpath.evaluate("/pattern_instance", doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                this.ontology = ((Element)nodesOP.item(i)).getAttribute("ontology");
                ++i;
            }
            return binding;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String exportTransformationInstructions(boolean generalOne) {
        StringBuilder xmlInstructions = new StringBuilder();
        xmlInstructions.append("<instructions ontology=\"" + this.ontology + "\" tp=\"" + this.tp.getLocation() + "\">\n");
        xmlInstructions.append("<entities>\n");
        if (generalOne) {
            for (String s : this.entitiesInstructions) {
                xmlInstructions.append(s);
            }
            xmlInstructions.append("</entities>\n");
            xmlInstructions.append("<axioms>\n");
            for (String s : this.axiomsRemovingInstructions) {
                xmlInstructions.append(s);
            }
            for (String s : this.axiomsInstructions) {
                xmlInstructions.append(s);
            }
            for (String s : this.axiomAddingInstructions) {
                xmlInstructions.append(s);
            }
            xmlInstructions.append("</axioms>\n");
            xmlInstructions.append("<annotations>\n");
            for (String s : this.annotationsInstructions) {
                xmlInstructions.append(s);
            }
        } else {
            for (String s : this.instantiatedEntitiesInstructions) {
                xmlInstructions.append(s);
            }
            xmlInstructions.append("</entities>\n");
            xmlInstructions.append("<axioms>\n");
            for (String s : this.instantiatedAxiomsRemovingInstructions) {
                xmlInstructions.append(s);
            }
            for (String s : this.instantiatedAxiomsInstructions) {
                xmlInstructions.append(s);
            }
            for (String s : this.instantiatedAxiomAddingInstructions) {
                xmlInstructions.append(s);
            }
            xmlInstructions.append("</axioms>\n");
            xmlInstructions.append("<annotations>\n");
            for (String s : this.instantiatedAnnotationsInstructions) {
                xmlInstructions.append(s);
            }
        }
        xmlInstructions.append("</annotations>\n");
        xmlInstructions.append("</instructions>\n");
        return xmlInstructions.toString();
    }

    @Override
    public HashMap<String, String> getNamingInstructions() {
        return this.namingInstructions;
    }

    @Override
    public void generateInstantiatedInstructions(HashMap<String, String> binding, boolean append) {
        if (!append) {
            this.instantiatedEntitiesInstructions = new HashSet();
            this.instantiatedAxiomsInstructions = new HashSet();
            this.instantiatedAxiomsRemovingInstructions = new HashSet();
            this.instantiatedAxiomAddingInstructions = new HashSet();
            this.instantiatedAnnotationsInstructions = new HashSet();
        }
        HashMap<String, String> namingMapping = new HashMap<String, String>();
        this.ne.setBinding(binding);
        String naming_instruction = "";
        for (String s : binding.keySet()) {
            namingMapping.put(s, binding.get(s));
        }
        for (String s : this.namingInstructions.keySet()) {
            if (this.tp.getOP2().getPlaceholders().containsKey(this.namingInstructions.get(s))) {
                String pom = "foo" + this.number_of_generated_names++;
                namingMapping.put(this.namingInstructions.get(s), pom);
                continue;
            }
            if (this.tp.getOP1().getPlaceholders().containsKey(this.namingInstructions.get(s))) continue;
            namingMapping.put(this.namingInstructions.get(s), this.ne.getName(this.namingInstructions.get(s)).toString());
        }
        if (this.debuggingOutput) {
            System.out.println(namingMapping);
        }
        for (String s : this.entitiesInstructions) {
            if (this.debuggingOutput) {
                System.out.println("entity instruction:" + s);
            }
            int i = 0;
            String key = "";
            String value = "";
            boolean okInstr = true;
            while (s.indexOf("[") != -1 && s.indexOf("]") != -1) {
                okInstr = true;
                naming_instruction = s.substring(s.indexOf("[") + 1, s.indexOf("]"));
                s = s.replaceAll("\\[" + naming_instruction.replaceAll("\\?", "\\\\?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+") + "\\]", (String)namingMapping.get(naming_instruction));
                if (i == 0) {
                    key = (String)namingMapping.get(naming_instruction);
                } else {
                    value = (String)namingMapping.get(naming_instruction);
                }
                ++i;
            }
            if (value.equals("")) {
                value = key;
            }
            this.renameList.put(key, value);
            if (this.debuggingOutput) {
                System.out.println(s);
            }
            if (!okInstr) continue;
            this.instantiatedEntitiesInstructions.add(s);
        }
        for (String s : this.axiomsRemovingInstructions) {
            while (s.indexOf("[") != -1 && s.indexOf("]") != -1) {
                naming_instruction = s.substring(s.indexOf("[") + 1, s.indexOf("]"));
                s = s.replaceAll("\\[" + naming_instruction.replaceAll("\\?", "\\\\?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+") + "\\]", (String)namingMapping.get(naming_instruction));
            }
            if (this.debuggingOutput) {
                System.out.println(s);
            }
            this.instantiatedAxiomsRemovingInstructions.add(s);
        }
        if (this.debuggingOutput) {
            System.out.println("axiomy:" + this.axiomsInstructions);
        }
        if (this.debuggingOutput) {
            System.out.println("renameList:" + this.renameList);
        }
        if (this.debuggingOutput) {
            System.out.println("namingMapping:" + namingMapping);
        }
        for (String s : this.axiomsInstructions) {
            while (s.indexOf("[") != -1 && s.indexOf("]") != -1) {
                naming_instruction = s.substring(s.indexOf("[") + 1, s.indexOf("]"));
                s = this.renameList.containsKey(namingMapping.get(naming_instruction)) ? s.replaceAll("\\[" + naming_instruction.replaceAll("\\?", "\\\\?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+") + "\\]", this.renameList.get(namingMapping.get(naming_instruction))) : s.replaceAll("\\[" + naming_instruction.replaceAll("\\?", "\\\\?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+") + "\\]", (String)namingMapping.get(naming_instruction));
            }
            if (this.debuggingOutput) {
                System.out.println(s);
            }
            this.instantiatedAxiomAddingInstructions.add(s);
        }
        for (String s : this.axiomAddingInstructions) {
            while (s.indexOf("[") != -1 && s.indexOf("]") != -1) {
                naming_instruction = s.substring(s.indexOf("[") + 1, s.indexOf("]"));
                s = this.renameList.containsKey(namingMapping.get(naming_instruction)) ? s.replaceAll("\\[" + naming_instruction.replaceAll("\\?", "\\\\?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+") + "\\]", this.renameList.get(namingMapping.get(naming_instruction))) : s.replaceAll("\\[" + naming_instruction.replaceAll("\\?", "\\\\?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+") + "\\]", (String)namingMapping.get(naming_instruction));
            }
            if (this.debuggingOutput) {
                System.out.println(s);
            }
            this.instantiatedAxiomAddingInstructions.add(s);
        }
        for (String s : this.annotationsInstructions) {
            while (s.indexOf("[") != -1 && s.indexOf("]") != -1) {
                naming_instruction = s.substring(s.indexOf("[") + 1, s.indexOf("]"));
                s = this.renameList.containsKey(namingMapping.get(naming_instruction)) ? s.replaceAll("\\[" + naming_instruction.replaceAll("\\?", "\\\\?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+") + "\\]", this.renameList.get(namingMapping.get(naming_instruction))) : s.replaceAll("\\[" + naming_instruction.replaceAll("\\?", "\\\\?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+") + "\\]", (String)namingMapping.get(naming_instruction));
            }
            if (this.debuggingOutput) {
                System.out.println(s);
            }
            this.instantiatedAnnotationsInstructions.add(s);
        }
    }

    @Override
    public void generateGeneralTransformationInstructions() {
        Matcher m;
        ArrayList<String> specifiedOP2OptionalPlaceholders = this.getSpecifiedOP2OptionalPlaceholders(this.tp.getOP1().getPlaceholders().keySet());
        if (this.debuggingOutput) {
            System.out.println("specifiedOP2OptionalPlaceholders:" + specifiedOP2OptionalPlaceholders);
        }
        ArrayList<String> entitiesForAdding = this.getEntitiesForAdding();
        ArrayList<String> specifiedEntitiesForAdding = this.getSpecifiedEntitiesForAdding();
        ArrayList<String> axiomsEntitiesForAdding = this.getAxiomsEntitiesForAdding();
        ArrayList<String> entitiesForRetyping = this.getEntitiesForRetyping(specifiedOP2OptionalPlaceholders);
        ArrayList<String> entitiesForRemoving = this.getEntitiesForRemoving();
        HashMap<String, String> entitiesForRenaming = this.getEntitiesForRenaming();
        this.namingInstructions = this.tp.getPT().getENP();
        for (String s : this.tp.getPT().getLinks(PatternTransformation.Type.any).keySet()) {
            if (!this.namingInstructions.containsKey(this.tp.getPT().getLinks(PatternTransformation.Type.any).get(s))) {
                this.namingInstructions.put(this.tp.getPT().getLinks(PatternTransformation.Type.any).get(s), s);
            }
            this.OP2toOP1.put(this.tp.getPT().getLinks(PatternTransformation.Type.any).get(s), s);
        }
        if (this.debuggingOutput) {
            System.out.println("ni:" + this.namingInstructions);
        }
        if (this.debuggingOutput) {
            System.out.println("op2 to op1:" + this.OP2toOP1);
        }
        if (this.debuggingOutput) {
            System.out.println("entities for renaming:" + entitiesForRenaming);
        }
        if (this.debuggingOutput) {
            System.out.println("entities for adding:" + entitiesForAdding);
        }
        if (this.debuggingOutput) {
            System.out.println("specified entities for adding:" + entitiesForAdding);
        }
        if (this.debuggingOutput) {
            System.out.println("entities for retyping:" + entitiesForRetyping);
        }
        if (this.debuggingOutput) {
            System.out.println("entities for removing:" + entitiesForRemoving);
        }
        HashMap<String, String> namingOP2 = new HashMap<String, String>();
        if (!entitiesForRemoving.isEmpty()) {
            for (String s : entitiesForRemoving) {
                switch (this.tp.getOP1().getPlaceholders().get(s)) {
                    case ObjectProperty: {
                        this.entitiesInstructions.add("<remove type=\"ObjectProperty\">" + s + "</remove>\n");
                        break;
                    }
                    case AnnotationProperty: {
                        this.entitiesInstructions.add("<remove type=\"AnnotationProperty\">" + s + "</remove>\n");
                        break;
                    }
                    case DatatypeProperty: {
                        this.entitiesInstructions.add("<remove type=\"DatatypeProperty\">" + s + "</remove>\n");
                        break;
                    }
                    case Class: {
                        this.entitiesInstructions.add("<remove type=\"Class\">" + s + "</remove>\n");
                        break;
                    }
                    case Individual: {
                        this.entitiesInstructions.add("<remove type=\"Individual\">" + s + "</remove>\n");
                        break;
                    }
                    default: {
                        this.entitiesInstructions.add("<remove type=\"Uknown\">" + s + "</remove>\n");
                    }
                }
            }
        }
        if (!specifiedEntitiesForAdding.isEmpty()) {
            for (String s : specifiedEntitiesForAdding) {
                switch (this.tp.getOP2().getSpecifiedEntities().get(s)) {
                    case ObjectProperty: {
                        this.entitiesInstructions.add("<add type=\"imported_entity_ObjectProperty\">" + s + "</add>\n");
                        break;
                    }
                    case AnnotationProperty: {
                        this.entitiesInstructions.add("<add type=\"imported_entity_AnnotationProperty\">" + s + "</add>\n");
                        break;
                    }
                    case DatatypeProperty: {
                        this.entitiesInstructions.add("<add type=\"imported_entity_DatatypeProperty\">" + s + "</add>\n");
                        break;
                    }
                    case Class: {
                        this.entitiesInstructions.add("<add type=\"imported_entity_Class\">" + s + "</add>\n");
                        break;
                    }
                    case Individual: {
                        this.entitiesInstructions.add("<add type=\"imported_entity_Individual\">" + s + "</add>\n");
                        break;
                    }
                    default: {
                        this.entitiesInstructions.add("<remove type=\"Uknown\">" + s + "</remove>\n");
                    }
                }
            }
        }
        if (!entitiesForAdding.isEmpty()) {
            for (String s : entitiesForAdding) {
                if (this.namingInstructions.containsKey(s)) {
                    if (this.tp.getOP2().getPlaceholders().get(s).equals((Object)OntologyPattern.EntityType.Literal)) {
                        System.out.println("literal:" + s);
                        namingOP2.put(s, "\\\"[" + this.namingInstructions.get(s) + "]\\\"");
                        continue;
                    }
                    if (this.tp.getOP2().getPlaceholders().get(s).equals((Object)OntologyPattern.EntityType.Literal)) continue;
                    this.entitiesInstructions.add("<add type=\"" + (Object)((Object)this.tp.getOP2().getPlaceholders().get(s)) + "\">[" + this.namingInstructions.get(s) + "]</add>\n");
                    namingOP2.put(s, "[" + this.namingInstructions.get(s) + "]");
                    continue;
                }
                if (this.tp.getOP2().getPlaceholders().get(s).equals((Object)OntologyPattern.EntityType.Literal)) {
                    System.out.println("literal:" + s);
                    namingOP2.put(s, "\\\"[" + s + "]\\\"");
                    this.namingInstructions.put(s, "\\\"[" + s + "]\\\"");
                    continue;
                }
                if (this.tp.getOP2().getPlaceholders().get(s).equals((Object)OntologyPattern.EntityType.Literal)) continue;
                this.entitiesInstructions.add("<add type=\"" + (Object)((Object)this.tp.getOP2().getPlaceholders().get(s)) + "\">[" + s + "]</add>\n");
                namingOP2.put(s, "[" + s + "]");
                this.namingInstructions.put(s, s);
            }
        }
        for (String s : this.tp.getOP2().getPlaceholders().keySet()) {
            if (entitiesForRetyping.contains(s)) {
                String counterpart = "";
                for (String r : this.tp.getPT().getLinks(PatternTransformation.Type.any).keySet()) {
                    if (!this.tp.getPT().getLinks(PatternTransformation.Type.any).get(r).equals(s)) continue;
                    counterpart = r;
                    break;
                }
                System.out.println("entity:" + s + ";counterpart:" + counterpart);
                switch (this.tp.getOP1().getPlaceholders().get(counterpart)) {
                    case ObjectProperty: {
                        this.entitiesInstructions.add("<remove type=\"ObjectProperty\">" + counterpart + "</remove>\n");
                        break;
                    }
                    case AnnotationProperty: {
                        this.entitiesInstructions.add("<remove type=\"AnnotationProperty\">" + counterpart + "</remove>\n");
                        break;
                    }
                    case DatatypeProperty: {
                        this.entitiesInstructions.add("<remove type=\"DatatypeProperty\">" + counterpart + "</remove>\n");
                        break;
                    }
                    case Class: {
                        this.entitiesInstructions.add("<remove type=\"Class\">[" + this.namingInstructions.get(s) + "]</remove>\n");
                        break;
                    }
                    case Individual: {
                        this.entitiesInstructions.add("<remove type=\"Individual\">" + counterpart + "</remove>\n");
                        break;
                    }
                    default: {
                        this.entitiesInstructions.add("<remove type=\"Uknown\">" + counterpart + "</remove>\n");
                    }
                }
                switch (this.tp.getOP2().getPlaceholders().get(s)) {
                    case ObjectProperty: {
                        this.entitiesInstructions.add("<add type=\"ObjectProperty\">[" + this.namingInstructions.get(s) + "]</add>\n");
                        break;
                    }
                    case AnnotationProperty: {
                        this.entitiesInstructions.add("<add type=\"AnnotationProperty\">[" + this.namingInstructions.get(s) + "]</add>\n");
                        break;
                    }
                    case DatatypeProperty: {
                        this.entitiesInstructions.add("<add type=\"DatatypeProperty\">[" + this.namingInstructions.get(s) + "]</add>\n");
                        break;
                    }
                    case Class: {
                        this.entitiesInstructions.add("<add type=\"Class\">[" + this.namingInstructions.get(s) + "]</add>\n");
                        break;
                    }
                    case Individual: {
                        this.entitiesInstructions.add("<add type=\"Individual\">[" + this.namingInstructions.get(s) + "]</add>\n");
                        break;
                    }
                    default: {
                        this.entitiesInstructions.add("<add type=\"Uknown\">[" + this.namingInstructions.get(s) + "]</add>\n");
                    }
                }
                if (this.namingInstructions.containsKey(s)) {
                    namingOP2.put(s, "[" + this.namingInstructions.get(s) + "]");
                    continue;
                }
                namingOP2.put(s, "[!NTF]");
                continue;
            }
            if (!entitiesForRenaming.containsKey(s)) continue;
            if (this.namingInstructions.containsKey(s)) {
                namingOP2.put(s, "[" + this.namingInstructions.get(s) + "]");
                if (entitiesForRenaming.get(s).equals(this.namingInstructions.get(s))) continue;
                switch (this.tp.getOP2().getPlaceholders().get(s)) {
                    case ObjectProperty: {
                        this.entitiesInstructions.add("<rename type=\"ObjectProperty\" original_name=\"[" + entitiesForRenaming.get(s) + "]\">[" + this.namingInstructions.get(s) + "]</rename>\n");
                        break;
                    }
                    case AnnotationProperty: {
                        this.entitiesInstructions.add("<rename type=\"AnnotationProperty\" original_name=\"[" + entitiesForRenaming.get(s) + "]\">[" + this.namingInstructions.get(s) + "]</rename>\n");
                        break;
                    }
                    case DatatypeProperty: {
                        this.entitiesInstructions.add("<rename type=\"DatatypeProperty\" original_name=\"[" + entitiesForRenaming.get(s) + "]\">[" + this.namingInstructions.get(s) + "]</rename>\n");
                        break;
                    }
                    case Class: {
                        this.entitiesInstructions.add("<rename type=\"Class\" original_name=\"[" + entitiesForRenaming.get(s) + "]\">[" + this.namingInstructions.get(s) + "]</rename>\n");
                        break;
                    }
                    case Individual: {
                        this.entitiesInstructions.add("<rename type=\"Individual\" original_name=\"[" + entitiesForRenaming.get(s) + "]\">[" + this.namingInstructions.get(s) + "]</rename>\n");
                        break;
                    }
                    case Literal: {
                        this.entitiesInstructions.add("<rename type=\"Literal\" original_name=\"[" + entitiesForRenaming.get(s) + "]\">[" + this.namingInstructions.get(s) + "]</rename>\n");
                        break;
                    }
                    default: {
                        this.entitiesInstructions.add("<rename type=\"Uknown\" original_name=\"[" + entitiesForRenaming.get(s) + "]\">[" + this.namingInstructions.get(s) + "]</rename>\n");
                        break;
                    }
                }
                continue;
            }
            if (this.tp.getOP2().getPlaceholders().get(s).equals((Object)OntologyPattern.EntityType.Literal)) {
                System.out.println("literal:" + s);
                namingOP2.put(s, "\\\"" + entitiesForRenaming.get(s) + "]\\\"");
                continue;
            }
            namingOP2.put(s, "[" + entitiesForRenaming.get(s) + "]");
        }
        if (this.debuggingOutput) {
            System.out.println(namingOP2);
        }
        if (this.debuggingOutput) {
            System.out.println("Instructions in XML:");
        }
        String p = "";
        for (Map.Entry entry : namingOP2.entrySet()) {
            if (this.tp.getOP2().getPlaceholders().get(entry.getKey()).name().equals("Class")) continue;
            p = (String)entry.getValue();
            if (p.matches(".*")) {
                p = String.valueOf(p.substring(0, 1).toLowerCase()) + p.substring(1);
            } else if (this.debuggingOutput) {
                System.out.println(p);
            }
            entry.setValue(p);
        }
        if (this.debuggingOutput) {
            System.out.println(namingOP2);
        }
        ArrayList<String> arrayList = this.getAxiomsForAdding();
        ArrayList<String> axiomsForRemoving = this.getAxiomsForRemoving();
        axiomsForRemoving = this.getAxiomsForRemoving();
        ArrayList<String> axiomsForAddingFullName = new ArrayList<String>();
        ArrayList<String> axiomsForRemovingFullName = new ArrayList<String>();
        Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        StringBuilder str = new StringBuilder("BEGIN \n");
        int i = 0;
        for (String s : axiomsForRemoving) {
            ++i;
            if (this.debuggingOutput) {
                System.out.println("for removing:" + s);
            }
            m = pat.matcher(s);
            while (m.find()) {
                if (this.debuggingOutput) {
                    System.out.println(s);
                }
                if (this.debuggingOutput) {
                    System.out.println("test " + m.group() + " cim " + m.group());
                }
                s = s.replaceAll("\\" + m.group() + " ", "[" + m.group() + "]" + " ");
                s = s.replaceAll("directSubClassOf", "SubClassOf:");
            }
            if (this.debuggingOutput) {
                System.out.println("for removing:" + s);
            }
            axiomsForRemovingFullName.add(s);
        }
        i = 0;
        for (String s : arrayList) {
            ++i;
            if (this.debuggingOutput) {
                System.out.println("for adding:" + s);
            }
            m = pat.matcher(s);
            String tempAxiom = s;
            while (m.find()) {
                if (this.debuggingOutput) {
                    System.out.println("test " + m.group());
                }
                tempAxiom = tempAxiom.replaceAll("\\" + m.group(), "[" + this.OP2toOP1.get(m.group()) + "]");
                tempAxiom = tempAxiom.replaceAll("directSubClassOf", "SubClassOf:");
                s = s.replaceAll("\\" + m.group(), (String)namingOP2.get(m.group()));
                s = s.replaceAll("directSubClassOf", "SubClassOf:");
            }
            if (this.debuggingOutput) {
                System.out.println("for adding:" + s);
            }
            if (this.debuggingOutput) {
                System.out.println("for adding:" + tempAxiom);
            }
            if (axiomsForRemovingFullName.contains(tempAxiom)) {
                axiomsForRemovingFullName.remove(tempAxiom);
                continue;
            }
            axiomsForAddingFullName.add(s);
        }
        for (String s : axiomsForRemovingFullName) {
            this.axiomsRemovingInstructions.add("<remove>" + s + "</remove>\n");
            if (i != axiomsForRemoving.size()) {
                str.append("REMOVE " + s + ",\n");
                continue;
            }
            str.append("REMOVE " + s + "\n");
        }
        for (String s : axiomsForAddingFullName) {
            this.axiomsInstructions.add("<add>" + s + "</add>\n");
            if (i != arrayList.size()) {
                str.append("ADD " + s + ",\n");
                continue;
            }
            str.append("ADD " + s + "\n");
        }
        str.append("END;");
        String annotationToEntity = "";
        if (this.debuggingOutput) {
            System.out.println(this.entitiesInstructions);
        }
        if (this.debuggingOutput) {
            System.out.println(this.axiomsInstructions);
        }
        if (this.debuggingOutput) {
            System.out.println(this.annotationsInstructions);
        }
        this.namingOP2 = namingOP2;
        if (!entitiesForAdding.isEmpty()) {
            for (String s : entitiesForAdding) {
                if (!this.tp.getOP2().getPlaceholders().get(s).equals((Object)OntologyPattern.EntityType.Class)) continue;
                System.out.println("nova entita a je to trida od " + s + " k " + this.getBindings().get(s));
                this.axiomsInstructions.add("<add>" + this.getBindings().get(s) + " SubClassOf: Thing</add>\n");
            }
        }
    }

    @Override
    public HashMap<String, String> getEntitiesForRenaming() {
        HashMap<String, String> entitiesForRenaming = new HashMap<String, String>();
        for (String key : this.tp.getPT().getLinks(PatternTransformation.Type.eq).keySet()) {
            entitiesForRenaming.put(key, "ENP(" + this.tp.getPT().getLinks(PatternTransformation.Type.eq).get(key) + ")");
            entitiesForRenaming.put(this.tp.getPT().getLinks(PatternTransformation.Type.eq).get(key), key);
        }
        return entitiesForRenaming;
    }

    @Override
    public ArrayList<String> getSpecifiedOP2OptionalPlaceholders(Set<String> specifiedOP1Placeholders) {
        ArrayList<String> specifiedOP2OptionalPlaceholders = new ArrayList<String>();
        for (String key : this.tp.getPT().getLinks(PatternTransformation.Type.eq).keySet()) {
            if (!specifiedOP1Placeholders.contains(key)) continue;
            specifiedOP2OptionalPlaceholders.add(this.tp.getPT().getLinks(PatternTransformation.Type.eq).get(key));
        }
        for (String key : this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).keySet()) {
            if (!specifiedOP1Placeholders.contains(key)) continue;
            specifiedOP2OptionalPlaceholders.add(this.tp.getPT().getLinks(PatternTransformation.Type.eqHet).get(key));
        }
        return specifiedOP2OptionalPlaceholders;
    }
}

