/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.transformation.pattern;

import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import cz.vse.keg.patomat.transformation.pattern.NameDetectionPatternImpl;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern;
import cz.vse.keg.patomat.transformation.pattern.OntologyPatternImpl;
import cz.vse.keg.patomat.transformation.pattern.PatternTransformation;
import cz.vse.keg.patomat.transformation.pattern.PatternTransformationImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.util.URLGrabber;
import java.io.StringBufferInputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TransformationPatternImpl
implements TransformationPattern {
    private OntologyPattern OP1 = new OntologyPatternImpl();
    private OntologyPattern OP2 = new OntologyPatternImpl();
    private PatternTransformation PT = new PatternTransformationImpl();
    private String uri = "no uri";
    private boolean debuggingOutput = false;

    public TransformationPatternImpl(String uriXML) {
        try {
            if (uriXML.matches("^http.*") || uriXML.matches("^file.*")) {
                this.uri = uriXML;
                this.setTP(URLGrabber.getDocumentAsString((String)uriXML));
            } else {
                this.setTP(uriXML);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setTP(String tp) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(new StringBufferInputStream(tp));
            DocumentType doctype = doc.getDoctype();
            if (doctype != null && doctype.getEntities() != null) {
                int number_of_nodes = doctype.getEntities().getLength();
                int i = 0;
                while (i < number_of_nodes) {
                    this.OP1.addNamespace(doc.getDoctype().getEntities().item(i).getNodeName(), doc.getDoctype().getEntities().item(i).getTextContent());
                    this.OP2.addNamespace(doc.getDoctype().getEntities().item(i).getNodeName(), doc.getDoctype().getEntities().item(i).getTextContent());
                    if (this.debuggingOutput) {
                        System.out.println(String.valueOf(doc.getDoctype().getEntities().item(i).getNodeName()) + ":" + doc.getDoctype().getEntities().item(i).getTextContent());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final PrefixResolverDefault resolver = new PrefixResolverDefault(doc.getDocumentElement());
        NamespaceContext ctx = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return resolver.getNamespaceForPrefix(prefix);
            }

            public Iterator getPrefixes(String val) {
                return null;
            }

            @Override
            public String getPrefix(String uri) {
                return null;
            }
        };
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(ctx);
        String expression = "/:tp/:op1/:entity_declarations/:placeholder";
        try {
            NodeList nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodesOP.getLength()) {
                if (((Element)nodesOP.item(i)).getAttribute("type").equals("Axiom")) {
                    this.OP1.addPlaceholderAxiom(nodesOP.item(i).getTextContent(), OntologyPatternImpl.getType(((Element)nodesOP.item(i)).getAttribute("type")));
                } else {
                    this.OP1.addPlaceholder(nodesOP.item(i).getTextContent(), OntologyPatternImpl.getType(((Element)nodesOP.item(i)).getAttribute("type")));
                }
                ++i;
            }
            nodesOP = (NodeList)xpath.evaluate("/:tp/:op1/:entity_declarations/:entity", doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                this.OP1.addSpecifiedEntity(nodesOP.item(i).getTextContent(), OntologyPatternImpl.getType(((Element)nodesOP.item(i)).getAttribute("type")));
                ++i;
            }
            nodesOP = (NodeList)xpath.evaluate("/:tp/:op1/:axioms/:axiom", doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                String axiom = nodesOP.item(i).getTextContent();
                axiom = axiom.replaceAll(",", " ,");
                axiom = axiom.replaceAll("\\)", " )");
                axiom = axiom.replaceAll("}", " }");
                axiom = axiom.replaceAll("$", " ");
                if (((Element)nodesOP.item(i)).getAttribute("optional").equals("yes")) {
                    this.OP1.addOptionalAxiom(axiom);
                }
                this.OP1.addAxiom(axiom);
                ++i;
            }
            nodesOP = (NodeList)xpath.evaluate("/:tp/:op1/:ndp/*", doc, XPathConstants.NODESET);
            int i2 = 0;
            while (i2 < nodesOP.getLength()) {
                NameDetectionPatternImpl ndp = new NameDetectionPatternImpl();
                if (nodesOP.item(i2).getNodeName().equals("exist")) {
                    ndp.setNamePatternType(nodesOP.item(i2).getNodeName());
                    ndp.setEntity1(nodesOP.item(i2).getTextContent());
                    this.OP1.addNameDetectionPattern(ndp);
                } else if (nodesOP.item(i2).getNodeName().equals("comparison")) {
                    ndp.setNamePatternType(nodesOP.item(i2).getNodeName());
                    ndp.setThreshold(Float.valueOf(((Element)nodesOP.item(i2)).getAttribute("threshold")).floatValue());
                    ndp.setMeasureType(((Element)nodesOP.item(i2)).getAttribute("measure"));
                    ndp.setEntity1(nodesOP.item(i2).getFirstChild().getTextContent());
                    ndp.setEntity2(nodesOP.item(i2).getLastChild().getTextContent());
                    this.OP1.addNameDetectionPattern(ndp);
                }
                ++i2;
            }
            nodesOP = (NodeList)xpath.evaluate("/:tp/:op2/:entity_declarations/:placeholder", doc, XPathConstants.NODESET);
            i2 = 0;
            while (i2 < nodesOP.getLength()) {
                this.OP2.addPlaceholder(nodesOP.item(i2).getTextContent(), OntologyPatternImpl.getType(((Element)nodesOP.item(i2)).getAttribute("type")));
                ++i2;
            }
            nodesOP = (NodeList)xpath.evaluate("/:tp/:op2/:entity_declarations/:entity", doc, XPathConstants.NODESET);
            i2 = 0;
            while (i2 < nodesOP.getLength()) {
                this.OP2.addSpecifiedEntity(nodesOP.item(i2).getTextContent(), OntologyPatternImpl.getType(((Element)nodesOP.item(i2)).getAttribute("type")));
                ++i2;
            }
            nodesOP = (NodeList)xpath.evaluate("/:tp/:op2/:axioms/:axiom", doc, XPathConstants.NODESET);
            i2 = 0;
            while (i2 < nodesOP.getLength()) {
                String axiom = nodesOP.item(i2).getTextContent();
                axiom = axiom.replaceAll(",", " ,");
                axiom = axiom.replaceAll("\\)", " )");
                axiom = axiom.replaceAll("}", " }");
                axiom = axiom.replaceAll("$", " ");
                if (((Element)nodesOP.item(i2)).getAttribute("optinal").equals("yes")) {
                    this.OP2.addOptionalAxiom(axiom);
                }
                this.OP2.addAxiom(axiom);
                ++i2;
            }
            nodesOP = (NodeList)xpath.evaluate("/:tp/:op2/:ndp/*", doc, XPathConstants.NODESET);
            i2 = 0;
            while (i2 < nodesOP.getLength()) {
                NameDetectionPatternImpl ndp = new NameDetectionPatternImpl();
                if (nodesOP.item(i2).getNodeName().equals("exist")) {
                    ndp.setNamePatternType(nodesOP.item(i2).getNodeName());
                    ndp.setEntity1(nodesOP.item(i2).getTextContent());
                    this.OP2.addNameDetectionPattern(ndp);
                } else if (nodesOP.item(i2).getNodeName().equals("comparison")) {
                    ndp.setNamePatternType(nodesOP.item(i2).getNodeName());
                    ndp.setThreshold(Float.valueOf(((Element)nodesOP.item(i2)).getAttribute("threshold")).floatValue());
                    ndp.setMeasureType(((Element)nodesOP.item(i2)).getAttribute("measure"));
                    ndp.setEntity1(nodesOP.item(i2).getFirstChild().getTextContent());
                    ndp.setEntity2(nodesOP.item(i2).getLastChild().getTextContent());
                    this.OP2.addNameDetectionPattern(ndp);
                }
                ++i2;
            }
            nodesOP = (NodeList)xpath.evaluate("/:tp/:pt/:eq", doc, XPathConstants.NODESET);
            HashMap<String, String> anyLinks = new HashMap<String, String>();
            HashMap<String, String> curLinks = new HashMap<String, String>();
            int i3 = 0;
            while (i3 < nodesOP.getLength()) {
                curLinks.put(((Element)nodesOP.item(i3)).getAttribute("op1"), ((Element)nodesOP.item(i3)).getAttribute("op2"));
                ++i3;
            }
            this.PT.setLinks(curLinks, PatternTransformation.Type.eq);
            anyLinks.putAll(curLinks);
            nodesOP = (NodeList)xpath.evaluate("/:tp/:pt/:eqHet", doc, XPathConstants.NODESET);
            curLinks = new HashMap();
            i3 = 0;
            while (i3 < nodesOP.getLength()) {
                curLinks.put(((Element)nodesOP.item(i3)).getAttribute("op1"), ((Element)nodesOP.item(i3)).getAttribute("op2"));
                ++i3;
            }
            this.PT.setLinks(curLinks, PatternTransformation.Type.eqHet);
            anyLinks.putAll(curLinks);
            nodesOP = (NodeList)xpath.evaluate("/:tp/:pt/:eqAnn", doc, XPathConstants.NODESET);
            curLinks = new HashMap();
            i3 = 0;
            while (i3 < nodesOP.getLength()) {
                curLinks.put(((Element)nodesOP.item(i3)).getAttribute("op1"), ((Element)nodesOP.item(i3)).getAttribute("op2"));
                ++i3;
            }
            this.PT.setLinks(curLinks, PatternTransformation.Type.eqAnn);
            anyLinks.putAll(curLinks);
            this.PT.setLinks(anyLinks, PatternTransformation.Type.any);
            nodesOP = (NodeList)xpath.evaluate("/:tp/:pt/:ntp", doc, XPathConstants.NODESET);
            HashMap<String, String> curENP = new HashMap<String, String>();
            int i4 = 0;
            while (i4 < nodesOP.getLength()) {
                curENP.put(((Element)nodesOP.item(i4)).getAttribute("entity"), ((Element)nodesOP.item(i4)).getTextContent());
                ++i4;
            }
            this.PT.setENP(curENP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public OntologyPattern getOP1() {
        return this.OP1;
    }

    @Override
    public OntologyPattern getOP2() {
        return this.OP2;
    }

    @Override
    public PatternTransformation getPT() {
        return this.PT;
    }

    @Override
    public String getLocation() {
        return this.uri;
    }

    public String toString() {
        StringBuffer niceOutput = new StringBuffer();
        niceOutput.append("<tp>\n");
        niceOutput.append("<op1>\n");
        niceOutput.append(this.OP1.toString());
        niceOutput.append("</op1>\n");
        niceOutput.append("<op2>\n");
        niceOutput.append(this.OP2.toString());
        niceOutput.append("</op2>\n");
        niceOutput.append(this.PT.toString());
        niceOutput.append("</tp>\n");
        return niceOutput.toString();
    }

    public static void main(String[] args) {
        TransformationPatternImpl tp1 = new TransformationPatternImpl("");
        if (tp1.debuggingOutput) {
            System.out.println(tp1.getOP1());
        }
        if (tp1.debuggingOutput) {
            System.out.println(tp1.getOP2());
        }
    }
}

