/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.transformation.pattern;

import cz.vse.keg.patomat.transformation.pattern.NameDetectionPattern;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OntologyPatternImpl
implements OntologyPattern {
    private HashMap<String, OntologyPattern.EntityType> placeholders = new HashMap();
    private HashMap<String, OntologyPattern.EntityType> placeholderaxioms = new HashMap();
    private HashMap<String, OntologyPattern.EntityType> specified_entities = new HashMap();
    private HashMap<String, OntologyPattern.EntityType> allPlaceholders = new HashMap();
    private ArrayList<String> axioms = new ArrayList();
    private ArrayList<String> optionalAxioms = new ArrayList();
    private HashSet<String> optionalPlaceholders;
    private ArrayList<NameDetectionPattern> nameDetectionPatterns = new ArrayList();
    private HashMap<String, String> namespaces = new HashMap();

    @Override
    public HashMap<String, OntologyPattern.EntityType> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public HashMap<String, OntologyPattern.EntityType> getPlaceholderAxioms() {
        return this.placeholders;
    }

    @Override
    public HashMap<String, OntologyPattern.EntityType> getSpecifiedEntities() {
        return this.specified_entities;
    }

    @Override
    public ArrayList<String> getAxioms() {
        return this.axioms;
    }

    @Override
    public ArrayList<String> getOptionalAxioms() {
        return this.optionalAxioms;
    }

    @Override
    public void addPlaceholder(String placeholder, OntologyPattern.EntityType type) {
        this.placeholders.put(placeholder, type);
    }

    @Override
    public void addPlaceholderAxiom(String placeholder, OntologyPattern.EntityType type) {
        this.placeholderaxioms.put(placeholder, type);
    }

    @Override
    public void addSpecifiedEntity(String specified_entity, OntologyPattern.EntityType type) {
        this.specified_entities.put(specified_entity, type);
    }

    @Override
    public void setPlaceholders() {
        Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        for (String axiom : this.axioms) {
            Matcher m = pat.matcher(axiom);
            while (m.find()) {
                this.placeholders.put(m.group(), OntologyPattern.EntityType.Uknown);
            }
        }
    }

    public static OntologyPattern.EntityType getType(String type) {
        if (type.equals("Class")) {
            return OntologyPattern.EntityType.Class;
        }
        if (type.equals("ObjectProperty")) {
            return OntologyPattern.EntityType.ObjectProperty;
        }
        if (type.equals("DatatypeProperty")) {
            return OntologyPattern.EntityType.DatatypeProperty;
        }
        if (type.equals("AnnotationProperty")) {
            return OntologyPattern.EntityType.AnnotationProperty;
        }
        if (type.equals("Individual")) {
            return OntologyPattern.EntityType.Individual;
        }
        if (type.equals("AnonymousIndividual")) {
            return OntologyPattern.EntityType.AnonymousIndividual;
        }
        if (type.equals("Literal")) {
            return OntologyPattern.EntityType.Literal;
        }
        return OntologyPattern.EntityType.Uknown;
    }

    @Override
    public void addAxiom(String axiom) {
        this.axioms.add(axiom);
    }

    @Override
    public void addOptionalAxiom(String axiom) {
        this.optionalAxioms.add(axiom);
    }

    public String toString() {
        StringBuffer niceOutput = new StringBuffer();
        niceOutput.append("<entity_declarations>\n");
        for (String string : this.placeholders.keySet()) {
            niceOutput.append("<placeholder type=" + (Object)((Object)this.placeholders.get(string)) + ">" + string + "</placeholder>\n");
        }
        niceOutput.append("</entity_declarations>\n");
        niceOutput.append("<axioms>\n");
        for (String string : this.axioms) {
            if (this.optionalAxioms.contains(string)) {
                niceOutput.append("<axiom optional=\"yes\">" + string + "</axiom>\n");
                continue;
            }
            niceOutput.append("<axiom>" + string + "</axiom>\n");
        }
        niceOutput.append("</axioms>\n");
        niceOutput.append("<axioms>\n");
        if (!this.nameDetectionPatterns.isEmpty()) {
            niceOutput.append("<ndp\n>");
            for (NameDetectionPattern nameDetectionPattern : this.nameDetectionPatterns) {
                niceOutput.append(nameDetectionPattern);
            }
            niceOutput.append("</ndp>\n");
        }
        return niceOutput.toString();
    }

    @Override
    public void addNameDetectionPattern(NameDetectionPattern n) {
        this.nameDetectionPatterns.add(n);
    }

    @Override
    public ArrayList<NameDetectionPattern> getNameDetectionPatterns() {
        return this.nameDetectionPatterns;
    }

    @Override
    public HashMap<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void addNamespace(String prefix, String namespace) {
        this.namespaces.put(namespace, prefix);
    }

    @Override
    public void replaceAxiom(String oldAxiom, String newAxiom) {
        int i = this.axioms.indexOf(oldAxiom);
        this.axioms.set(i, newAxiom);
        if (this.optionalAxioms.contains(oldAxiom)) {
            i = this.optionalAxioms.indexOf(oldAxiom);
            this.optionalAxioms.set(i, newAxiom);
        }
    }

    @Override
    public void replacePlaceholder(String oldPlaceholder, String[] newPlaceholdersArray) {
        if (newPlaceholdersArray.length == 0) {
            return;
        }
        int j = 0;
        while (j < newPlaceholdersArray.length) {
            this.placeholders.put(newPlaceholdersArray[j], this.placeholders.get(oldPlaceholder));
            ++j;
        }
        this.placeholders.remove(oldPlaceholder);
    }

    @Override
    public void replaceAxiom(String oldAxiom, String[] newAxiomsArray) {
        if (newAxiomsArray.length == 0) {
            return;
        }
        int i = this.axioms.indexOf(oldAxiom);
        this.axioms.set(i, newAxiomsArray[0]);
        int j = 1;
        while (j < newAxiomsArray.length) {
            this.axioms.add(newAxiomsArray[j]);
            ++j;
        }
        if (this.optionalAxioms.contains(oldAxiom)) {
            i = this.optionalAxioms.indexOf(oldAxiom);
            this.optionalAxioms.set(i, newAxiomsArray[0]);
            j = 1;
            while (j < newAxiomsArray.length) {
                this.optionalAxioms.add(newAxiomsArray[j]);
                ++j;
            }
        }
    }

    @Override
    public HashSet<String> getOptionalPlaceholders() {
        HashSet<String> optPlaceholders = new HashSet<String>();
        Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
        for (String s : this.optionalAxioms) {
            Matcher m = pat.matcher(s);
            while (m.find()) {
                optPlaceholders.add(m.group());
            }
        }
        return null;
    }
}

