/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat.transformation;

import cz.vse.keg.patomat.transformation.Entity;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.pattern.EntityTypeException;
import cz.vse.keg.patomat.util.URLGrabber;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxEditorParser;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxFramesParser;
import org.coode.owlapi.manchesterowlsyntax.OntologyAxiomPair;
import org.coode.parsers.BidirectionalShortFormProviderAdapter;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.OWLOntologyChecker;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.expression.ShortFormEntityChecker;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.util.BidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.OWLEntityRemover;
import org.semanticweb.owlapi.util.OWLEntityRenamer;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.manchester.cs.owl.owlapi.OWLImportsDeclarationImpl;

public class OntologyTransformationImpl
implements OntologyTransformation<OWLOntology> {
    protected OWLOntology ontology;
    protected OWLOntologyManager manager;
    protected OWLDataFactory factory;
    protected String base;
    protected String url;
    protected String tpLocation;
    protected StringBuilder axiomsAdding;
    protected StringBuilder axiomsRemoving;
    protected HashMap<Entity, String> renamingEntitiesInstructions;
    protected HashSet<Entity> removingEntities;
    protected HashSet<Entity> addingImportedEntities;
    protected HashSet<Entity> addingEntities;
    protected HashSet<Entity> addingAxioms;
    protected HashSet<String> addingAxioms2;
    protected HashSet<String> removingAxioms2;
    protected HashSet<String> addingAnnotationsAxioms;
    protected HashMap<String, String> newNamespaces;
    protected String dictionaryPath;
    protected String modelsPath;
    private boolean debuggingOutput;
    private String workingDirectory;

    @Override
    public boolean willTransformOntology() {
        return !this.removingEntities.isEmpty() || !this.addingEntities.isEmpty() || !this.axiomsRemoving.toString().trim().equals("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN\nEND;") || !this.renamingEntitiesInstructions.isEmpty() || !this.axiomsAdding.toString().trim().equals("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN\nEND;") || !this.addingAnnotationsAxioms.isEmpty();
    }

    public OntologyTransformationImpl(OWLOntology ontology, String wordnetPath, String modelPath, String workingDirectory) {
        this.url = "";
        this.tpLocation = "";
        this.debuggingOutput = false;
        this.workingDirectory = String.valueOf(System.getProperty("user.home").replaceAll("\\\\", "/")) + "/";
        this.dictionaryPath = wordnetPath;
        this.modelsPath = modelPath;
        this.workingDirectory = String.valueOf(workingDirectory) + "/";
        this.renamingEntitiesInstructions = new HashMap();
        this.removingEntities = new HashSet();
        this.addingImportedEntities = new HashSet();
        this.addingEntities = new HashSet();
        this.addingAxioms = new HashSet();
        this.addingAnnotationsAxioms = new HashSet();
        this.addingAxioms2 = new HashSet();
        this.removingAxioms2 = new HashSet();
        this.axiomsRemoving = new StringBuilder();
        this.axiomsAdding = new StringBuilder();
        this.manager = OWLManager.createOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.newNamespaces = new HashMap();
        this.ontology = ontology;
        this.manager = ontology.getOWLOntologyManager();
        this.base = this.getBaseURI(":");
    }

    public OntologyTransformationImpl(String url) {
        block10: {
            this.url = "";
            this.tpLocation = "";
            this.debuggingOutput = false;
            this.workingDirectory = String.valueOf(System.getProperty("user.home").replaceAll("\\\\", "/")) + "/";
            try {
                BufferedReader vstup = new BufferedReader(new FileReader("config.properties"));
                String row = vstup.readLine();
                if (row != null) {
                    this.dictionaryPath = row.substring(row.indexOf("=") + 2, row.length() - 1);
                }
                if ((row = vstup.readLine()) != null) {
                    this.modelsPath = row.substring(row.indexOf("=") + 2, row.length() - 1);
                }
                vstup.close();
            }
            catch (FileNotFoundException e) {
                if (this.debuggingOutput) {
                    System.out.println("File does not exist");
                }
            }
            catch (IOException e) {
                if (!this.debuggingOutput) break block10;
                System.out.println("Error on input of a file");
            }
        }
        this.renamingEntitiesInstructions = new HashMap();
        this.removingEntities = new HashSet();
        this.addingImportedEntities = new HashSet();
        this.addingEntities = new HashSet();
        this.addingAxioms = new HashSet();
        this.addingAnnotationsAxioms = new HashSet();
        this.axiomsRemoving = new StringBuilder();
        this.addingAxioms2 = new HashSet();
        this.removingAxioms2 = new HashSet();
        this.axiomsAdding = new StringBuilder();
        this.manager = OWLManager.createOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.url = url;
        this.newNamespaces = new HashMap();
        try {
            if (this.url.matches("^http.*") || this.url.matches("^file.*")) {
                this.setOntology(this.manager.loadOntologyFromOntologyDocument(IRI.create((String)this.url)));
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(this.url.getBytes());
                this.ontology = this.manager.loadOntologyFromOntologyDocument((InputStream)in);
                ((InputStream)in).close();
            }
            this.base = this.getBaseURI(":");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OntologyTransformationImpl(OWLOntology ont) {
        block7: {
            this.url = "";
            this.tpLocation = "";
            this.debuggingOutput = false;
            this.workingDirectory = String.valueOf(System.getProperty("user.home").replaceAll("\\\\", "/")) + "/";
            try {
                BufferedReader vstup = new BufferedReader(new FileReader("config.properties"));
                String row = vstup.readLine();
                if (row != null) {
                    this.dictionaryPath = row.substring(row.indexOf("=") + 2, row.length() - 1);
                }
                if ((row = vstup.readLine()) != null) {
                    this.modelsPath = row.substring(row.indexOf("=") + 2, row.length() - 1);
                }
                vstup.close();
            }
            catch (FileNotFoundException e) {
                if (this.debuggingOutput) {
                    System.out.println("File does not exist");
                }
            }
            catch (IOException e) {
                if (!this.debuggingOutput) break block7;
                System.out.println("Error on input of a file");
            }
        }
        this.renamingEntitiesInstructions = new HashMap();
        this.removingEntities = new HashSet();
        this.addingImportedEntities = new HashSet();
        this.addingEntities = new HashSet();
        this.addingAxioms = new HashSet();
        this.addingAnnotationsAxioms = new HashSet();
        this.addingAxioms2 = new HashSet();
        this.removingAxioms2 = new HashSet();
        this.axiomsRemoving = new StringBuilder();
        this.axiomsAdding = new StringBuilder();
        this.ontology = ont;
        this.manager = this.ontology.getOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.newNamespaces = new HashMap();
        this.base = this.getBaseURI("");
        if (this.base == null || this.base.equals("http://www.w3.org/2002/07/owl#")) {
            this.base = this.getBaseURI();
        }
        this.url = this.base;
    }

    public OntologyTransformationImpl(String url, String wordnetPath, String modelPath) {
        this.url = "";
        this.tpLocation = "";
        this.debuggingOutput = false;
        this.workingDirectory = String.valueOf(System.getProperty("user.home").replaceAll("\\\\", "/")) + "/";
        this.dictionaryPath = wordnetPath;
        this.modelsPath = modelPath;
        this.renamingEntitiesInstructions = new HashMap();
        this.removingEntities = new HashSet();
        this.addingImportedEntities = new HashSet();
        this.addingEntities = new HashSet();
        this.addingAxioms = new HashSet();
        this.addingAnnotationsAxioms = new HashSet();
        this.addingAxioms2 = new HashSet();
        this.removingAxioms2 = new HashSet();
        this.axiomsRemoving = new StringBuilder();
        this.axiomsAdding = new StringBuilder();
        this.manager = OWLManager.createOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.url = url;
        this.newNamespaces = new HashMap();
        try {
            if (this.url.matches("^http.*") || this.url.matches("^file.*")) {
                this.setOntology(this.manager.loadOntologyFromOntologyDocument(IRI.create((String)this.url)));
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(this.url.getBytes());
                this.ontology = this.manager.loadOntologyFromOntologyDocument((InputStream)in);
                ((InputStream)in).close();
            }
            this.base = this.getBaseURI(":");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OntologyTransformationImpl(String url, String wordnetPath, String modelPath, String workingDirectory) {
        this.url = "";
        this.tpLocation = "";
        this.debuggingOutput = false;
        this.workingDirectory = String.valueOf(System.getProperty("user.home").replaceAll("\\\\", "/")) + "/";
        this.dictionaryPath = wordnetPath;
        this.modelsPath = modelPath;
        this.workingDirectory = String.valueOf(workingDirectory) + "/";
        this.renamingEntitiesInstructions = new HashMap();
        this.removingEntities = new HashSet();
        this.addingImportedEntities = new HashSet();
        this.addingEntities = new HashSet();
        this.addingAxioms = new HashSet();
        this.addingAnnotationsAxioms = new HashSet();
        this.addingAxioms2 = new HashSet();
        this.removingAxioms2 = new HashSet();
        this.axiomsRemoving = new StringBuilder();
        this.axiomsAdding = new StringBuilder();
        this.manager = OWLManager.createOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.url = url;
        this.newNamespaces = new HashMap();
        try {
            if (this.url.matches("^http.*") || this.url.matches("^file.*")) {
                this.setOntology(this.manager.loadOntologyFromOntologyDocument(IRI.create((String)this.url)));
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(this.url.getBytes());
                this.ontology = this.manager.loadOntologyFromOntologyDocument((InputStream)in);
                ((InputStream)in).close();
            }
            this.base = this.getBaseURI(":");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getBaseURI(String namespace) {
        Map nsMap = null;
        OWLOntologyFormat format = this.manager.getOntologyFormat(this.ontology);
        if (format instanceof PrefixOWLOntologyFormat) {
            PrefixOWLOntologyFormat nsFormat = (PrefixOWLOntologyFormat)format;
            nsMap = nsFormat.getPrefixName2PrefixMap();
            return (String)nsMap.get(namespace);
        }
        return "";
    }

    private String getBaseURI() {
        for (OWLClass c : this.ontology.getClassesInSignature()) {
            String s = c.toStringID().indexOf("#") != -1 ? c.toStringID().substring(0, c.toStringID().indexOf("#") + 1) : c.toStringID().substring(0, c.toStringID().lastIndexOf("/") + 1);
            if (s.equals("http://www.w3.org/2002/07/owl#")) continue;
            return s;
        }
        return "";
    }

    private void setNewPrefix(String prefix, String namespace) {
        OWLOntologyFormat format = this.manager.getOntologyFormat(this.ontology);
        if (format instanceof PrefixOWLOntologyFormat) {
            ((PrefixOWLOntologyFormat)format).setPrefix(prefix, namespace);
        }
    }

    @Override
    public void setInstructions(String instructions) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(instructions.getBytes()));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "/instructions/entities/rename";
            NodeList nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodesOP.getLength()) {
                if (!((Element)nodesOP.item(i)).getAttribute("original_name").equals(((Element)nodesOP.item(i)).getTextContent())) {
                    this.renamingEntitiesInstructions.put(new Entity(((Element)nodesOP.item(i)).getAttribute("original_name"), ((Element)nodesOP.item(i)).getAttribute("type")), ((Element)nodesOP.item(i)).getTextContent());
                }
                ++i;
            }
            expression = "/instructions";
            nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                this.tpLocation = ((Element)nodesOP.item(i)).getAttribute("tp");
                ++i;
            }
            expression = "/instructions/entities/remove";
            nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                this.removingEntities.add(new Entity(((Element)nodesOP.item(i)).getTextContent(), ((Element)nodesOP.item(i)).getAttribute("type")));
                ++i;
            }
            expression = "/instructions/entities/add";
            nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                if (((Element)nodesOP.item(i)).getAttribute("type").equals("imported_entity_ObjectProperty")) {
                    this.addingImportedEntities.add(new Entity(((Element)nodesOP.item(i)).getTextContent(), "ObjectProperty"));
                } else if (((Element)nodesOP.item(i)).getAttribute("type").equals("imported_entity_AnnotationProperty")) {
                    this.addingImportedEntities.add(new Entity(((Element)nodesOP.item(i)).getTextContent(), "AnnotationProperty"));
                } else if (((Element)nodesOP.item(i)).getAttribute("type").equals("imported_entity_DatatypeProperty")) {
                    this.addingImportedEntities.add(new Entity(((Element)nodesOP.item(i)).getTextContent(), "DatatypeProperty"));
                } else if (((Element)nodesOP.item(i)).getAttribute("type").equals("imported_entity_Class")) {
                    this.addingImportedEntities.add(new Entity(((Element)nodesOP.item(i)).getTextContent(), "Class"));
                } else if (((Element)nodesOP.item(i)).getAttribute("type").equals("imported_entity_Individual")) {
                    this.addingImportedEntities.add(new Entity(((Element)nodesOP.item(i)).getTextContent(), "Individual"));
                } else if (((Element)nodesOP.item(i)).getAttribute("type").equals("axiom")) {
                    this.addingAxioms.add(new Entity(((Element)nodesOP.item(i)).getTextContent()));
                } else {
                    this.addingEntities.add(new Entity(((Element)nodesOP.item(i)).getTextContent(), ((Element)nodesOP.item(i)).getAttribute("type")));
                }
                ++i;
            }
            expression = "/instructions/annotations/add";
            nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                this.addingAnnotationsAxioms.add(((Element)nodesOP.item(i)).getTextContent().replaceAll("!", ""));
                ++i;
            }
            nodesOP = (NodeList)xpath.evaluate("/instructions/axioms/add", doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                System.out.println(((Element)nodesOP.item(i)).getTextContent().replaceAll("!", ""));
                this.addingAxioms2.add(((Element)nodesOP.item(i)).getTextContent().replaceAll("!", ""));
                ++i;
            }
            nodesOP = (NodeList)xpath.evaluate("/instructions/axioms/remove", doc, XPathConstants.NODESET);
            i = 0;
            while (i < nodesOP.getLength()) {
                this.removingAxioms2.add(((Element)nodesOP.item(i)).getTextContent().replaceAll("!", ""));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setOntology(OWLOntology o) {
        this.ontology = o;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OWLOntology transformOntology(OntologyTransformation.TransformationStrategy ts, boolean addAnnotationsForRemovedAddedAxioms) {
        ManchesterOWLSyntaxEditorParser parser;
        HashSet<String> listOfEntities = new HashSet<String>();
        if (ts == null) {
            ts = OntologyTransformation.TransformationStrategy.Progressive;
        }
        String annotationNS = "http://nb.vse.cz/~svabo/patomat/PatternAnnotation.owl#";
        for (String s : this.newNamespaces.keySet()) {
            if (this.debuggingOutput) {
                System.out.println(String.valueOf(s) + "," + this.newNamespaces.get(s));
            }
            this.setNewPrefix(s, this.newNamespaces.get(s));
        }
        if (ts.equals((Object)OntologyTransformation.TransformationStrategy.Radical) || ts.equals((Object)OntologyTransformation.TransformationStrategy.RadicalKeep) || ts.equals((Object)OntologyTransformation.TransformationStrategy.RadicalRemove)) {
            try {
                ArrayList<AddAxiom> newAxioms = new ArrayList<AddAxiom>();
                ArrayList<AddAxiom> newAnnotatedAxioms = new ArrayList<AddAxiom>();
                block45: for (Entity e : this.removingEntities) {
                    switch (e.getType()) {
                        case ObjectProperty: {
                            break;
                        }
                        case DatatypeProperty: {
                            break;
                        }
                        case Class: {
                            OWLClass clss = this.factory.getOWLClass(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                            OWLClass superClss = null;
                            for (OWLClassExpression c : clss.getSuperClasses(this.ontology)) {
                                if (!(c instanceof OWLClass)) continue;
                                superClss = (OWLClass)c;
                                if (!this.debuggingOutput) break;
                                System.out.println("superclass is " + superClss);
                                break;
                            }
                            TreeSet annotations = new TreeSet();
                            for (OWLAxiom ax : clss.getReferencingAxioms(this.ontology)) {
                                if (ts.equals((Object)OntologyTransformation.TransformationStrategy.RadicalKeep) || ts.equals((Object)OntologyTransformation.TransformationStrategy.RadicalRemove)) {
                                    if (ax instanceof OWLDeclarationAxiom) continue;
                                    OWLAnnotationProperty oWLAnnotationProperty = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(this.base) + "annotation:remove_warning_by")));
                                    OWLLiteral annLiteral = this.factory.getOWLLiteral(this.tpLocation);
                                    annotations.add(this.factory.getOWLAnnotation(oWLAnnotationProperty, (OWLAnnotationValue)annLiteral));
                                    OWLAnnotationProperty oWLAnnotationProperty2 = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(this.base) + "annotation:remove_warning_for")));
                                    IRI annValue = IRI.create((String)clss.toStringID());
                                    annotations.add(this.factory.getOWLAnnotation(oWLAnnotationProperty2, (OWLAnnotationValue)annValue));
                                    newAnnotatedAxioms.add(new AddAxiom(this.ontology, ax.getAnnotatedAxiom((Set)annotations)));
                                    continue;
                                }
                                if (!ts.equals((Object)OntologyTransformation.TransformationStrategy.Radical)) continue;
                                if (ax instanceof OWLObjectPropertyRangeAxiom) {
                                    OWLObjectPropertyRangeAxiom axRangeNew = null;
                                    axRangeNew = superClss == null ? this.factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)((OWLObjectPropertyRangeAxiom)ax).getProperty(), (OWLClassExpression)this.factory.getOWLThing()) : this.factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)((OWLObjectPropertyRangeAxiom)ax).getProperty(), (OWLClassExpression)superClss);
                                    newAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)axRangeNew));
                                    continue;
                                }
                                if (!(ax instanceof OWLObjectPropertyDomainAxiom)) continue;
                                OWLObjectPropertyDomainAxiom axDomainNew = null;
                                axDomainNew = superClss == null ? this.factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)((OWLObjectPropertyDomainAxiom)ax).getProperty(), (OWLClassExpression)this.factory.getOWLThing()) : this.factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)((OWLObjectPropertyDomainAxiom)ax).getProperty(), (OWLClassExpression)superClss);
                                newAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)axDomainNew));
                            }
                            continue block45;
                        }
                        case Individual: {
                            break;
                        }
                        default: {
                            throw new EntityTypeException("Unrecognized entity type.");
                        }
                    }
                }
                if (newAnnotatedAxioms != null) {
                    this.manager.applyChanges(newAnnotatedAxioms);
                }
                if (newAxioms != null) {
                    this.manager.applyChanges(newAxioms);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!this.addingImportedEntities.isEmpty()) {
            AddImport importOntology = null;
            for (Entity e : this.addingImportedEntities) {
                String s = e.getName();
                OWLObjectProperty ent = null;
                System.out.println(String.valueOf(e.getName()) + " " + e.getType().toString().trim());
                if (e.getType().toString().equals("ObjectProperty")) {
                    ent = this.factory.getOWLObjectProperty(IRI.create((String)e.getName()));
                } else if (e.getType().toString().equals("DatatypeProperty")) {
                    ent = this.factory.getOWLDataProperty(IRI.create((String)e.getName()));
                } else if (e.getType().toString().equals("AnnotationProperty")) {
                    ent = this.factory.getOWLAnnotationProperty(IRI.create((String)e.getName()));
                    System.out.println("here here");
                } else if (e.getType().toString().equals("Individual")) {
                    ent = this.factory.getOWLNamedIndividual(IRI.create((String)e.getName()));
                } else if (e.getType().toString().equals("Class")) {
                    ent = this.factory.getOWLClass(IRI.create((String)e.getName()));
                }
                s = s.indexOf("#") != -1 ? s.substring(0, s.indexOf("#")) : s.substring(0, s.lastIndexOf("/"));
                if (!s.equals(this.url)) {
                    OWLImportsDeclarationImpl importDeclaration = new OWLImportsDeclarationImpl(IRI.create((String)s));
                    importOntology = new AddImport(this.ontology, (OWLImportsDeclaration)importDeclaration);
                }
                this.manager.applyChange(importOntology);
                this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)ent)));
            }
        }
        Set importsClosure = this.ontology.getImportsClosure();
        SimpleShortFormProvider shortFormProvider = new SimpleShortFormProvider();
        BidirectionalShortFormProviderAdapter bidiShortFormProvider = new BidirectionalShortFormProviderAdapter(this.manager, importsClosure, (ShortFormProvider)shortFormProvider);
        ShortFormEntityChecker entityChecker = new ShortFormEntityChecker((BidirectionalShortFormProvider)bidiShortFormProvider);
        if (!ts.equals((Object)OntologyTransformation.TransformationStrategy.Conservative) && !this.removingAxioms2.isEmpty()) {
            if (addAnnotationsForRemovedAddedAxioms) {
                OWLAnnotationProperty property;
                TreeSet annotations = new TreeSet();
                if (this.debuggingOutput) {
                    System.out.println("Removed axioms:");
                }
                if (this.removingAxioms2.size() > 0) {
                    property = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(annotationNS) + "removed_axiom")));
                    this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)property)));
                }
                for (String s : this.removingAxioms2) {
                    if (this.debuggingOutput) {
                        System.out.println(s);
                    }
                    property = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(annotationNS) + "removed_axiom")));
                    OWLLiteral oWLLiteral = this.factory.getOWLLiteral(s);
                    this.manager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, this.factory.getOWLAnnotation(property, (OWLAnnotationValue)oWLLiteral)));
                }
            }
            if (this.debuggingOutput) {
                System.out.println("axioms removing:");
            }
            if (this.debuggingOutput) {
                System.out.println(this.removingAxioms2.toString());
            }
            for (String s : this.removingAxioms2) {
                Iterator<Entity> ontologyChecker = new OWLChecker(this.ontology);
                ManchesterOWLSyntaxFramesParser manchesterOWLSyntaxFramesParser = new ManchesterOWLSyntaxFramesParser(this.factory, (OWLEntityChecker)entityChecker);
                manchesterOWLSyntaxFramesParser.setDefaultOntology(this.ontology);
                manchesterOWLSyntaxFramesParser.setOWLEntityChecker((OWLEntityChecker)entityChecker);
                manchesterOWLSyntaxFramesParser.setOWLOntologyChecker(ontologyChecker);
                HashSet axioms = new HashSet();
                try {
                    for (OntologyAxiomPair p : manchesterOWLSyntaxFramesParser.parse(s)) {
                        if (p.getAxiom() instanceof OWLDeclarationAxiom) continue;
                        this.manager.applyChange((OWLOntologyChange)new RemoveAxiom(this.ontology, p.getAxiom()));
                    }
                }
                catch (ParserException exc) {
                    parser = new ManchesterOWLSyntaxEditorParser(this.factory, s);
                    parser.setDefaultOntology(this.ontology);
                    parser.setOWLEntityChecker((OWLEntityChecker)entityChecker);
                    parser.getBase();
                    try {
                        this.manager.applyChange((OWLOntologyChange)new RemoveAxiom(this.ontology, parser.parseAxiom()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (ts.equals((Object)OntologyTransformation.TransformationStrategy.Radical) || ts.equals((Object)OntologyTransformation.TransformationStrategy.RadicalRemove)) {
            OWLEntityRemover remover = new OWLEntityRemover(this.manager, Collections.singleton(this.ontology));
            block52: for (Entity e : this.removingEntities) {
                try {
                    switch (e.getType()) {
                        case ObjectProperty: {
                            remover.visit(this.factory.getOWLObjectProperty(IRI.create((String)(String.valueOf(this.base) + e.getName()))));
                            continue block52;
                        }
                        case DatatypeProperty: {
                            remover.visit(this.factory.getOWLDataProperty(IRI.create((String)(String.valueOf(this.base) + e.getName()))));
                            continue block52;
                        }
                        case Class: {
                            remover.visit(this.factory.getOWLClass(IRI.create((String)(String.valueOf(this.base) + e.getName()))));
                            continue block52;
                        }
                        case Individual: {
                            remover.visit(this.factory.getOWLNamedIndividual(IRI.create((String)(String.valueOf(this.base) + e.getName()))));
                            continue block52;
                        }
                        default: {
                            throw new EntityTypeException("Unrecognized entity type.");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.manager.applyChanges(remover.getChanges());
        }
        OWLEntityRenamer renamer = new OWLEntityRenamer(this.manager, Collections.singleton(this.ontology));
        block53: for (Entity e : this.renamingEntitiesInstructions.keySet()) {
            Object var13_26 = null;
            try {
                void var13_31;
                switch (e.getType()) {
                    case ObjectProperty: {
                        OWLObjectProperty oWLObjectProperty = this.factory.getOWLObjectProperty(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case DatatypeProperty: {
                        OWLDataProperty oWLDataProperty = this.factory.getOWLDataProperty(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case Class: {
                        if (this.debuggingOutput) {
                            System.out.println(String.valueOf(this.base) + this.renamingEntitiesInstructions.get(e));
                        }
                        OWLClass oWLClass = this.factory.getOWLClass(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case Individual: {
                        OWLNamedIndividual oWLNamedIndividual = this.factory.getOWLNamedIndividual(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case Literal: {
                        continue block53;
                    }
                    default: {
                        throw new EntityTypeException("Unrecognized entity type.");
                    }
                }
                if (this.debuggingOutput) {
                    System.out.println(var13_31 + ":" + this.renamingEntitiesInstructions.get(e));
                }
                if (this.debuggingOutput) {
                    System.out.println(this.base);
                }
                if (this.debuggingOutput) {
                    System.out.println(var13_31 + ":" + this.renamingEntitiesInstructions.get(e));
                }
                this.manager.applyChanges(renamer.changeIRI((OWLEntity)var13_31, IRI.create((String)(String.valueOf(this.base) + this.renamingEntitiesInstructions.get(e)))));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Entity e : this.addingEntities) {
            Object var13_33 = null;
            try {
                void var13_38;
                switch (e.getType()) {
                    case ObjectProperty: {
                        OWLObjectProperty oWLObjectProperty = this.factory.getOWLObjectProperty(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case DatatypeProperty: {
                        OWLDataProperty oWLDataProperty = this.factory.getOWLDataProperty(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case Class: {
                        OWLClass oWLClass = this.factory.getOWLClass(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case Individual: {
                        OWLNamedIndividual oWLNamedIndividual = this.factory.getOWLNamedIndividual(IRI.create((String)(String.valueOf(this.base) + e.getName())));
                        break;
                    }
                    case AnonymousIndividual: {
                        this.factory.getOWLAnonymousIndividual(String.valueOf(this.base) + e.getName());
                        break;
                    }
                    default: {
                        throw new EntityTypeException("Unrecognized entity type.");
                    }
                }
                this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)var13_38)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (OWLClassExpression c : this.ontology.getClassesInSignature()) {
            listOfEntities.add(c.toStringID().substring(c.toStringID().indexOf("#") + 1));
        }
        for (OWLNamedIndividual i : this.ontology.getIndividualsInSignature()) {
            listOfEntities.add(i.toStringID().substring(i.toStringID().indexOf("#") + 1));
        }
        for (OWLObjectProperty op : this.ontology.getObjectPropertiesInSignature()) {
            listOfEntities.add(op.toStringID().substring(op.toStringID().indexOf("#") + 1));
        }
        for (OWLDataProperty dp : this.ontology.getDataPropertiesInSignature()) {
            listOfEntities.add(dp.toStringID().substring(dp.toStringID().indexOf("#") + 1));
        }
        if (this.debuggingOutput) {
            System.out.println("List of entities:");
        }
        if (this.debuggingOutput) {
            System.out.println(listOfEntities);
        }
        if (!this.addingAxioms2.isEmpty()) {
            if (addAnnotationsForRemovedAddedAxioms) {
                OWLAnnotationProperty property;
                if (this.debuggingOutput) {
                    System.out.println("Added axioms:");
                }
                if (this.addingAxioms2.size() > 0) {
                    property = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(annotationNS) + "added_axiom")));
                    this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)property)));
                }
                for (String string : this.addingAxioms2) {
                    if (this.debuggingOutput) {
                        System.out.println(string);
                    }
                    property = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(annotationNS) + "added_axiom")));
                    OWLLiteral annLiteral = this.factory.getOWLLiteral(string);
                    this.manager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, this.factory.getOWLAnnotation(property, (OWLAnnotationValue)annLiteral)));
                }
            }
            if (this.debuggingOutput) {
                System.out.println("axioms adding:");
            }
            if (this.debuggingOutput) {
                System.out.println(this.addingAxioms2);
            }
            boolean addAxiom = true;
            for (String s : this.addingAxioms2) {
                StringTokenizer st = new StringTokenizer(s, " ");
                while (st.hasMoreTokens()) {
                    addAxiom = true;
                    String next = st.nextToken();
                    if ((next = next.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\[", "").replaceAll("\\]", "")).trim().equals("Class:") || next.equals("SubClassOf:") || next.equals("EquivalentTo:") || next.equals("some") || next.equals("Individual:") || next.equals("Types:") || next.equals("Annotations:") || next.equals("Facts:") || next.equals("label") || next.equals("broader") || next.equals("inScheme") || next.equals("skosscheme") || next.trim().equals("") || listOfEntities.contains(next.trim())) continue;
                    if (this.debuggingOutput) {
                        System.out.println("neni na seznamu:" + next);
                    }
                    addAxiom = false;
                    break;
                }
                if (!addAxiom) continue;
                Set axioms = new HashSet();
                OWLChecker ontologyChecker = new OWLChecker(this.ontology);
                ManchesterOWLSyntaxFramesParser frameParser = new ManchesterOWLSyntaxFramesParser(this.factory, (OWLEntityChecker)entityChecker);
                frameParser.setDefaultOntology(this.ontology);
                frameParser.setOWLEntityChecker((OWLEntityChecker)entityChecker);
                frameParser.setOWLOntologyChecker((OWLOntologyChecker)ontologyChecker);
                try {
                    if (this.debuggingOutput) {
                        System.out.println("frame:" + s);
                    }
                    axioms = frameParser.parse(s);
                    System.out.println("frame:" + axioms.size());
                    for (OntologyAxiomPair p : axioms) {
                        System.out.println("frame:" + p.getAxiom() + " in " + p.getOntology());
                        if (p.getAxiom() instanceof OWLDeclarationAxiom) continue;
                        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, p.getAxiom()));
                    }
                }
                catch (ParserException exc) {
                    if (this.debuggingOutput) {
                        exc.printStackTrace();
                    }
                    parser = new ManchesterOWLSyntaxEditorParser(this.factory, s);
                    parser.setDefaultOntology(this.ontology);
                    parser.setOWLEntityChecker((OWLEntityChecker)entityChecker);
                    parser.getBase();
                    try {
                        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, parser.parseAxiom()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        String entityType = "";
        IRI subject = null;
        Object var13_43 = null;
        IRI annotationValue = null;
        OWLAnnotationAssertionAxiom annotationAxiom = null;
        AddAxiom axiomToAdd = null;
        for (String s : this.addingAnnotationsAxioms) {
            try {
                void var13_47;
                StringTokenizer st;
                if (this.debuggingOutput) {
                    System.out.println(s);
                }
                if ((entityType = (st = new StringTokenizer(s, " ")).nextToken()).equals("ObjectProperty")) {
                    subject = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("DatatypeProperty")) {
                    subject = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("Class")) {
                    subject = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("Individual")) {
                    subject = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else {
                    if (!entityType.equals("AnonymousIndividual")) break;
                    subject = this.factory.getOWLAnonymousIndividual(st.nextToken());
                }
                String p = st.nextToken();
                if (p.matches("^http://.*")) {
                    OWLAnnotationProperty oWLAnnotationProperty = this.factory.getOWLAnnotationProperty(IRI.create((String)p));
                } else {
                    OWLAnnotationProperty oWLAnnotationProperty = this.factory.getOWLAnnotationProperty(IRI.create((String)(String.valueOf(this.base) + p)));
                }
                entityType = st.nextToken();
                if (entityType.equals("ObjectProperty")) {
                    annotationValue = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("DatatypeProperty")) {
                    annotationValue = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("Class")) {
                    annotationValue = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("Individual")) {
                    annotationValue = IRI.create((String)(String.valueOf(this.base) + st.nextToken()));
                } else if (entityType.equals("AnonymousIndividual")) {
                    annotationValue = this.factory.getOWLAnonymousIndividual(st.nextToken());
                } else {
                    if (!entityType.equals("Literal")) break;
                    annotationValue = this.factory.getOWLLiteral(st.nextToken());
                }
                annotationAxiom = this.factory.getOWLAnnotationAssertionAxiom((OWLAnnotationProperty)var13_47, (OWLAnnotationSubject)subject, (OWLAnnotationValue)annotationValue);
                axiomToAdd = new AddAxiom(this.ontology, (OWLAxiom)annotationAxiom);
                this.manager.applyChange((OWLOntologyChange)axiomToAdd);
                if (!this.debuggingOutput) continue;
                System.out.println(axiomToAdd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void preprocessOntology() {
        ArrayList<AddAxiom> addAxioms = new ArrayList<AddAxiom>();
        ArrayList<RemoveAxiom> removeAxioms = new ArrayList<RemoveAxiom>();
        for (OWLClass cls : this.ontology.getClassesInSignature()) {
            Set allOperands;
            for (OWLClassExpression exp : cls.getEquivalentClasses(this.ontology)) {
                if (!(exp instanceof OWLDisjointUnionAxiom)) continue;
                if (this.debuggingOutput) {
                    System.out.println("DisjointUnionOf " + exp);
                }
                allOperands = ((OWLObjectUnionOf)exp).getOperands();
                for (OWLClassExpression operand : allOperands) {
                    if (!this.debuggingOutput) continue;
                    System.out.println(" " + operand);
                }
            }
            for (OWLClassExpression exp : cls.getSuperClasses(this.ontology)) {
                if (exp instanceof OWLObjectIntersectionOf) {
                    allOperands = ((OWLObjectIntersectionOf)exp).getOperands();
                    for (OWLClassExpression operand : allOperands) {
                        addAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLSubClassOfAxiom((OWLClassExpression)cls, operand)));
                    }
                    removeAxioms.add(new RemoveAxiom(this.ontology, (OWLAxiom)this.factory.getOWLSubClassOfAxiom((OWLClassExpression)cls, exp)));
                }
                if (!(exp instanceof OWLDisjointUnionAxiom)) continue;
                if (this.debuggingOutput) {
                    System.out.println("DisjointUnionOf " + exp);
                }
                allOperands = ((OWLObjectUnionOf)exp).getOperands();
                for (OWLClassExpression operand : allOperands) {
                    if (!this.debuggingOutput) continue;
                    System.out.println(" " + operand);
                }
            }
            for (OWLClassExpression exp : cls.getDisjointClasses(this.ontology)) {
                addAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLDisjointClassesAxiom(new OWLClassExpression[]{cls, (OWLClass)exp})));
            }
            for (OWLDisjointUnionAxiom disUn : this.ontology.getDisjointUnionAxioms(cls)) {
                addAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)disUn.getOWLDisjointClassesAxiom()));
                addAxioms.add(new AddAxiom(this.ontology, (OWLAxiom)disUn.getOWLEquivalentClassesAxiom()));
                removeAxioms.add(new RemoveAxiom(this.ontology, (OWLAxiom)disUn));
            }
        }
        this.manager.applyChanges(addAxioms);
        this.manager.applyChanges(removeAxioms);
    }

    @Override
    public void adjustOWLProfile() {
        ArrayList<RemoveAxiom> removeAxioms = new ArrayList<RemoveAxiom>();
        OWL2ELProfile profile = new OWL2ELProfile();
        OWLProfileReport report = profile.checkOntology(this.ontology);
        System.out.println("The following axioms are more expressive than OWL2 EL. They are removed from the ontology:");
        int i = 0;
        for (OWLProfileViolation v : report.getViolations()) {
            System.out.println(String.valueOf(++i) + ".:" + v + "\n");
            if (v.getAxiom() == null) continue;
            removeAxioms.add(new RemoveAxiom(this.ontology, v.getAxiom()));
        }
    }

    @Override
    public void saveOntology(String url) {
        try {
            if (url.matches("^file.*")) {
                if (this.debuggingOutput) {
                    System.out.println(url.substring(url.lastIndexOf("/") + 1, url.indexOf(".")));
                }
                this.manager.saveOntology(this.ontology, IRI.create((String)("file://" + this.workingDirectory + "ontology.owl")));
            } else {
                if (this.debuggingOutput) {
                    System.out.println(this.url);
                }
                System.out.println(this.url);
                this.manager.saveOntology(this.ontology, IRI.create((String)("file://" + this.workingDirectory + "ontology.owl")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String printOntology() {
        try {
            String s = URLGrabber.getDocumentAsString((String)("file://" + this.workingDirectory + "ontology.owl"));
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    @Override
    public String getDictionaryPath() {
        return this.dictionaryPath;
    }

    @Override
    public String getModelsPath() {
        return this.modelsPath;
    }

    @Override
    public OWLOntology getOntology() {
        return this.ontology;
    }

    @Override
    public OWLOntologyManager getManager() {
        return this.manager;
    }

    @Override
    public void finish() {
        this.manager.removeOntology(this.ontology);
        this.ontology = null;
    }

    private static class OWLChecker
    implements OWLOntologyChecker {
        private OWLOntology ontology;

        public OWLChecker(OWLOntology ontology) {
            this.ontology = ontology;
        }

        public OWLOntology getOntology(String name) {
            return this.ontology;
        }
    }
}

