/*
 * Decompiled with CFR 0.152.
 */
package cz.vse.keg.patomat;

import cz.vse.keg.patomat.RenamingInstruction;
import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestLibrary2forORE {
    public static void printRenameInstructions(String instructions, String bindings) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(instructions.getBytes()));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "/instructions/entities/rename";
            NodeList nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodesOP.getLength()) {
                String new_name;
                String original_name = ((Element)nodesOP.item(i)).getAttribute("original_name");
                if (!original_name.equals(new_name = ((Element)nodesOP.item(i)).getTextContent())) {
                    System.out.println(String.valueOf(original_name) + " to " + new_name);
                    System.out.println(bindings);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        String ontologyURI = "http://nb.vse.cz/~svabo/oaei2011/data/confOf.owl";
        String namingPattern = "http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1b.xml";
        OWLOntology ontology = OWLManager.createOWLOntologyManager().loadOntology(IRI.create((String)ontologyURI));
        TransformationPatternImpl tp1 = new TransformationPatternImpl(namingPattern);
        OntologyTransformationImpl transformation = new OntologyTransformationImpl(ontology, "resources/wordnet", "resources/postagger", "/tmp/");
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl(transformation.getDictionaryPath(), transformation.getModelsPath());
        ArrayList<String> pattern = detection.queryPatternStructuralAspect2((TransformationPattern)tp1, ontologyURI, false, false);
        ArrayList<String> selectedPattern = new ArrayList<String>();
        selectedPattern.add(pattern.get(0));
        selectedPattern.add(pattern.get(1));
        ArrayList<RenamingInstruction> instructions = new ArrayList<RenamingInstruction>();
        boolean POStagger = true;
        InstructionGeneratorImpl ig = new InstructionGeneratorImpl(tp1, POStagger, transformation.getDictionaryPath(), transformation.getModelsPath());
        ig.generateGeneralTransformationInstructions();
        for (String pi : selectedPattern) {
            ig.generateInstantiatedInstructions(ig.parseXMLpatternInstanceBinding(OntologyPatternDetectionImpl.outputOnePairXML(ontologyURI, namingPattern, pi)), true);
        }
        String instructionXML = ig.exportTransformationInstructions(false);
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(new ByteArrayInputStream(instructionXML.getBytes()));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "/instructions/entities/rename";
            NodeList nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodesOP.getLength()) {
                String new_name;
                Node currentNode = nodesOP.item(i);
                String original_name = ((Element)currentNode).getAttribute("original_name");
                if (!original_name.equals(new_name = ((Element)nodesOP.item(i)).getTextContent())) {
                    instructions.add(new RenamingInstruction("Rename " + original_name + " to " + new_name, currentNode));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<RenamingInstruction> selectedInstructions = new ArrayList<RenamingInstruction>();
        selectedInstructions.add((RenamingInstruction)instructions.get(0));
        String expression = "/instructions/entities";
        Node parent = null;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodesOP = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            parent = nodesOP.item(0);
        }
        catch (XPathExpressionException e1) {
            e1.printStackTrace();
        }
        for (RenamingInstruction i : selectedInstructions) {
            if (i.isSelected()) continue;
            parent.removeChild(i.getNode());
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            String instructionsString = result.getWriter().toString();
            transformation.setInstructions(instructionsString);
            OWLOntology transformedOntology = (OWLOntology)transformation.transformOntology(OntologyTransformation.TransformationStrategy.Progressive, true);
            transformation.saveOntology("patomat_test.owl");
            transformedOntology = (OWLOntology)transformation.getOntology();
            System.out.println(transformedOntology.getLogicalAxiomCount());
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

