package cz.vse.keg.patomat.usecase.naming;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

import org.semanticweb.owlapi.model.OWLOntology;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.string.Words;
import cz.vse.keg.patomat.meronym.MyWordNet2;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation.TransformationStrategy;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;
import cz.vse.keg.patomat.usecase.logicalreasoning.OWL2ELProfileTransformation;

public class ChildParentNP {
	
	boolean serverVersion=true;
	TransformationPattern tp;
	String tpIRI;
	OntologyTransformation<OWLOntology> transformation;
	Words words;
	MyWordNet2 myMeronymy;
	PrintWriter summary;
	
	ChildParentNP() {
		if (serverVersion)
			tpIRI="http://nb.vse.cz/~svabo/patomat/tp/np/tp_np1c.xml";
		else
			tpIRI="file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1-2b.xml";
		tp = new TransformationPatternImpl(tpIRI);
		words = new Words(true, "/usr/share/WordNet-3.0", "/usr/share/models");
		myMeronymy = new MyWordNet2("/usr/share/WordNet-3.0");
		try {
			//summary = new PrintWriter(new FileWriter("/home/ondrej/conferences.papers/RR2012/experiment/transformationSummary09-05-12.dat", true));
			if (serverVersion)
				summary = new PrintWriter(new FileWriter("/home/svabo/codes/NamingPatternExperiment/summary23-05-12.dat", true));
			else
				summary = new PrintWriter(new FileWriter("/home/ondrej/projects/LOD2/WP3/summary23-05-12.dat", true));
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void detectNP(String ontology) throws Exception {		
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1-2.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1-2a.xml";
		//String tp1IRI="file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1-2b.xml";
				
		//eg.
		//System.out.println(new OntologyPatternImpl());
		//System.out.println(tp1.getOP1());
		//System.out.println(tp1.getOP2());
		
		//System.out.println(this.tp);
		
		//pattern detection
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");		
		//String ontology="file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf.owl";
		
		this.transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0", "/usr/share/models");
		
		//System.exit(1);
		boolean POStagger=true;
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		InstructionGenerator ig = new InstructionGeneratorImpl(this.tp,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());				
		//System.out.println(detection.queryPatternNamingAspect(tp1, ontology, false, false));
		//19-09-11,DONE: this must be applied on all pattern instances
		try {
			for(String s : detection.queryPattern(this.tp, ontology, false, true)) {
			//for(String s : detection.queryPatternNamingAspect(tp1, ontology, false, false)) {
				//System.out.println(s);
				String n1 = s.substring(s.indexOf("=")+1,s.indexOf(";"));
				String n2 = s.substring(s.lastIndexOf("=")+1);
				this.checkMeronymy(n1, n2);
				//currently just detection so generation of instructions can be switched off: 
				//TODO: then do the following to have transformation instructions:
				//ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(ontology, tp1IRI, s));
			}	
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		//currently just detection: 														
	}
	
	public void transform(OntologyTransformation transformation, InstructionGenerator ig) {
		System.out.println(ig.exportInstructions());
		transformation.setInstructions(ig.exportInstructions());		
		//3. step
		transformation.transformOntology(TransformationStrategy.Progressive, true);
		transformation.saveOntology("");
		System.out.println(transformation.printOntology());		
	}
	
	public void checkMeronymy(String name1, String name2) {
		System.out.println(name1 + " " + name2);
		boolean meronymy;
		try {
		
			String conceptNames1=words.secondSplit((words.splitName(" "+name1).toString()));
			String hn1=words.getMT(conceptNames1);
			
			String conceptNames2=words.secondSplit((words.splitName(" "+name2).toString()));
			String hn2=words.getMT(conceptNames2);
			
			System.out.println(hn1 + " " + hn2);
			
			meronymy = 	myMeronymy.isMeronym2(15, true, hn1, hn2);
			if (meronymy) {
				this.summary.println(name1+" "+hn1+","+name2+" "+hn2);
			}
			System.out.println(meronymy);
			
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	public static void main(String[] args) {
		//ChildParentNP cpNP = new ChildParentNP("file:///home/ondrej/prace/PatOMat/namingPattern/tp_namingPattern1-2b.xml");
		ChildParentNP cpNP = new ChildParentNP();
		try {
			cpNP.detectNP("file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf.owl");
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		/*
		String path;
		
		if (cpNP.serverVersion)			
			path="file:////home/svabo/codes/NamingPatternExperiment/ontologies/";
		else
			path="file:///home/ondrej/projects/LOD2/WP3/ontologies/";
		
		//for(int i=39;i<671;i++) {			
		for(int i=43;i<151;i++) {
			System.out.println("ontology:"+i);
			
			File soubor;
			if (cpNP.serverVersion)
				soubor = new File("/home/svabo/codes/NamingPatternExperiment/ontologies/"+i+".owl");
			else
				soubor = new File("/home/ondrej/projects/LOD2/WP3/ontologies/"+i+".owl");
						
			if (!soubor.canRead()) continue;
			
			try {
				cpNP.summary.println("==="+i+".owl===");
				cpNP.detectNP(path+i+".owl");
			}
			catch (Exception e) {
				e.printStackTrace();
				continue;				
			}
			//elProfileTr.transformation.preprocessOntology();
			//elProfileTr.transformation.saveOntology("");			
			
			
			//elProfileTr.detectForbiddenAxioms(false);			
			///home/ondrej/codes/eclipse-codes
		}
		cpNP.summary.close();
		*/
	}
	
}
