package cz.vse.keg.patomat.usecase.logicalreasoning;

import java.util.ArrayList;
import java.util.List;

import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.profiles.OWL2QLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation.TransformationStrategy;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;

public class OWL2QLProfileTransformation {

	/**
	 * @param args
	 */
	
	OntologyTransformation<OWLOntology> transformation;
	String ontologyIRI;
	private boolean debuggingOutput=true;
	
	public OWL2QLProfileTransformation(String ontology) {
		this.ontologyIRI = ontology;
		this.transformation = new OntologyTransformationImpl(ontology);		
	}
	
	//this method can be used just for information or as a post-processing step to remove everything which is forbidden
	public String detectForbiddenAxioms(boolean remove) {
		String result="";
		List<RemoveAxiom> removeAxioms = new ArrayList<RemoveAxiom>();
		OWL2QLProfile profile = new OWL2QLProfile();
		OWLProfileReport report = profile.checkOntology(transformation.getOntology());
		if (this.debuggingOutput) System.out.println("The following axioms are more expressive than OWL2 RL:");
		result="The following axioms are more expressive than OWL2 RL:";
		int i=0;
		for (OWLProfileViolation v :report.getViolations()) {
			i++;
			if (this.debuggingOutput) System.out.println(i+".:"+v+"\n");
			result+=i+".:"+v+"\n";
			//if (this.debuggingOutput) System.out.println(i+".:"+v.getAxiom()+"\n");
			if(v.getAxiom()!=null) {
				removeAxioms.add(new RemoveAxiom(transformation.getOntology(), v.getAxiom()));				
			}	
		}
		if (remove) transformation.getManager().applyChanges(removeAxioms);
		return result;
	}
	
	//this method combines specific detection for transforming to OWL2EL profile and applying transformation patterns as such based on detection
	private void applySuitableTransformationPatterns() {
		org.semanticweb.owlapi.profiles.OWL2RLProfile profile = new org.semanticweb.owlapi.profiles.OWL2RLProfile();
		OWLProfileReport report = profile.checkOntology(transformation.getOntology());
		OWLAxiom axiom;
		
		TransformationPattern tp1;
		String tp1IRI="";
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		InstructionGenerator ig;
		boolean POStagger=false;
		
		boolean apply_tp_complementEL=false;
		boolean apply_tp_cardinalityEL=false;
		boolean apply_tp_decomposedNominalsELeq=false;
		boolean apply_tp_decomposedNominalsELsub=false;
		
		/*now still for OWL2EL:
		for (OWLProfileViolation v :report.getViolations()) {		
			if (v.toString().matches(".*ObjectComplementOf\\(ObjectAllValuesFrom.*")) {
				//apply tp_complementEL.xml TP
				apply_tp_complementEL=true;
				if (this.debuggingOutput) System.out.println("to apply complement TP on "+v.getAxiom());
			}
			else if (v.toString().matches(".*ObjectMinCardinality.*")) {
			//else if (v.getAxiom instanceof OWLObjectMinCardinality) {
				//apply tp_cardinalityEL.xml
				apply_tp_cardinalityEL=true;
				if (this.debuggingOutput) System.out.println("to apply cardinality TP on "+v.getAxiom());
			}
			else if (v.toString().matches(".*EquivalentClasses\\(.*ObjectOneOf.*")) {
			//else if (v.getAxiom instanceof OWLObjectOneOf) {
				//TODO: apply tp_decomposedEL.xml
				apply_tp_decomposedNominalsELeq=true;
				if (this.debuggingOutput) System.out.println("to apply decomposed nominals eq TP on "+v.getAxiom());
			}
			else if (v.toString().matches(".*SubClassOf\\(.*ObjectOneOf.*")) {
				//else if (v.getAxiom instanceof OWLObjectOneOf) {
					//TODO: apply tp_decomposedEL.xml
					apply_tp_decomposedNominalsELsub=true;
					if (this.debuggingOutput) System.out.println("to apply decomposed nominals sub TP on "+v.getAxiom());
			}
		}
		
		//apply suitable transformation patterns:
		if (apply_tp_complementEL) {
			//reload first:			
			this.transformation.finish();
			this.transformation = new OntologyTransformationImpl(this.ontologyIRI, "/usr/share/WordNet-3.0/", "/usr/share/models/");
			tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_complementEL.xml";
			tp1 = new TransformationPatternImpl(tp1IRI);
			ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
			
			for(String s : detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false)) {
				if (this.debuggingOutput) System.out.println(s);
				ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
			}
			
			transformation.setInstructions(ig.exportInstructions());				
			transformation.transformOntology(TransformationStrategy.Progressive, false);
			transformation.saveOntology("");
		}
		
		if (apply_tp_cardinalityEL) {
			//reload first:			
			this.transformation.finish();
			this.transformation = new OntologyTransformationImpl(this.ontologyIRI);			
			tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_cardinalityEL.xml";
			tp1 = new TransformationPatternImpl(tp1IRI);
			ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
			
			for(String s : detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false)) {
				if (this.debuggingOutput) System.out.println(s);
				ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
			}
			
			transformation.setInstructions(ig.exportInstructions());				
			transformation.transformOntology(TransformationStrategy.Progressive, true);
			transformation.saveOntology("");
		}
		
		if (apply_tp_decomposedNominalsELeq) {					
			tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_nominalsDecomposedELa.xml";
			tp1 = new TransformationPatternImpl(tp1IRI);
			
			ArrayList<String> queryResults;		
			queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
			//loop for replaccing all nominals in an ontology
			while (queryResults.size()>0) {			
				//reload:			
				this.transformation.finish();
				transformation = new OntologyTransformationImpl(this.ontologyIRI);
				ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
				
				for(String s : queryResults) {
					if (this.debuggingOutput) System.out.println(s);
					ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
				}		
				if (this.debuggingOutput) System.out.println(ig.exportInstructions());
				transformation.setInstructions(ig.exportInstructions());
				//System.exit(1);
				//3. step
				transformation.transformOntology(TransformationStrategy.Progressive, true);
				transformation.saveOntology("");
				
				tp1 = new TransformationPatternImpl(tp1IRI);
				detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
				queryResults.clear();			
				queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
			}						
		}
		
		if (apply_tp_decomposedNominalsELsub) {					
			tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_nominalsDecomposedELb.xml";
			tp1 = new TransformationPatternImpl(tp1IRI);
			
			ArrayList<String> queryResults;		
			queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
			//loop for replaccing all nominals in an ontology
			while (queryResults.size()>0) {			
				//reload:			
				this.transformation.finish();
				transformation = new OntologyTransformationImpl(this.ontologyIRI);
				ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
				
				for(String s : queryResults) {
					if (this.debuggingOutput) System.out.println(s);
					ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
				}		
				if (this.debuggingOutput) System.out.println(ig.exportInstructions());
				transformation.setInstructions(ig.exportInstructions());
				//System.exit(1);
				//3. step
				transformation.transformOntology(TransformationStrategy.Progressive, true);
				transformation.saveOntology("");
				
				tp1 = new TransformationPatternImpl(tp1IRI);
				detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
				queryResults.clear();			
				queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
			}						
		}*/
	}		
	
	public void runTransformationToOWL2QLProfile() {
		//1. pre-processing will be applied:
		this.transformation.preprocessOntology();
		transformation.saveOntology("");
		this.ontologyIRI="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+this.ontologyIRI.substring(this.ontologyIRI.lastIndexOf("/")+1,this.ontologyIRI.lastIndexOf("."))+".owl";
		//just for my information:
		//this.detectForbiddenAxioms(false);
		//2. apply suitable transformation patterns, i.e. using specific detection method using OWLAPI:
		//this.applySuitableTransformationPatterns();
		//this.transformation.preprocessOntology();
		//this.transformation.finish();
		//this.transformation = new OntologyTransformationImpl(this.ontologyIRI);
		//3. post-processing will be applied:
		//this.detectForbiddenAxioms(true);
		//just for my information:
		this.detectForbiddenAxioms(false);
		//finally save ontology into the user home directory:
		this.transformation.saveOntology("");
		this.transformation.finish();
	}
	
	public static void main(String[] args) {		
		OWL2QLProfileTransformation qlProfileTr = new OWL2QLProfileTransformation("file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl");				
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:///home/ondrej/OWL2-EL.owl");
		qlProfileTr.runTransformationToOWL2QLProfile();
	}

}
