package cz.vse.keg.patomat.usecase.logicalreasoning;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;

import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation.TransformationStrategy;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;

public class OWL2ELProfileTransformation {

	/**
	 * @param args
	 */
	
	OntologyTransformation<OWLOntology> transformation;
	String ontologyIRI;
	private boolean debuggingOutput=true;
	PrintWriter summary;
	
	public OWL2ELProfileTransformation(String ontology) {			
		this.ontologyIRI = ontology;
		this.transformation = new OntologyTransformationImpl(ontology);
		try {
			summary = new PrintWriter(new FileWriter("/home/ondrej/conferences.papers/RR2012/experiment/transformationSummary-25-05-12.dat", true));
			//summary.println("ontology,complement,cardinalityA,time,cardinalityB,time,enumerationEq,time,enumarationSub,time,remainingConstructs");
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}	
	
	//this method can be used just for information or as a post-processing step to remove everything which is forbidden
	public String detectForbiddenAxioms(boolean remove) {
		String result="";
		List<RemoveAxiom> removeAxioms = new ArrayList<RemoveAxiom>();
		OWL2ELProfile profile = new OWL2ELProfile();
		OWLProfileReport report = profile.checkOntology(transformation.getOntology());
		if (this.debuggingOutput) System.out.println("The following axioms are more expressive than OWL2 EL:");
		result="The following axioms are more expressive than OWL2 EL:";
		int i=0;
		for (OWLProfileViolation v :report.getViolations()) {
			i++;
			if (this.debuggingOutput) System.out.println(i+".:"+v+"\n");
			result+=i+".:"+v+"\n";
			//if (this.debuggingOutput) System.out.println(i+".:"+v.getAxiom()+"\n");
			if(v.getAxiom()!=null) {
				removeAxioms.add(new RemoveAxiom(transformation.getOntology(), v.getAxiom()));				
			}	
		}
		if (remove) {
			transformation.getManager().applyChanges(removeAxioms);
			transformation.saveOntology("");
		}
		//return result;
		return ","+i;
	}
	
	//this method combines specific detection for transforming to OWL2EL profile and applying transformation patterns as such based on detection
	private void applySuitableTransformationPatterns() {
		org.semanticweb.owlapi.profiles.OWL2ELProfile profile = new org.semanticweb.owlapi.profiles.OWL2ELProfile();
		OWLProfileReport report = profile.checkOntology(transformation.getOntology());
		OWLAxiom axiom;
		
		TransformationPattern tp1;
		String tp1IRI="";
		OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
		InstructionGenerator ig;
		boolean POStagger=false;
		
		boolean apply_tp_complementEL=false;
		boolean apply_tp_cardinalityEL=false;
		boolean apply_tp_decomposedNominalsELeq=false;
		boolean apply_tp_decomposedNominalsELsub=false;
		
		for (OWLProfileViolation v :report.getViolations()) {		
			if (v.toString().matches(".*ObjectComplementOf\\(ObjectAllValuesFrom.*")) {
				//apply tp_complementEL.xml TP
				apply_tp_complementEL=true;
				if (this.debuggingOutput) System.out.println("to apply complement TP on "+v.getAxiom());
			}
			else if (v.toString().matches(".*ObjectMinCardinality.*")) {
			//else if (v.getAxiom instanceof OWLObjectMinCardinality) {
				//apply tp_cardinalityEL.xml
				apply_tp_cardinalityEL=true;
				if (this.debuggingOutput) System.out.println("to apply cardinality TP on "+v.getAxiom());
			}
			else if (v.toString().matches(".*EquivalentClasses\\(.*ObjectOneOf.*")) {
			//else if (v.getAxiom instanceof OWLObjectOneOf) {
				//TODO: apply tp_decomposedEL.xml
				apply_tp_decomposedNominalsELeq=true;
				if (this.debuggingOutput) System.out.println("to apply decomposed nominals eq TP on "+v.getAxiom());
			}
			else if (v.toString().matches(".*SubClassOf\\(.*ObjectOneOf.*")) {
				//09-05-12,for avoiding trying to apply transformaci v pripade, kdy je enumeration schovana v allValuesFrom tp_nominalsDecomposedELb.xml
				if (!v.toString().matches(".*SubClassOf\\(.*AllValuesFrom.*")) {
				//else if (v.getAxiom instanceof OWLObjectOneOf) {
					//TODO: apply tp_decomposedEL.xml
					apply_tp_decomposedNominalsELsub=true;
					if (this.debuggingOutput) System.out.println("to apply decomposed nominals sub TP on "+v.getAxiom());
				}
			}
		}
		
		//25-05-12
		//testovani vlivu jen transformace enumeraci:
		/*
		apply_tp_complementEL=false;
		apply_tp_cardinalityEL=false;
		apply_tp_decomposedNominalsELeq=false;
		apply_tp_decomposedNominalsELsub=false;
		*/
		//apply suitable transformation patterns:
		if (apply_tp_complementEL) {
			long currentTime=0;
			currentTime=System.currentTimeMillis();
			long time=0;
			time=currentTime;
			
			int nr_applications=0;
			//reload first:			
			this.transformation.finish();
			this.transformation = new OntologyTransformationImpl(this.ontologyIRI, "/usr/share/WordNet-3.0/", "/usr/share/models/");
			tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_complementEL.xml";
			tp1 = new TransformationPatternImpl(tp1IRI);
			ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
			
			for(String s : detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false)) {
				nr_applications++;
				if (this.debuggingOutput) System.out.println(s);
				ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
			}
			
			transformation.setInstructions(ig.exportInstructions());				
			transformation.transformOntology(TransformationStrategy.Progressive, false);
			transformation.saveOntology("");
			
			currentTime=System.currentTimeMillis();			
			summary.print(","+nr_applications+","+(currentTime-time));
		}
		else {
			summary.print(",0,0.0");
		}
		
		if (apply_tp_cardinalityEL) {
			long currentTime=0;
			currentTime=System.currentTimeMillis();
			long time=0;
			time=currentTime;
			
			int nr_applications=0;
			//reload first:			
			this.transformation.finish();
			this.transformation = new OntologyTransformationImpl(this.ontologyIRI);			
			tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_cardinalityEL.xml";
			tp1 = new TransformationPatternImpl(tp1IRI);
			ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
			
			for(String s : detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false)) {
				nr_applications++;
				if (this.debuggingOutput) System.out.println(s);
				ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
			}
			
			transformation.setInstructions(ig.exportInstructions());
			System.out.println(ig.exportInstructions());			
			//run transform?
			//if (!transformation.willTransformOntology()) System.out.println("empty");
			//summary.print(","+nr_applications+",cardA,0.0");
			//if (nr_applications==0) summary.print(",0,0.0");
			if (transformation.willTransformOntology()) {
				transformation.transformOntology(TransformationStrategy.Progressive, true);
				transformation.saveOntology("");
				
				currentTime=System.currentTimeMillis();			
				summary.print(","+nr_applications+","+(currentTime-time));
			}			
			else summary.print(",0,0.0");
			//System.exit(1);
		}
		else {
			summary.print(",0,0.0");
		}
		
		if (apply_tp_cardinalityEL) {
			long currentTime=0;
			currentTime=System.currentTimeMillis();
			long time=0;
			time=currentTime;
			
			int nr_applications=0;
			//reload first:			
			this.transformation.finish();
			this.transformation = new OntologyTransformationImpl(this.ontologyIRI);			
			tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_cardinalityEL1.xml";
			tp1 = new TransformationPatternImpl(tp1IRI);
			ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
			
			for(String s : detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false)) {
				nr_applications++;
				if (this.debuggingOutput) System.out.println(s);
				ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
			}
			
			transformation.setInstructions(ig.exportInstructions());							
			//run transform?
			//if (!transformation.willTransformOntology()) System.out.println("empty");			
			//if (nr_applications==0) summary.print(",0,0.0");
			if (transformation.willTransformOntology()) {
				transformation.transformOntology(TransformationStrategy.Progressive, true);
				transformation.saveOntology("");
				
				currentTime=System.currentTimeMillis();			
				summary.print(","+nr_applications+","+(currentTime-time));
			}
			else summary.print(",0,0.0");
		}
		else {
			summary.print(",0,0.0");
		}
		
		if (apply_tp_decomposedNominalsELeq) {					
			long currentTime=0;
			currentTime=System.currentTimeMillis();
			long time=0;
			time=currentTime;
			
			int nr_applications=0;
			tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_nominalsDecomposedELa.xml";
			tp1 = new TransformationPatternImpl(tp1IRI);
			
			ArrayList<String> queryResults;		
			queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
			//loop for replaccing all nominals in an ontology
			while (queryResults.size()>0) {			
				//reload:			
				this.transformation.finish();
				transformation = new OntologyTransformationImpl(this.ontologyIRI);
				ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
				
				for(String s : queryResults) {
					nr_applications++;
					if (this.debuggingOutput) System.out.println(s);
					ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
				}		
				if (this.debuggingOutput) System.out.println(ig.exportInstructions());
				transformation.setInstructions(ig.exportInstructions());
				//System.exit(1);
				//3. step
				//run transform?
				//if (!transformation.willTransformOntology()) System.out.println("empty");
				if (transformation.willTransformOntology()) {
					transformation.transformOntology(TransformationStrategy.Progressive, true);
					transformation.saveOntology("");					
				}
				//transformation.transformOntology(TransformationStrategy.Progressive, true);
				//transformation.saveOntology("");
				
				tp1 = new TransformationPatternImpl(tp1IRI);
				detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
				queryResults.clear();			
				queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
			}
			currentTime=System.currentTimeMillis();			
			summary.print(","+nr_applications+","+(currentTime-time));
		}
		else {
			summary.print(",0,0.0");
		}
		
		if (apply_tp_decomposedNominalsELsub) {	
			long currentTime=0;
			currentTime=System.currentTimeMillis();
			long time=0;
			time=currentTime;
			
			int nr_applications=0;
			tp1IRI="file:///home/ondrej/prace/PatOMat/reasoning/toOWLEL/selection/tp_nominalsDecomposedELb.xml";
			tp1 = new TransformationPatternImpl(tp1IRI);
			
			ArrayList<String> queryResults;		
			queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
			//loop for replaccing all nominals in an ontology
			while (queryResults.size()>0) {			
				//reload:			
				this.transformation.finish();
				transformation = new OntologyTransformationImpl(this.ontologyIRI);
				ig = new InstructionGeneratorImpl(tp1,POStagger,transformation.getDictionaryPath(),transformation.getModelsPath());
				
				for(String s : queryResults) {
					nr_applications++;
					if (this.debuggingOutput) System.out.println(s);
					ig.generateInstructions(OntologyPatternDetectionImpl.outputOnePairXML(this.ontologyIRI, tp1IRI, s));
				}		
				if (this.debuggingOutput) System.out.println(ig.exportInstructions());
				transformation.setInstructions(ig.exportInstructions());
				//System.exit(1);
				//3. step				
				//transformation.transformOntology(TransformationStrategy.Progressive, true);
				//transformation.saveOntology("");
				//run transform?
				//if (!transformation.willTransformOntology()) System.out.println("empty");
				if (transformation.willTransformOntology()) {
					transformation.transformOntology(TransformationStrategy.Progressive, true);
					transformation.saveOntology("");					
				}
				
				tp1 = new TransformationPatternImpl(tp1IRI);
				detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");
				queryResults.clear();			
				queryResults = detection.queryPatternNamingAspect(tp1, this.ontologyIRI, false, false);
			}
			currentTime=System.currentTimeMillis();			
			summary.print(","+nr_applications+","+(currentTime-time));
		}
		else {
			summary.print(",0,0.0");
		}
	}		
	
	public void runTransformationToOWL2ELProfile() {
		//1. pre-processing will be applied:
		this.transformation.preprocessOntology();
		transformation.saveOntology("");
		this.ontologyIRI="file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+this.ontologyIRI.substring(this.ontologyIRI.lastIndexOf("/")+1,this.ontologyIRI.lastIndexOf("."))+".owl";
		//just for my information:
		//this.detectForbiddenAxioms(false);
		summary.print(this.detectForbiddenAxioms(false));
		//2. apply suitable transformation patterns, i.e. using specific detection method using OWLAPI:		
		//25-05-12, this should be applied
		this.applySuitableTransformationPatterns();
		//25-05-12, this should be applied
		this.transformation.preprocessOntology();
		//25-05-12, this should be applied
		this.transformation.finish();
		this.transformation = new OntologyTransformationImpl(this.ontologyIRI);
		//3. post-processing will be applied:
		summary.print(this.detectForbiddenAxioms(true));
		//just for my information:
		summary.println(this.detectForbiddenAxioms(false));		
		//finally save ontology into the user home directory:
		this.transformation.saveOntology("");
		this.transformation.finish();
		summary.close();
	}
	
	public static void main(String[] args) {		
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl");				
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:///home/ondrej/OWL2-EL.owl");
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/ECAI.owl");
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/camera.owl");
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/wine.owl");
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/MICRO.owl");
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/linklings.owl");
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/ekaw.owl");
		
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:///media/CORSAIR/conferences.papers/ECAI2012/experiments/ontologies/pizza.owl", false);
		//extended experiment
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:////home/ondrej/codes/eclipse-codes/PatOMatService/4.owl");
		//elProfileTr.detectForbiddenAxioms(true);
		//elProfileTr.detectForbiddenAxioms(false);
		//elProfileTr.transformation.saveOntology("");
		//elProfileTr.transformation.printOntology();
		//elProfileTr.detectForbiddenAxioms(true);
		//elProfileTr.runTransformationToOWL2ELProfile();
		//OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation("file:///home/ondrej/conferences.papers/ECAI2012/experiments/larger/ontologies/1.owl");
		
		//20-04-12
		//String path="file:///home/ondrej/conferences.papers/ECAI2012/experiments/larger/ontologies/";
		
		String path="file:///home/ondrej/conferences.papers/RR2012/experiment/ontologies/";		
		
		for(int i=1;i<64;i++) {			
			System.out.println("ontology:"+i);
			
			File soubor = new File("/home/ondrej/conferences.papers/RR2012/experiment/ontologies/"+i+".owl");
			//if (!soubor.canRead()) System.out.println("no");
			if (!soubor.canRead()) continue;
			
			OWL2ELProfileTransformation elProfileTr = new OWL2ELProfileTransformation(path+i+".owl");
			elProfileTr.summary.print(i+".owl");
			//elProfileTr.transformation.preprocessOntology();
			//elProfileTr.transformation.saveOntology("");			
			elProfileTr.runTransformationToOWL2ELProfile();
			
			//elProfileTr.detectForbiddenAxioms(false);			
			///home/ondrej/codes/eclipse-codes
		}
		
		
	}

}
