package cz.vse.keg.patomat.transformation.util;

import java.net.URI;
import java.util.List;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

//import org.coode.patterns.PatternOPPLScript;
//import org.coode.patterns.syntax.PatternParser;
import org.coode.oppl.ChangeExtractor;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.ParserFactory;
import org.coode.oppl.OPPLParser;
import org.coode.oppl.exceptions.QuickFailRuntimeExceptionHandler;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.common.SystemErrorEcho;

import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.io.SystemOutDocumentTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

import cz.vse.keg.patomat.util.URLGrabber;

/**
 * @author Ondrej Zamazal
 * 
 */

public class RunOPPLscript {	
	
	public static void main(String[] args) {
		ErrorListener errorListener = new SystemErrorEcho();
		OWLOntologyManager manager;
		OWLOntology ontology = null;
		manager = OWLManager.createOWLOntologyManager();
		try {
		//ontology = manager.loadOntologyFromPhysicalURI(URI.create(""));
			//ontology = manager.loadOntologyFromPhysicalURI(URI.create("file:///home/ondrej/conferences.papers/beutifulOntologies/ontologies/eswc09book2.owl"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("file:///tmp/confOf.owl"));			
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("file:///home/ondrej/prace/PatOMat/TPs/ontology/confOf2.owl"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWLOneOf1.owl"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/small_pizza_with_nominals.owl"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/small_pizza.owl"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/OWL2-EL.owl"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("file:///home/ondrej/prace/PatOMat/reasoning/testingOntoSet/Complement1.owl"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("file:///home/ondrej/wine-copy.owl"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("http://www.w3.org/2002/03owlt/description-logic/inconsistent601"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("http://lists.w3.org/Archives/Public/public-webont-comments/2003Oct/att-0026/iso-metadata.owl"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("http://loki.cae.drexel.edu/~wbs/ontology/2004/02/iso-metadata"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("http://kmi-web05.open.ac.uk:81/cache/b/e12/1825/197df/8d37d83655/cc3673fc7d475788c"));
			//ontology = manager.loadOntologyFromOntologyDocument(IRI.create("file:///home/ondrej/conferences.papers/ECAI2012/experiments/larger/ontologies/44.owl"));			
			//file:///home/ondrej/conferences.papers/ECAI2012/experiments/larger/ontologies/
			ontology = manager.loadOntologyFromOntologyDocument(IRI.create("file:///home/ondrej/conferences.papers/ECAI2012/experiments/larger/ontologies/59.owl"));
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		OWLReasonerFactory reasonerFactory = new PelletReasonerFactory();
		//OWLReasoner reasoner = reasonerFactory.createReasoner(manager);
		OWLReasoner reasoner = null;
		HashSet<OWLOntology> ontos = new HashSet<OWLOntology>();
		ontos.add(ontology);		
		// Assume o is an instance of OWLOntology and ontologyManager an instance of OWLOntologyManager to which you have previously loaded/added o
		//String formula = "BEGIN ADD !PositionPaper subClassOf Thing, ADD !PositionPaper subClassOf Paper, REMOVE DemoPaper subClassOf Paper END;";
		//String formula = "BEGIN ADD !RejectedPaper subClassOf Paper END;";
		//String formula = "BEGIN ADD !A equivalentTo (!q some !F) END;";
		/*
		Pattern pat = Pattern.compile("\\?.");
		Matcher m = pat.matcher("?p domain ?A");		
		while(m.find()) {
			System.out.println(m.group());
		}
		*/
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN ADD !p domain (!q some !F) END;";		
		//String formula = "BEGIN ADD !MultimediaTopicValue types AcceptedPaper, ADD !ComputerNetworkTopicValue types AcceptedPaper, ADD !MultimediaTopicValue DifferentFrom !ComputerNetworkTopicValue END;";
		//String formula = "BEGIN ADD Person subClassOf http://www.ontologydesignpatterns.org/cp/owl/objectrole.owl#Agent END;";
		//String formula = "BEGIN ADD Person subClassOf Agent, ADD !Author subClassOf Role, ADD !authorRole a !Author END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN ADD !Woman subClassOf Agent END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE Person subClassOf (hasCountry min 1 Country) END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE Author subClassOf Person END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN ADD Person subClassOf (hasCountry min 1 owl:Thing) END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE C3 subClassOf (p1 exactly 2 owl:Thing) END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE (not Concept1) END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE C1 equivalentTo {a} END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE Concept3 equivalentTo (not (p1 min 2 Thing))  END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN ADD !OneOfC1 equivalentTo (!a_nc or !b_nc or !c_nc)  END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN ADD C1 equivalentTo (C2 or C3)  END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN ADD MozzarellaTopping subclassOf (hasCountryOfOrigin some Country )  END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN ADD DisjointClasses: SET (MozzarellaTopping, CheeseTopping) END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE p1 propertyDisjointWith p3 END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE p3 types http://www.w3.org/2002/07/owl#IrreflexiveProperty END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN ADD !C5 types Thing END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE C1 disjointWith C2 END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE C2 equivalentTo (p1 some C1) END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE Symmetric p3 END;"; OK
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN ADD Asymmetric p3 END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN ADD a p3 b END;"; //objectPropertyAssertion
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN ADD ObjectPropertyAssertion(a p3 b) END;"; //objectPropertyAssertion
		/*
		String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN "+
						 "REMOVE WineFlavor equivalentTo {Delicate , Moderate , Strong } ,"+
						 "REMOVE WineColor equivalentTo {Rose , White , Red } ,"+
						 "REMOVE WineBody equivalentTo {Medium , Full , Light } ,"+
						 "REMOVE WineSugar equivalentTo {Dry , OffDry , Sweet } END;";*/
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN "+
		 //"REMOVE WineFlavor equivalentTo {Delicate , Moderate , Strong } END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN "+
		//"ADD b equivalentTo (!p_19 min 1 Thing ) END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN "+
		//"REMOVE MD_StandardOrderProcess subClassOf (plannedAvailableDateTime min 0 Thing ) END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN "+
		//"REMOVE MD_Keywords subClassOf (type min 0 Thing ) END;";
		//"ADD MD_StandardOrderProcess subClassOf (type min 0 Thing ) END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGINREMOVE MD_StandardOrderProcess subClassOf (plannedAvailableDateTime min 0 Thing ) ,REMOVE MD_VectorSpatialRepresentation subClassOf (topologyLevel min 0 Thing ) ,REMOVE DQ_Element subClassOf (evaluationMethodType min 0 Thing ) ,REMOVE MD_Identification subClassOf (descriptiveKeywords min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (spatialRepresentationType min 0 Thing ) ,REMOVE MD_Metadata subClassOf (hierarchyLevel min 0 Thing ) ,REMOVE LI_Source subClassOf (sourceReferenceSystem min 0 Thing ) ,REMOVE MD_Dimension subClassOf (resolution min 1 Thing ) ,REMOVE MD_Identification subClassOf (graphicOverview min 0 Thing ) ,REMOVE CI_Citation subClassOf (editionDate min 0 Thing ) ,REMOVE EX_SpatialTemporalExtent subClassOf (spatialExtent min 1 Thing ) ,REMOVE LI_Lineage subClassOf (processStep min 0 Thing ) ,REMOVE MD_CoverageDescription subClassOf (dimension min 0 Thing ) ,REMOVE MD_CRS subClassOf (ellipsoid min 0 Thing ) ,REMOVE EX_Extent subClassOf (verticalElement min 0 Thing ) ,REMOVE CI_OnlineResource subClassOf (function min 0 Thing ) ,REMOVE MD_Identification subClassOf (resourceFormat min 0 Thing ) ,REMOVE MD_Metadata subClassOf (contentInfo min 0 Thing ) ,REMOVE DQ_DataQuality subClassOf (report min 0 Thing ) ,REMOVE EX_Extent subClassOf (temporalElement min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (topicCategory min 1 Thing ) ,REMOVE DQ_QuantitativeResult subClassOf (valueUnit min 0 Thing ) ,REMOVE MD_Format subClassOf (formatDistributor min 0 Thing ) ,REMOVE RS_ReferenceSystem subClassOf (domainOfValidity min 0 Thing ) ,REMOVE DQ_Element subClassOf (evaluationProcedure min 0 Thing ) ,REMOVE MD_Metadata subClassOf (characterSet min 0 Thing ) ,REMOVE CI_Citation subClassOf (citedResponsibleParty min 0 Thing ) ,REMOVE MD_Identification subClassOf (pointOfConact min 0 Thing ) ,REMOVE DQ_Scope subClassOf (level min 1 Thing ) ,REMOVE MD_FeatureCatalogueDescription subClassOf (featureCatalogueCitation min 0 Thing ) ,REMOVE MD_Band subClassOf (units min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (geographicDescription min 0 Thing ) ,REMOVE MD_MaintenanceInformation subClassOf (dateOfNextUpdate min 0 Thing ) ,REMOVE MD_Metadata subClassOf (metadataExtensionInfo min 0 Thing ) ,REMOVE MD_Metadata subClassOf (referenceSystemInfo min 0 Thing ) ,REMOVE MD_RangeDimension subClassOf (sequenceIdentifier min 0 Thing ) ,REMOVE MD_Distributor subClassOf (distributorFormat min 0 Thing ) ,REMOVE MD_Identification subClassOf (resourceMaintenance min 0 Thing ) ,REMOVE MD_PortrayalCatalogueReference subClassOf (portrayalCatalogueCitation min 1 Thing ) ,REMOVE MD_SpatialAttributeSupplement subClassOf (theFeatureTypeList min 1 Thing ) ,REMOVE MD_ImageDescription subClassOf (imageQualityCode min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (characterSet min 0 Thing ) ,REMOVE MD_Identification subClassOf (resourceSpecificUsage min 0 Thing ) ,REMOVE LI_ProcessStep subClassOf (processor min 0 Thing ) ,REMOVE MD_Distribution subClassOf (transferOptions min 0 Thing ) ,REMOVE MD_MaintenanceInformation subClassOf (updateScope min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (imagingCondition min 0 Thing ) ,REMOVE MD_Usage subClassOf (usageDateTime min 0 Thing ) ,REMOVE MD_Medium subClassOf (mediumFormat min 0 Thing ) ,REMOVE MD_Metadata subClassOf (applicationSchemaInfo min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (extent min 0 Thing ) ,REMOVE MD_Resolution subClassOf (distance min 0 Thing ) ,REMOVE LI_Lineage subClassOf (source min 0 Thing ) ,REMOVE MD_Metadata subClassOf (distributionInfo min 0 Thing ) ,REMOVE MD_ApplicationSchemaInformation subClassOf (softwareDevelopmentFile min 0 Thing ) ,REMOVE MD_VectorSpatialRepresentation subClassOf (geometricObjects min 0 Thing ) ,REMOVE MD_Distributor subClassOf (distributionOrderProcess min 0 Thing ) ,REMOVE MD_Keywords subClassOf (type min 0 Thing ) ,REMOVE CI_Contact subClassOf (phone min 0 Thing ) ,REMOVE MD_CRS subClassOf (projection min 0 Thing ) ,REMOVE EX_BoundingPolygon subClassOf (polygon min 1 Thing ) ,REMOVE MD_CRS subClassOf (projectionParameter min 0 Thing ) ,REMOVE MD_Georectified subClassOf (centerPoint min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (obliqueLinePointParameter min 0 Thing ) ,REMOVE LI_ProcessStep subClassOf (source min 0 Thing ) ,REMOVE MD_ExtendedElementInformation subClassOf (extEleSrc min 1 Thing ) ,REMOVE DQ_DataQuality subClassOf (lineage min 0 Thing ) ,REMOVE CI_Contact subClassOf (onlineResource min 0 Thing ) ,REMOVE DQ_Scope subClassOf (levelDescription min 0 Thing ) ,REMOVE MD_FeatureCatalogueDescription subClassOf (featureTypes min 0 Thing ) ,REMOVE DQ_Element subClassOf (measureIdentification min 0 Thing ) ,REMOVE MD_Distributor subClassOf (distributionTransferOptions min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (processingLevelCode min 0 Thing ) ,REMOVE DQ_QuantitativeResult subClassOf (valueType min 0 Thing ) ,REMOVE MD_Medium subClassOf (medName min 0 Thing ) ,REMOVE MD_Keywords subClassOf (thesaurusName min 0 Thing ) ,REMOVE MD_MaintenanceInformation subClassOf (updateScopeDescription min 0 Thing ) ,REMOVE LI_Source subClassOf (sourceExtent min 0 Thing ) ,REMOVE MD_ExtendedElementInformation subClassOf (obligation min 0 Thing ) ,REMOVE MD_LegalConstraints subClassOf (useConstraints min 0 Thing ) ,REMOVE MD_ReferenceSystem subClassOf (referenceSystemIdentifier min 0 Thing ) ,REMOVE MD_CRS subClassOf (datum min 0 Thing ) ,REMOVE CI_Citation subClassOf (resRefDate min 1 Thing ) ,REMOVE MD_DataIdentification subClassOf (geographicBox min 0 Thing ) ,REMOVE MD_DigitalTransferOptions subClassOf (offLine min 0 Thing ) ,REMOVE MD_Identification subClassOf (status min 0 Thing ) ,REMOVE CI_Citation subClassOf (series min 0 Thing ) ,REMOVE MD_Identifier subClassOf (authority min 0 Thing ) ,REMOVE LI_Source subClassOf (scaleDenominator min 0 Thing ) ,REMOVE EX_Extent subClassOf (geographicElement min 0 Thing ) ,REMOVE DQ_Scope subClassOf (extent min 0 Thing ) ,REMOVE MD_LegalConstraints subClassOf (accessConstraints min 0 Thing ) ,REMOVE MD_Usage subClassOf (userContactInfo min 1 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (falseEastingNorthingUnits min 0 Thing ) ,REMOVE MD_MetadataExtensionInformation subClassOf (extendedElementInformation min 0 Thing ) ,REMOVE MD_Identification subClassOf (resourceConstraints min 0 Thing ) ,REMOVE MD_Distribution subClassOf (distributor min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (obliqueLineAzimuthParameter min 0 Thing ) ,REMOVE MD_CRS subClassOf (ellipsoidParameters min 0 Thing ) ,REMOVE MD_DigitalTransferOptions subClassOf (onLine min 0 Thing ) ,REMOVE MD_Georeferenceable subClassOf (parameterCitation min 0 Thing ) ,REMOVE MD_Resolution subClassOf (equivalentScale min 0 Thing ) ,REMOVE LI_Source subClassOf (sourceCitation min 0 Thing ) ,REMOVE DQ_QuantitativeResult subClassOf (value1 min 1 Thing ) ,REMOVE CI_ResponsibleParty subClassOf (contactInfo min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (spatialResolution min 0 Thing ) ,REMOVE CI_Citation subClassOf (presentationForm min 0 Thing ) ,REMOVE MD_Metadata subClassOf (metadataMaintenance min 0 Thing ) ,REMOVE MD_Metadata subClassOf (identificationInfo min 1 Thing ) ,REMOVE MD_Metadata subClassOf (spatialRepresentationInfo min 0 Thing ) ,REMOVE MD_Distribution subClassOf (distributionFormat min 0 Thing ) ,REMOVE MD_Metadata subClassOf (dataQualityInfo min 0 Thing ) ,REMOVE MD_Metadata subClassOf (metadataConstraints min 0 Thing ) ,REMOVE DQ_Element subClassOf (result min 1 Thing ) ,REMOVE MD_Metadata subClassOf (portrayalCatalogueInfo min 0 Thing ) ,REMOVE CI_Contact subClassOf (address min 0 Thing ) ,REMOVE MD_MetadataExtensionInformation subClassOf (extensionOnLineResource min 0 Thing ) END;";
		//String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE ArcType equivalentTo {inhibitor , reset , normal , read } END;";
		String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE Service subClassOf (perform_task min 1 Thing ) END;";
		//String formula="?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN REMOVE MD_StandardOrderProcess subClassOf (plannedAvailableDateTime min 0 Thing ) ,REMOVE CI_Citation subClassOf (identifier min 0 Thing ) ,REMOVE MD_Medium subClassOf (densityUnits min 0 Thing ) ,REMOVE MD_VectorSpatialRepresentation subClassOf (topologyLevel min 0 Thing ) ,REMOVE DQ_QuantitativeResult subClassOf (errorStatistic min 0 Thing ) ,REMOVE CI_Telephone subClassOf (voice min 0 Thing ) ,REMOVE CI_Address subClassOf (deliveryPoint min 0 Thing ) ,REMOVE MD_ExtendedElementInformation subClassOf (condition_extEleCond min 0 Thing ) ,REMOVE DQ_Element subClassOf (evaluationMethodType min 0 Thing ) ,REMOVE MD_Identification subClassOf (descriptiveKeywords min 0 Thing ) ,REMOVE MD_Metadata subClassOf (fieldIdentifier min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (spatialRepresentationType min 0 Thing ) ,REMOVE MD_Band subClassOf (toneGradation min 0 Thing ) ,REMOVE EX_BoundingPolygon subClassOf (polygon_polygon min 1 Thing ) ,REMOVE MD_Dimension subClassOf (resolution min 1 Thing ) ,REMOVE CI_Address subClassOf (postalCode min 0 Thing ) ,REMOVE EX_SpatialTemporalExtent subClassOf (spatialExtent min 1 Thing ) ,REMOVE MD_ImageDescription subClassOf (triangulationIndicator min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (illuminationAzimuthAngle min 0 Thing ) ,REMOVE LI_Lineage subClassOf (processStep min 0 Thing ) ,REMOVE CI_Citation subClassOf (ISBN min 0 Thing ) ,REMOVE MD_Identification subClassOf (credit min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (falseEasting min 0 Thing ) ,REMOVE LI_ProcessStep subClassOf (source_stepSrc min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (language_dataLang min 1 Thing ) ,REMOVE MD_Metadata subClassOf (contentInfo min 0 Thing ) ,REMOVE EX_Extent subClassOf (temporalElement min 0 Thing ) ,REMOVE MD_SecurityConstraints subClassOf (userNote min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (topicCategory min 1 Thing ) ,REMOVE MD_Format subClassOf (formatDistributor min 0 Thing ) ,REMOVE RS_ReferenceSystem subClassOf (domainOfValidity min 0 Thing ) ,REMOVE DQ_Element subClassOf (nameOfMeasure min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (longitudeOfCentralMeridian min 0 Thing ) ,REMOVE CI_ResponsibleParty subClassOf (positionName min 0 Thing ) ,REMOVE MD_DigitalTransferOptions subClassOf (unitsOfDistribution min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (characterSet_dataChar min 0 Thing ) ,REMOVE CI_Citation subClassOf (citedResponsibleParty min 0 Thing ) ,REMOVE MD_ApplicationSchemaInformation subClassOf (schemaAscii min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (latitudeOfProjectionOrigin min 0 Thing ) ,REMOVE LI_ProcessStep subClassOf (dateTime_stepDateTm min 0 Thing ) ,REMOVE MD_Band subClassOf (units min 0 Thing ) ,REMOVE MD_BrowseGraphics subClassOf (fileDescription min 0 Thing ) ,REMOVE MD_BrowseGraphics subClassOf (fileType min 0 Thing ) ,REMOVE MD_GeometricObjects subClassOf (geometricObjectCount min 0 Thing ) ,REMOVE MD_Metadata subClassOf (metadataExtensionInfo min 0 Thing ) ,REMOVE MD_MaintenanceInformation subClassOf (dateOfNextUpdate min 0 Thing ) ,REMOVE MD_RangeDimension subClassOf (sequenceIdentifier min 0 Thing ) ,REMOVE DQ_Element subClassOf (dateTime_measDateTm min 0 Thing ) ,REMOVE MD_Identification subClassOf (resourceMaintenance min 0 Thing ) ,REMOVE MD_PortrayalCatalogueReference subClassOf (portrayalCatalogueCitation min 1 Thing ) ,REMOVE MD_MaintenanceInformation subClassOf (updateScope min 0 Thing ) ,REMOVE LI_Source subClassOf (description_srcDesc min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (imagingCondition min 0 Thing ) ,REMOVE CI_Citation subClassOf (alternateTitle min 0 Thing ) ,REMOVE MD_Medium subClassOf (mediumFormat min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (extent_dataExt min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (longitudeOfProjectionCenter min 0 Thing ) ,REMOVE MD_DigitalTransferOptions subClassOf (onLine_onLineSrc min 0 Thing ) ,REMOVE MD_Georectified subClassOf (checkPointDescription min 0 Thing ) ,REMOVE MD_VectorSpatialRepresentation subClassOf (geometricObjects min 0 Thing ) ,REMOVE MD_Keywords subClassOf (type min 0 Thing ) ,REMOVE CI_Contact subClassOf (phone min 0 Thing ) ,REMOVE CI_OnlineResource subClassOf (protocol min 0 Thing ) ,REMOVE MD_CRS subClassOf (projection min 0 Thing ) ,REMOVE MD_Metadata subClassOf (metadataStandardVersion min 0 Thing ) ,REMOVE MD_StandardOrderProcess subClassOf (tumaround min 0 Thing ) ,REMOVE MD_Georectified subClassOf (centerPoint min 0 Thing ) ,REMOVE DQ_DataQuality subClassOf (lineage min 0 Thing ) ,REMOVE CI_Contact subClassOf (onlineResource min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (standardParallel min 0 Thing ) ,REMOVE DQ_Scope subClassOf (levelDescription min 0 Thing ) ,REMOVE DQ_Element subClassOf (measureIdentification min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (processingLevelCode min 0 Thing ) ,REMOVE MD_Identification subClassOf (purpose min 0 Thing ) ,REMOVE DQ_QuantitativeResult subClassOf (valueType min 0 Thing ) ,REMOVE DQ_Scope subClassOf (extent_scpExt min 0 Thing ) ,REMOVE MD_Metadata subClassOf (hierarchyLevelName min 0 Thing ) ,REMOVE MD_Keywords subClassOf (thesaurusName min 0 Thing ) ,REMOVE EX_Extent subClassOf (description_exDesc min 0 Thing ) ,REMOVE LI_Source subClassOf (sourceExtent min 0 Thing ) ,REMOVE LI_Source subClassOf (sourceStep min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (cloudCoverPercentage min 0 Thing ) ,REMOVE MD_Identification subClassOf (status min 0 Thing ) ,REMOVE LI_Source subClassOf (scaleDenominator min 0 Thing ) ,REMOVE EX_Extent subClassOf (geographicElement min 0 Thing ) ,REMOVE MD_Keywords subClassOf (keyword min 1 Thing ) ,REMOVE MD_ExtendedElementInformation subClassOf (parentEntity min 1 Thing ) ,REMOVE MD_LegalConstraints subClassOf (accessConstraints min 0 Thing ) ,REMOVE MD_Georectified subClassOf (transformationDimensionMapping min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (falseEastingNorthingUnits min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (straightVerticalLongitudeFromPole min 0 Thing ) ,REMOVE MD_Format subClassOf (specification_formatSpec min 0 Thing ) ,REMOVE MD_ApplicationSchemaInformation subClassOf (softwareDevelopmentFileFormat min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (environmentDescription min 0 Thing ) ,REMOVE MD_Distribution subClassOf (distributor min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (obliqueLineAzimuthParameter min 0 Thing ) ,REMOVE CI_OnlineResource subClassOf (description_orDesc min 0 Thing ) ,REMOVE CI_Address subClassOf (electiveMailAddress min 0 Thing ) ,REMOVE MD_Constraints subClassOf (useLimitation min 0 Thing ) ,REMOVE MD_Band subClassOf (peakResponse min 0 Thing ) ,REMOVE MD_Format subClassOf (amendmentNumber min 0 Thing ) ,REMOVE CI_Contact subClassOf (hoursOfService min 0 Thing ) ,REMOVE LI_Source subClassOf (sourceCitation min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (spatialResolution min 0 Thing ) ,REMOVE CI_Citation subClassOf (presentationForm min 0 Thing ) ,REMOVE MD_MaintenanceInformation subClassOf (maintenanceNote min 0 Thing ) ,REMOVE CI_Address subClassOf (country min 0 Thing ) ,REMOVE LI_Lineage subClassOf (source_dataSource min 0 Thing ) ,REMOVE MD_FeatureCatalogueDescription subClassOf (language_catLang min 0 Thing ) ,REMOVE MD_Metadata subClassOf (identificationInfo min 1 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (scaleFactorAtCenterLine min 0 Thing ) ,REMOVE MD_Metadata subClassOf (spatialRepresentationInfo min 0 Thing ) ,REMOVE CI_Citation subClassOf (edition min 0 Thing ) ,REMOVE MD_Distribution subClassOf (distributionFormat min 0 Thing ) ,REMOVE MD_ApplicationSchemaInformation subClassOf (graphicsFile min 0 Thing ) ,REMOVE DQ_Element subClassOf (result min 1 Thing ) ,REMOVE MD_Metadata subClassOf (portrayalCatalogueInfo min 0 Thing ) ,REMOVE CI_Contact subClassOf (address min 0 Thing ) ,REMOVE MD_MetadataExtensionInformation subClassOf (extensionOnLineResource min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (heightOfProspectivePointAboveSurface min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (illuminationElevationAngle min 0 Thing ) ,REMOVE MD_ExtendedElementInformation subClassOf (source_extEleSrc min 1 Thing ) ,REMOVE MD_DataIdentification subClassOf (supplementalInformation min 0 Thing ) ,REMOVE MD_Band subClassOf (scaleFactor min 0 Thing ) ,REMOVE MD_Metadata subClassOf (characterSet_mdChar min 0 Thing ) ,REMOVE MD_Metadata subClassOf (language_mdLang min 0 Thing ) ,REMOVE MD_Metadata subClassOf (hierarchyLevel min 0 Thing ) ,REMOVE LI_Source subClassOf (sourceReferenceSystem min 0 Thing ) ,REMOVE MD_Identification subClassOf (graphicOverview min 0 Thing ) ,REMOVE CI_Citation subClassOf (editionDate min 0 Thing ) ,REMOVE MD_Metadata subClassOf (parentIdentifier min 0 Thing ) ,REMOVE MD_Medium subClassOf (density min 0 Thing ) ,REMOVE MD_Usage subClassOf (userDeterminedLimitations min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (radiometricCalibrationDataAvailability min 0 Thing ) ,REMOVE MD_SecurityConstraints subClassOf (handlingDescription min 0 Thing ) ,REMOVE MD_Band subClassOf (maxValue min 0 Thing ) ,REMOVE MD_Format subClassOf (fileDecompressionTechnique min 0 Thing ) ,REMOVE CI_Address subClassOf (city min 0 Thing ) ,REMOVE EX_GeographicExtent subClassOf (extentTypeCode min 0 Thing ) ,REMOVE MD_CoverageDescription subClassOf (dimension min 0 Thing ) ,REMOVE MD_Georectified subClassOf (transformationDimensionDescription min 0 Thing ) ,REMOVE MD_CRS subClassOf (ellipsoid min 0 Thing ) ,REMOVE EX_Extent subClassOf (verticalElement min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (scaleFactorAtEquator min 0 Thing ) ,REMOVE CI_OnlineResource subClassOf (function min 0 Thing ) ,REMOVE MD_Identification subClassOf (resourceFormat min 0 Thing ) ,REMOVE DQ_DataQuality subClassOf (report min 0 Thing ) ,REMOVE CI_OnlineResource subClassOf (applicationProfile min 0 Thing ) ,REMOVE MD_Band subClassOf (bitsPerValue min 0 Thing ) ,REMOVE DQ_Element subClassOf (evaluationMethodDescription min 0 Thing ) ,REMOVE DQ_QuantitativeResult subClassOf (valueUnit min 0 Thing ) ,REMOVE DQ_Element subClassOf (evaluationProcedure min 0 Thing ) ,REMOVE DQ_QuantitativeResult subClassOf (value min 1 Thing ) ,REMOVE MD_Metadata subClassOf (metadataStandardName min 0 Thing ) ,REMOVE MD_Medium subClassOf (name_medName min 0 Thing ) ,REMOVE CI_ResponsibleParty subClassOf (organisationName min 0 Thing ) ,REMOVE MD_Identification subClassOf (pointOfConact min 0 Thing ) ,REMOVE CI_Series subClassOf (name_seriesName min 0 Thing ) ,REMOVE DQ_Scope subClassOf (level min 1 Thing ) ,REMOVE MD_FeatureCatalogueDescription subClassOf (featureCatalogueCitation min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (falseNorthing min 0 Thing ) ,REMOVE CI_Citation subClassOf (identifierType min 0 Thing ) ,REMOVE CI_Address subClassOf (administrativeArea min 0 Thing ) ,REMOVE MD_FeatureCatalogueDescription subClassOf (complianceCode min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (geographicDescription min 0 Thing ) ,REMOVE MD_Metadata subClassOf (referenceSystemInfo min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (filmDistortionInformationAvailibility min 0 Thing ) ,REMOVE MD_Georeferenceable subClassOf (orientationParameterAvailibility min 0 Thing ) ,REMOVE CI_ResponsibleParty subClassOf (individualName min 0 Thing ) ,REMOVE MD_Distributor subClassOf (distributorFormat min 0 Thing ) ,REMOVE MD_Band subClassOf (minValue min 0 Thing ) ,REMOVE MD_ExtendedElementInformation subClassOf (maximumOccurance min 0 Thing ) ,REMOVE MD_SpatialAttributeSupplement subClassOf (theFeatureTypeList min 1 Thing ) ,REMOVE MD_Band subClassOf (offset min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (imageQualityCode min 0 Thing ) ,REMOVE MD_Medium subClassOf (volumes min 0 Thing ) ,REMOVE LI_Lineage subClassOf (statement min 0 Thing ) ,REMOVE MD_RangeDimension subClassOf (descriptor min 0 Thing ) ,REMOVE MD_Identification subClassOf (resourceSpecificUsage min 0 Thing ) ,REMOVE LI_ProcessStep subClassOf (processor min 0 Thing ) ,REMOVE MD_Distribution subClassOf (transferOptions min 0 Thing ) ,REMOVE CI_Series subClassOf (issuedIdentification min 0 Thing ) ,REMOVE MD_Usage subClassOf (usageDateTime min 0 Thing ) ,REMOVE MD_Metadata subClassOf (applicationSchemaInfo min 0 Thing ) ,REMOVE MD_DigitalTransferOptions subClassOf (transferSize min 0 Thing ) ,REMOVE MD_ApplicationSchemaInformation subClassOf (softwareDevelopmentFile min 0 Thing ) ,REMOVE MD_Metadata subClassOf (distributionInfo min 0 Thing ) ,REMOVE LI_ProcessStep subClassOf (rationale_stepRat min 0 Thing ) ,REMOVE MD_Distributor subClassOf (distributionOrderProcess min 0 Thing ) ,REMOVE CI_Citation subClassOf (collectiveTitle min 0 Thing ) ,REMOVE MD_CRS subClassOf (projectionParameter min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (obliqueLinePointParameter min 0 Thing ) ,REMOVE MD_EllipsoidParameters subClassOf (denominationOfFlatteningRatio min 0 Thing ) ,REMOVE MD_FeatureCatalogueDescription subClassOf (featureTypes min 0 Thing ) ,REMOVE MD_StandardOrderProcess subClassOf (orderingInstructions min 0 Thing ) ,REMOVE MD_Distributor subClassOf (distributionTransferOptions min 0 Thing ) ,REMOVE MD_Medium subClassOf (mediumNote min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (cameraCalibrationInformationAvailability min 0 Thing ) ,REMOVE MD_MaintenanceInformation subClassOf (updateScopeDescription min 0 Thing ) ,REMOVE MD_ExtendedElementInformation subClassOf (obligation min 0 Thing ) ,REMOVE MD_LegalConstraints subClassOf (useConstraints min 0 Thing ) ,REMOVE CI_Series subClassOf (page min 0 Thing ) ,REMOVE MD_ReferenceSystem subClassOf (referenceSystemIdentifier min 0 Thing ) ,REMOVE MD_CRS subClassOf (datum min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (geographicBox min 0 Thing ) ,REMOVE MD_DigitalTransferOptions subClassOf (offLine min 0 Thing ) ,REMOVE MD_Identifier subClassOf (authority min 0 Thing ) ,REMOVE MD_SecurityConstraints subClassOf (classificationSystem min 0 Thing ) ,REMOVE MD_Usage subClassOf (userContactInfo min 1 Thing ) ,REMOVE CI_Citation subClassOf (series_datasetSeries min 0 Thing ) ,REMOVE MD_LegalConstraints subClassOf (otherConstraints min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (latitudeOfProjectionCenter min 0 Thing ) ,REMOVE MD_MetadataExtensionInformation subClassOf (extendedElementInformation min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (zone min 0 Thing ) ,REMOVE MD_Identification subClassOf (resourceConstraints min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (compressionGenerationQuantity min 0 Thing ) ,REMOVE CI_OnlineResource subClassOf (name_onlName min 0 Thing ) ,REMOVE MD_CRS subClassOf (ellipsoidParameters min 0 Thing ) ,REMOVE MD_Georeferenceable subClassOf (parameterCitation min 0 Thing ) ,REMOVE MD_DataIdentification subClassOf (supplementalInformation min 1 Thing ) ,REMOVE MD_StandardOrderProcess subClassOf (fees min 0 Thing ) ,REMOVE MD_ExtendedElementInformation subClassOf (domainCode_extDomCode min 0 Thing ) ,REMOVE CI_Citation subClassOf (date_resRefDate min 1 Thing ) ,REMOVE DQ_Element subClassOf (measureDescription min 0 Thing ) ,REMOVE MD_MaintenanceInformation subClassOf (userDefinedMaintenanceFrequency min 0 Thing ) ,REMOVE CI_ResponsibleParty subClassOf (contactInfo min 0 Thing ) ,REMOVE MD_ExtendedElementInformation subClassOf (shortName_extShortName min 0 Thing ) ,REMOVE CI_Contact subClassOf (contactInstructions min 0 Thing ) ,REMOVE MD_ProjectionParameters subClassOf (scaleFactorAtProjectionOrigin min 0 Thing ) ,REMOVE MD_Metadata subClassOf (metadataMaintenance min 0 Thing ) ,REMOVE MD_ExtendedElementInformation subClassOf (domainValue min 0 Thing ) ,REMOVE CI_Citation subClassOf (otherCitationDetails min 0 Thing ) ,REMOVE MD_ImageDescription subClassOf (lenseDistortionInformationAvailibility min 0 Thing ) ,REMOVE MD_Metadata subClassOf (dataQualityInfo min 0 Thing ) ,REMOVE MD_Metadata subClassOf (metadataConstraints min 0 Thing ) ,REMOVE CI_Telephone subClassOf (fascimile min 0 Thing ) ,REMOVE CI_Citation subClassOf (ISSN min 0 Thing ) END;";
		 //"REMOVE <http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine#WineFlavor> equivalentTo {<http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine#Delicate> , <http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine#Moderate> , <http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine#Strong> } END;";
		 //"REMOVE RedWine subClassOf (hasFlavor value Strong) END;";
		//if you add new entity in axioms you do not have to add 'x subClassOf Thing'
		try {
			//String formula = URLGrabber.getDocumentAsString("file:///home/ondrej/conferences.papers/EKAW2010/Corcho/transformations/trans2.oppl");
			//String formula = "?a:CLASS, ?c:CLASS, ?p:OBJECTPROPERTY, ?b:CLASS = ?p some ?c SELECT ASSERTED ?a equivalentTo ?b BEGIN  REMOVE ?a equivalentTo ?b,  ADD ?a subClassOf ?b END;"; 
			//System.out.println(formula);
			//MD_StandardOrderProcess
			OPPLParser p = new org.coode.oppl.ParserFactory(manager, ontology, reasoner).build(errorListener);
			//(this.OPPLinstructions.toString(), this.ontology, this.manager, reasoner);
			OPPLScript script = p.parse(formula);
			
			// I need to evaluate the script now
			ChangeExtractor changeExtractor = new ChangeExtractor(
					new QuickFailRuntimeExceptionHandler(), false);
			List<OWLAxiomChange> changes = changeExtractor.visit(script);
			// Evaluation finished the resulting changes can be printed out.
			for (OWLAxiomChange axiom : changes) {
				System.out.println(axiom);
				manager.applyChange(axiom);
			}
			manager.saveOntology(ontology, new SystemOutDocumentTarget());

			
			/*my old version:
			// Do what you want to do with it
			for(OWLAxiomChange axiom : script.getActions()) {
				System.out.println(axiom);
				//RemoveAxiom ra = new RemoveAxiom(axiom);
				manager.applyChange(axiom); //or apply set of changes at once, i.e. applyChanges method
			}
			//manager.saveOntology(ontology, new SystemOutDocumentTarget());
			*/
			//Executor exec = new Executor(script.getConstraintSystem(), true);
			//exec.visitActions(script.getActions());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
