package cz.vse.keg.patomat.transformation.util;

import java.net.URI;
import java.util.List;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.coode.oppl.ChangeExtractor;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.ParserFactory;
import org.coode.oppl.OPPLParser;
import org.coode.oppl.exceptions.QuickFailRuntimeExceptionHandler;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.common.SystemErrorEcho;

import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.io.SystemOutDocumentTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

import cz.vse.keg.patomat.util.URLGrabber;

/**
 * @author Ondrej Zamazal
 * 
 */

public class CopyOfRunOPPLscript {	
	
	public static void main(String[] args) {
		ErrorListener errorListener = new SystemErrorEcho();
		OWLOntologyManager manager;
		OWLOntology ontology = null;
		manager = OWLManager.createOWLOntologyManager();
		try {
			ontology = manager.loadOntologyFromOntologyDocument(IRI.create("http://www.w3.org/2001/sw/WebOnt/guide-src/wine.rdf"));
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		//OWLReasoner reasoner = reasonerFactory.createReasoner(manager);
		OWLReasoner reasoner = null;
		HashSet<OWLOntology> ontos = new HashSet<OWLOntology>();
		ontos.add(ontology);		
		String formula = "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN "+
		 "REMOVE WineFlavor equivalentTo {Delicate , Moderate , Strong } END;";
		try {
		
			OPPLParser p = new org.coode.oppl.ParserFactory(manager, ontology, reasoner).build(errorListener);
			OPPLScript script = p.parse(formula);
			
			ChangeExtractor changeExtractor = new ChangeExtractor(
					new QuickFailRuntimeExceptionHandler(), false);
			List<OWLAxiomChange> changes = changeExtractor.visit(script);

			for (OWLAxiomChange axiom : changes) {
				System.out.println(axiom);
				manager.applyChange(axiom);
			}
			manager.saveOntology(ontology, new SystemOutDocumentTarget());
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
