package cz.vse.keg.patomat.transformation.pattern.service;

import org.restlet.resource.Post;
import org.restlet.resource.ServerResource;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.semanticweb.owlapi.model.OWLOntology;
//import org.restlet.resource.Get;
import cz.vse.keg.patomat.transformation.OntologyTransformation.TransformationStrategy;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;

/**
 * @author Ondrej Zamazal
 * 
 */

public class OntologyTransformationServiceResource extends ServerResource {
	/**
     * Handle POST requests: create a new item.
     */
    @Post
    public Representation acceptItem(Representation entity) {
        Representation result = null;

        // Parse the given representation and retrieve pairs of
        // "name=value" tokens.
        Form form = new Form(entity);
        String ontology = form.getFirstValue("ontology");
        String tp = form.getFirstValue("tp");
        String strategy = form.getFirstValue("strategy");//a strategy for transformation
        																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																														String binding = form.getFirstValue("binding");        
        String instructions = "";
        TransformationStrategy ts;
        
        //OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0", "/usr/share/models");
        OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
        
        boolean POStagger=true;//because of make_passive_verb() function which need POS-tagger
        System.out.println(tp);
        InstructionGenerator ig = new InstructionGeneratorImpl(new TransformationPatternImpl(tp),POStagger, "/usr/share/WordNet-3.0", "/usr/share/models");
        //InstructionGenerator ig = new InstructionGeneratorImpl(new TransformationPatternImpl("file:///home/ondrej/doktorandsky/PatOMat/TPs/tp_hasSome2.xml"),POStagger);
        ig.generateInstructions(binding);
		instructions = ig.exportInstructions();
		System.out.println(instructions);
		transformation.setInstructions(instructions);
		
		if (strategy.equals("conservative")) ts=TransformationStrategy.Conservative;
        else if (strategy.equals("progressive")) ts=TransformationStrategy.Progressive;
        else ts=TransformationStrategy.Radical;
        		
        transformation.transformOntology(ts,true);
        transformation.saveOntology("");
        
        // Set the response's status and entity
        setStatus(Status.SUCCESS_CREATED);
        Representation rep = new StringRepresentation(transformation.printOntology(),
        //Representation rep = new StringRepresentation("OK",
                MediaType.TEXT_XML);
   
        result = rep;
        return result;
    }   
}
