package cz.vse.keg.patomat.transformation.pattern.service;

import org.restlet.resource.Post;
import org.restlet.resource.ServerResource;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.semanticweb.owlapi.model.OWLOntology;
//import org.restlet.resource.Get;
import cz.vse.keg.patomat.transformation.OntologyTransformation.TransformationStrategy;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;
import cz.vse.keg.patomat.transformation.OntologyTransformation;
import cz.vse.keg.patomat.transformation.OntologyTransformationImpl;

/**
 * @author Ondrej Zamazal
 * 
 */

public class OntologyTransformationResource extends ServerResource {
	/**
     * Handle POST requests: create a new item.
     */
    @Post
    public Representation acceptItem(Representation entity) {
        Representation result = null;

        // Parse the given representation and retrieve pairs of
        // "name=value" tokens.
        Form form = new Form(entity);
        String ontology = form.getFirstValue("ontology");
        String instructions = form.getFirstValue("instructions");//instructions for transformation
        String strategy = form.getFirstValue("strategy");//a strategy for transformation
        String radicalStrategy = form.getFirstValue("radical-strategy");//variant of radical strategy for transformation
        TransformationStrategy ts;
        String ontologyNew="";
        //OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology, "/usr/share/WordNet-3.0", "/usr/share/models");
        OntologyTransformation<OWLOntology> transformation = new OntologyTransformationImpl(ontology);
        
        transformation.setInstructions(instructions);
        
        if (strategy.equals("conservative")) ts=TransformationStrategy.Conservative;
        else if (strategy.equals("progressive")) ts=TransformationStrategy.Progressive;
        //04-03-11
        else if (radicalStrategy.equals("conservative")) ts=TransformationStrategy.RadicalKeep; //radical-keep
        else if (radicalStrategy.equals("radical")) ts=TransformationStrategy.RadicalRemove; //radical-remove
        else ts=TransformationStrategy.Radical; //radical-neutral
        
        transformation.transformOntology(ts,true);
        transformation.saveOntology("");
        
        // Set the response's status and entity
        setStatus(Status.SUCCESS_CREATED);
        Representation rep = new StringRepresentation(transformation.printOntology(),
                MediaType.TEXT_XML);
   
        result = rep;
        return result;
    }   
}
