package cz.vse.keg.patomat.transformation.pattern.service;

import java.util.StringTokenizer;

import org.restlet.resource.Post;
import org.restlet.resource.ServerResource;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
//import org.restlet.resource.Get;
import cz.vse.keg.patomat.transformation.pattern.InstructionGenerator;
import cz.vse.keg.patomat.transformation.pattern.InstructionGeneratorImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;

/**
 * @author Ondrej Zamazal
 * 
 */

public class InstructionGeneratorResource extends ServerResource {
	/**
     * Handle POST requests: create a new item.
     */
    @Post
    public Representation acceptItem(Representation entity) {
        Representation result = null;

        // Parse the given representation and retrieve pairs of
        // "name=value" tokens.
        Form form = new Form(entity);
        String tp = form.getFirstValue("tp");
        String binding = form.getFirstValue("binding");//biding for pattern instance
        String instructions="";
        boolean POStagger=true;//because of make_passive_verb() function which need POS-tagger
        InstructionGenerator ig = new InstructionGeneratorImpl(new TransformationPatternImpl(tp),POStagger, "/usr/share/WordNet-3.0", "/usr/share/models");                                      
        //04-03-11,priprava pro vice vyskytu pattern instance        
        binding=binding.replaceAll("</pattern_instance>", "\t");
        StringTokenizer st = new StringTokenizer(binding, "\t");
        String curBinding="";
        //System.out.println(binding);
        while (st.hasMoreTokens()) {
        	curBinding=st.nextToken();
        	//System.out.println(curBinding);
        	curBinding+="</pattern_instance>\n";
        	//System.out.println(curBinding);
        	ig.generateInstructions(curBinding);
        }
        //ig.generateInstructions(binding);
        instructions = ig.exportInstructions();
        // Set the response's status and entity
        setStatus(Status.SUCCESS_CREATED);
        Representation rep = new StringRepresentation(instructions,
                MediaType.TEXT_XML);
   
        result = rep;
        return result;
    }   
}
