package cz.vse.keg.patomat.transformation.pattern;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//import com.sun.org.apache.xml.internal.utils.*;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;

import cz.vse.keg.patomat.transformation.pattern.PatternTransformation.Type;
import cz.vse.keg.patomat.util.URLGrabber;

public class TransformationPatternImpl implements TransformationPattern {
	
	/**
	 * Implementation of generic Transformation Pattern interface
	 * @author Ondrej Zamazal
	 */
	
	private  OntologyPattern OP1;
	private  OntologyPattern OP2;
	private  PatternTransformation PT; //ENP is a part of PT
	private String uri="no uri";
	//private  HashMap<String,String> ENP; 
	private boolean debuggingOutput=false;
	
	public TransformationPatternImpl(String uriXML) {
		OP1 = new OntologyPatternImpl();
		OP2 = new OntologyPatternImpl();
		PT = new PatternTransformationImpl();		
		//ENP = new HashMap<String,String>();		
		
		try {					    
			//09-03-10,transformation pattern can be directly XML file as String or referring URL
			if ((uriXML.matches("^http.*"))||(uriXML.matches("^file.*"))) {
				this.uri = uriXML;
				setTP(URLGrabber.getDocumentAsString(uriXML));
			}
			else {
				setTP(uriXML);
			}			
		} 
		catch(Exception e) {
		    e.printStackTrace();
		}
	}
	
	public void setTP(String tp) {
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
	    dbf.setNamespaceAware(true);
	    Document doc = null;
	    try {
		    DocumentBuilder db = dbf.newDocumentBuilder();
		    doc = db.parse(new StringBufferInputStream(tp));		    
		    //doc = db.parse(new InputStream(new StringReader(tp)));
		    //16-12-10, doctype entities as namespaces in query in OntologyPatternDetection		    
		    DocumentType doctype = doc.getDoctype();
		    if (doctype != null) {
			    if (doctype.getEntities()!=null) {
				    int number_of_nodes = doctype.getEntities().getLength();
				    //if (this.debuggingOutput) System.out.println("number of nodes:"+number_of_nodes);
				    for(int i=0;i<number_of_nodes;i++) {
				    	//Node n = doc.getDoctype().getEntities().item(i);
				    	//if (this.debuggingOutput) System.out.println("entities");
				    	this.OP1.addNamespace(doc.getDoctype().getEntities().item(i).getNodeName(),doc.getDoctype().getEntities().item(i).getTextContent());
				    	this.OP2.addNamespace(doc.getDoctype().getEntities().item(i).getNodeName(),doc.getDoctype().getEntities().item(i).getTextContent());
				    	if (this.debuggingOutput) System.out.println(doc.getDoctype().getEntities().item(i).getNodeName()+":"+doc.getDoctype().getEntities().item(i).getTextContent());		    
				    }
		    	}
	    	}
	    }
	    catch(Exception e) {
	    	e.printStackTrace();
	    }
		//08-12-10, implementation for namespaces awareness (based on XPath with namespaces in Java), it corresponds with xpath.setNamespaceContext(ctx);
	    //for default namespace it is used ":"
	    final PrefixResolver resolver =
		       new PrefixResolverDefault(doc.getDocumentElement());
         NamespaceContext ctx = new NamespaceContext() {
         	public String getNamespaceURI(String prefix) {
         		return resolver.getNamespaceForPrefix(prefix);
         	}		    

         	// Dummy implementation - not used!
             public Iterator getPrefixes(String val) {
                 return null;
             }
 
             // Dummy implemenation - not used!
             public String getPrefix(String uri) {
                 return null;		    
             }
         };
         
	    // evaluate the XPath expression against the Document
		XPath xpath = XPathFactory.newInstance().newXPath();
		xpath.setNamespaceContext(ctx);
		String expression = "/:tp/:op1/:entity_declarations/:placeholder";
		try {
			//OP1
			NodeList nodesOP;
			nodesOP = (NodeList) xpath.evaluate(expression, doc,
                XPathConstants.NODESET);
			for(int i=0;i<nodesOP.getLength();i++) {
				//if (this.debuggingOutput) System.out.println(nodesOP.item(i).getNodeValue("type")+" zzz");				
				//if (this.debuggingOutput) System.out.println(((Element)nodesOP.item(i)).getTextContent()+","+((Element)nodesOP.item(i)).getAttribute("type"));
				OP1.addPlaceholder(nodesOP.item(i).getTextContent(),OntologyPatternImpl.getType(((Element)nodesOP.item(i)).getAttribute("type")));
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());
			}			
			//08-12-10, specified entities in OP1			
			nodesOP = (NodeList) xpath.evaluate("/:tp/:op1/:entity_declarations/:entity", doc,
	                XPathConstants.NODESET);
			for(int i=0;i<nodesOP.getLength();i++) {				
				OP1.addSpecifiedEntity(nodesOP.item(i).getTextContent(),OntologyPatternImpl.getType(((Element)nodesOP.item(i)).getAttribute("type")));
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());
			}			
			//axioms in OP1
			nodesOP = (NodeList) xpath.evaluate("/:tp/:op1/:axioms/:axiom", doc,
                XPathConstants.NODESET);
			for(int i=0;i<nodesOP.getLength();i++) {
				String axiom=nodesOP.item(i).getTextContent();
				axiom=axiom.replaceAll(","," ,");
				axiom=axiom.replaceAll("\\)"," )");
				axiom=axiom.replaceAll("}"," }");
				axiom=axiom.replaceAll("$"," ");
				if ((((Element)nodesOP.item(i)).getAttribute("optional")).equals("yes"))
					OP1.addOptionalAxiom(axiom);					
				OP1.addAxiom(axiom);
				
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());
			}
			//nameDetectionPattern in OP1, comparison tag or exist tag
			nodesOP = (NodeList) xpath.evaluate("/:tp/:op1/:ndp/*", doc,
                XPathConstants.NODESET);
			NameDetectionPattern ndp;

			for(int i=0;i<nodesOP.getLength();i++) {				
				ndp = new NameDetectionPatternImpl();				
				if (nodesOP.item(i).getNodeName().equals("exist")) {
					ndp.setNamePatternType(nodesOP.item(i).getNodeName());
					ndp.setEntity1(nodesOP.item(i).getTextContent());
					//if (this.debuggingOutput) System.out.println(nodesOP.item(i).getNodeName());
					OP1.addNameDetectionPattern(ndp);
				}
				else if (nodesOP.item(i).getNodeName().equals("comparison")) {
					ndp.setNamePatternType(nodesOP.item(i).getNodeName());
					ndp.setThreshold(Float.valueOf(((Element)nodesOP.item(i)).getAttribute("threshold")));
					ndp.setMeasureType(((Element)nodesOP.item(i)).getAttribute("measure"));				
					ndp.setEntity1(nodesOP.item(i).getFirstChild().getTextContent());
					ndp.setEntity2(nodesOP.item(i).getLastChild().getTextContent());
					//if (this.debuggingOutput) System.out.println("comparison");					
					OP1.addNameDetectionPattern(ndp);
				}
				//if (this.debuggingOutput) System.out.println("ha");
				//if (this.debuggingOutput) System.out.println(OP1.getNameDetectionPatterns());
			}
			//OP1.setPlaceholders();
			//OP2
			nodesOP = (NodeList) xpath.evaluate("/:tp/:op2/:entity_declarations/:placeholder", doc,
                XPathConstants.NODESET);
			for(int i=0;i<nodesOP.getLength();i++) {
				OP2.addPlaceholder(nodesOP.item(i).getTextContent(),OntologyPatternImpl.getType(((Element)nodesOP.item(i)).getAttribute("type")));
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());
			}
			//08-12-10, specified entities in OP2			
			nodesOP = (NodeList) xpath.evaluate("/:tp/:op2/:entity_declarations/:entity", doc,
	                XPathConstants.NODESET);
			for(int i=0;i<nodesOP.getLength();i++) {				
				OP2.addSpecifiedEntity(nodesOP.item(i).getTextContent(),OntologyPatternImpl.getType(((Element)nodesOP.item(i)).getAttribute("type")));
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());
			}						
			//axioms in OP2
			nodesOP = (NodeList) xpath.evaluate("/:tp/:op2/:axioms/:axiom", doc,
                XPathConstants.NODESET);
			for(int i=0;i<nodesOP.getLength();i++) {
				String axiom=nodesOP.item(i).getTextContent();
				axiom=axiom.replaceAll(","," ,");
				axiom=axiom.replaceAll("\\)"," )");
				axiom=axiom.replaceAll("}"," }");
				axiom=axiom.replaceAll("$"," ");
				if ((((Element)nodesOP.item(i)).getAttribute("optinal")).equals("yes"))
					OP2.addOptionalAxiom(axiom);
				OP2.addAxiom(axiom);
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());
			}
			//OP2.setPlaceholders();
			//nameDetectionPattern in OP1, comparison tag or exist tag
			nodesOP = (NodeList) xpath.evaluate("/:tp/:op2/:ndp/*", doc,
                XPathConstants.NODESET);			

			for(int i=0;i<nodesOP.getLength();i++) {				
				ndp = new NameDetectionPatternImpl();				
				if (nodesOP.item(i).getNodeName().equals("exist")) {
					ndp.setNamePatternType(nodesOP.item(i).getNodeName());
					ndp.setEntity1(nodesOP.item(i).getTextContent());
					//if (this.debuggingOutput) System.out.println(nodesOP.item(i).getNodeName());
					OP2.addNameDetectionPattern(ndp);
				}
				else if (nodesOP.item(i).getNodeName().equals("comparison")) {
					ndp.setNamePatternType(nodesOP.item(i).getNodeName());
					ndp.setThreshold(Float.valueOf(((Element)nodesOP.item(i)).getAttribute("threshold")));
					ndp.setMeasureType(((Element)nodesOP.item(i)).getAttribute("measure"));				
					ndp.setEntity1(nodesOP.item(i).getFirstChild().getTextContent());
					ndp.setEntity2(nodesOP.item(i).getLastChild().getTextContent());
					//if (this.debuggingOutput) System.out.println("comparison");					
					OP2.addNameDetectionPattern(ndp);
				}
				//if (this.debuggingOutput) System.out.println("ha");
				//if (this.debuggingOutput) System.out.println(OP1.getNameDetectionPatterns());
			}
			
			//Pattern Transformation
			nodesOP = (NodeList) xpath.evaluate("/:tp/:pt/:eq", doc,
                XPathConstants.NODESET);
			HashMap<String,String> anyLinks = new HashMap<String,String>(); 
			HashMap<String,String> curLinks = new HashMap<String,String>();
			for(int i=0;i<nodesOP.getLength();i++) {				
				curLinks.put(((Element)nodesOP.item(i)).getAttribute("op1"), ((Element)nodesOP.item(i)).getAttribute("op2"));
				//if (this.debuggingOutput) System.out.println((((Element)nodesOP.item(i)).getAttribute("op1")+"&"+((Element)nodesOP.item(i)).getAttribute("op2")));
			}
			PT.setLinks(curLinks, Type.eq);
			//if (this.debuggingOutput) System.out.println(PT.getLinks(Type.eq));
			anyLinks.putAll(curLinks);
			//eqHet
			nodesOP = (NodeList) xpath.evaluate("/:tp/:pt/:eqHet", doc,
                XPathConstants.NODESET);			
			curLinks = new HashMap<String,String>();
			for(int i=0;i<nodesOP.getLength();i++) {				
				curLinks.put(((Element)nodesOP.item(i)).getAttribute("op1"), ((Element)nodesOP.item(i)).getAttribute("op2"));				
			}
			PT.setLinks(curLinks, Type.eqHet);
			anyLinks.putAll(curLinks);
			//eqAnn
			nodesOP = (NodeList) xpath.evaluate("/:tp/:pt/:eqAnn", doc,
                XPathConstants.NODESET);			
			curLinks = new HashMap<String,String>();
			for(int i=0;i<nodesOP.getLength();i++) {				
				curLinks.put(((Element)nodesOP.item(i)).getAttribute("op1"), ((Element)nodesOP.item(i)).getAttribute("op2"));				
			}	
			PT.setLinks(curLinks, Type.eqAnn);
			anyLinks.putAll(curLinks);
			PT.setLinks(anyLinks, Type.any);
			//ENP - naming instructions
			nodesOP = (NodeList) xpath.evaluate("/:tp/:pt/:ntp", doc,
                XPathConstants.NODESET);			
			HashMap<String,String> curENP = new HashMap<String,String>();
			for(int i=0;i<nodesOP.getLength();i++) {				
				curENP.put(((Element)nodesOP.item(i)).getAttribute("entity"), ((Element)nodesOP.item(i)).getTextContent());				
			}
			PT.setENP(curENP);
		}
		catch(Exception e) {
			e.printStackTrace();
		}

	}
	
	public OntologyPattern getOP1() {
		return this.OP1;
	}
	
	public OntologyPattern getOP2() {
		return this.OP2;
	}
	
	public PatternTransformation getPT() {
		return this.PT;
	}		
	
	/*
	public HashMap<String,String> getENP() {
		return this.ENP;
	}*/
	
	public String getLocation() {
		return this.uri;
	}
	
	@Override
	public String toString() {
		//return this.OP1 +"\n"+ this.OP2 +"\n"+this.PT;
		StringBuffer niceOutput = new StringBuffer();
		//04-10-11, TODO: provide more information about tp and remove necessary internet connection due to XML schema
		niceOutput.append("<tp>\n");
		niceOutput.append("<op1>\n");
		niceOutput.append(this.OP1.toString());
		niceOutput.append("</op1>\n");
		niceOutput.append("<op2>\n");
		niceOutput.append(this.OP2.toString());
		niceOutput.append("</op2>\n");
		niceOutput.append(this.PT.toString());
		niceOutput.append("</tp>\n");
		return niceOutput.toString();
	}
	
	public static void main(String[] args) {
		TransformationPatternImpl tp1 = new TransformationPatternImpl("");
		if (tp1.debuggingOutput) System.out.println(tp1.getOP1());
		if (tp1.debuggingOutput) System.out.println(tp1.getOP2());
	}

}
