package cz.vse.keg.patomat.transformation.pattern;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;

/**
 * @author Ondrej Zamazal
 * 
 */

public class PatternTransformationImpl implements PatternTransformation {

	private EnumMap<Type,HashMap<String,String>> links;
	private HashMap<String,String> ENP;
	
	public PatternTransformationImpl() {
		this.links = new EnumMap<Type,HashMap<String,String>>(Type.class);
		this.ENP = new HashMap<String,String>();
	}
	
	@Override
	public void setLinks(HashMap<String,String> links,Type type) {		
		//link = "placeholder,placeholder" comma-separated
		this.links.put(type, links);
	}

	@Override
	public HashMap<String, String> getLinks(Type type) {
		return this.links.get(type);		
	}
	
	public void setENP(HashMap<String,String> enp) {
		this.ENP=enp;
	}
	
	public HashMap<String,String> getENP() {
		return this.ENP;
	}
	
	@Override
	public String toString() {
		//return links + ":::"+ENP;
		StringBuffer niceOutput = new StringBuffer();
		niceOutput.append("<pt>\n");
		for(String s : this.links.get(Type.eq).keySet()) {
			niceOutput.append("<eq op1=\""+s+"\" op2=\""+this.links.get(Type.eq).get(s)+"\"/>\n");
		}
		for(String s : this.links.get(Type.eqHet).keySet()) {
			niceOutput.append("<eqHet op1=\""+s+"\" op2=\""+this.links.get(Type.eqHet).get(s)+"\"/>\n");
		}
		for(String s : this.links.get(Type.eqAnn).keySet()) {
			niceOutput.append("<eqAnn op1=\""+s+"\" op2=\""+this.links.get(Type.eq).get(s)+"\"/>\n");
		}
		for(String s : this.ENP.keySet()) {
			niceOutput.append("<ntp entity=\""+s+"\">"+this.ENP.get(s)+"\"<ntp/>\n");
		}
		niceOutput.append("</pt>\n");
		return niceOutput.toString();
	}

	@Override
	public void addLink(Type type, String[] newLHSLink, String[] newRHSLink) {
		
		HashMap<String, String> links = this.getLinks(type);
		
		for(int j=0; j<newLHSLink.length; j++) {			
			links.put(newLHSLink[j], newRHSLink[j]);
		}		
		
	}

	@Override
	public void removeLink(Type type, ArrayList<String> oldLHSLinks) {
		
		HashMap<String, String> links = this.getLinks(type);
		
		for(String s : oldLHSLinks) {
			links.remove(s);
		}			
		
	}
	
	public void removeLink(Type type, String oldLHSLink) {
		
		HashMap<String, String> links = this.getLinks(type);
		
		links.remove(oldLHSLink);						
	}

	@Override
	public void replaceNTP(String lhsOld, String rhsOld, String[] lhsNew, String[] rhsNew) {
		//String oldNamingInstruction = this.ENP.get(lhsOld);
		for(int j=0; j<rhsNew.length; j++) {
			//System.out.println(rhsNew[j]+","+rhsOld+","+lhsOld+","+lhsNew[j]);
			this.ENP.put(rhsNew[j], this.ENP.get(rhsOld).replaceAll("\\"+lhsOld, lhsNew[j]));
		}		
		this.ENP.remove(rhsOld);				
	}
	
	public void replaceNTP2(String lhsOld, String rhsOld, String lhsNew, String rhsNew) {			
		this.ENP.put(lhsNew, rhsNew);
		this.ENP.remove(rhsOld);				
	}
}
