/**
 * 
 */
package cz.vse.keg.patomat.transformation.pattern;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;

/**
 * Represents Pattern Transformation as a part of Ontology Pattern.
 * @author Ondrej Zamazal
 *
 */
public interface PatternTransformation {
	
	public enum Type {eq, eqHet, eqAnn, any};
	
	public void setLinks(HashMap<String,String> links,Type type);
	
	//public void replaceLink(Type type, String oldLHSLink, String oldRHSLink, String[] newLHSLink, String[] newRHSLink);
	
	public void addLink(Type type, String[] newLHSLink, String[] newRHSLink);
	
	//public void removeLink(Type type, String oldLHSLink, String oldRHSLink);
	public void removeLink(Type type, ArrayList<String> oldLHSLinks);
	
	public void removeLink(Type type, String oldLHSLink);
	
	//any means all links
	public HashMap<String,String> getLinks(Type type);
	//any means all links
	//public EnumMap<Type,HashMap<String,String>> getLinks(Type type);
	
	public void setENP(HashMap<String,String> enp);
	//NTP=ENP
	public void replaceNTP(String lhsOld, String rhsOld, String[] lhsNew, String[] rhsNew);
	
	public void replaceNTP2(String lhsOld, String rhsOld, String lhsNew, String rhsNew);	
	
	public HashMap<String,String> getENP();
}
