package cz.vse.keg.patomat.transformation.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
//import java.util.HashSet;
//import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cz.vse.keg.patomat.transformation.pattern.OntologyPattern.EntityType;

/**
 * @author Ondrej Zamazal
 * 
 */

public class OntologyPatternImpl implements OntologyPattern {

	private HashMap<String,EntityType> placeholders;
	private HashMap<String,EntityType> specified_entities;
	private ArrayList<String> axioms;//13-09-11, all axioms on which transformation can be applied 
	private ArrayList<String> optionalAxioms;//13-09-11, TODO for optional detection phase
	//TODO:naming aspect
	private ArrayList<NameDetectionPattern> nameDetectionPatterns;
	private HashMap<String,String> namespaces; ////(key=url,value=prefix),17-12-10
	
	public OntologyPatternImpl() {
		this.placeholders = new HashMap<String,EntityType>();
		this.specified_entities = new HashMap<String,EntityType>();
		this.axioms = new ArrayList<String>();
		this.optionalAxioms = new ArrayList<String>();
		this.nameDetectionPatterns = new ArrayList<NameDetectionPattern>();
		this.namespaces = new HashMap<String,String>();
	}
	
	public HashMap<String,EntityType> getPlaceholders() {
		return this.placeholders;
	}
	
	public HashMap<String,EntityType> getSpecifiedEntities() {
		return this.specified_entities;
	}
	
	public ArrayList<String> getAxioms() {
		return this.axioms;
	}
	
	public ArrayList<String> getOptionalAxioms() {
		return this.optionalAxioms;
	}
	
	public void addPlaceholder(String placeholder, EntityType type) {
		this.placeholders.put(placeholder,type);
	}
	
	public void addSpecifiedEntity(String specified_entity, EntityType type) {
		this.specified_entities.put(specified_entity,type);
	}
	
	public void setPlaceholders() {
		//Pattern pat = Pattern.compile("\\?.");
		Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
		Matcher m;
		for(String axiom : axioms) {
			m = pat.matcher(axiom);		
			while(m.find()) {
				//System.out.println(m.group());
				this.placeholders.put(m.group(), EntityType.Uknown);
			}	
		}		
	}
	
	public static EntityType getType(String type) {
		if (type.equals("Class")) return EntityType.Class;
		else if (type.equals("ObjectProperty")) return EntityType.ObjectProperty;
		else if (type.equals("DatatypeProperty")) return EntityType.DatatypeProperty;
		else if (type.equals("AnnotationProperty")) return EntityType.AnnotationProperty;
		else if (type.equals("Individual")) return EntityType.Individual;
		else if (type.equals("AnonymousIndividual")) return EntityType.AnonymousIndividual;
		else if (type.equals("Literal")) return EntityType.Literal;
		else return EntityType.Uknown;
	}
	
	public void addAxiom(String axiom) {
		this.axioms.add(axiom);
	}
	
	public void addOptionalAxiom(String axiom) {
		this.optionalAxioms.add(axiom);
	}
	
	public String toString() {
		//return this.placeholders + " & " + this.specified_entities + " & " + this.axioms + " & "+ this.optionalAxioms +" & "+this.nameDetectionPatterns;
		StringBuffer niceOutput = new StringBuffer();
		niceOutput.append("<entity_declarations>\n");
		for(String s : placeholders.keySet()) {
			niceOutput.append("<placeholder type="+placeholders.get(s)+">"+s+"</placeholder>\n");
		}
		//TODO do the same for specified_entities
		niceOutput.append("</entity_declarations>\n");
		niceOutput.append("<axioms>\n");
		for(String s : axioms) {
			if (optionalAxioms.contains(s))
				niceOutput.append("<axiom optional=\"yes\">"+s+"</axiom>\n");
			else
				niceOutput.append("<axiom>"+s+"</axiom>\n");
		}
		niceOutput.append("</axioms>\n");
		niceOutput.append("<axioms>\n");
		if (!nameDetectionPatterns.isEmpty()) {
			niceOutput.append("<ndp\n>");
			for(NameDetectionPattern s : nameDetectionPatterns) {
				//TODO
				niceOutput.append(s);
			}
			niceOutput.append("</ndp>\n");
		}
		return niceOutput.toString();
	}

	@Override
	public void addNameDetectionPattern(NameDetectionPattern n) {
		// TODO Auto-generated method stub
		this.nameDetectionPatterns.add(n);
	}

	@Override
	public ArrayList<NameDetectionPattern> getNameDetectionPatterns() {
		return this.nameDetectionPatterns;
	}
	
	@Override
	public HashMap<String,String> getNamespaces() {
		return this.namespaces;
	}
	
	@Override
	public void addNamespace(String prefix, String namespace) {
		this.namespaces.put(namespace, prefix);
	}

	@Override
	public void replaceAxiom(String oldAxiom, String newAxiom) {		
		int i = this.axioms.indexOf(oldAxiom);
		this.axioms.set(i, newAxiom);
		
		if (this.optionalAxioms.contains(oldAxiom)) {
			i = this.optionalAxioms.indexOf(oldAxiom);
			this.optionalAxioms.set(i, newAxiom);
		}			
	}

	@Override
	public void replacePlaceholder(String oldPlaceholder, String[] newPlaceholdersArray) {
		//if there is at least (some) one placeholder continue otherwise exits 
		//if (!newPlaceholders.matches(".*\\?.*")) return;
		//if (newPlaceholders.equals("")) return;
		if (newPlaceholdersArray.length==0) return; 
		
		for(int j=0; j<newPlaceholdersArray.length; j++) {			
			this.placeholders.put(newPlaceholdersArray[j], this.placeholders.get(oldPlaceholder));
		}
		this.placeholders.remove(oldPlaceholder);
	}	
	
	@Override
	public void replaceAxiom(String oldAxiom, String[] newAxiomsArray) {		
		if (newAxiomsArray.length==0) return; 
		int i = this.axioms.indexOf(oldAxiom);
		//System.out.println(i);
		this.axioms.set(i, newAxiomsArray[0]);
		for(int j=1; j<newAxiomsArray.length; j++) {			
			this.axioms.add(newAxiomsArray[j]);
		}
		
		if (this.optionalAxioms.contains(oldAxiom)) {
			i = this.optionalAxioms.indexOf(oldAxiom);
			//System.out.println(i);
			this.optionalAxioms.set(i, newAxiomsArray[0]);
			for(int j=1; j<newAxiomsArray.length; j++) {			
				this.optionalAxioms.add(newAxiomsArray[j]);
			}
		}
	}
}
