package cz.vse.keg.patomat.transformation.pattern;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Represents Ontology Pattern.
 * @author Ondrej Zamazal
 * 
 */

public interface OntologyPattern {

	//constant
	//public static final String OP="";
	public enum EntityType {Class, ObjectProperty, DatatypeProperty, AnnotationProperty, Individual, Literal, AnonymousIndividual, Uknown};
	
	public HashMap<String,EntityType> getPlaceholders();
	
	public HashMap<String,EntityType> getSpecifiedEntities();
	
	public ArrayList<String> getAxioms();
	
	public ArrayList<String> getOptionalAxioms(); //these axioms are not for detection phase 
	
	public void addPlaceholder(String placeholder, EntityType type);
	
	public void addSpecifiedEntity(String specified_entity, EntityType type);
	
	//public EntityType getType(String type);
	
	public void setPlaceholders();
	
	public void replacePlaceholder(String oldPlaceholder, String[] newPlaceholdersArray);
	
	public void addAxiom(String axiom);
	
	public void replaceAxiom(String oldAxiom, String newAxiom);
	
	public void replaceAxiom(String oldAxiom, String[] newAxiomsArray);
	
	public void addOptionalAxiom(String axiom);
	
	public ArrayList<NameDetectionPattern> getNameDetectionPatterns();
	
	public void addNameDetectionPattern(NameDetectionPattern n);
	
	public HashMap<String,String> getNamespaces(); //17-12-10, namespaces from tps as entities from doctype
	
	public void addNamespace(String prefix, String namespace);
}
