package cz.vse.keg.patomat.transformation.pattern;

import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

/**
 * @author Ondrej Zamazal
 * 
 */

public class NameDetectionPatternImpl implements NameDetectionPattern {
	
	private float threshold;
	private MeasureType measureType; //if levenshtein it calls OntoSim etc.
	private String entity1;
	private String entity2;
	private NamePatternType namePatternType;
	
	@Override
	public MeasureType getMeasureType() {		
		return measureType;
	}

	@Override
	public float getThreshold() {		
		return this.threshold;
	}

	@Override
	public void setMeasureType(String type) {
		if (type.equals("equal")) this.measureType=MeasureType.EQUAL;
		else if (type.equals("unequal")) this.measureType=MeasureType.UNEQUAL;
		else if (type.equals("levenshtein")) this.measureType=MeasureType.LEVENSHTEIN;
		else if (type.equals("jaro")) this.measureType=MeasureType.JARO;					
		else if (type.equals("hyperonym")) this.measureType=MeasureType.HYPERONYM;
		else if (type.equals("not_hyperonym")) this.measureType=MeasureType.NOT_HYPERONYM;
	}

	@Override
	public void setThreshold(float threshold) {
		this.threshold=threshold;		
	}

	@Override
	public String getEntity1() {		
		return this.entity1;
	}

	@Override
	public String getEntity2() {
		return this.entity2;
	}

	@Override
	public void setEntity1(String e) {
		this.entity1=e;
	}

	@Override
	public void setEntity2(String e) {
		this.entity2=e;
	}
	
	@Override
	public String toString() {
		return this.entity1+","+this.entity2+","+this.getThreshold()+","+this.measureType+","+this.namePatternType;
	}
	
	@Override
	public void setNamePatternType(String type) {
		if (type.equals("comparison")) this.namePatternType=NamePatternType.COMPARISON;
		else if (type.equals("exist")) this.namePatternType=NamePatternType.EXIST;						
	}

	@Override
	public NamePatternType getNamePatternType() {
		return namePatternType;
	}

	/*
	@Override
	public ArrayList<String> getInvolvedPlaceholders() {
		String s = entity1+entity2;
		//System.out.println(s);
		ArrayList<String> results=new ArrayList<String>();
		while (s.indexOf("?")!=-1) {
			int indexQ=s.indexOf("?");
			results.add(s.substring(indexQ, indexQ+2));
			s=s.substring(indexQ+2);
			//System.out.println(s);
		}
		return results;
	}
	*/
	@Override
	public ArrayList<String> getInvolvedPlaceholders() {
		ArrayList<String> results=new ArrayList<String>();
		results.addAll(this.getInvolvedPlaceholdersEntity1());
		results.addAll(this.getInvolvedPlaceholdersEntity2());
		return results;
	}
	/*public ArrayList<String> getInvolvedPlaceholdersEntity1() {
		String s = entity1;
		//System.out.println(s);
		ArrayList<String> results=new ArrayList<String>();
		while (s.indexOf("?")!=-1) {
			int indexQ=s.indexOf("?");
			results.add(s.substring(indexQ, indexQ+2));
			s=s.substring(indexQ+2);
			//System.out.println(s);
		}
		return results;
	}*/

	@Override
	public ArrayList<String> getInvolvedPlaceholdersEntity1() {
		String s = entity1;
		//System.out.println(s);
		
		Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
		
		Matcher matcher = pat.matcher(s);
		ArrayList<String> placeholders = new ArrayList<String>();
		while(matcher.find()) {        			
			placeholders.add(matcher.group());			
		}
				
		return placeholders;
	}
	/*
	@Override
	public ArrayList<String> getInvolvedPlaceholdersEntity2() {
		String s = entity2;
		//System.out.println(s);
		ArrayList<String> results=new ArrayList<String>();
		while (s.indexOf("?")!=-1) {
			int indexQ=s.indexOf("?");
			results.add(s.substring(indexQ, indexQ+2));
			s=s.substring(indexQ+2);
			//System.out.println(s);
		}
		return results;
	}			
	*/
	
	@Override
	public ArrayList<String> getInvolvedPlaceholdersEntity2() {
		//05-01-12, for the case in which there is no entity2 like for exists condition
		if (entity2==null) return new ArrayList<String>();
		String s = entity2;
		
		Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
		
		Matcher matcher = pat.matcher(s);
		ArrayList<String> placeholders = new ArrayList<String>();
		while(matcher.find()) {        			
			placeholders.add(matcher.group());			
		}
				
		return placeholders;
	}
	
	public static void main(String[] args) {
		NameDetectionPatternImpl ndp = new NameDetectionPatternImpl();
		ndp.threshold=1;
		ndp.entity1="head_noun(?OP1_A)";
		//ndp.entity1="?OP1_A";
		ndp.entity2="head_noun(?OP1_P)";
		//ndp.entity2="?OP1_P";
		ndp.measureType=MeasureType.EQUAL;
		ndp.namePatternType=NamePatternType.COMPARISON;
		
		System.out.println(ndp);
		System.out.println(ndp.getInvolvedPlaceholders());
	}
}
