package cz.vse.keg.patomat.transformation.pattern;

import java.util.ArrayList;

/**
 * Represents Naming Detection Pattern.
 * @author Ondrej Zamazal
 * 
 */

public interface NameDetectionPattern {
	
	public enum MeasureType {EQUAL, UNEQUAL, LEVENSHTEIN, JARO, HYPERONYM, NOT_HYPERONYM};
	
	public enum NamePatternType {COMPARISON, EXIST}
	
	public float getThreshold();
	
	public void setThreshold(float threshold);
	
	public MeasureType getMeasureType();
		
	public void setMeasureType(String type);
	
	public String getEntity1();
	
	public void setEntity1(String e);
	
	public String getEntity2();
	
	public void setEntity2(String e);
	
	public void setNamePatternType(String type);
	
	public NamePatternType getNamePatternType();
	
	public ArrayList<String> getInvolvedPlaceholders();
	
	public ArrayList<String> getInvolvedPlaceholdersEntity1();
	
	public ArrayList<String> getInvolvedPlaceholdersEntity2();
}
