package cz.vse.keg.patomat.transformation.pattern;

import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import cz.vse.keg.patomat.naming.NameEntity;
import cz.vse.keg.patomat.naming.NameEntityImpl;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern.EntityType;

import cz.vse.keg.patomat.transformation.pattern.PatternTransformation.Type;

/**
 * InstructionGeneratorImpl generates and exports transformation instructions.
 * @author Ondrej Zamazal
 * 
 */

public class InstructionGeneratorImpl implements InstructionGenerator {

	private TransformationPattern tp;
	private String ontology;
	private boolean POStagger;
	private String dictionaryPath;
	private String modelsPath;
	private HashSet<String> entitiesInstructions;
	private HashSet<String> opplScriptInstructions;
	private HashSet<String> annotationsInstructions;
	private boolean debuggingOutput=true;
	//29-06-12
	private HashMap<String,String> binding;
	private HashMap<String,String> namingOP2;
	
	/**
	 * InstructionGeneratorImpl constructor initializes all parameter according to arguments specifications.
	 * @param tp	transformation pattern
	 * @param POStagger	true/false whether POS tagger should be employed
	 * @param dictionaryPath	a path to WorNet-3.0, see constructor of OntologyTransformationImpl
	 * @param modelsPath	a path to language model employed in Stanford POS tagger, see constructor of OntologyTransformationImpl 
	 */
	public InstructionGeneratorImpl(TransformationPattern tp,boolean POStagger, String dictionaryPath, String modelsPath) {
		this.tp=tp;
		this.POStagger=POStagger;
		this.dictionaryPath=dictionaryPath;
		this.modelsPath=modelsPath;
		this.entitiesInstructions = new HashSet<String>();
		this.opplScriptInstructions = new HashSet<String>();
		this.annotationsInstructions = new HashSet<String>();
		this.binding = new HashMap<String,String>();
		this.namingOP2 = new HashMap<String,String>();
	}
	
	public HashMap<String,String> getOldBindings() {
		return this.binding;
	}
	
	public HashMap<String,String> getBindings() {
		return this.namingOP2;
	}
	
	@Override
	//30-03-10, reflecting the fact that OPPL cannot work with annotations!
	public ArrayList<String> getAxiomsForAdding(ArrayList<String> specifiedOP2OptionalPlaceholders) {		
		//except annotation, they are dealt with outside OPPL script
		//if (this.debuggingOutput) System.out.println(specifiedOP2OptionalPlaceholders);
		ArrayList<String> axiomsForAdding = new ArrayList<String>();
		boolean forAdding = true;
		for(String s : tp.getOP2().getAxioms()) {
			//if (this.debuggingOutput) System.out.println("axiom in OP2:"+s);
			//Pattern pat = Pattern.compile("\\?.");
			Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
			Matcher m;
			
			m = pat.matcher(s);		
			while(m.find()) {				
				//if there is placeholder from eqAnn link then this axiom is annotation axiom
				if (tp.getPT().getLinks(Type.eqAnn).containsValue(m.group())) {					
					forAdding=false;
					break;
				}
				//06-10-11, we can cope only with axioms which have all placeholders specified but in the case of OPTIONAL queries it can happen that not all placeholders are specified
				else if (!specifiedOP2OptionalPlaceholders.contains(m.group())) {
					if ((tp.getPT().getLinks(Type.eq).containsValue(m.group()))||(tp.getPT().getLinks(Type.eqHet).containsValue(m.group()))) {					
						forAdding=false;
						break;
					}					
				}
				else forAdding=true;
			}
			if (forAdding) {
				//if (this.debuggingOutput) System.out.println(s+" will be added");
				axiomsForAdding.add(s);
			}
		}
		return axiomsForAdding;
	}

	@Override
	//30-10-10, reflecting the fact that OPPL cannot work with annotations
	public ArrayList<String> getAnnotationAxiomsForAdding(ArrayList<String> specifiedOP2OptionalPlaceholders) {		
		//except annotation, they are dealt with outside OPPL script
		ArrayList<String> annotationAxiomsForAdding = new ArrayList<String>();
		boolean forAdding = true;
		for(String s : tp.getOP2().getAxioms()) {
			//Pattern pat = Pattern.compile("\\?.");
			Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
			Matcher m;
			
			m = pat.matcher(s);		
			if (this.debuggingOutput) System.out.println(s+" annotation?");
			while(m.find()) {				
				//if there is placeholder from eqAnn link then this axiom is annotation axiom
				//21-12-10, pomoci eqAnn se najdou vsechny anotace v getAnnotationAxiomsForAdding(), coz ale vylucuje nektere anotacni axiomy, jejichz entity nejsou v eqAnn -> TODO mozne vylepseni tak, aby se to poznalo na zaklade pouzite vlastnosti v anotacnim axiomu, napr. rdfs:seeAlso, annotation:value apod. - see below from 08-03-11 solution
				if (tp.getPT().getLinks(Type.eqAnn).containsValue(m.group())) {					
					if (this.debuggingOutput) System.out.println(s+" yes annotation");
					forAdding=true;
					break;
				}
				//06-10-11, we can cope only with axioms which have all placeholders specified but in the case of OPTIONAL queries it can happen that not all placeholders are specified
				else if (!specifiedOP2OptionalPlaceholders.contains(m.group())) {
					forAdding=false;
					break;
				}
				else {
					if (this.debuggingOutput) System.out.println(s+" no annotation");
					forAdding=false;
				}
			}
			if (forAdding)
				annotationAxiomsForAdding.add(s);							
		}
		//08-03-11, vylepseni anotacni axiomy jsou take takove, ktere maji v sobe anotacni vlastnost deklarovanou v ramci deklarace entit
		//jde to pres specified entities z deklarace entit
		for(String s : tp.getOP2().getSpecifiedEntities().keySet()) {
			if (tp.getOP2().getSpecifiedEntities().get(s).equals(EntityType.AnnotationProperty)) {
				if (this.debuggingOutput) System.out.println(s+" annotation property to check");
				for(String ss : tp.getOP2().getAxioms()) {
					if (this.debuggingOutput) System.out.println(ss+" annotation?");
					if (ss.matches(".*"+s+".*")) {
						if (this.debuggingOutput) System.out.println(s+" ano anotace");
						annotationAxiomsForAdding.add(ss);
						break;
					}
				}
			}
		}
		return annotationAxiomsForAdding;
	}
	
	@Override
	public ArrayList<String> getAxiomsForRemoving(Set<String> specifiedOP1OptionalPlaceholders) { 
		ArrayList<String> axiomsForRemoving = new ArrayList<String>();
		ArrayList<String> annotationProperties = new ArrayList<String>();
		boolean axiomRemoving=false;
		
		//08-03-11,priprava anotacnich vlastnosti
		for(String s : tp.getOP1().getSpecifiedEntities().keySet()) {
			if (tp.getOP1().getSpecifiedEntities().get(s).equals(EntityType.AnnotationProperty)) {
				annotationProperties.add(s);
				//if (this.debuggingOutput) System.out.println("anotacni vlastnost:"+s);
			}
		}
		
		for(String s : tp.getOP1().getAxioms()) {
			axiomRemoving=true;
			Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
			Matcher m;
			
			m = pat.matcher(s);					
			while(m.find()) {
				//06-10-11, we can cope only with axioms which have all placeholders specified but in the case of OPTIONAL queries it can happen that not all placeholders are specified
				if (!specifiedOP1OptionalPlaceholders.contains(m.group())) {
					axiomRemoving=false;
					break;
				}
			}
			
			//08-03-11, new version without annotation: convention!			
			for (String ss : annotationProperties) {
				if (s.matches(".*"+ss+".*")) {
			//if (!s.matches(".*annotation:.*"))
					axiomRemoving=false;
					break;
				}
			}
			
			if (axiomRemoving) axiomsForRemoving.add(s);
		}
		return axiomsForRemoving;
	}

	@Override
	public ArrayList<String> getEntitiesForAdding(ArrayList<String> specifiedOP2OptionalPlaceholders) {				
		ArrayList<String> entitiesForAdding = new ArrayList<String>();
		//if (this.debuggingOutput) System.out.println("OP2:"+tp.getOP2().getPlaceholders().keySet());
		//if (this.debuggingOutput) System.out.println("specified placeholders:"+specifiedOP2OptionalPlaceholders);
		for(String s : tp.getOP2().getPlaceholders().keySet()) {
			//06-10-11, only deal with placeholders which were specified during querying. There can also be unspecified placeholders from OPTIONAL parts of an query
			//if (this.debuggingOutput) System.out.println(s);
			//if (specifiedOP2OptionalPlaceholders.contains(s)) {
				//if (this.debuggingOutput) System.out.println("   "+s);
				//if (this.debuggingOutput) System.out.println("testing entities for adding "+s);
				//if (this.debuggingOutput) System.out.println(tp.getPT().getLinks(Type.any));
				//if (this.debuggingOutput) System.out.println("PT:"+tp.getPT().getLinks(Type.any));
				if (!tp.getPT().getLinks(Type.eq).containsValue(s)&&(!tp.getPT().getLinks(Type.eqHet).containsValue(s))) {
					if (this.debuggingOutput) System.out.println("add ADD("+s+",ENP("+tp.getPT().getENP().get(s)+")");
					entitiesForAdding.add(s);
				}
			//}
		}		
		return entitiesForAdding;
	}

	@Override
	public ArrayList<String> getEntitiesForRemoving(Set<String> specifiedOP1Placeholders) {
		ArrayList<String> entitiesForRemoving = new ArrayList<String>(); 
		for(String s : tp.getOP1().getPlaceholders().keySet()) {
			if (specifiedOP1Placeholders.contains(s)) {
				if (!tp.getPT().getLinks(Type.any).containsKey(s)) {
					if (this.debuggingOutput) System.out.println("REMOVE("+s+")");
					entitiesForRemoving.add(s);
				}
			}
		}		
		return entitiesForRemoving;
	}

	@Override
	public ArrayList<String> getEntitiesForRetyping(ArrayList<String> specifiedOP2OptionalPlaceholders) {		
		//from extralogical links
		ArrayList<String> entitiesForRetyping = new ArrayList<String>();
		//ArrayList<String> literalsForAdding = new ArrayList<String>();
		//ArrayList<String> classesForAdding = new ArrayList<String>();
		for(String s : tp.getOP2().getPlaceholders().keySet()) {	
			//06-10-11, only deal with placeholders which were specified during querying. There can also be unspecified placeholders from OPTIONAL parts of an query
			//if (this.debuggingOutput) System.out.println(s);
			//if (this.debuggingOutput) System.out.println("eqHet:"+tp.getPT().getLinks(Type.eqHet));
			//if (this.debuggingOutput) System.out.println(specifiedOP2OptionalPlaceholders);
			if (specifiedOP2OptionalPlaceholders.contains(s)) {
				//if (this.debuggingOutput) System.out.println("   yes");
				//30-03-10, currently eqAnn are dealt with outside OPPL so there is just eqHet
				if (tp.getPT().getLinks(Type.eqHet).containsValue(s)||tp.getPT().getLinks(Type.eqAnn).containsValue(s)) {
					if (this.debuggingOutput) System.out.println("ADD("+s+",ENP("+tp.getPT().getENP().get(s)+"))");
					entitiesForRetyping.add(s);//annotations
				}
			}
		}		
		return entitiesForRetyping;
	}
	
	//TODO:17-02-10,ziskani z query_results postupne jednotlive pattern_instances
	//nejsnazsi asi bude, kdyz to OntologyPatternDetectionImpl vrati ArrayList of XML bindings
	//a ten se muze prochazet v iteraci a postupne pripadne aplikovat patricne zmeny
	//ale mozna webova sluzba bude vracet jedno velke XML (query_results XML) a to se pak musi rozkouskovat do ArrayList<pattern_instance XML>
	
	//XML variant of input, output are instructions
	//15-02-11, generate instructions as lists
	/**
	 * This method generates instructions based on interplay between results of detection, pattern transformation, OP1 and OP2
	 * @param bindingPlaceholders	string representation of pattern instance from ontology pattern detection, i.e. binding (assignment) of placeholders
	 */
	public void generateInstructions(String bindingPlaceholders) {
		try {
			//29-06-12, for direct getting mapping between placeholders and detected entities
			HashMap<String,String> binding = new HashMap<String,String>();
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		    dbf.setNamespaceAware(true);	    
		    DocumentBuilder db = dbf.newDocumentBuilder();
		    Document doc = db.parse(new StringBufferInputStream(bindingPlaceholders));
			
		    //getting sparql binding:
		    //TODO,16-02-10,for each <pattern_instance> within <query_results> we call getInstructions once so it must be processed before 
		    XPath xpath = XPathFactory.newInstance().newXPath();
			String expression = "/pattern_instance/binding";		
			//rename
			NodeList nodesOP=null;
			
			nodesOP = (NodeList) xpath.evaluate(expression, doc,
					XPathConstants.NODESET);
			for(int i=0;i<nodesOP.getLength();i++) {				
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());
				binding.put(((Element)nodesOP.item(i)).getAttribute("placeholder"), ((Element)nodesOP.item(i)).getTextContent());
			}
			//08-03-11
			nodesOP = (NodeList) xpath.evaluate("/pattern_instance", doc,
					XPathConstants.NODESET);
			for(int i=0;i<nodesOP.getLength();i++) {				
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());
				this.ontology=((Element)nodesOP.item(i)).getAttribute("ontology");
			}
			generateInstructions(binding);
			this.binding = binding;
		}				
		catch(Exception e) {
			e.printStackTrace();
		}		
	}
	
	//15-02-11, export instructions as String
	/**
	 * This method exports all generated transformation instructions prepared by generateInstructions() method.
	 * @return string representation of transformation instructions
	 */
	public String exportInstructions() {
		StringBuilder xmlInstructions = new StringBuilder();
		xmlInstructions.append("<instructions ontology=\""+this.ontology+"\" tp=\""+this.tp.getLocation()+"\">\n");
		//TODO, 18-02-11, change consuming entities
		xmlInstructions.append("<entities>\n");
		for(String s : this.entitiesInstructions)
			xmlInstructions.append(s);		
		xmlInstructions.append("</entities>\n");
		xmlInstructions.append("<oppl_script>\n");
		for(String s : this.opplScriptInstructions)
			xmlInstructions.append(s);
		xmlInstructions.append("</oppl_script>\n");
		xmlInstructions.append("<annotations>\n");
		for(String s : this.annotationsInstructions)
			xmlInstructions.append(s);
		xmlInstructions.append("</annotations>\n");
		xmlInstructions.append("</instructions>\n");
		return xmlInstructions.toString();
	}
	
	@Override
	//get instructions in XML, input binding as a hashMap
	//15-02-11, generate instructions as lists
	/**
	 * This method generates instructions based on interplay between results of detection, pattern transformation, OP1 and OP2
	 * @param binding	representation of pattern instance from ontology pattern detection, i.e. binding (assignment) of placeholders
	 */
	public void generateInstructions(HashMap<String,String> binding) {		
		//06-10-11, entities which were not bound because of OPTIONAL parts and those should be ignored from further processing: adding entities, axioms, retyping etc.
		ArrayList<String> specifiedOP2OptionalPlaceholders = this.getSpecifiedOP2OptionalPlaceholders(binding.keySet());
		//if (this.debuggingOutput) System.out.println("binding:"+binding);
		if (this.debuggingOutput) System.out.println("specifiedOP2OptionalPlaceholders:"+specifiedOP2OptionalPlaceholders);
		//18-02-11
		//here we will bind placeholders with specified entities
		//naming for all entities from OP2:
		ArrayList<String> entitiesForAdding = this.getEntitiesForAdding(specifiedOP2OptionalPlaceholders); 
		ArrayList<String> entitiesForRetyping = this.getEntitiesForRetyping(specifiedOP2OptionalPlaceholders);
		//07-02-11
		ArrayList<String> entitiesForRemoving = this.getEntitiesForRemoving(binding.keySet());
		//entitiesForRenaming is rather entities for naming from OP2 which are in eq links
		HashMap<String,String> entitiesForRenaming = this.getEntitiesForRenaming(binding.keySet());
		HashMap<String,String> namingInstructions = tp.getPT().getENP();
		//30-03-10 naming for entities which this is not specified in ENP:
		//this information is taken from links
		for(String s : tp.getPT().getLinks(Type.any).keySet()) {
			//if there is no naming instruction for this entity then we will add it
			if (!namingInstructions.containsKey(tp.getPT().getLinks(Type.any).get(s))) {
				namingInstructions.put(tp.getPT().getLinks(Type.any).get(s), s);
			}
		}		
		NameEntity ne = new NameEntityImpl(binding,this.POStagger, this.dictionaryPath, this.modelsPath);
		//16-03-10
		if (this.debuggingOutput) System.out.println("binding:"+binding);
		if (this.debuggingOutput) System.out.println("ni:"+namingInstructions);
		if (this.debuggingOutput) System.out.println("entities for renaming:"+entitiesForRenaming);
		if (this.debuggingOutput) System.out.println("entities for adding:"+entitiesForAdding);
		if (this.debuggingOutput) System.out.println("entities for retyping:"+entitiesForRetyping);
		//07-02-11
		if (this.debuggingOutput) System.out.println("entities for removing:"+entitiesForRemoving);
		
		//Map<String,String> namingOP2 = Collections.synchronizedMap(new HashMap<String,String>()); 
		HashMap<String,String> namingOP2 = new HashMap<String,String>();
		//naming for all placeholders from OP2			
		//07-02-11, here we have instructions for removing entities
		//NOTE: maybe we could do adding entities by ourselves but currently OPPL does this for us using ! and in the case of different IRIs some customized classes
		if(!entitiesForRemoving.isEmpty()) {			
			for(String s : entitiesForRemoving) {
				switch (tp.getOP1().getPlaceholders().get(s)) {
					case ObjectProperty:						
						this.entitiesInstructions.add(("<remove type=\"ObjectProperty\">"+binding.get(s)+"</remove>\n"));
						break;
					case AnnotationProperty:
						this.entitiesInstructions.add("<remove type=\"AnnotationProperty\">"+binding.get(s)+"</remove>\n");						
						break;
					case DatatypeProperty:
						this.entitiesInstructions.add("<remove type=\"DatatypeProperty\">"+binding.get(s)+"</remove>\n");						
						break;
					case Class:
						this.entitiesInstructions.add("<remove type=\"Class\">"+binding.get(s)+"</remove>\n");
						break;
					case Individual:
						this.entitiesInstructions.add("<remove type=\"Individual\">"+binding.get(s)+"</remove>\n");
						break;
					default:
						this.entitiesInstructions.add("<remove type=\"Uknown\">"+binding.get(s)+"</remove>\n");
						break;
				}
			}						
		}
		//TODO,18-02-11																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																					
		for (String s : tp.getOP2().getPlaceholders().keySet()) {
			//adding entities using OPPL
			if (entitiesForAdding.contains(s)) { 
				//TODO: add naming according to ENP
				//this task for some lexicalEngine 
				if (this.debuggingOutput) System.out.println("again:"+s+" "+namingInstructions.get(s));
				if (namingInstructions.containsKey(s))
					namingOP2.put(s,  "!"+ne.getName(namingInstructions.get(s)).toString());
				else
					namingOP2.put(s, "!NTF"); //adding new entity using OPPL - exclamation mark
			}//add new entity of proper type
			else if (entitiesForRetyping.contains(s)) {
				if (namingInstructions.containsKey(s))
					namingOP2.put(s,  "!"+ne.getName(namingInstructions.get(s)));
					//namingOP2.put(s,  ne.getName(namingInstructions.get(s)).toString());
				else
					namingOP2.put(s, "!NTF");
			}
			//renaming existing entities
			else if (entitiesForRenaming.containsKey(s)) {				
				//this task for some lexicalEngine
				//if there is no ENP for particular entity than it is plain name of eq entity
				if (namingInstructions.containsKey(s)) {
					//if (this.debuggingOutput) System.out.println("naming...");//rename accordingly
					/*
					if (binding.get(entitiesForRenaming.get(s)).equals(ne.getName(namingInstructions.get(s)))) {
						//actually,there is no renaming
						namingOP2.put(s, binding.get(entitiesForRenaming.get(s)));
					}
					else {
						//renaming afterwards
						xmlInstructions.append(b)
					}*/
					//11-02-10,actually, renaming is applied after OPPL instructions
					//so in OPPL instructions there are original names
					//16-04-10, commented the following, because we need already new name of entity in instructions below:
					//namingOP2.put(s, binding.get(entitiesForRenaming.get(s)));
					//if (this.debuggingOutput) System.out.println(s+" "+binding.get(entitiesForRenaming.get(s)));
					String newName=ne.getName(namingInstructions.get(s)).toString();
					//16-04-10, already new name put into namingOP2 for further using in instructions:
					namingOP2.put(s, newName);
					switch (tp.getOP2().getPlaceholders().get(s)) {
						case ObjectProperty:
							this.entitiesInstructions.add("<rename type=\"ObjectProperty\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</rename>\n");
							//TODO: reflect this change to consuming XML in OntologyTransformationImpl
							//xmlInstructions.append("<entity type=\"ObjectProperty\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</entity>\n");
							break;
						case AnnotationProperty:
							//xmlInstructions.append("<entity type=\"AnnotationProperty\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</entity>\n");
							this.entitiesInstructions.add("<rename type=\"AnnotationProperty\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</rename>\n");
							break;
						case DatatypeProperty:
							//xmlInstructions.append("<entity type=\"DatatypeProperty\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</entity>\n");
							this.entitiesInstructions.add("<rename type=\"DatatypeProperty\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</rename>\n");
							break;
						case Class:
							//xmlInstructions.append("<entity type=\"Class\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</entity>\n");
							this.entitiesInstructions.add("<rename type=\"Class\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</rename>\n");
							break;
						case Individual:
							//xmlInstructions.append("<entity type=\"Individual\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</entity>\n");
							this.entitiesInstructions.add("<rename type=\"Individual\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</rename>\n");
							break;
						case Literal:
							//xmlInstructions.append("<entity type=\"Individual\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</entity>\n");
							this.entitiesInstructions.add("<rename type=\"Literal\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</rename>\n");
							break;
						default:
							//xmlInstructions.append("<entity type=\"Uknown\" original_name=\""+s+"\">"+newName+"</entity>\n");
							this.entitiesInstructions.add("<rename type=\"Uknown\" original_name=\""+binding.get(entitiesForRenaming.get(s))+"\">"+newName+"</rename>\n");
							break;
					}
					//xmlInstructions.append("<RENAME entity=""></rename>")
					//namingOP2.put(s, ne.getName(namingInstructions.get(s)).toString());
				}
				else 
					namingOP2.put(s, binding.get(entitiesForRenaming.get(s)));
			}			
		}				
		
		if (this.debuggingOutput) System.out.println(namingOP2);
		if (this.debuggingOutput) System.out.println("Instructions in XML:");
		//13-04-10, additional check whether entity named is class (first letter upper-case) or not (first letter lower-case)		
		String p = "";								
		
		for (Map.Entry<String, String> e : namingOP2.entrySet()) {				    
		    if (!tp.getOP2().getPlaceholders().get(e.getKey()).name().equals("Class")) {
		    	p = e.getValue();
				if (p.matches("!.*")) 
					p = "!"+p.substring(1,2).toLowerCase()+p.substring(2); 
				else
					//NOTE, 07-10-11: I just removed the following line. Is this correct? Now it works for nominals: small_pizza_with_nominals.owl
					//p = p.substring(0,1).toLowerCase()+p.substring(1);
				if (this.debuggingOutput) System.out.println(p);
		    	e.setValue(p);
		    }
		}				
		
		if (this.debuggingOutput) System.out.println(namingOP2);		
		ArrayList<String> axiomsForAdding = this.getAxiomsForAdding(specifiedOP2OptionalPlaceholders); 
		ArrayList<String> annotationAxiomsForAdding = this.getAnnotationAxiomsForAdding(specifiedOP2OptionalPlaceholders);
		ArrayList<String> axiomsForRemoving = this.getAxiomsForRemoving(binding.keySet());
		//17-12-10
		//kontrola, ze se mazou jen takove axiomy, ktere se pak hned zase nepridavaji!	
		ArrayList<String> axiomsForAddingFullName = new ArrayList<String>();
		ArrayList<String> axiomsForRemovingFullName = new ArrayList<String>();
		
		//Pattern pat = Pattern.compile("\\?.");
		Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
		Matcher m;
		StringBuilder str = new StringBuilder("BEGIN \n");
		//remove axioms
		//17-12-10
		//kontrola, ze se mazou jen takove axiomy, ktere se pak hned zase nepridavaji!
		int i=0;
		for(String s : axiomsForRemoving) {
			i++;					
			//if (this.debuggingOutput) System.out.println(s);
			m = pat.matcher(s);		
			while(m.find()) {
				if (this.debuggingOutput) System.out.println(s);
				if (this.debuggingOutput) System.out.println("test "+m.group()+" cim "+binding.get(m.group()));
				//str.append(s.replace(this.getEntitiesForRenaming().get(m.group()),binding.get(m.group())));
				//if (this.debuggingOutput) System.out.println(m.group());
				//29-02-12, explicitly adding namespace of active ontology not imported one, base will be replace during transformation as such by proper namespace of given ontology
				s=s.replaceAll("\\"+m.group()+" ", binding.get(m.group())+" ");
				//s=s.replaceAll("\\"+m.group()+" ", "baseNamespace@"+binding.get(m.group())+" ");
				//09-01-12, z axiomu, ktere maji directSubClassOf udelame axiomy se subClassOf
				s=s.replaceAll("directSubClassOf","subClassOf");
			}
			axiomsForRemovingFullName.add(s);					
		}
		//add axioms
		i=0;
		for(String s : axiomsForAdding) {
			//07-11-11, skip annotations axioms because they need special care, see below in section for(String s : annotationAxiomsForAdding)
			if (annotationAxiomsForAdding.contains(s))
				continue;
			i++;
			//if (this.debuggingOutput) System.out.println("for adding:"+ s);
			m = pat.matcher(s);		
			while(m.find()) {				
				if (this.debuggingOutput) System.out.println("test "+m.group());
				//if (this.debuggingOutput) System.out.println("nahradit co: "+m.group());
				//if (this.debuggingOutput) System.out.println(" >"+namingOP2.get(m.group()));
				//if (namingOP2.get(m.group()).indexOf("!")!=-1)
				//		s=s.replaceAll("\\"+m.group(), "\\"+namingOP2.get(m.group()));
				//else					
					s=s.replaceAll("\\"+m.group(), namingOP2.get(m.group()));
					//09-01-12, z axiomu, ktere maji directSubClassOf udelame axiomy se subClassOf
					s=s.replaceAll("directSubClassOf","subClassOf");
			}
			//17-12-10
			//kontrola, ze se mazou jen takove axiomy, ktere se pak hned zase nepridavaji!
			if (axiomsForRemovingFullName.contains(s)) {
				axiomsForRemovingFullName.remove(s);
			}
			else {
				axiomsForAddingFullName.add(s);
			}					
		}
		//17-12-10
		//v axiomsForRemovingFullName jiz redukovany parove ADD-REMOVE axiomy
		for (String s : axiomsForRemovingFullName) {
			this.opplScriptInstructions.add("<remove>"+s+"</remove>\n");
			//xmlInstructions.append("<remove>"+s+"</remove>\n");
			if (i!=axiomsForRemoving.size())
				str.append("REMOVE "+s+",\n");
			else str.append("REMOVE "+s+"\n");	
		}		
		//17-12-10
		//v axiomsForAddingFullName jiz redukovany parove ADD-REMOVE axiomy
		for (String s : axiomsForAddingFullName) {
			this.opplScriptInstructions.add("<add>"+s+"</add>\n");
			//xmlInstructions.append("<add>"+s+"</add>\n");
			if (i!=axiomsForAdding.size())
				str.append("ADD "+s+",\n");
			else str.append("ADD "+s+"\n");
		}
		str.append("END;");						
		String annotationToEntity="";
		for(String s : annotationAxiomsForAdding) {
			i++;
			if (this.debuggingOutput) System.out.println(s);
			m = pat.matcher(s);
			i=0;
			while(m.find()) {
				i++;
				//if (i==1) annotationToEntity=tp.getOP2().getPlaceholders().get(m.group()).name();
				//07-11-11, for any placeholder get first type of placeholder:
				annotationToEntity=tp.getOP2().getPlaceholders().get(m.group()).name();
				
				//if (this.debuggingOutput) System.out.println("type in annotation "+m.group()+" is "+annotationToEntity);
				//if (this.debuggingOutput) System.out.println("replaced by "+annotationToEntity+" "+namingOP2.get(m.group()));
				s=s.replaceAll("\\"+m.group(), annotationToEntity+" "+namingOP2.get(m.group()));
				//s=s.replaceAll(namingOP2.get(m.group()), annotationToEntity+" "+namingOP2.get(m.group()));
			}
			//this.annotationsInstructions.add("<add>"+annotationToEntity+" "+s+"</add>\n");
			//07-11-11, for any placeholder get first type of placeholder:
			this.annotationsInstructions.add("<add>"+s+"</add>\n");
			//xmlInstructions.append("<add>"+annotationToEntity+" "+s+"</add>\n");			
		}				
		//if (this.debuggingOutput) System.out.println(str);
		if (this.debuggingOutput) System.out.println(this.entitiesInstructions);
		if (this.debuggingOutput) System.out.println(this.opplScriptInstructions);
		if (this.debuggingOutput) System.out.println(this.annotationsInstructions);
		
		this.namingOP2 = namingOP2;
		
		ne.finish();
	}

	@Override
	public HashMap<String,String> getEntitiesForRenaming(Set<String> specifiedOP1OptionalPlaceholders) {
		HashMap<String,String> entitiesForRenaming = new HashMap<String,String>();
		for (String key : tp.getPT().getLinks(Type.eq).keySet()) {
			if (specifiedOP1OptionalPlaceholders.contains(key)) {
				//from op1perspective
				entitiesForRenaming.put(key, "ENP("+tp.getPT().getLinks(Type.eq).get(key)+")");			
				//from op2 perspective:
				entitiesForRenaming.put(tp.getPT().getLinks(Type.eq).get(key), key);
				//value = tp.getPT().getLinks(Type.eq).get(key)
			}
		}
		return entitiesForRenaming;
	}
	
	//@Override
	public ArrayList<String> getSpecifiedOP2OptionalPlaceholders(Set<String> specifiedOP1Placeholders) {				
		ArrayList<String> specifiedOP2OptionalPlaceholders = new ArrayList<String>(); 
		for (String key : tp.getPT().getLinks(Type.eq).keySet()) {
			if(specifiedOP1Placeholders.contains(key)) {				
				specifiedOP2OptionalPlaceholders.add(tp.getPT().getLinks(Type.eq).get(key));
			}
		}
		for (String key : tp.getPT().getLinks(Type.eqHet).keySet()) {
			if(specifiedOP1Placeholders.contains(key)) {				
				specifiedOP2OptionalPlaceholders.add(tp.getPT().getLinks(Type.eqHet).get(key));
			}
		}		
		return specifiedOP2OptionalPlaceholders;
	}
	
}
