package cz.vse.keg.patomat.transformation.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

/*
 * Generic generator of instructions for OPPL or other languages
 * */

/**
 * @author Ondrej Zamazal
 * 
 */

public interface InstructionGenerator {
	
	public ArrayList<String> getSpecifiedOP2OptionalPlaceholders(Set<String> specifiedOP1Placeholders);	
	
	public ArrayList<String> getEntitiesForAdding(ArrayList<String> specifiedOP2OptionalPlaceholders);
	
	public ArrayList<String> getEntitiesForRemoving(Set<String> specifiedOP1OptionalPlaceholders);
	
	public ArrayList<String> getEntitiesForRetyping(ArrayList<String> specifiedOP2OptionalPlaceholders);
	
	public HashMap<String,String> getEntitiesForRenaming(Set<String> specifiedOP2Placeholders);
	
	public ArrayList<String> getAxiomsForAdding(ArrayList<String> specifiedOP2OptionalPlaceholders);

	public ArrayList<String> getAnnotationAxiomsForAdding(ArrayList<String> specifiedOP2OptionalPlaceholders);

	public ArrayList<String> getAxiomsForRemoving(Set<String> specifiedOP1OptionalPlaceholders);
	
	public HashMap<String,String> getOldBindings(); 
	
	public HashMap<String,String> getBindings();
	/*
	//All instructions in one processable (by implementations of TransformationOntology) StringBuilder
	public StringBuilder getInstructions(HashMap<String,String> binding);
	//for XML variant of input binding
	public StringBuilder getInstructions(String binding);
	*/
	//All instructions in one processable (by implementations of TransformationOntology) StringBuilder
	//15-02-11, store instructions into lists
	public void generateInstructions(HashMap<String,String> binding);
	//for XML variant of input binding
	public void generateInstructions(String binding);
	//15-02-11, export instructions as String
	public String exportInstructions();
	
}

//implement: InstructionGeneratorWithOPPL