package cz.vse.keg.patomat.transformation;

import java.util.List;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
//import java.io.StringBufferInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.coode.oppl.OPPLScript;
import org.coode.oppl.OPPLParser;
//import org.coode.parsers.ErrorListener;
import org.coode.parsers.common.JUnitTestErrorListener;
//import org.coode.parsers.common.SystemErrorEcho;
//import org.coode.patterns.OPPLPatternParser;
//import org.coode.patterns.ParserFactory;
//import org.coode.patterns.PatternModel;
//import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationObject;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntologyChange;
//import org.semanticweb.owlapi.model.OWLConstant;
//import org.semanticweb.owlapi.model.OWLConstantAnnotation;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
//import org.semanticweb.owlapi.model.OWLEntityAnnotationAxiom;
//import org.semanticweb.owlapi.model.OWLObjectAnnotation;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLEntityRemover;
import org.semanticweb.owlapi.util.OWLEntityRenamer;
//import org.semanticweb.owlapi.vocab.NamespaceOWLOntologyFormat;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import com.hp.hpl.jena.ontology.impl.OWLProfile;

import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyRangeAxiomImpl;
//import org.semanticweb.owl.io.StringInputSource;

import cz.vse.keg.patomat.transformation.pattern.EntityTypeException;
import cz.vse.keg.patomat.transformation.pattern.OntologyPatternImpl;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern.EntityType;
import cz.vse.keg.patomat.util.URLGrabber;

/**
 * Entity class represents entity with its local name and type.
 * @author Ondrej Zamazal
 * 
 */

class Entity {
	private String name;
	private EntityType type;
	
	public Entity(String name, String type) {
		this.name=name;
		this.type=OntologyPatternImpl.getType(type);
	}
	
	public String getName() {
		return this.name;
	}
	
	public EntityType getType() {
		return this.type;
	}
}

/**
 * OntologyTransformationImpl class implements OntologyTransformation. It enables manipulation/transformation with an ontology.
 * @author Ondrej Zamazal
 * 
 */

public class OntologyTransformationImpl implements OntologyTransformation<OWLOntology> {

	protected OWLOntology ontology;
	protected OWLOntologyManager manager;
	protected OWLDataFactory factory;
	protected String base;
	protected String url="";
	protected String tpLocation ="";
	protected StringBuilder OPPLinstructionsAdding;
	//07-02-11,OPPLinstructionsRemoving jen pro mazani
	//07-02-11,OPPLinstructionsAdding jen pro pridani axiomu a entit
	protected StringBuilder OPPLinstructionsRemoving;
	protected ArrayList<String> annotationsDueToRemovingAxioms;
	protected ArrayList<String> annotationsDueToAddingAxioms;
	protected HashMap<Entity,String> renamingEntitiesInstructions;
	//07-02-11
	protected HashSet<Entity> removingEntities;
	protected HashSet<String> addingAnnotationsAxioms;
	//17-01-11,because of entities from different IRI namespaces:
	protected HashMap<String,String> newNamespaces;
	//wordnet and NLP (for Stanford postagger) setting:
	protected String dictionaryPath, modelsPath;
	private boolean debuggingOutput=false;
	
	//23-04-12, will this make any effect?
	public boolean willTransformOntology() {
		if (    (this.removingEntities.isEmpty()) && 
				(this.OPPLinstructionsRemoving.toString().trim().equals("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN\nEND;")) &&
				(this.renamingEntitiesInstructions.isEmpty()) &&
				(this.OPPLinstructionsAdding.toString().trim().equals("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN\nEND;")) &&
				(this.addingAnnotationsAxioms.isEmpty())				
			)
			return false;		
		return true;
	}
	
	/**
	 * OntologyTransformationImpl constructor loads an ontology resides at given url and initializes parameters such as dictionaryPath and modelsPath from config.properties file.  
	 * @param url	a link to the source ontology
	 */
	public OntologyTransformationImpl(String url) {		
		//init from config.properties for wordnet and models tagger stanford:
		try {		
			//File f = new File("config.properties");			
			BufferedReader vstup = new BufferedReader(new FileReader ("config.properties"));
			//if (this.debuggingOutput) System.out.println(f.getAbsolutePath());
			//BufferedReader vstup = new BufferedReader(new FileReader (f));			
			  String row;
			  row = vstup.readLine();
			  if (row != null)
				  this.dictionaryPath=row.substring(row.indexOf("=")+2,row.length()-1);
			  row = vstup.readLine();
			  if (row != null)
				  this.modelsPath=row.substring(row.indexOf("=")+2,row.length()-1);			  
			  vstup.close();
		}
		catch (FileNotFoundException e) {
			if (this.debuggingOutput) System.out.println ("File does not exist");
		}
		catch (IOException e){
			if (this.debuggingOutput) System.out.println ("Error on input of a file");
		}
				
		this.renamingEntitiesInstructions = new HashMap<Entity,String>();
		this.removingEntities = new HashSet<Entity>();
		this.addingAnnotationsAxioms = new HashSet<String>();
		this.OPPLinstructionsRemoving = new StringBuilder();
		this.annotationsDueToRemovingAxioms = new ArrayList<String>();
		this.annotationsDueToAddingAxioms = new ArrayList<String>();
		this.OPPLinstructionsAdding = new StringBuilder();
		this.manager = OWLManager.createOWLOntologyManager();
		this.factory = manager.getOWLDataFactory();
		this.url = url;
		this.newNamespaces = new HashMap<String,String>();
		try {
			//ontology:
			//this.ontology = manager.loadOntologyFromPhysicalURI(URI.create(url));			
			//09-03-10,ontology can be directly file as String or referring URL
			if ((this.url.matches("^http.*"))||(this.url.matches("^file.*"))) {
				setOntology(this.manager.loadOntologyFromOntologyDocument(IRI.create(this.url)));
				//this.url=url;
			}
			else {
				//InputStream in = new ByteArrayInputStream(url.getBytes()); for owl-api 3.0.0
				//setOntology(this.manager.loadOntologyFromOntologyDocument(new StringInputSource(url))); for owl-api 2
				InputStream in = new ByteArrayInputStream(this.url.getBytes()); //for owl-api 3.0.0
				this.ontology=this.manager.loadOntologyFromOntologyDocument(in);
				in.close();
			}			
			this.base = getBaseURI(":");
			//if (this.debuggingOutput) System.out.println("base="+this.base);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public OntologyTransformationImpl(OWLOntology ont) {		
		try {		
			//File f = new File("config.properties");			
			BufferedReader vstup = new BufferedReader(new FileReader ("config.properties"));
			//if (this.debuggingOutput) System.out.println(f.getAbsolutePath());
			//BufferedReader vstup = new BufferedReader(new FileReader (f));			
			  String row;
			  row = vstup.readLine();
			  if (row != null)
				  this.dictionaryPath=row.substring(row.indexOf("=")+2,row.length()-1);
			  row = vstup.readLine();
			  if (row != null)
				  this.modelsPath=row.substring(row.indexOf("=")+2,row.length()-1);			  
			  vstup.close();
		}
		catch (FileNotFoundException e) {
			if (this.debuggingOutput) System.out.println ("File does not exist");
		}
		catch (IOException e){
			if (this.debuggingOutput) System.out.println ("Error on input of a file");
		}
				
		this.renamingEntitiesInstructions = new HashMap<Entity,String>();
		this.removingEntities = new HashSet<Entity>();
		this.addingAnnotationsAxioms = new HashSet<String>();
		this.OPPLinstructionsRemoving = new StringBuilder();
		this.annotationsDueToRemovingAxioms = new ArrayList<String>();
		this.annotationsDueToAddingAxioms = new ArrayList<String>();
		this.OPPLinstructionsAdding = new StringBuilder();
		this.ontology=ont;
		this.manager = this.ontology.getOWLOntologyManager();
		//this.manager = OWLManager.createOWLOntologyManager();
		this.factory = this.manager.getOWLDataFactory();		
		this.newNamespaces = new HashMap<String,String>();
		this.base = getBaseURI(":");
				
	}
	
	
	
	/**
	 * OntologyTransformationImpl constructor loads an ontology resides at given url and initializes parameters such as dictionaryPath and modelsPath as specified in arguments of this constructor.  
	 * @param url	a link to the source ontology
	 * @param wordnetPath	a path to the root directory of WordNet-3.0 installation, e.g. "/usr/share/WordNet-3.0/"
	 * @param modelPath	a path to language model (left3words-wsj-0-18.tagger) employed in Stanford POS tagger, e.g. "/usr/share/models/" 
	 */
	public OntologyTransformationImpl(String url, String wordnetPath, String modelPath) {
		//without config.properties for wordnet and models tagger stanford:
		
		this.dictionaryPath=wordnetPath;
		this.modelsPath=modelPath;
		
		this.renamingEntitiesInstructions = new HashMap<Entity,String>();
		this.removingEntities = new HashSet<Entity>();
		this.addingAnnotationsAxioms = new HashSet<String>();
		this.OPPLinstructionsRemoving = new StringBuilder();
		this.annotationsDueToRemovingAxioms = new ArrayList<String>();
		this.annotationsDueToAddingAxioms = new ArrayList<String>();
		this.OPPLinstructionsAdding = new StringBuilder();
		this.manager = OWLManager.createOWLOntologyManager();
		this.factory = manager.getOWLDataFactory();
		this.url = url;
		this.newNamespaces = new HashMap<String,String>();
		try {
			//ontology:
			//this.ontology = manager.loadOntologyFromPhysicalURI(URI.create(url));			
			//09-03-10,ontology can be directly file as String or referring URL
			if ((this.url.matches("^http.*"))||(this.url.matches("^file.*"))) {
				setOntology(this.manager.loadOntologyFromOntologyDocument(IRI.create(this.url)));
				//this.url=url;
			}
			else {
				//InputStream in = new ByteArrayInputStream(url.getBytes()); for owl-api 3.0.0
				//setOntology(this.manager.loadOntologyFromOntologyDocument(new StringInputSource(url))); for owl-api 2
				InputStream in = new ByteArrayInputStream(this.url.getBytes()); //for owl-api 3.0.0
				this.ontology=this.manager.loadOntologyFromOntologyDocument(in);
				in.close();
			}				
			this.base = getBaseURI(":");
			//if (this.debuggingOutput) System.out.println("base="+this.base);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private String getBaseURI(String namespace) {
	  	Map<String, String> nsMap = null;
	    OWLOntologyFormat format = this.manager.getOntologyFormat(this.ontology);
		if(format instanceof PrefixOWLOntologyFormat) {
			PrefixOWLOntologyFormat nsFormat =
			(PrefixOWLOntologyFormat) format;
			nsMap =
				nsFormat.getPrefixName2PrefixMap();
			//nsFormat.getNamespacesByPrefixMap(); owl-api 2
			//if (this.debuggingOutput) System.out.println(nsMap.keySet());
			//return nsFormat.getPrefix("");
			return nsMap.get(namespace);
		}
		else return "";										
	}
	
	private void setNewPrefix(String prefix, String namespace) {	  	
	    OWLOntologyFormat format = manager.getOntologyFormat(ontology);
		if(format instanceof PrefixOWLOntologyFormat) {					
			((PrefixOWLOntologyFormat) format).setPrefix(prefix, namespace);
		}											
	}
	
	/**
	 * This method loads instructions which should be followed during transformation itself.
	 * @param instructions	the whole instructions in one string 
	 * @Override
	 */	
	public void setInstructions(String instructions) {		
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		    dbf.setNamespaceAware(true);
		    //dbf.setValidating(true);
		    //dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage",
		    //                 "http://www.w3.org/2001/XMLSchema");
		    //dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource",
		    //                 "http://www.example.com/Report.xsd");
		    DocumentBuilder db = dbf.newDocumentBuilder();
		    //Document doc = db.parse(uriXML);
		    //Document doc = db.parse("file:///home/ondrej/doktorandsky/PatOMat/TPs/tp1.xml");
		    //Document doc = db.parse("file:///home/ondrej/doktorandsky/PatOMat/TPs/tp_hasValue2.xml");
		    //Document doc = db.parse(new StringBufferInputStream(instructions));
		    Document doc = db.parse(new ByteArrayInputStream(instructions.getBytes()));
			//16-12-10, doctype entities as namespaces in query in OntologyPatternDetection
		    /*
		    int number_of_nodes = doc.getDoctype().getEntities().getLength();
		    if (this.debuggingOutput) System.out.println("number of nodes:"+number_of_nodes);
		    for(int i=0;i<number_of_nodes;i++) {
		    	//Node n = doc.getDoctype().getEntities().item(i);
		    	if (this.debuggingOutput) System.out.println("entities");
		    	if (this.debuggingOutput) System.out.println(doc.getDoctype().getEntities().item(i));		    
		    }*/		   
		    //getting instructions:
		    XPath xpath = XPathFactory.newInstance().newXPath();
			//String expression = "/instructions/rename/entity";		
		    String expression = "/instructions/entities/rename";
			//rename
			NodeList nodesOP;
			nodesOP = (NodeList) xpath.evaluate(expression, doc,
                XPathConstants.NODESET);			
			for(int i=0;i<nodesOP.getLength();i++) {				
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());
				if (!((Element)nodesOP.item(i)).getAttribute("original_name").equals(((Element)nodesOP.item(i)).getTextContent()))
					//renamingEntitiesInstructions.put((new Entity (((Element)nodesOP.item(i)).getAttribute("original_name")),(((Element)nodesOP.item(i)).getAttribute("type")))), ((Element)nodesOP.item(i)).getTextContent()));
					renamingEntitiesInstructions.put(new Entity (((Element)nodesOP.item(i)).getAttribute("original_name"),((Element)nodesOP.item(i)).getAttribute("type")), ((Element)nodesOP.item(i)).getTextContent());
			}
			//18-02-11, get uri of the transformation pattern
			expression = "/instructions";								
			nodesOP = (NodeList) xpath.evaluate(expression, doc,
                XPathConstants.NODESET);			
			for(int i=0;i<nodesOP.getLength();i++) {
				this.tpLocation = ((Element)nodesOP.item(i)).getAttribute("tp");
			}
			//07-02-10, entities removing
			expression = "/instructions/entities/remove";								
			nodesOP = (NodeList) xpath.evaluate(expression, doc,
                XPathConstants.NODESET);			
			for(int i=0;i<nodesOP.getLength();i++) {				
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());				
					//renamingEntitiesInstructions.put((new Entity (((Element)nodesOP.item(i)).getAttribute("original_name")),(((Element)nodesOP.item(i)).getAttribute("type")))), ((Element)nodesOP.item(i)).getTextContent()));
					removingEntities.add(new Entity (((Element)nodesOP.item(i)).getTextContent(),((Element)nodesOP.item(i)).getAttribute("type")));
			}
			//30-03-10, annotations
			expression = "/instructions/annotations/add";
			nodesOP = (NodeList) xpath.evaluate(expression, doc,
                XPathConstants.NODESET);			
			for(int i=0;i<nodesOP.getLength();i++) {				
				//if (this.debuggingOutput) System.out.print(nodesOP.item(i).getTextContent());									
				addingAnnotationsAxioms.add(((Element)nodesOP.item(i)).getTextContent().replaceAll("!", ""));				
			}	
			//oppl_script			
			//13-01-11, vratil jsem se k OPPL Script, kam jsem pridal jen "?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y ", ktere se pak nepouziva. Vypada to, ze to funguje ale neni to moc ciste.
			this.OPPLinstructionsRemoving.append("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y ");
			this.OPPLinstructionsAdding.append("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y ");
			this.OPPLinstructionsRemoving.append("BEGIN\n");
			//this.OPPLinstructionsWOremoving=this.OPPLinstructions;
			this.OPPLinstructionsAdding.append("BEGIN\n");
			//nodesOP = (NodeList) xpath.evaluate("/instructions/oppl_script/*", doc,
			nodesOP = (NodeList) xpath.evaluate("/instructions/oppl_script/add", doc,
	                XPathConstants.NODESET);						
			for(int i=0;i<nodesOP.getLength();i++) {								
				//preprocessing step,20-12-10
				//From the perspective of OPPL imported entities are part of ontology, so it is need to usefull uri just their local names: ss.substring(ss.indexOf("#")+1)
				String sin=nodesOP.item(i).getTextContent();
				String sout="";

				//06-06-11,special heuristic for equivalentTo axiom, e.g. <add>Event equivalentTo http://www.ontologydesignpatterns.org/cp/owl/participation.owl#Event</add>
				//TODO: zatim to nezafunguje na situaci obracenou, e.g. <add>http://www.ontologydesignpatterns.org/cp/owl/participation.owl#Event equivalentTo Event</add>
				if (sin.matches(".* equivalentTo .*")) {					
					String pat="";
					if (!sin.startsWith("!")) {			
						//if (this.debuggingOutput) System.out.println("jsme tu");
						pat=sin.substring(0,sin.indexOf(" "));						
						if (this.debuggingOutput) System.out.println("   "+pat);
						if (sin.matches("^.*#"+pat+" $")) {
							if (this.debuggingOutput) System.out.println("a pak zde");
							if (this.debuggingOutput) System.out.print("using OWL API to create this equivalentTo axiom:");
							StringTokenizer st = new StringTokenizer(sin);
							String class1=st.nextToken();
							st.nextToken();
							String class2=st.nextToken();
							if (this.debuggingOutput) System.out.println(base+class1+" "+class2);
							this.manager.addAxiom(this.ontology,this.factory.getOWLEquivalentClassesAxiom(this.factory.getOWLClass(IRI.create(base+class1)), this.factory.getOWLClass(IRI.create(class2))));					
						}
						
					}
				}
				//06-06-11,end of special heuristic for equivalentTo axiom, e.g. <add>Event equivalentTo http://www.ontologydesignpatterns.org/cp/owl/participation.owl#Event</add>
				
				//OWLClass newClass; //21-12-10, for a new class if OPPL cannot work, e.g. in the case of !http://				
				StringTokenizer st = new StringTokenizer(sin);				
				while (st.hasMoreTokens()) {					
					String ss=st.nextToken();
					if (this.debuggingOutput) System.out.println("Problem?"+ss);
					if (ss.matches("^!http://.*")) {
						//21-12-10
						//deprecated see below this is the case of !http:// which would be in OPPL but it cannot
						//solution: in this case we create new class using OWL API
						//furthermore it will be also substringed
						//newClass = this.factory.getOWLClass(URI.create(ss.replace("!", "")));
						//TODO: je zde potreba nejdriv zjistit,zda se jedna o vlastnost ci tridu
						//proto by bylo lepsi,pokud by to preci jen bylo zajisteno pomoci OPPL
						//17-01-11,pripravime different jmenne prostory
						//06-06-11,note:provede se to pomoci OPPL - upravene MyEntityFactoryScript class
						//nyni i v else vetvi ale bez "!" a bez pridani noveho namespace
						newNamespaces.put(ss.substring(ss.lastIndexOf("/")+1,ss.lastIndexOf(".")), ss.substring(1,ss.indexOf("#")+1));
						//DONE: from newNamespaces we can generate prefixes for an ontology
						//TODO: jeste do parseru. Ted je to neco jako prefix:
						sout+="!"+ss.substring(ss.lastIndexOf("/")+1,ss.lastIndexOf("."))+":"+ss.substring(ss.indexOf("#")+1)+" ";
					}
					else //if ((ss.matches("^http://.*"))||(ss.matches("^\\(http://.*"))) {		
						
						if (ss.startsWith("(")&&(ss.indexOf("#")!=-1)) //06-06-11 problem with disappearing "(": e.g. (http://...relation -> relation\							
							sout+="("+ss.substring(ss.indexOf("#")+1)+" ";
						else
							sout+=ss.substring(ss.indexOf("#")+1)+" ";
							
						//06-06-11,see above u if vetve, no way
						/*if (ss.startsWith("(")) 
							sout+="(!"+ss.substring(ss.lastIndexOf("/")+1,ss.lastIndexOf("."))+":"+ss.substring(ss.indexOf("#")+1)+" ";
						else 
							sout+="!"+ss.substring(ss.lastIndexOf("/")+1,ss.lastIndexOf("."))+":"+ss.substring(ss.indexOf("#")+1)+" ";
							*/
					//}
					//else sout+=ss+" ";
			    }				
				//end of preprocessing step for adding entity
				//04-11-11, in order to be in line with SPARQL and OPPL at the same time
				sout=sout.replace("propertyDisjointWith", "disjointWith");
				if (i!=nodesOP.getLength()-1) {
					this.OPPLinstructionsAdding.append("ADD "+sout+",\n");
					this.annotationsDueToAddingAxioms.add(sout);
				}
				else { 
					this.OPPLinstructionsAdding.append("ADD "+sout+"\n");
					this.annotationsDueToAddingAxioms.add(sout);
				}
							
			}
			
			nodesOP = (NodeList) xpath.evaluate("/instructions/oppl_script/remove", doc,
	                XPathConstants.NODESET);
			
			for(int i=0;i<nodesOP.getLength();i++) {
				
				//03-11-11, begin
				String sin=nodesOP.item(i).getTextContent();
				String sout="";
				
				
				StringTokenizer st = new StringTokenizer(sin);				
				while (st.hasMoreTokens()) {					
					String ss=st.nextToken();
					if (this.debuggingOutput) System.out.println("Problem?"+ss);
							
						
					if (ss.startsWith("(")&&(ss.indexOf("#")!=-1)) //06-06-11 problem with disappearing "(": e.g. (http://...relation -> relation\							
						sout+="("+ss.substring(ss.indexOf("#")+1)+" ";
					else
						sout+=ss.substring(ss.indexOf("#")+1)+" ";
							
			    }								
				//String sout=nodesOP.item(i).getTextContent();
				//03-11-11, end
				
				//04-11-11, in order to be in line with SPARQL and OPPL at the same time
				sout=sout.replace("propertyDisjointWith", "disjointWith");
				if (i!=nodesOP.getLength()-1) {				
					this.OPPLinstructionsRemoving.append("REMOVE "+sout+",\n");
					this.annotationsDueToRemovingAxioms.add(sout);
				}
				else {						
					this.OPPLinstructionsRemoving.append("REMOVE "+sout+"\n");
					this.annotationsDueToRemovingAxioms.add(sout);
				}
			}
			
			this.OPPLinstructionsRemoving.append("END;\n");
			this.OPPLinstructionsAdding.append("END;\n");
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	    //TODO
		//this.OPPLinstructions=instructions;
	}

	/**
	 * This method loads an ontology.
	 * @Override
	 */	
	public void setOntology(OWLOntology o) {
		this.ontology=o;		
	}	
	
	//07-02-11, newly we deal with transformation strategy - removing stuff
	//default transformation (null) strategy is progressive one (default and original one)	
	/**
	 * This method transforms the ontology according to provided transformation strategy. It can log all adding/removing of axioms as ontology annotations.
	 * @param ts	transformation strategy={Conservative,Progressive,RadicalKeep, Radical, RadicalRemove}
	 * @param addAnnotationsForRemovedAddedAxioms	true/false logging of adding/removing of axioms as ontology annotations
	 * @Override 
	 */	
	public OWLOntology transformOntology(TransformationStrategy ts, boolean addAnnotationsForRemovedAddedAxioms) {			
		if (ts==null) ts=TransformationStrategy.Progressive;
		String annotationNS = "http://nb.vse.cz/~svabo/PatternAnnotation.owl#";		
		/*
		String OPPLinstructions="";
		
		if (ts.equals(TransformationStrategy.Conservative)) OPPLinstructions=this.OPPLinstructionsWOremoving.toString();
		else OPPLinstructions=this.OPPLinstructions.toString();
		*/
		if (this.debuggingOutput) System.out.println(this.OPPLinstructionsRemoving.toString().trim());
		if (this.debuggingOutput) System.out.println(this.OPPLinstructionsAdding.toString().trim());
		//if (this.debuggingOutput) System.out.println(OPPLinstructions.trim());
		
		//28-05-12, if annotation properties remove and add are used
		/*
		if (addAnnotationsForRemovedAddedAxioms) {
			newNamespaces.put("annot", "http://nb.vse.cz/~svabo/PatternAnnotation.owl#");
		}*/
		
		//17-01-11, include new namespaces because of creating entities from different IRIs
		for(String s : newNamespaces.keySet()) {
			if (this.debuggingOutput) System.out.println(s+","+newNamespaces.get(s));
			this.setNewPrefix(s, newNamespaces.get(s));
		}
		
		//08-02-11, 0. treatment of addional axioms
		//puvodne to bylo soucasne v casti mazani entit, ale v pripade superclass, ktera byla smazana v ramci mazani axiomu to byl problem
		if(ts.equals(TransformationStrategy.Radical)||ts.equals(TransformationStrategy.RadicalKeep)||ts.equals(TransformationStrategy.RadicalRemove)) {
			//08-02-11, TODO: dealing with additional axioms v nasledujicim switchy									
			List<AddAxiom> newAxioms = new ArrayList<AddAxiom>();
			//18-02-11, nove po ztrate prace ze 14-02-11
			List<AddAxiom> newAnnotatedAxioms = new ArrayList<AddAxiom>();
			for(Entity e : this.removingEntities) {
				//OWLEntity entity=null;			
				try {
					switch (e.getType()) {
						case ObjectProperty: 
							//TODO						
							break;
						case DatatypeProperty: 
							//TODO
							break;
						//case AnnotationProperty: 
						//	entity = factory.getOWL.getOWLAnnotationProperty(URI.create(base+e.getName()));
						//	break;
						case Class: 
							OWLClass clss = factory.getOWLClass(IRI.create(base+e.getName()));							
							//08-02-11, dealing with additional axioms
							OWLClass superClss = null;
							//prozatim bereme prvni pojmenovanou nadtridu 
							for (OWLClassExpression c :clss.getSuperClasses(this.ontology)) {
								//if (this.debuggingOutput) System.out.println(c);
								if (c instanceof OWLClass) {
									superClss = (OWLClass)c;
									//if (this.debuggingOutput) System.out.println(" "+c);
									break;
								}									
							}														
							Set<OWLAnnotation> annotations = new TreeSet<OWLAnnotation>();
							OWLAnnotation ann1;
							OWLAnnotationProperty property;
							OWLAnnotationValue annValue;
							OWLLiteral annLiteral;
							for (OWLAxiom ax: clss.getReferencingAxioms(this.ontology)) {
								//18-02-11, 14-02-11, add warnings as axioms not for declaration axiom like Person type Class
								if (ts.equals(TransformationStrategy.RadicalKeep)||ts.equals(TransformationStrategy.RadicalRemove)) {
									if (!(ax instanceof OWLDeclarationAxiom)) {
										//1st annotation
										property = this.factory.getOWLAnnotationProperty(IRI .create(base+"annotation:remove_warning_by"));
										//annValue = IRI.create();
										annLiteral = this.factory.getOWLLiteral(this.tpLocation);								
										annotations.add(this.factory.getOWLAnnotation(property, annLiteral));								
										//2nd annotations
										property = this.factory.getOWLAnnotationProperty(IRI.create(base+"annotation:remove_warning_for"));
										annValue = IRI.create(clss.toStringID());
										annotations.add(this.factory.getOWLAnnotation(property, annValue));
										newAnnotatedAxioms.add(new AddAxiom(this.ontology,ax.getAnnotatedAxiom(annotations)));
									}
								}
								//18-02-11, radical with proper dealing with additional axioms
								//now there is hard-coded approach, TODO: apply TPs on these places of additional axioms, see e.g.: http://nb.vse.cz/~svabo/patomat/tp/tp_domain.xml 
								if (ts.equals(TransformationStrategy.Radical)) {								
									if (ax instanceof OWLObjectPropertyRangeAxiom) {
										//if (this.debuggingOutput) System.out.println(((OWLObjectPropertyRangeAxiom) ax).getProperty()+" "+superClss);
										//vytvorime novy axiom, ten puvodni se pak smaze pri mazani dane entity
										OWLAxiom axRangeNew = this.factory.getOWLObjectPropertyRangeAxiom(((OWLObjectPropertyRangeAxiom) ax).getProperty(),superClss);
										newAxioms.add(new AddAxiom(this.ontology, axRangeNew));									
									}
									else if (ax instanceof OWLObjectPropertyDomainAxiom) {
										//if (this.debuggingOutput) System.out.println(((OWLObjectPropertyRangeAxiom) ax).getProperty()+" "+superClss);
										//vytvorime novy axiom, ten puvodni se pak smaze pri mazani dane entity
										OWLAxiom axDomainNew = this.factory.getOWLObjectPropertyDomainAxiom(((OWLObjectPropertyDomainAxiom) ax).getProperty(),superClss);
										newAxioms.add(new AddAxiom(this.ontology, axDomainNew));									
									}
								}
							}
							break;
						case Individual: 
							//TODO
							break;				
						default:
							throw new EntityTypeException("Unrecognized entity type.");						
					}	  	
					//remover visits all entities to be removed and then they are removed after a loop 
		  		}
		  		
				catch(Exception ex) {
		  			ex.printStackTrace();
		  		}
			}			
			this.manager.applyChanges(newAnnotatedAxioms); //nove axiomy, ktere vyplynuly ze spracovani addional axioms
			this.manager.applyChanges(newAxioms); //nove axiomy, ktere vyplynuly ze spracovani addional axioms
		}
		//07-02-11, 1. oppl_script execution for Removing axioms if applicable
		if(!ts.equals(TransformationStrategy.Conservative)) {
			if (!OPPLinstructionsRemoving.toString().trim().equals("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN\nEND;")) {
				//10-11-11, automatically add annotations about which axiom where removed:
				if (addAnnotationsForRemovedAddedAxioms) {
					OWLAnnotation ann1;
					OWLAnnotationAssertionAxiom annAssertion1;
					OWLAnnotationProperty property;
					//OWLAnnotationSubject subject;
					OWLLiteral annLiteral;
					OWLAnnotationValue annValue;
					AddAxiom axiomToAdd;
					Set<OWLAnnotationAssertionAxiom> annotations = new TreeSet<OWLAnnotationAssertionAxiom>();
					if (this.debuggingOutput) System.out.println("Removed axioms:");
					//annotation will be n-ary, so we will use anonymous individual - this does not work for ontology annotations. Why? That's a pity. 				
					//subject = this.factory.getOWLAnonymousIndividual();
					// ontology annotation:
					//subject = (OWLAnnotationSubject)annValue;
					//property = this.factory.getOWLAnnotationProperty(IRI .create(base+"annotation:removed"));
					//this.manager.applyChange(new AddOntologyAnnotation(this.ontology,  this.factory.getOWLAnnotation(property, (OWLAnnotationValue)subject)));
					
					//if this is not like n-ary relation then this is not good to have the following because there will be more removed axioms and then it will not be clear which one was removed by which transformation pattern
					//but maybe in future I will find out that n-ary relation is possible to add to ontology
					//property = this.factory.getOWLAnnotationProperty(IRI .create(base+"annotation:removed_by"));
					//annLiteral = this.factory.getOWLLiteral(this.tpLocation);								
					//axiomToAdd = new AddAxiom(ontology,this.factory.getOWLAnnotationAssertionAxiom(property, subject, annLiteral));
					//manager.applyChange(axiomToAdd);
					//this.manager.applyChange(new AddOntologyAnnotation(this.ontology,  this.factory.getOWLAnnotation(property, annLiteral)));
					if (this.annotationsDueToRemovingAxioms.size()>0) {
						property = this.factory.getOWLAnnotationProperty(IRI.create(annotationNS+"annotation:removed_axiom"));
						this.manager.applyChange(new AddAxiom(this.ontology, this.factory.getOWLDeclarationAxiom(property)));
					}
					
					for (String s : this.annotationsDueToRemovingAxioms) {
						if (this.debuggingOutput) System.out.println(s);					
																			
						property = this.factory.getOWLAnnotationProperty(IRI.create(annotationNS+"annotation:removed_axiom"));
						annLiteral = this.factory.getOWLLiteral(s);
						//axiomToAdd = new AddAxiom(ontology,this.factory.getOWLAnnotationAssertionAxiom(property, subject, annLiteral));
						//manager.applyChange(axiomToAdd);
						this.manager.applyChange(new AddOntologyAnnotation(this.ontology,  this.factory.getOWLAnnotation(property, annLiteral)));														
					}
				}
				//end of adding annotations
				
				org.semanticweb.owlapi.reasoner.OWLReasonerFactory reasonerFactory = new PelletReasonerFactory();				
				//OWLReasoner reasoner = reasonerFactory.createReasoner(this.ontology);
				//09-03-10, in glassfish server I had problem with xsdlib.jar so I try not to use reasoner:
				//so currently it is not possible to use inferred axioms with oppl script				
				//28-02-12
				OWLReasoner reasoner = null;System.out.println("oppl instructions removing:");
				System.out.println(OPPLinstructionsRemoving.toString());
				OPPLinstructionsRemoving=new StringBuilder(OPPLinstructionsRemoving.toString().replaceAll("baseNamespace@", base));
				System.out.println(OPPLinstructionsRemoving.toString());
				List<OWLOntologyChange> removals = new ArrayList<OWLOntologyChange>();
				try {
					//ParserFactory factory = new ParserFactory(this.ontology, this.manager);
					final JUnitTestErrorListener errorListener = new JUnitTestErrorListener();
					//29-02-12
					OPPLParser p = new cz.vse.keg.patomat.oppl.MyParserFactory1(manager, ontology, reasoner).build(errorListener);
					//OPPLParser p = new cz.vse.keg.patomat.oppl.MyParserFactory(manager, ontology, reasoner).build(errorListener);
					//OPPLParser p = new org.coode.oppl.ParserFactory(manager, ontology, reasoner).build(errorListener);
					OPPLScript script = p.parse(OPPLinstructionsRemoving.toString());				
					//ParserFactory factory = new new cz.vse.keg.patomat.oppl.MyParserFactory(this.ontology, this.manager);																							
					// Do what you want to do with it
					for(OWLAxiomChange axiom : script.getActions()) {
						//if (this.debuggingOutput) System.out.println(axiom);
						System.out.println(axiom);						
						removals.add(axiom);
						//this.manager.applyChange(axiom);
					}
					this.manager.applyChanges(removals);
					//this.manager.saveOntology(this.ontology);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		
		//07-02-11, 2. removing entities (with old names) if applicable
		//18-02-11 (14-02-11), radical remove
		if(ts.equals(TransformationStrategy.Radical)||ts.equals(TransformationStrategy.RadicalRemove)) {
			//08-02-11, TODO: dealing with additional axioms v nasledujicim switchy						
			OWLEntityRemover remover = new OWLEntityRemover(this.manager,Collections.singleton(ontology));			
			for(Entity e : this.removingEntities) {
				//OWLEntity entity=null;			
				try {
					switch (e.getType()) {
						case ObjectProperty: 
							remover.visit(factory.getOWLObjectProperty(IRI.create(base+e.getName())));						
							break;
						case DatatypeProperty: 
							remover.visit(factory.getOWLDataProperty(IRI.create(base+e.getName())));
							break;
						//case AnnotationProperty: 
						//	entity = factory.getOWL.getOWLAnnotationProperty(URI.create(base+e.getName()));
						//	break;
						case Class: 
							remover.visit(factory.getOWLClass(IRI.create(base+e.getName())));							
							break;
						case Individual: 
							remover.visit(factory.getOWLNamedIndividual(IRI.create(base+e.getName())));
							break;				
						default:
							throw new EntityTypeException("Unrecognized entity type.");						
					}	  	
					//remover visits all entities to be removed and then they are removed after a loop 
		  		}
		  		
				catch(Exception ex) {
		  			ex.printStackTrace();
		  		}
			}
			this.manager.applyChanges(remover.getChanges());			
		}		
		
		//3. renaming (shifting renaming to this point /from point 5/ because it already works with new naming
		//if (this.debuggingOutput) System.out.println("renaming: "+renamingEntitiesInstructions);
		OWLEntityRenamer renamer = new OWLEntityRenamer(this.manager,Collections.singleton(ontology));
		//System.out.println(this.renamingEntitiesInstructions);
		for(Entity e : this.renamingEntitiesInstructions.keySet()) {
			OWLEntity entity=null;			
			try {
				switch (e.getType()) {
					case ObjectProperty: 
						entity = factory.getOWLObjectProperty(IRI.create(base+e.getName()));
						break;
					case DatatypeProperty: 
						entity = factory.getOWLDataProperty(IRI.create(base+e.getName()));
						break;
					//case AnnotationProperty: 
					//	entity = factory.getOWL.getOWLAnnotationProperty(URI.create(base+e.getName()));
					//	break;
					case Class: 
						entity = factory.getOWLClass(IRI.create(base+e.getName()));
						break;
					case Individual: 
						entity = factory.getOWLNamedIndividual(IRI.create(base+e.getName()));
						break;				
					case Literal: 
						//20-09-11, no renaming of any enity inside ontology just explicit new name
						continue;//skip renaming using applyChanges in this case
					default:
						throw new EntityTypeException("Unrecognized entity type.");						
				}				
				//if (this.debuggingOutput) System.out.println(entity+":"+this.renamingEntitiesInstructions.get(e));
	  			this.manager.applyChanges(renamer.changeIRI(entity,IRI.create(base+this.renamingEntitiesInstructions.get(e))));	  			
	  			//this.manager.saveOntology(this.ontology);
	  		}
	  		
			catch(Exception ex) {
	  			ex.printStackTrace();
	  		}
		}
		
		//4. oppl_script execution for Adding axioms and entities
		if (!OPPLinstructionsAdding.toString().trim().equals("?x:CLASS, ?y:CLASS SELECT ?x subClassOf ?y BEGIN\nEND;")) {			
			//10-11-11, automatically add annotations about which axiom where added:
			if (addAnnotationsForRemovedAddedAxioms) {
				OWLAnnotationProperty property;
				OWLLiteral annLiteral;
				if (this.debuggingOutput) System.out.println("Added axioms:");
				//annotation will be n-ary, so we will use anonymous individual - this does not work for ontology annotations. Why? That's a pity. 				
				// ontology annotation:
				//subject = (OWLAnnotationSubject)annValue;
				//property = this.factory.getOWLAnnotationProperty(IRI .create(base+"annotation:removed"));
				//this.manager.applyChange(new AddOntologyAnnotation(this.ontology,  this.factory.getOWLAnnotation(property, (OWLAnnotationValue)subject)));
				
				//if this is not like n-ary relation then this is not good to have the following because there will be more removed axioms and then it will not be clear which one was removed by which transformation pattern
				//but maybe in future I will find out that n-ary relation is possible to add to ontology
				//property = this.factory.getOWLAnnotationProperty(IRI .create(base+"annotation:removed_by"));
				//annLiteral = this.factory.getOWLLiteral(this.tpLocation);								
				//axiomToAdd = new AddAxiom(ontology,this.factory.getOWLAnnotationAssertionAxiom(property, subject, annLiteral));
				//manager.applyChange(axiomToAdd);
				//this.manager.applyChange(new AddOntologyAnnotation(this.ontology,  this.factory.getOWLAnnotation(property, annLiteral)));
				if (this.annotationsDueToAddingAxioms.size()>0) {
					property = this.factory.getOWLAnnotationProperty(IRI.create(annotationNS+"annotation:added_axiom"));
					this.manager.applyChange(new AddAxiom(this.ontology, this.factory.getOWLDeclarationAxiom(property)));
				}
				
				for (String s : this.annotationsDueToAddingAxioms) {
					if (this.debuggingOutput) System.out.println(s);					
																		
					property = this.factory.getOWLAnnotationProperty(IRI.create(annotationNS+"annotation:added_axiom"));
					annLiteral = this.factory.getOWLLiteral(s);
					//axiomToAdd = new AddAxiom(ontology,this.factory.getOWLAnnotationAssertionAxiom(property, subject, annLiteral));
					//manager.applyChange(axiomToAdd);
					this.manager.applyChange(new AddOntologyAnnotation(this.ontology,  this.factory.getOWLAnnotation(property, annLiteral)));					
				}
			}
			//end of adding annotations
			
			org.semanticweb.owlapi.reasoner.OWLReasonerFactory reasonerFactory = new PelletReasonerFactory();
			//OWLReasoner reasoner = reasonerFactory.createReasoner(this.ontology);
			//09-03-10, in glassfish server I had problem with xsdlib.jar so I try not to use reasoner:
			//so currently it is not possible to use inferred axioms with oppl script
			OWLReasoner reasoner = null;
			try {
				System.out.println("oppl instructions adding:");
				System.out.println(OPPLinstructionsAdding.toString());
				//ParserFactory factory = new ParserFactory(this.ontology, this.manager);
				final JUnitTestErrorListener errorListener = new JUnitTestErrorListener();
				//OPPLParser p = new org.coode.oppl.ParserFactory(manager, ontology, reasoner).build(errorListener);
				//(this.OPPLinstructions.toString(), this.ontology, this.manager, reasoner);
				//TODO: 17-01-11, budu pouzivat cz.vse.keg.patomat.transformation.MyParserFactory
				//OPPLParser p = new cz.vse.keg.patomat.oppl.MyParserFactory1(manager, ontology, reasoner).build(errorListener);
				OPPLParser p = new cz.vse.keg.patomat.oppl.MyParserFactory(manager, ontology, reasoner).build(errorListener);
				OPPLScript script = p.parse(OPPLinstructionsAdding.toString());				
				//ParserFactory factory = new new cz.vse.keg.patomat.oppl.MyParserFactory(this.ontology, this.manager);																							
				// Do what you want to do with it
				for(OWLAxiomChange axiom : script.getActions()) {
					//if (this.debuggingOutput) System.out.println(axiom);
					manager.applyChange(axiom);
				}							
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		//30-03-10, 5. adding annotations axioms
		String entityType = "";
		//OWLEntity subject = null;
		OWLAnnotationSubject subject = null;
		//OWLAnnotationObject predicate = null;
		OWLAnnotationProperty predicate = null;
		OWLAnnotationValue annotationValue = null;
		//OWLConstantAnnotation predicate = null;
		//OWLEntityAnnotationAxiom annotationAxiom = null;
		OWLAnnotationAssertionAxiom annotationAxiom = null;		 
		AddAxiom axiomToAdd = null; 
		
		for (String s : addingAnnotationsAxioms) {
			try {
				if (this.debuggingOutput) System.out.println(s);
				StringTokenizer st = new StringTokenizer(s," ");
				//13-04-10, first I have to decide of which type the entity which we will annotate is
				entityType = st.nextToken();
				//entityType = entityType.trim();
				//if (this.debuggingOutput) System.out.println("entityType "+entityType);
				if (entityType.equals("ObjectProperty")) 
					//subject = factory.getOWLObjectProperty(IRI.create(base+st.nextToken()));
					subject = IRI.create(base+st.nextToken()); //22-12-10, crazy stuff, maybe this is correct way
				else if (entityType.equals("DatatypeProperty"))
					//subject = factory.getOWLDataProperty(IRI.create(base+st.nextToken()));
					subject = IRI.create(base+st.nextToken());
				else if (entityType.equals("Class"))
					//subject = factory.getOWLClass(IRI.create(base+st.nextToken()));
					subject = IRI.create(base+st.nextToken());
				else if (entityType.equals("Individual"))
					//subject = factory.getOWLNamedIndividual(IRI.create(base+st.nextToken()));
					subject = IRI.create(base+st.nextToken());
				else if (entityType.equals("AnonymousIndividual"))
					//subject = factory.getOWLNamedIndividual(IRI.create(base+st.nextToken()));
					subject = this.factory.getOWLAnonymousIndividual(st.nextToken()); 						
				else {					
					break;					
				}
				//next AnnotationProperty
				String p = st.nextToken();
				if (p.matches("^http://.*")) {
					//predicate = factory.getOWLAnnotationObject(URI.create(p), factory.getOWLNamedIndividual(IRI.create(base+st.nextToken()))); owl-api 2
					predicate = factory.getOWLAnnotationProperty(IRI.create(p));
				}
				//else predicate = factory.getOWLObjectAnnotation(URI.create(base+p), factory.getOWLIndividual(URI.create(base+st.nextToken())));
				else predicate = factory.getOWLAnnotationProperty(IRI.create(base+p));
				//annotationValue = factory.getOWLNamedIndividual(IRI.create(base+st.nextToken())); 
				//07-11-11, trying to cope with n-ary annotation via AnonymousIndividual
				//07-11-11, check which type should be in object
				entityType = st.nextToken();
				if (entityType.equals("ObjectProperty")) 
					annotationValue = IRI.create(base+st.nextToken()); //22-12-10, crazy stuff, maybe this is correct way
				else if (entityType.equals("DatatypeProperty"))
					annotationValue = IRI.create(base+st.nextToken()); 
				else if (entityType.equals("Class"))
					annotationValue = IRI.create(base+st.nextToken());
				else if (entityType.equals("Individual"))
					annotationValue = IRI.create(base+st.nextToken());
				else if (entityType.equals("AnonymousIndividual"))
					annotationValue = this.factory.getOWLAnonymousIndividual(st.nextToken());
				else if (entityType.equals("Literal"))
					annotationValue = this.factory.getOWLLiteral(st.nextToken()); 						
				else {					
					break;					
				}				
				//annotationValue = IRI.create(base+st.nextToken()); //22-12-10, crazy stuff, maybe this is correct way
				//predicate = factory.getOWLConstantAnnotation(URI.create(base+st.nextToken()), new OWLConstant());
				//30-03-10,right version would be just with literals like the following:
				//this is only possible within OWL-API v3
				//but OPPL does not work with OWL-API v3, so for now I add OWLObjectAnnotation using OWL-API v2
				//OWLAnnotation constantAnnotation = factory.getOWLAnnotation(
				//		factory.getOWL .getOWLAnnotationProperty(URI.create(base+st.nextToken())),
				//		df.getOWLStringLiteral("A class which represents pizzas", "en"));

				//annotationAxiom = factory.getOWLEntityAnnotationAxiom(subject, predicate);
				//if (this.debuggingOutput) System.out.println(subject+ " : "+ predicate + " : " + annotationValue);
				annotationAxiom = factory.getOWLAnnotationAssertionAxiom(predicate, subject, annotationValue);
				axiomToAdd = new AddAxiom(ontology,annotationAxiom);
				manager.applyChange(axiomToAdd);
				if (this.debuggingOutput) System.out.println(axiomToAdd);
			}
			catch(Exception e) {
				e.printStackTrace();
			}
		}
					
		return null;
	}
	
	//23-09-11, all the pre-processing that is necessary to do with an ontology
	/**
	 * This method preprocesses the ontology, i.e. it decomposes intersection in superclass position, disjoint classes and disjoint union.
	 */
	public void preprocessOntology() {
		List<AddAxiom> addAxioms = new ArrayList<AddAxiom>();
		List<RemoveAxiom> removeAxioms = new ArrayList<RemoveAxiom>();
		for(OWLClass cls : this.ontology.getClassesInSignature()) {
			//dealing with decomposition of intersectionOf
			for (OWLClassExpression exp : cls.getEquivalentClasses(this.ontology)) {				
				/*01-02-12, v dusledku experimentovani pri psani clanku jsem zjistil, ze tato dekompozice nelze see clanek na ECAI/EKAW2012
				if (exp instanceof OWLObjectIntersectionOf) {
					Set<OWLClassExpression> allOperands = ((OWLObjectIntersectionOf) exp).getOperands();
					for (OWLClassExpression operand : allOperands) {
						addAxioms.add(new AddAxiom(this.ontology, this.factory.getOWLEquivalentClassesAxiom(cls,operand)));												
					}
					removeAxioms.add(new RemoveAxiom(this.ontology, this.factory.getOWLEquivalentClassesAxiom(cls,exp)));
				}				
				*/
				if (exp instanceof OWLDisjointUnionAxiom) {
					if (this.debuggingOutput) System.out.println("DisjointUnionOf "+exp);
					Set<OWLClassExpression> allOperands = ((OWLObjectUnionOf) exp).getOperands();
					for (OWLClassExpression operand : allOperands) {
						//addAxioms.add(new AddAxiom(this.ontology, this.factory.getOWLEquivalentClassesAxiom(cls,operand)));
						if (this.debuggingOutput) System.out.println(" "+operand);					
					}
					//removeAxioms.add(new RemoveAxiom(this.ontology, this.factory.getOWLEquivalentClassesAxiom(cls,exp)));
				}
			}
			//dealing with decomposition of intersectionOf
			for (OWLClassExpression exp : cls.getSuperClasses(this.ontology)) {				
				if (exp instanceof OWLObjectIntersectionOf) {
					Set<OWLClassExpression> allOperands = ((OWLObjectIntersectionOf) exp).getOperands();
					for (OWLClassExpression operand : allOperands) {
						addAxioms.add(new AddAxiom(this.ontology, this.factory.getOWLSubClassOfAxiom(cls,operand)));												
					}
					removeAxioms.add(new RemoveAxiom(this.ontology, this.factory.getOWLSubClassOfAxiom(cls,exp)));
				}
				
				if (exp instanceof OWLDisjointUnionAxiom) {
					if (this.debuggingOutput) System.out.println("DisjointUnionOf "+exp);
					Set<OWLClassExpression> allOperands = ((OWLObjectUnionOf) exp).getOperands();
					for (OWLClassExpression operand : allOperands) {
						//addAxioms.add(new AddAxiom(this.ontology, this.factory.getOWLEquivalentClassesAxiom(cls,operand)));
						if (this.debuggingOutput) System.out.println(" "+operand);					
					}
					//removeAxioms.add(new RemoveAxiom(this.ontology, this.factory.getOWLEquivalentClassesAxiom(cls,exp)));
				}
			}
			
			//dealing with decomposition of disjointness (there can also be AllDisjointClass so the following should ensure that there are only pairwise axioms)
			//pairwise disjointWith axiom will be added and if there were AllDisjointClass it will be preserved
			
			for (OWLClassExpression exp : cls.getDisjointClasses(this.ontology)) {															
				//addAxioms.add(new AddAxiom(this.ontology, this.factory.getOWLSubClassOfAxiom(cls,(OWLClass)exp)));																								
				addAxioms.add(new AddAxiom(this.ontology, this.factory.getOWLDisjointClassesAxiom(cls,(OWLClass)exp)));
				//if (this.debuggingOutput) System.out.println("DisjointClasses:"+exp);
			}
			
			//04-11-11, for getting DisjointUnionAxioms:
			for (OWLDisjointUnionAxiom disUn : this.ontology.getDisjointUnionAxioms(cls)) {
				/*for (OWLClassExpression exp : disUn.getClassExpressions()) {
					if (this.debuggingOutput) System.out.println("Expressions in disjointUnion:"+exp);
				}*/
				//if (this.debuggingOutput) System.out.println("   disjointness there:"+disUn.getOWLDisjointClassesAxiom());
				//if (this.debuggingOutput) System.out.println("   equivalent classes:"+disUn.getOWLEquivalentClassesAxiom());
				
				addAxioms.add(new AddAxiom(this.ontology, disUn.getOWLDisjointClassesAxiom()));
				addAxioms.add(new AddAxiom(this.ontology, disUn.getOWLEquivalentClassesAxiom()));
				
				removeAxioms.add(new RemoveAxiom(this.ontology, disUn));
			}
			
		}
		
		this.manager.applyChanges(addAxioms);
		this.manager.applyChanges(removeAxioms);		
	}
	
	//16-11-11, downgrading using directly OWLAPI, based on the code from Mathias Niepert
	public void adjustOWLProfile() {
		List<RemoveAxiom> removeAxioms = new ArrayList<RemoveAxiom>();
		OWL2ELProfile profile = new OWL2ELProfile();
		OWLProfileReport report = profile.checkOntology(this.ontology);
		System.out.println("The following axioms are more expressive than OWL2 EL. They are removed from the ontology:");
		int i=0;
		for (OWLProfileViolation v :report.getViolations()) {
			i++;
			System.out.println(i+".:"+v+"\n");
			if(v.getAxiom()!=null){
				removeAxioms.add(new RemoveAxiom(this.ontology, v.getAxiom()));				
			}	
		}
		
		//this.manager.applyChanges(removeAxioms);
	}
	
	/**
	 * This method save (to location specified using url) all changes made on the ontology.
	 * @url url	a location to which an ontology should be saved
	 * @Override
	 */	
	public void saveOntology(String url) {
		try {	
			if (url.matches("^file.*")) {
				if (this.debuggingOutput) System.out.println(url.substring(url.lastIndexOf("/")+1,url.indexOf(".")));				
				this.manager.saveOntology(ontology,IRI.create(url.substring(0,url.indexOf("."))+"-transformed.owl"));
				//27-07-11 path must be flexible according to OS
				//this.manager.saveOntology(ontology, IRI.create("file:///tmp/"+this.url.substring(this.url.lastIndexOf("/")+1,this.url.lastIndexOf("."))));
				//if (this.debuggingOutput) System.out.println(new String("C:\\a\\b\\c"));
				//if (this.debuggingOutput) System.out.println(new String("C:\\a\\b\\c").replaceAll("\\\\", "/"));
				//if (this.debuggingOutput) System.out.println(System.getProperty("user.home"));
				this.manager.saveOntology(ontology, IRI.create("file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+url.substring(url.lastIndexOf("/")+1,url.lastIndexOf("."))+".owl"));
			}
			else {
				if (this.debuggingOutput) System.out.println(this.url);
				//manager.saveOntology(ontology, URI.create("file:///home/ondrej/doktorandsky/PatOMat/TPs/ontology/cmt-changed.owl"));
				//this.manager.saveOntology(ontology, IRI.create("file:///tmp/"+this.url.substring(this.url.lastIndexOf("/")+1,this.url.lastIndexOf("."))));
				this.manager.saveOntology(ontology, IRI.create("file:///"+System.getProperty("user.home").replaceAll("\\\\", "/")+"/"+this.url.substring(this.url.lastIndexOf("/")+1,this.url.lastIndexOf("."))+".owl"));
			}
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * This method prints the whole ontology on standard output.
	 * @Override
	 */	
	public String printOntology() { 		
		try {
			String s = URLGrabber.getDocumentAsString("file:///"+System.getProperty("user.home")+"/"+this.url.substring(this.url.lastIndexOf("/")+1,this.url.lastIndexOf("."))+".owl");
			return s;
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		//return ontology.toString();
		return "error";
	}

	@Override
	public String getDictionaryPath() {
		// TODO Auto-generated method stub
		return this.dictionaryPath;
	}

	@Override
	public String getModelsPath() {
		// TODO Auto-generated method stub
		return this.modelsPath;
	}

	@Override
	public OWLOntology getOntology() {		
		return this.ontology;
	}

	@Override
	public OWLOntologyManager getManager() {		
		return this.manager;
	}
	
	@Override
	//21-11-11, solving problem "too many open files"	
	public void finish() {
		this.manager.removeOntology(this.ontology);
		this.ontology=null;		
	}		
}
