package cz.vse.keg.patomat.transformation;

import java.util.HashMap;

import org.semanticweb.owlapi.model.OWLOntologyManager;

//import cz.vse.keg.patomat.transformation.pattern.TransformationPattern;

/**
 * @author Ondrej Zamazal
 * 
 */

public interface OntologyTransformation<O> {

	public enum TransformationStrategy {Conservative, Progressive, RadicalKeep, Radical, RadicalRemove};
	
	public O transformOntology(TransformationStrategy ts, boolean addAnnotationsForRemovedAxioms);	
	
	public void adjustOWLProfile();
	public void preprocessOntology();
	public void setOntology(O o);
	public void finish();
	public O getOntology();
	public OWLOntologyManager getManager();
	public void setInstructions(String instructions);
	public void saveOntology(String url);
	public String printOntology();
	public String getDictionaryPath();
	public String getModelsPath();
	public boolean willTransformOntology();
}

/*Implements:
* TransformationImpl
*/