package cz.vse.keg.patomat.service;

import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.routing.Router;

import cz.vse.keg.patomat.detection.service.OntologyPatternDetectionResource;
import cz.vse.keg.patomat.transformation.pattern.service.InstructionGeneratorResource;
import cz.vse.keg.patomat.transformation.pattern.service.OntologyTransformationResource;
import cz.vse.keg.patomat.transformation.pattern.service.OntologyTransformationServiceResource;

/**
 * @author Ondrej Zamazal
 * 
 */

public class OntologyTransformationApplication extends Application {

    /**
     * Creates a root Restlet that will receive all incoming calls.
     */
    @Override
    public Restlet createInboundRoot() {
        // Create a router Restlet that routes each call to a
        // new instance of Detection.
        Router router = new Router(getContext());

        // Defines a route for the resource "OntologyPatternDetectionResource"  
        router.attach("/detection", OntologyPatternDetectionResource.class);
        // Defines a route for the resource "InstructionGeneratorResouce"  
        router.attach("/instructions", InstructionGeneratorResource.class);
        // Defines a route for the resource "OntologyTransformationResource"  
        router.attach("/transform", OntologyTransformationResource.class);
        // Defines a route for the resource "OntologyTransformationServiceResource"  
        router.attach("/service", OntologyTransformationServiceResource.class);

        return router;
    }

}
