package cz.vse.keg.patomat.naming;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cz.vse.keg.patomat.string.Words;
import cz.vse.keg.patomat.synonym.MyWordNet;
import cz.vse.keg.patomat.transformation.pattern.NameDetectionPattern;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern;
import cz.vse.keg.patomat.transformation.pattern.NameDetectionPattern.MeasureType;
import cz.vse.keg.patomat.transformation.pattern.OntologyPattern.EntityType;

/**
 * @author Ondrej Zamazal
 * 
 */

public class NamingConstraintsImpl implements NamingConstraints {

	protected Words words;
	protected MyWordNet myWordNet;
	protected ArrayList<String> classes;
	protected ArrayList<String> properties;
	protected ArrayList<String> individuals;
	protected HashMap<String,List<String>> placeholdersBindingCurrent;
	protected ArrayList<HashMap<String,List<String>>> placeholdersBinding;
	private boolean debuggingOutput=true;
	
	public NamingConstraintsImpl(boolean POStagger, String dictionaryPath, String modelsPath) {
		this.words = new Words(POStagger, dictionaryPath, modelsPath);
		//this.myWordNet = new MyWordNet("/usr/share/WordNet-3.0/");		
		this.myWordNet = new MyWordNet(dictionaryPath);		
	}
	
	private boolean matchEntities(String entity1, String entity2, float threshold, MeasureType measureType) {
		//if (this.debuggingOutput) System.out.println(entity1+","+entity2);
		switch (measureType) {
			case EQUAL: 				
				//if (entity1.equals(entity2))
					//if (this.debuggingOutput) System.out.println("exact");
				return entity1.equals(entity2);
			case UNEQUAL: 				
				//if (entity1.equals(entity2))
					//if (this.debuggingOutput) System.out.println("exact");
				return !entity1.equals(entity2);
			case LEVENSHTEIN:
				//TODO: using OntoSim or directly SecondString library
				//using threshold
				return false;				
			case JARO:
				//TODO: using OntoSim or directly SecondString library
				//using threshold
				return false;
			//06-01-12, hyperonym as relation - special measure type
			case HYPERONYM:
				try {
					//simple equality 
					if (entity1.equals(entity2)) {
						if (this.debuggingOutput) System.out.println(entity1+" "+entity2+" "+true);
						return true;
					}
					//check hyperonym relation
					boolean hyperonym = this.myWordNet.isHyperonym2(12, true, entity1.toLowerCase(), entity2.toLowerCase());
					if (this.debuggingOutput) System.out.println(entity1+" "+entity2+" "+hyperonym);
					return hyperonym;
				}
				catch(Exception e) {
					e.printStackTrace();
				}
				//06-01-12, hyperonym as relation - special measure type
			case NOT_HYPERONYM:
				try {
					//simple equality 
					if (entity1.equals(entity2)) {
						if (this.debuggingOutput) System.out.println(entity1+" "+entity2+" "+false);
						return false;
					}
					//check hyperonym relation
					boolean hyperonym = this.myWordNet.isHyperonym2(12, true, entity1.toLowerCase(), entity2.toLowerCase());
					if (this.debuggingOutput) System.out.println(entity1+" "+entity2+" "+hyperonym);
					return !hyperonym;
				}
				catch(Exception e) {
					e.printStackTrace();
				}
			default:
				//TODO
				return false;
		}		
	}
	//07-06-11, for implementation where naming aspect goes before structural-logical
	private boolean compareEntities(String entity1, String entity2, float threshold, MeasureType measureType) {
		
		return true;
	}
	
	//07-06-11, for implementation where naming aspect goes before structural-logical
	private String executeEntityCompared(String entityCompared, String binding) {
		String naming_function="";
		String parameter="";
		
		//if (this.debuggingOutput) System.out.println(entityCompared);
		
		if (entityCompared.matches("^.*\\(.*\\)$")) {
			//03-06-11
			//it there are more nested naming operations
			boolean nested_patterns=true;
			ArrayList<String> nst_patterns=new ArrayList<String>();
			
			while(nested_patterns) {
				//if (this.debuggingOutput) System.out.println("uvnitr");
				//if (this.debuggingOutput) System.out.println(entityCompared);
				naming_function=entityCompared.substring(0,entityCompared.indexOf("("));
				//if (this.debuggingOutput) System.out.println(naming_function);
				nst_patterns.add(naming_function);
				parameter=entityCompared.substring(entityCompared.indexOf("(")+1,entityCompared.lastIndexOf(")"));
				//if (this.debuggingOutput) System.out.println(parameter);			
				if (parameter.matches(".*\\(.*\\)")) {									
					nested_patterns=true;
					entityCompared=parameter;
				}
				else nested_patterns=false;
			}
				
				if (this.debuggingOutput) System.out.println(nst_patterns);
				
				//last parameter is input entry for passive naming operations !
				parameter = binding;
				//if (this.debuggingOutput) System.out.println("Applied on "+parameter);
				//System.exit(1);
				
				for(int i=nst_patterns.size()-1;i>=0;i--) {
					if (this.debuggingOutput) System.out.println(nst_patterns.get(i));
					naming_function=nst_patterns.get(i);
					if (this.debuggingOutput) System.out.println(naming_function+" over "+parameter);
					//execution of naming_function
					String conceptNames="";
					String hn="";
					//if (this.debuggingOutput) System.out.println("nf:"+naming_function+",p: "+parameter);
					try {
						if (naming_function.equals("head_noun")) {							
							conceptNames=words.secondSplit((words.splitName(" "+parameter).toString()));
							hn=words.getMT(conceptNames);
							//if (this.debuggingOutput) System.out.println("head noun is "+hn);
							//by default, first letter is upper case
							parameter=hn.substring(0,1).toUpperCase()+hn.substring(1);					
						}
						else if (naming_function.equals("head_term")) {
							conceptNames=words.secondSplit((words.splitName(" "+parameter).toString()));
							hn=words.getMT(conceptNames);
							//by default, first letter is upper case							
							parameter=hn.substring(0,1).toUpperCase()+hn.substring(1);
							//if (this.debuggingOutput) System.out.println(">>head_term je "+parameter);
						} 
						else if (naming_function.equals("get_first")) {						
							//if (this.debuggingOutput) System.out.println(parameter);
							parameter="";
						}
						//22-04-10,adding object term using corresponding implemention of getOT in Words class
						//03-06-11, code lost now it is just getMT again
						else if (naming_function.equals("object_term")) {
							conceptNames=words.secondSplit((words.splitName(" "+parameter).toString()));
							//hn=words.getOT(conceptNames);
							hn=words.getMT(conceptNames);
							//by default, first letter is upper case
							parameter=hn.substring(0,1).toUpperCase()+hn.substring(1);
						}
						//03-06-11, complement_head_noun()
						else if (naming_function.equals("complement_head_noun")) {										
							//by default, first letter is upper case
							parameter=words.getComplementHeadNoun(parameter);
						}
						//03-06-11, passive_verb()
						else if (naming_function.equals("passive_verb")) {															
							parameter=words.getVerbPassiveForm(parameter);
						}
						//03-06-11, word_lemma()
						else if (naming_function.equals("word_lemma")) {															
							parameter=words.nlp.getOneWordLemma(parameter);
						}
						//14-06-11, make_passive_verb() taken from NameEntityImpl
						else if (naming_function.equals("make_passive_verb")) {						
							//if (this.debuggingOutput) System.out.println(parameter);
							//TODO,13-04-10, 1. vzit jen head noun a aplikovat to nasledujici jen na headnoun
							conceptNames=words.secondSplit((words.splitName(" "+parameter).toString()));
							parameter=words.getMT(conceptNames);
							if (words.nlp.getOneWordTag(parameter).equals("VB")) {							
								words.getVerbPassiveForm(parameter);							
							}
							else {
								ArrayList<String> relatedTerms = myWordNet.getRelatedWord(parameter);
								if (relatedTerms == null) {
									parameter=parameter;								
								}
								else {
									for(String r : relatedTerms) {
									//if (this.debuggingOutput) System.out.println(">>related "+r+"verb form? "+words.nlp.getOneWordTag(r));
									//TODO,16-02-10: stalo by za to si vzit jen head_noun 
										if ((words.nlp.getOneWordTag(r).equals("VB"))||words.nlp.getOneWordTag(r).equals("JJ")) {
											//adjective or verb
											String passive = words.getVerbPassiveForm(r);										
											parameter = passive.substring(0,1).toUpperCase()+passive.substring(1);
											break;
										}
										parameter = parameter;
									}
								}
							}
							if (this.debuggingOutput) System.out.println(">>passive variant is "+parameter);
						}
						else throw new NamingFunctionException("This function "+naming_function+" is not currently supported. Please wait for the next release.");
					}
					catch(NamingFunctionException e) {
						e.printStackTrace();
					}
					catch(Exception e) {
						e.printStackTrace();
					}
					//return entityCompared;
				}
				return parameter;
		}
		//26-04-11, there is just placeholder
		else if (entityCompared.matches("^\\?.*")) {
			return binding;
		}
		//26-04-11, there is specified entity
		else return entityCompared;
	}
	
	//07-06-11, for implementation where naming aspect goes before structural-logical
	private ArrayList<String> initEntityComparison(String entityCompared) {
		String naming_function="";
		String parameter="";
		
		boolean nested_patterns=true;
		ArrayList<String> nst_patterns=new ArrayList<String>();
		
		while(nested_patterns) {
			//if (this.debuggingOutput) System.out.println("uvnitr");
			//if (this.debuggingOutput) System.out.println(entityCompared);
			naming_function=entityCompared.substring(0,entityCompared.indexOf("("));
			//if (this.debuggingOutput) System.out.println(naming_function);
			nst_patterns.add(naming_function);
			parameter=entityCompared.substring(entityCompared.indexOf("(")+1,entityCompared.lastIndexOf(")"));
			//if (this.debuggingOutput) System.out.println(parameter);			
			if (parameter.matches(".*\\(.*\\)")) {									
				nested_patterns=true;
				entityCompared=parameter;
			}
			else nested_patterns=false;
		}
		return nst_patterns;
	}
	
	//16-02-10, eg. head_noun(?C), ?p
	private String executeEntityCompared(String entityCompared, HashMap<String,String> sparqlBinding) {
		String naming_function="";
		String parameter="";
		
		//if (this.debuggingOutput) System.out.println(entityCompared);
		
		if (entityCompared.matches("^.*\\(.*\\)$")) {
			//03-06-11
			//it there are more nested naming operations
			boolean nested_patterns=true;
			ArrayList<String> nst_patterns=new ArrayList<String>();
			
			while(nested_patterns) {
				//if (this.debuggingOutput) System.out.println("uvnitr");
				//if (this.debuggingOutput) System.out.println(entityCompared);
				naming_function=entityCompared.substring(0,entityCompared.indexOf("("));
				//if (this.debuggingOutput) System.out.println(naming_function);
				nst_patterns.add(naming_function);
				parameter=entityCompared.substring(entityCompared.indexOf("(")+1,entityCompared.lastIndexOf(")"));
				//if (this.debuggingOutput) System.out.println(parameter);			
				if (parameter.matches(".*\\(.*\\)")) {									
					nested_patterns=true;
					entityCompared=parameter;
				}
				else nested_patterns=false;
			}
				
				if (this.debuggingOutput) System.out.println(nst_patterns);
				
				//last parameter is input entry for passive naming operations !
				parameter = sparqlBinding.get(parameter);
				//if (this.debuggingOutput) System.out.println("Applied on "+parameter);
				//System.exit(1);
				
				for(int i=nst_patterns.size()-1;i>=0;i--) {
					if (this.debuggingOutput) System.out.println(nst_patterns.get(i));
					naming_function=nst_patterns.get(i);
					if (this.debuggingOutput) System.out.println(naming_function+" over "+parameter);
					//execution of naming_function
					String conceptNames="";
					String hn="";
					//if (this.debuggingOutput) System.out.println("nf:"+naming_function+",p: "+parameter);
					try {
						if (naming_function.equals("head_noun")) {
							conceptNames=words.secondSplit((words.splitName(" "+parameter).toString()));
							hn=words.getMT(conceptNames);
							if (this.debuggingOutput) System.out.println("head noun is "+hn);
							//by default, first letter is upper case
							parameter=hn.substring(0,1).toUpperCase()+hn.substring(1);					
						}
						else if (naming_function.equals("head_term")) {
							conceptNames=words.secondSplit((words.splitName(" "+parameter).toString()));
							hn=words.getMT(conceptNames);
							//by default, first letter is upper case
							parameter=hn.substring(0,1).toUpperCase()+hn.substring(1);					
						} 
						else if (naming_function.equals("get_first")) {						
							//if (this.debuggingOutput) System.out.println(parameter);
							parameter="";
						}
						//22-04-10,adding object term using corresponding implemention of getOT in Words class
						//03-06-11, code lost now it is just getMT again
						else if (naming_function.equals("object_term")) {
							conceptNames=words.secondSplit((words.splitName(" "+parameter).toString()));
							//hn=words.getOT(conceptNames);
							hn=words.getMT(conceptNames);
							//by default, first letter is upper case
							parameter=hn.substring(0,1).toUpperCase()+hn.substring(1);
						}
						//03-06-11, complement_head_noun()
						else if (naming_function.equals("complement_head_noun")) {										
							//by default, first letter is upper case
							parameter=words.getComplementHeadNoun(parameter);
						}
						//03-06-11, passive_verb()
						else if (naming_function.equals("passive_verb")) {															
							parameter=words.getVerbPassiveForm(parameter);
						}
						//03-06-11, word_lemma()
						else if (naming_function.equals("word_lemma")) {															
							parameter=words.nlp.getOneWordLemma(parameter);
						}						
						else throw new NamingFunctionException("This function "+naming_function+" is not currently supported. Please wait for the next release.");
					}
					catch(NamingFunctionException e) {
						e.printStackTrace();
					}
					catch(Exception e) {
						e.printStackTrace();
					}
					//return entityCompared;
				}
				return parameter;
		}
		//26-04-11, there is just placeholder
		else if (entityCompared.matches("^\\?.*")) {
			return sparqlBinding.get(entityCompared);
		}
		//26-04-11, there is specified entity
		else return entityCompared;
	}
	
	//16-03-10, eg. delimiter_underscore(?C)
	private boolean executeEntityExist(String entityCompared, HashMap<String,String> sparqlBinding) {
		String naming_function="";
		//26-04-11, for the case that naming function has more than one argument
		ArrayList<String> parameters=new ArrayList<String>();
		String parameter="";
		//if (this.debuggingOutput) System.out.println(entityCompared);
		//06-01-12, special implementation for isHyperonymOf where more than one argument can be
		//in this case it is space-separated, e.g. isHyperonym head_noun(?OP1_A) head_noun(?OP1_P)
		//finally I moved this into comparison as special measure type - hyperonym or not_hyperonym
		/*
		if (entityCompared.matches("isHyperonym.*")) {			
			if (this.debuggingOutput) System.out.println("...isHyperonym");
			String[] isHyperonym = new String[2];
			StringTokenizer st1=new StringTokenizer(entityCompared," ");
			int i=0;
			while (st1.hasMoreTokens()) {
				String next=st1.nextToken();
				if (next.matches("isHyperonym.*")) {
					continue;
				}
				else if (next.matches("head_noun.*")) {					
					try {
						parameter = next.substring(next.indexOf("(")+1, next.indexOf(")"));
						if (this.debuggingOutput) System.out.println(parameter);
						parameter = sparqlBinding.get(parameter);
						if (this.debuggingOutput) System.out.println(parameter);					
						
						String conceptNames=words.secondSplit((words.splitName(" "+parameter).toString()));
						String hn=words.getMT(conceptNames);
						if (this.debuggingOutput) System.out.println("head noun is of "+parameter+" is "+hn);
						//by default, first letter is upper case
						//isHyperonym[i++]=hn.substring(0,1).toUpperCase()+hn.substring(1);
						//for checking hyperonym relation first letter is not to be changed to upper case
						isHyperonym[i++]=hn;
					}
					catch(Exception e) {
						e.printStackTrace();
					}														
				}
			}
			if (this.debuggingOutput) System.out.println(isHyperonym[0]+" "+isHyperonym[1]);
			try {
				if (isHyperonym[0].equals(isHyperonym[1]))
					return true;
				else {
					boolean hyperonym = myWordNet.isHyperonym2(12, true, isHyperonym[0], isHyperonym[1]);
					if (this.debuggingOutput) System.out.println(hyperonym);
					return myWordNet.isHyperonym2(12, true, isHyperonym[0], isHyperonym[1]);
				}
				
			}			
			catch(Exception e) {
				e.printStackTrace();
			}
			return false;
		}
		else */ 
		if (entityCompared.matches("^.*\\(.*\\)$")) {
			//if (this.debuggingOutput) System.out.println("uvnitr");
			Pattern pat = Pattern.compile("^.*\\(");
			Matcher m;
			//get naming function, eg. head_noun
			m = pat.matcher(entityCompared);
			while(m.find()) {
				//if (this.debuggingOutput) System.out.println(m.group());
				naming_function=m.group();
			}
			naming_function = naming_function.replaceAll("\\(", "");
			
			pat = Pattern.compile("\\(.*\\)$");			
			//get parameter, eg. head_noun over Paper			
			m = pat.matcher(entityCompared);
			while(m.find()) {
				//if (this.debuggingOutput) System.out.println(m.group());
				parameter=m.group();
			}
			parameter = parameter.replaceAll("\\(", "");
			parameter = parameter.replaceAll("\\)", "");
			//26-04-11
			StringTokenizer st1=new StringTokenizer(parameter,",");
			while (st1.hasMoreTokens()) {
				parameters.add(st1.nextToken());
			}
			//26-04-11
			//currently, just the first item is used:
			parameters.set(0, sparqlBinding.get(parameters.get(0)));
			parameter = sparqlBinding.get(parameter); 
			if (this.debuggingOutput) System.out.println("test:"+parameters);
			//if (this.debuggingOutput) System.out.println(naming_function+" over "+parameter);
			//execution of naming_function
			String conceptNames="";
			String hn="";
			if (this.debuggingOutput) System.out.println("enf:"+naming_function+",ep: "+parameter);
			try {
				if (naming_function.equals("delimiter_camel-case")) {
					pat = Pattern.compile(".+[A-Z].+");																												
					m = pat.matcher(parameter);
					if (this.debuggingOutput) System.out.println("[A-Z]");
					if (m.matches()) {
						//if (this.debuggingOutput) System.out.println("yes");
						return true;
					}
					else {
						//if (this.debuggingOutput) System.out.println("not");
						return false;
					}
				}
				else if (naming_function.equals("delimiter_underscore")) {					
					if (parameter.indexOf("_")!=-1) 
						return true;
					else 
						return false;
				}
				else if (naming_function.equals("delimiter_hyphen")) {					
					if (parameter.indexOf("-")!=-1) 
						return true;
					else 
						return false;
				}
				else if (naming_function.equals("verb_form")) {
					//if (this.debuggingOutput) System.out.println(parameter);
					if (words.nlp.getOneWordTag(parameter).equals("VB")) {							
						return true;							
						//03-06-11, return lemma of a verb
						//return words.nlp.getOneWordLemma(parameter);
					}
					else {
						//20-04-10, neni-li dane slovo ve Wordnetu, pak wordnet vrati null
						ArrayList<String> relatedTerms = myWordNet.getRelatedWord(parameter);
						if (relatedTerms == null) {
							return false;								
						}
						else {
							for(String r : relatedTerms) {						
								//if (this.debuggingOutput) System.out.println("verb? "+r+" "+words.nlp.getOneWordTag(r));
								//TODO,16-02-10: stalo by za to si vzit jen head_noun 
								//if (words.nlp.getOneWordTag(r).equals("VB")) {
								if (words.nlp.getOneWordTag(r).matches("VB.")||(words.nlp.getOneWordTag(r).equals("VB"))) {
									//if (this.debuggingOutput) System.out.println("yes this is verb");
									return true;														
								}
							}
						}
						return false;
					}
				}
				//26-04-11
				else if (naming_function.equals("isHyperonymOf")) {
					//05-01-12
					if (this.debuggingOutput) System.out.println(parameters.get(0)+" "+parameters.get(1));
					//TODO: muzeme vyuzit dva parametry v parameters! it does not work. Why?
					//maybe: http://code.google.com/p/lila-project/
					//return myWordNet.isHyperonym2(15, false, parameters.get(1), parameters.get(0));
					//zatim to nefunguje
					//if (this.debuggingOutput) System.out.println("test hyperonyma:"+myWordNet.isHyperonym2(15, false, "author", "person"));
					//return myWordNet.isHyperonym2(15, false, "speaker", "presenter");
					//return myWordNet.hyperonym(parameters.get(0), parameters.get(1), myWordNet.dict);
				}
				else throw new NamingFunctionException("This function "+naming_function+" is not currently supported. Please wait for the next release.");
			}
			catch(NamingFunctionException e) {
				e.printStackTrace();
			}
			catch(Exception e) {
				e.printStackTrace();
			}
			return false;
		}
		else 
			return false;
	}		 		
	
	//08-06-11, I realized I need more binding for one placeholder so classical HashMap<String,String> cannot work and we need this one: HashMap<String,List<String>>
	private void putPlaceholderBinding(String placeholder, String binding) {
		if (this.placeholdersBindingCurrent.containsKey(placeholder)) {
			List<String> bindings = this.placeholdersBindingCurrent.get(placeholder);
			bindings.add(binding);
		}
		else {
			List<String> bindings = new ArrayList<String>();
			bindings.add(binding);
			this.placeholdersBindingCurrent.put(placeholder, bindings);
		}
	}
	
	//07-06-11
	//private HashMap<String,List<String>> executeComparingEntities(OntologyPattern op, String p1, NameDetectionPattern ndp, String s1) {
	//08-06-11
	private void executeComparingEntities(OntologyPattern op, String p1, NameDetectionPattern ndp, String s1) {
		//HashMap<String,List<String>> placeholdersBinding = new HashMap<String,List<String>>(); 
		
		String entity1 = "";
		String entity2 = "";
		//entity1 is specified entity
		if (p1.equals("specified entity"))
			entity1=s1;
		else
			//entity1 is not specified entity
			entity1=this.executeEntityCompared(ndp.getEntity1(), s1);
		if (this.debuggingOutput) System.out.println("comparing entity1>"+s1);
		if (ndp.getInvolvedPlaceholdersEntity2().isEmpty()) {
			if (this.debuggingOutput) System.out.println("entity2 no placeholders");
			//entity2 is specified entity
			if (this.matchEntities(entity1, ndp.getEntity2(), ndp.getThreshold(), ndp.getMeasureType())) {
				if (this.debuggingOutput) System.out.println(s1+ " matches " +ndp.getEntity2());
				//placeholdersBinding.put(p1, s1);
				//08-06-11, I realized I need more binding for one placeholder so classical HashMap<String,String> cannot work and we need this one: HashMap<String,List<String>>
				this.putPlaceholderBinding(p1, s1);
			}
		}
		else {
			//entity2 is not specified entity
			for (String p2 : ndp.getInvolvedPlaceholdersEntity2()) {
				switch (op.getPlaceholders().get(p2)) {
					case Class : 
						for(String s2 : classes) {
							entity2=this.executeEntityCompared(ndp.getEntity2(), s2);
							if (this.debuggingOutput) System.out.println("comparing entity2>"+s2);
							if (this.matchEntities(entity1, entity2, ndp.getThreshold(), ndp.getMeasureType())) {
								if (this.debuggingOutput) System.out.println(s1+ " matches " +s2);
								//placeholdersBinding.put(p1, s1);
								this.putPlaceholderBinding(p1, s1);
								//placeholdersBinding.put(p2, s2);
								this.putPlaceholderBinding(p2, s2);
								/*TODO
								if (placeholdersBinding.containsKey(p1)) {
									if (entity1)
								}*/
							}
						}
					break;
					case ObjectProperty : 
						for(String s2 : properties) {
							entity2=this.executeEntityCompared(ndp.getEntity2(), s2);
							if (this.debuggingOutput) System.out.println("comparing entity2>"+entity2);
							if (this.matchEntities(entity1, entity2, ndp.getThreshold(), ndp.getMeasureType())) {
								//match!
								if (this.debuggingOutput) System.out.println(s1+ " matches " +s2);
								//placeholdersBinding.put(p1, s1);
								this.putPlaceholderBinding(p1, s1);
								//placeholdersBinding.put(p2, s2);
								this.putPlaceholderBinding(p2, s2);
							}
						}
					break;
					case DatatypeProperty : 
						for(String s2 : properties) {
							entity2=this.executeEntityCompared(ndp.getEntity2(), s2);
							if (this.debuggingOutput) System.out.println("comparing entity2>"+entity2);
							if (this.matchEntities(entity1, entity2, ndp.getThreshold(), ndp.getMeasureType())) {
								//match!
								if (this.debuggingOutput) System.out.println(s1+ " matches " +s2);
								//placeholdersBinding.put(p1, s1);
								this.putPlaceholderBinding(p1, s1);
								//placeholdersBinding.put(p2, s2);
								this.putPlaceholderBinding(p2, s2);
							}
						}
					break;
					case Individual : 
						for(String s2 : individuals) {
							entity2=this.executeEntityCompared(ndp.getEntity2(), s2);
							if (this.debuggingOutput) System.out.println("comparing entity2>"+entity2);
							if (this.matchEntities(entity1, entity2, ndp.getThreshold(), ndp.getMeasureType())) {
								//match!
								if (this.debuggingOutput) System.out.println(s1+ " matches " +s2);
								//placeholdersBinding.put(p1, s1);
								this.putPlaceholderBinding(p1, s1);
								//placeholdersBinding.put(p2, s2);
								this.putPlaceholderBinding(p2, s2);
							}
						}
					break;
				}
			}
		}
		//return this.placeholdersBinding;
	}
	
	//07-06-11
	//09-06-11, newly ArrayList<HashMap<String,List<String>>> i.e. array where one item for each COMPARISON
	public ArrayList<HashMap<String,List<String>>> checkNamingConstraints(OntologyPattern op, ArrayList<String> classes, ArrayList<String> properties, ArrayList<String> individuals,
			ArrayList<NameDetectionPattern> ndps) {
		
		
		//HashMap<String,String> placeholdersBinding = new HashMap<String,String>();
		//this.placeholdersBinding=new HashMap<String,List<String>>();
		this.placeholdersBinding=new ArrayList<HashMap<String,List<String>>>();
		this.placeholdersBindingCurrent=new HashMap<String,List<String>>();
		
		this.classes = classes;
		this.properties = properties;
		this.individuals = individuals;
		//if (this.debuggingOutput) System.out.println("asdjakh"+ndps);
		
		for(NameDetectionPattern ndp : ndps) {	
			//this.placeholdersBinding.clear();
			
			switch (ndp.getNamePatternType()) {				
				case COMPARISON:
					//if (this.debuggingOutput) System.out.println("current COMPARISON ndp:"+ndp);
					//this.placeholdersBindingCurrent.clear() - 10-06-11 - naprava: neni to reseni, protoze premaze i zaznam z placeholdersBinding
					this.placeholdersBindingCurrent = new HashMap<String,List<String>>();
					//07-06-11, this is checked before structural-logical aspect
					if (ndp.getInvolvedPlaceholdersEntity1().isEmpty()) {						
						//entity1 is specified entity
						if (this.debuggingOutput) System.out.println("no placeholders");
						executeComparingEntities(op, "specified entity", ndp, ndp.getEntity1());
					}
					else {
						if (this.debuggingOutput) System.out.println(ndp);
						//entity1 is not specified entity
						for (String p1 : ndp.getInvolvedPlaceholdersEntity1()) {
							if (this.debuggingOutput) System.out.println("p1>"+p1);
							switch (op.getPlaceholders().get(p1)) {
								case Class: 
									for (String s1 : classes) {
										if (this.debuggingOutput) System.out.println("s1>"+s1);
										//placeholdersBinding.putAll(executeComparingEntities(op, p1, ndp, s1));
										executeComparingEntities(op, p1, ndp, s1);
									}
								break;
								case ObjectProperty: 
									for (String s1 : properties)
										//placeholdersBinding.putAll(executeComparingEntities(op, p1, ndp, s1));								}
										executeComparingEntities(op, p1, ndp, s1);
								case DatatypeProperty: 
									for (String s1 : properties)
										//placeholdersBinding.putAll(executeComparingEntities(op, p1, ndp, s1));								}
										executeComparingEntities(op, p1, ndp, s1);
								break;
								case Individual: 
									for (String s1 : individuals) 
										//placeholdersBinding.putAll(executeComparingEntities(op, p1, ndp, s1));								}
										executeComparingEntities(op, p1, ndp, s1);
								break;
				        		//default: ; break;
							}
						}
					}
					if (this.debuggingOutput) System.out.println(this.placeholdersBindingCurrent);
					this.placeholdersBinding.add(this.placeholdersBindingCurrent);
					break;				
				case EXIST: 
					//07-06-11, this will be checked after structural-logical aspect
					//if (this.debuggingOutput) System.out.println("<<<<"+ndp.getNamePatternType());
					/*
					if (!this.executeEntityExist(ndp.getEntity1(), sparqlBinding))
						return false;
					break;
					*/				
			}
		}		
		return this.placeholdersBinding;
	}
	
	//05-01-12
	//added flag whether comparison checking of ndp should also be done	
	public boolean checkNamingConstraints(HashMap<String,String> sparqlBinding,
			ArrayList<NameDetectionPattern> ndps, boolean comparison) {
		
		//if (this.debuggingOutput) System.out.println("asdjakh"+ndps);
		
		for(NameDetectionPattern ndp : ndps) {
			//if (this.debuggingOutput) System.out.println("print:"+ndp.getEntity1()+" "+ndp.getEntity2());
			//if (this.debuggingOutput) System.out.println("..."+this.executeEntityCompared(ndp.getEntity1(),sparqlBinding));
			//if (this.debuggingOutput) System.out.println("..."+this.executeEntityCompared(ndp.getEntity2(),sparqlBinding));
			switch (ndp.getNamePatternType()) {
				//comparison goes before if comparison is set to false
				case COMPARISON: 
					if (comparison)
						if (!this.matchEntities(this.executeEntityCompared(ndp.getEntity1(),sparqlBinding),this.executeEntityCompared(ndp.getEntity2(),sparqlBinding),ndp.getThreshold(),ndp.getMeasureType()))
							return false;
						break;				
					
				case EXIST: 
					//TODO, 16-02-10, implement it as checking whether the condition is fulfilled
					//if (this.debuggingOutput) System.out.println("<<<<"+ndp.getNamePatternType());
					if (!this.executeEntityExist(ndp.getEntity1(), sparqlBinding))
						return false;
					break;				
			}
		}
		return true;
	}
	
	//21-11-11, in order to close open files - there was a problem of "too many open files"
	public void finish() {
		this.myWordNet.finish();
		this.words.finish();
	}

	@Override
	public boolean checkNamingConstraints(
			HashMap<String, String> sparqlBinding,
			ArrayList<NameDetectionPattern> ndps) {
		// TODO Auto-generated method stub
		//if (this.debuggingOutput) System.out.println("asdjakh"+ndps);
		
		for(NameDetectionPattern ndp : ndps) {
			//if (this.debuggingOutput) System.out.println("print:"+ndp.getEntity1()+" "+ndp.getEntity2());
			//if (this.debuggingOutput) System.out.println("..."+this.executeEntityCompared(ndp.getEntity1(),sparqlBinding));
			//if (this.debuggingOutput) System.out.println("..."+this.executeEntityCompared(ndp.getEntity2(),sparqlBinding));
			switch (ndp.getNamePatternType()) {
				//comparison goes before if comparison is set to false
				/*case COMPARISON: 
					if (!this.matchEntities(this.executeEntityCompared(ndp.getEntity1(),sparqlBinding),this.executeEntityCompared(ndp.getEntity2(),sparqlBinding),ndp.getThreshold(),ndp.getMeasureType()))
						return false;
					break;				
					*/
				case EXIST: 
					//TODO, 16-02-10, implement it as checking whether the condition is fulfilled
					//if (this.debuggingOutput) System.out.println("<<<<"+ndp.getNamePatternType());
					if (!this.executeEntityExist(ndp.getEntity1(), sparqlBinding))
						return false;
					break;				
			}
		}
		return true;
	}

}
