package cz.vse.keg.patomat.naming;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cz.vse.keg.patomat.string.Words;
import cz.vse.keg.patomat.synonym.MyWordNet;
import cz.vse.keg.patomat.naming.NamingFunctionException;

/**
 * @author Ondrej Zamazal
 * 
 */

public class NameEntityImpl implements NameEntity {

	protected HashMap<String,String> binding;
	protected ArrayList<String> instructions;
	protected Words words;
	protected MyWordNet myWordNet;
	private boolean debuggingOutput=true;
	
	public NameEntityImpl(HashMap<String,String> binding, boolean POStagger, String dictionaryPath, String modelsPath) {
		this.binding = binding;
		words = new Words(POStagger, dictionaryPath, modelsPath);
		//myWordNet = new MyWordNet("/home/ondrej/doktorandsky/wordnet/WordNet-3.0/");
		//myWordNet = new MyWordNet("/usr/share/WordNet-3.0/");
		//if (this.debuggingOutput) System.out.println(modelsPath);
		System.out.println("dictionaryPath:"+dictionaryPath);
		myWordNet = new MyWordNet(dictionaryPath);
		//NOTE,11-02-10,with false it does not work,why?		
	}
	
	//specify names instead of placeholders
	//separate instructions according '+'
	private ArrayList<String> getListOfInstructions(String namingInstructions) {
		//specify names instead of placeholders
		//if (this.debuggingOutput) System.out.println("ni:"+namingInstructions);
		//if (this.debuggingOutput) System.out.println("ni...:"+binding);
		Pattern pat = Pattern.compile("\\?[0-9a-zA-Z_]*");
		Matcher m;
		
		//if (this.debuggingOutput) System.out.println("ni"+namingInstructions);
		m = pat.matcher(namingInstructions);		
		//if (this.debuggingOutput) System.out.println(binding);
		//if (this.debuggingOutput) System.out.println("in getListOfInstructions"+namingInstructions);
		while(m.find()) {		
			if (this.debuggingOutput) System.out.println("\\"+m.group()+" replaced by "+ binding.get(m.group()));
			namingInstructions=namingInstructions.replaceAll("\\"+m.group(), binding.get(m.group()));			
		}
		//separate instructions according '+'
		ArrayList<String> ins = new ArrayList<String>();
		if (namingInstructions.indexOf("+")!=-1) {
			StringTokenizer st = new StringTokenizer(namingInstructions,"+");
		    //22-09-11,because of math operation on numbers
			boolean numberMode=false;
			int sum=0;
			String first=st.nextToken();
			if (first.matches("[0-9]*")) {
				numberMode=true;
				sum=Integer.valueOf(first);
			}
			else {
				numberMode=false;
				ins.add(first);
			}
		    String next;
			while (st.hasMoreTokens()) {			
				next=st.nextToken();
				if (numberMode)	{
					sum+=Integer.valueOf(next);
				}
				else ins.add(next);	        
		    }
			if (numberMode) ins.add(String.valueOf(sum));
		}
		else if (namingInstructions.indexOf("-")!=-1) {
			StringTokenizer st = new StringTokenizer(namingInstructions,"-");
		    //22-09-11,because of math operation on numbers
			boolean numberMode=false;
			int sum=0;
			String first=st.nextToken();
			if (first.matches("[0-9]*")) {
				numberMode=true;
				sum=Integer.valueOf(first);
			}
			else {
				numberMode=false;
				ins.add(first);
			}
		    String next;
			while (st.hasMoreTokens()) {			
				next=st.nextToken();
				if (numberMode)	{
					sum-=Integer.valueOf(next);
				}
				else ins.add(next);	        
		    }
			if (numberMode) ins.add(String.valueOf(sum));
		}
		else
			ins.add(namingInstructions);
	    return ins;
	}
	
	@Override
	public StringBuilder getName(String namingInstructions) {		
		//output:
		StringBuilder str = new StringBuilder();
		//input:
		instructions = getListOfInstructions(namingInstructions);
		//04-05-12, just name without naming operations on it
		boolean plainName = true;
		//if (this.debuggingOutput) System.out.println(instructions);
		//parse instructions naming_function(parameter) and execute them
		String naming_function="";
		String parameter="";
		if (this.debuggingOutput) System.out.println("instructions:"+instructions);
		if (instructions.equals("")) {
			return str;
		}
		for(String s : instructions) {
			//if (this.debuggingOutput) System.out.println("..."+s);
			if (s.matches("^.*\\(.*\\)$")) {
				plainName=false;
				//if (this.debuggingOutput) System.out.println("uvnitr");
				Pattern pat = Pattern.compile("^.*\\(");
				Matcher m;
				//get naming function, eg. head_noun
				m = pat.matcher(s);
				while(m.find()) {
					//if (this.debuggingOutput) System.out.println(m.group());
					naming_function=m.group();
				}
				naming_function = naming_function.replaceAll("\\(", "");
				
				pat = Pattern.compile("\\(.*\\)$");			
				//get parameter, eg. head_noun over Paper			
				m = pat.matcher(s);
				while(m.find()) {
					//if (this.debuggingOutput) System.out.println(m.group());
					parameter=m.group();
				}
				parameter = parameter.replaceAll("\\(", "");
				parameter = parameter.replaceAll("\\)", "");
				//if (this.debuggingOutput) System.out.println(naming_function+" over "+parameter);
				//execution of naming_function
				String hn="";
				String conceptNames="";
				if (this.debuggingOutput) System.out.println("nf:"+naming_function+",p: "+parameter);
				try {
					if (naming_function.equals("head_noun")) {
						conceptNames=words.secondSplit((words.splitName(" "+parameter).toString()));
						hn=words.getMT(conceptNames);
						//by default, first letter is upper case
						str.append(hn.substring(0,1).toUpperCase());											
						str.append(hn.substring(1));
					}
					else if (naming_function.equals("make_passive_verb")) {						
						//if (this.debuggingOutput) System.out.println(parameter);
						//TODO,13-04-10, 1. vzit jen head noun a aplikovat to nasledujici jen na headnoun
						conceptNames=words.secondSplit((words.splitName(" "+parameter).toString()));
						parameter=words.getMT(conceptNames);
						//if (this.debuggingOutput) System.out.println("haloo "+words.nlp.getOneWordTag(parameter));					
						if (words.nlp.getOneWordTag(parameter).equals("VB")) {							
							words.getVerbPassiveForm(parameter);							
						}
						else {
							ArrayList<String> relatedTerms = myWordNet.getRelatedWord(parameter);
							//if (this.debuggingOutput) System.out.println(relatedTerms);
							if (relatedTerms == null) {
								str.append(parameter);								
							}
							else {
								for(String r : relatedTerms) {
								//if (this.debuggingOutput) System.out.println(r);
								//TODO,16-02-10: stalo by za to si vzit jen head_noun 
									//if (words.nlp.getOneWordTag(r).equals("VB")) {
									if (words.nlp.getOneWordTag(r).matches("VB.")||(words.nlp.getOneWordTag(r).equals("VB"))) {
										String passive = words.getVerbPassiveForm(r);										
										str.append(passive.substring(0,1).toUpperCase()+passive.substring(1));
										break;
									}
									str.append(parameter);
								}
							}
						}
					}
					else if (naming_function.equals("make_delimiter_underscore")) {
						//16-03-10,predpokladame, ze tam nejaky delimiter je, dalo by se ale take nejprve testovat words.multiTokenName
						//nejprve je potreba rozpoznat o jaky delimiter se jedna
						String delimiter="camel";						
						if (parameter.indexOf("_")!=-1) delimiter="_";
						else if (parameter.indexOf("-")!=-1) delimiter="-";
						//default: upperCase between tokens
						//make delimiter underscore
						if (delimiter.equals("-")) str.append(parameter.replaceAll("-","_"));
						else {//default: upperCase between tokens (camelCase)
							//from uppercase to underscore delimitation
							pat = Pattern.compile("[A-Z]");												
							m = pat.matcher(parameter);
							String[] tokens = pat.split(parameter);
							int i=1;
							while(m.find()) {							
								//if (this.debuggingOutput) System.out.println(m.group());
								if(i==1) str.append(m.group().toLowerCase()+tokens[i++]);
								else str.append("-"+m.group().toLowerCase()+tokens[i++]);
								//naming_function=m.group();
							}
							//if (this.debuggingOutput) System.out.println(Arrays.toString((pat.split(parameter))));
						}
						/*
						String firstLetter = (parentHeadNoun.substring(0,1)).toUpperCase();
						parentHeadNoun = firstLetter + parentHeadNoun.substring(1,parentHeadNoun.length()); 
						parentHeadNoun = delimiter+parentHeadNoun;
						str.append("under_score");
						*/
					}
					else if (naming_function.equals("make_delimiter_hyphen")) {
						//23-03-10,predpokladame, ze tam nejaky delimiter je, dalo by se ale take nejprve testovat words.multiTokenName
						//nejprve je potreba rozpoznat o jaky delimiter se jedna
						String delimiter="camel";						
						if (parameter.indexOf("_")!=-1) delimiter="_";
						else if (parameter.indexOf("-")!=-1) delimiter="-";
						//default: upperCase between tokens
						//make delimiter underscore
						if (delimiter.equals("_")) str.append(parameter.replaceAll("_","-"));
						else {//default: upperCase between tokens (camelCase)
							//from uppercase to underscore delimitation
							pat = Pattern.compile("[A-Z]");												
							m = pat.matcher(parameter);
							String[] tokens = pat.split(parameter);
							int i=1;
							while(m.find()) {							
								//if (this.debuggingOutput) System.out.println(m.group());
								if(i==1) str.append(m.group().toLowerCase()+tokens[i++]);
								else str.append("_"+m.group().toLowerCase()+tokens[i++]);
								//naming_function=m.group();
							}
							//if (this.debuggingOutput) System.out.println(Arrays.toString((pat.split(parameter))));
						}
						/*
						String firstLetter = (parentHeadNoun.substring(0,1)).toUpperCase();
						parentHeadNoun = firstLetter + parentHeadNoun.substring(1,parentHeadNoun.length()); 
						parentHeadNoun = delimiter+parentHeadNoun;
						str.append("under_score");
						*/
					}
					else if (naming_function.equals("make_delimiter_camel-case")) {
						String delimiter="";						
						if (parameter.indexOf("_")!=-1) delimiter="_";
						else if (parameter.indexOf("-")!=-1) delimiter="-";
						if (delimiter.equals("")) break;
						String[] tokens = parameter.split(delimiter);						
						for(int j=0;j<tokens.length;j++) {
							if (j>0) {
								str.append(tokens[j].substring(0,1).toUpperCase());											
								str.append(tokens[j].substring(1));								
							}
							else str.append(tokens[j]);
						}
						if (this.debuggingOutput) System.out.println(Arrays.toString(parameter.split(delimiter)));
						//str.append("camelCase");						
					}
					/*else if (naming_function.equals("literal")) {
						
					}*/
					//03-06-11, complement_head_noun() - taken from NamingConstraintsImpl class
					else if (naming_function.equals("complement_head_noun")) {										
						//by default, first letter is upper case
						str.append(words.getComplementHeadNoun(parameter));
					}
					else throw new NamingFunctionException("This function "+naming_function+" is not currently supported. Please wait for the next release.");
				}
				catch(NamingFunctionException e) {
					e.printStackTrace();
				}
				catch(Exception e) {
					e.printStackTrace();
				}
			}
			else {//otherwise there is only concatenation operation 				
				str.append(s);
			}
		}
		//04-05-12, if there is no operation with namingInstructions just copy original name with delimiters
		if (plainName&&binding.containsKey(namingInstructions)) return new StringBuilder(binding.get(namingInstructions));
		else return str;
	}

	@Override
	//21-11-11, in order to close open files - there was a problem of "too many open files"
	public void finish() {
		this.myWordNet.finish();
		this.words.finish();
	}

}
