package cz.vse.keg.patomat.detection.service;

import org.restlet.resource.ServerResource;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
//import org.restlet.resource.Get;
import org.restlet.resource.Post;

import cz.vse.keg.patomat.detection.OntologyPatternDetection;
import cz.vse.keg.patomat.detection.OntologyPatternDetectionImpl;
import cz.vse.keg.patomat.transformation.pattern.TransformationPatternImpl;

/**
 * @author Ondrej Zamazal
 * 
 */

public class OntologyPatternDetectionResource extends ServerResource {
	/**
     * Handle POST requests: create a new item.
     */
    @Post
    public Representation acceptItem(Representation entity) {
        Representation result = null;

        // Parse the given representation and retrieve pairs of
        // "name=value" tokens.
        Form form = new Form(entity);
        String tp = form.getFirstValue("tp");
        String ontology = form.getFirstValue("ontology");
        StringBuilder sb = new StringBuilder("<query_results>\n");
        OntologyPatternDetectionImpl detection = new OntologyPatternDetectionImpl("/usr/share/WordNet-3.0", "/usr/share/models");        
        //for (String s : detection.queryPattern(new TransformationPatternImpl(tp), ontology, true)) {
        for(String s : detection.queryPatternNamingAspect(new TransformationPatternImpl(tp), ontology, true, false)) {
        	sb.append(s);
        }
        sb.append("</query_results>\n");        
        
        // Set the response's status and entity
        setStatus(Status.SUCCESS_CREATED);
        Representation rep = new StringRepresentation(sb.toString(),
                MediaType.TEXT_XML);
   
        result = rep;
        return result;
    }   
}
